********************************************************************************
*                         dConsultant Systems Windowing UDFs                   *
*                              for THE BREEZE by Logitek                       *
********************************************************************************
* 
* Program..: W_funcs.prg
* Author...: Paul H. Mannes
* Date.....: March 10,1988
* Notice...: Written for use with The Breeze Windows by Paul McDonald
*            Will work with The Breeze86 or '87 version 2.0 and later
* Notes....: Released into general circulation without restriction 
*            This file can be compiled and linked as is.
*
* Compile..: Use either Clipper A'86 or S'87
*            (YNLoop() uses the SET CURSOR ON/OFF of S'87 - the compile error
*             'Rest if line ignored' will result if compiled with A'86 )
* Link ....: MS Link or PLink86plus (do not use TLink from Borland)
* Library..: Along with others, you must include Breeze86 or Breeze87
*
*
* Purpose..: The number of lines of code it takes to initialize a window and
*            then, shut it down, can grow and grow if windows are used
*            extensively (a nice idea) in any program.  The following UDFs are
*            meant primarily to cut down on that number.  
*
* UDFs.....:      WMake()     - To Wselect, Wuse, Wframe a window with
*                               checks for prior wexist.
*
*                 WShut()     - To WClose and WRelease a window.
*
*                 IsCorrect() - PopWindow with question. Predefined location.
*
*                 YNLoop()    - Just a simple time saver.  Used with IsCorrect().
*
* Format...: I will list the name and syntax of the UDF first and then give
*            source code.  
*
*
* Function: WMake
* Syntax  : WMake(areanum,height,width,topright,topleft,frame,"color")
*           - The parameters are simply the several you would pass to
*             each of the necessary window functions.  The following would
*             be the per function equivalent:
*        
*    WSelect(1)                   && Select window area 1
*    WUse(10,60,10,20,"+gr/b")    && Use window with size,location and color
*    WFrame(3)                    && Place a border on the window
*
*           - In these typical lines no check is made of the selected area for
*             a conflict.  The UDF will do that checking.
*           - The WDisplay() function is left up to you.  The UDF (and the)
*             equivalent lines of code above) do not display the window, only
*             'ready' it for display.  Any Wprint() or WFill() options can be
*             added by you before the WDisplay() is used.
* Returns : numeric
*           - 0  is returned if no WSelect area conflict occurs
*           - 1  is returned if a conflict has arisen - it is up to you what
*                you do after that.
*
*
* Function Code for WMake

Func WMake

   para area,high,wide,tr,tl,frame,color

   if !WExist(area)         && Check to see if area is already in WUse

      WSelect(area)         && WSelect area if not already in WUse.
      WUse(high,wide,tr,tl,color)   && Initialize window
      WFrame(frame)                 && Put a frame on it.
      return(0)

   else

      return(1)

   endi


* Function: WShut
* Syntax  : WShut(areanum)
*           - The parameter is the WArea to WClose() and WRelease().
*             It will default to the currently WSelected area.  The 
*             following would be the per function equivalent:
*        
*    WClose(1)                    && Close the window area 1
*    WRelease(1)                  && Release the window memory
*
*           - In these typical lines no check is made of the selected area
*             to see if a window is really there.  The UDF will do that checking.
* Returns : numeric
*           - 0  is returned if the area exists.
*           - 1  is returned if no area exists - it is up to you what
*                you do after that.
*
* Function Code for WShut
func WShut

   para area

   if pcount() = 1            && check for WSelect area passed

      if Wexist(area)          && check areas existence

         WClose(area)
         WRelease(area)
         return(0)

      else

         return(1)

      endi

   else

      if Wexist()               && check current area for a window

         WClose()
         WRelease()
         return(0)

      else

         return(1)

      endi

   endi


* Function: IsCorrect
* Syntax  : IsCorrect("Window_Color")
*           - The one parameter is either a literal color string
*             such as "+gr/b" or a memory variable you have already
*             initialized for some color.
*           - This is wonderful for checking Data Entry screens.
* Example :
*
*          (series of GETS)
*          read
*          isok = iscorrect(ReverseVideo)       && window appears with question
*          if isok = "Y"
*             .
*             code sequence for "Y" response. . .
*             .
*          else
*             .
*             code sequence for "N" response. . .
*             .
*          endi
*
* Returns : upper case 'Y' or'N'
*
* Function Code for IsCorrect()

func iscorrect

   para color

   WMake(10,3,38,22,21,3,color)
   WPrint(1,2," Is all information correct? (y/n) ")
   WDisplay()

   i = ynloop()                 && see YNLoop()   below

   wshut()

return(i)


* Function: YNLoop
* Syntax  : YNLoop()
*           - I use this one alot for responses to Y/N type questions.
*             It is a great time saver.
*
* Example :
*
*          @ 23,5 say "Are you ready to continue? (y/n)"
*          ready = ynloop()
*          if ready = "Y"
*             .
*             code sequence for "Y" response. . .
*             .
*          else
*             .
*             code sequence for "N" response. . .
*             .
*          endi
*
* Returns : upper case 'Y' or'N'
*
* Function Code for YNLoop()

func ynloop

   ynl = 0

   set cursor off        && Nice to have with Summer '87

   do while !uppe(chr(ynl))$"YN"

      ynl = inke()

   endd

   set cursor on

   return(uppe(chr(ynl)))
