FUNCTION BorderDef
*-
* Programmer..: Carey L. Chilcote (QUESTECH)
* Date........: 03/09/1992
* Notes.......: Used to select a character string, designating the
*               appropriate border definition string for Windows and Popup
*               menus, from an array, based on the supplied parameter.
* Written for.: dBASE IV, 1.1
* Rev. History: None
* Calls.......: NONE
* Called by...: Any
* Usage.......: memvar = BorderDef(bordername)
*               define window(or popup)name from  xx,yy to xx,yy &memvar
*
*               Border definition strings are formated: Top, Bottom, Left,
*               Right, Upper Left, Upper Right, Lower Left, Lower Right.
*
*               The table below shows the name, characters used for the
*               definition string, and a sample box.
*
*                   DTDBSLSR   T   B   L   R   UL  UR  LL  LR    ͸
*                                                        ;
*
*                   STSBDLDR   S   T   S   B   D   L   D   R     ķ
*                                                        Ľ
*
*                   DTSBSLSR   D   T   S   B   S   L   S   R     ͸
*                                                        
*
*                   STDBSLSR   S   T   D   B   S   L   S   R     Ŀ
*                                                        ;
*
*                   STSBDLSR   S   T   S   B   D   L   S   R     Ŀ
*                                                        
*
*                   STSBSLDR   S   T   S   B   S   L   D   R     ķ
*                                                        Ľ
*
*                   DTSBDLDR   D   T   S   B   D   L   D   R     ͻ
*                                                        Ľ
*
*                   STDBDLDR   S   T   D   B   D   L   D   R     ķ
*                                                        ͼ
*
*                   DTDBDLSR   D   T   D   B   D   L   S   R     ͸
*                                                        ;
*
*                   DTDBSLDR   D   T   D   B   S   L   D   R     ͻ
*                                                        ͼ
*
*                   HTHBFLFR   H   T   H   B   F   L   F   R     
*                                                         
*                                                                
*
*                   DTDBDLDR   D   T   D   B   D   L   D   R     ͻ
*                                                        ͼ
*
*                   STSBSLSR   S   T   S   B   S   L   S   R     Ŀ
*                                                        
*
* Example.....: cBorderDef=BorderDef("DTDBSLSR")
*               define window Win1 from  xx,yy to xx,yy &cBorderDef
* Returns.....: aBorderDef[nCounter,2] - which is the appropriate border
*               definition string for the code name, passed by the
*               parameter, and extracted from the border definition
*               array.
* Parameters..: cBorderN =  the code name assigned to a particular border
*               definition string.
*-
   parameters cBorderN

*
* Test for array and declare and fill it if the necessary.
*
   if type("aBorderDef[1,1]") = "U"
      public aBorderDef
      declare aBorderDef[13,2]

*
* Defines Double Top Double Bottom Single Left Single Right border.  ͸
*                                                                    ;
*
         aBorderDef[1,1] = "DTDBSLSR"
         aBorderDef[1,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34);
            +""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34);
            +","+CHR(34)+""+CHR(34)
*
* Defines Single Top Single Bottom Double Left Double Right border.  ķ
*                                                                    Ľ
*
         aBorderDef[2,1] = "STSBDLDR"
         aBorderDef[2,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34);
            +""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34);
            +","+CHR(34)+""+CHR(34)
*
* Defines Double Top Single Bottom Single Left Single Right border.  ͸
*                                                                    
*
         aBorderDef[3,1] = "DTSBSLSR"
         aBorderDef[3,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+"";
            +CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)
*
* Defines Single Top Double Bottom Single Left Single Right border.  Ŀ
*                                                                    ;
*
         aBorderDef[4,1] = "STDBSLSR"
         aBorderDef[4,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+"";
            +CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)
*
* Defines Single Top Single Bottom Double Left Single Right border.  Ŀ
*                                                                    
*
         aBorderDef[5,1] = "STSBDLSR"
         aBorderDef[5,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+"";
            +CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)
*
* Defines Single Top Single Bottom Single Left Double Right border.  ķ
*                                                                    Ľ
*
         aBorderDef[6,1] = "STSBSLDR"
         aBorderDef[6,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+"";
            +CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)
*
* Defines Double Top Single Bottom Double Left Double Right border.  ͻ
*                                                                    Ľ
*
         aBorderDef[7,1] = "DTSBDLDR"
         aBorderDef[7,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+"";
            +CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)
*
* Defines Single Top Double Bottom Double Left Double Right border.  ķ
*                                                                    ͼ
*
         aBorderDef[8,1] = "STDBDLDR"
         aBorderDef[8,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+"";
            +CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)
*
* Defines Double Top Double Bottom Double Left Single Right border.  ͸
*                                                                    ;
*
         aBorderDef[9,1] = "DTDBDLSR"
         aBorderDef[9,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+"";
            +CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)
*
* Defines Double Top Double Bottom Single Left Double Right border.  ͻ
*                                                                    ͼ
*
         aBorderDef[10,1] = "DTDBSLDR"
         aBorderDef[10,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+"";
            +CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)
*
* Defines Half-Block Top Half-Block Bottom Full-Block Left Full-Block Right
* border.  
*           
*          
*
         aBorderDef[11,1] = "HTHBFLFR"
         aBorderDef[11,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34);
            +""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34);
            +","+CHR(34)+""+CHR(34)
*
* Defines Double Top Double Bottom Double Left Double Right border.  ͻ
*                                                                    ͼ
*
         aBorderDef[12,1] = "DTDBDLDR"       && Optional; duplicates "double"
         aBorderDef[12,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34);
            +""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34);
            +","+CHR(34)+""+CHR(34)
*
* Defines Single Top Single Bottom Single Left Single Right border.  Ŀ
*                                                                    
*
         aBorderDef[13,1] = "STSBSLSR"       && Optional; duplicates "single"
         aBorderDef[13,2] = CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+",";
            +CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34);
            +""+CHR(34)+","+CHR(34)+""+CHR(34)+","+CHR(34)+""+CHR(34);
            +","+CHR(34)+""+CHR(34)

   endif
*
* initialize the loop counter
*
   nCounter = 1
*
* This loop searches the border definition array for the border name,
* allowing the appropriate definition to be returned.
*
   do while nCounter < 13
      if aBorderDef[nCounter,1] = cBorderN
         exit
      endif
      nCounter = nCounter + 1
   enddo
*
* Pass the border character string back to the point from which the
* function was called for use in a window or popup border definition
*
RETURN aBorderDef[nCounter,2]

* EoF: BorderDef
