*----------------------------------------------------------
* BONGMENU - Copyright (c) 1988 Bernard Ong, California.
*----------------------------------------------------------
* program : start.prg (sample program utilizing the BONGMENU function)
* creator : bernard ong (CIS # 73667,1516)
* created : 08-23-88
* updated : 09-18-88
*         : 06-22-90
* comment : BONGMENU function - menu builder
*----------------------------------------------------------
*
do initial  && this is a UDF (refer to procedure below)
*
*--------------------------------------
public progname
progname = 'ABC Company Client System'

* you have to declare an array for each menu.
* array parameters :
*     DECLARE MENUn1[n2]
*     MENUn1[1] = n3
*     MENUn1[2] = n4
*     MENUn1[3] = n5
*     MENUn1[4] = 'char string - first menu option,rrcc'
*     MENUn1[5] = 'char string - second menu option,rrcc'
*     MENUn1[6] = 'char string - third menu option,rrcc'
*     .. etc.
*     .. etc.
*     MENUn1[n2] = 'char string - last menu option,rrcc'
*
* where :
*     n1 - integer : menu set number
*     n2 - integer : size of array
*     n3 - integer : width of menu (even no.)
*     n4 - integer : height of menu (even no.)
*     n5 - integer : how many options in the menu
*     rr - row where the option is located
*     cc - column where the option is located
*
* the following 2 sample arrays representing two menus in this system
* should make things clearer...

declare menu1[10]
menu1[1] = 60
menu1[2] = 12
menu1[3] = 6
menu1[4] = '<< MAIN MENU >>'
menu1[5] = 'Clients Listing,1215'
menu1[6] = 'Vendors Listing,1415'
menu1[7] = 'Prospects Listing,1615'
menu1[8] = 'Quoting System,1242'
menu1[9] = 'Pricing System,1442'
menu1[10] = 'Utilities Module,1642'

declare menu2[8]
menu2[1] = 40
menu2[2] = 14
menu2[3] = 4
menu2[4] = '<< UTILITY MENU >>'
menu2[5] = 'Reindex All Databases,1125'
menu2[6] = 'Purge Deleted Records,1325'
menu2[7] = 'Backup All Databases,1525'
menu2[8] = 'Redefine Color Settings,1725'

*--------------------------------------
do while .t.            &&                       .
  choice = bongmenu(1)  && the '1' came from menu1[10]
  do case
    case choice = 1
      * do clients
    case choice = 2
      * do vendors
    case choice = 3
      * do prospect
    case choice = 4
      * do quotes   
    case choice = 5
      * do pricing
    case choice = 6
      do utilmenu
    case choice = 0
      do termination
  endcase
enddo
*
* eof : start.prg

*==============================================================================
* START OF FUNCTIONS AND PROCEDURES - PULL INTO YOUR BOILER
* Feel free to modify source code for your own purposes and needs
*------------------------------------------------------------------------------
procedure initial
*
* executed as the very first procedure in the main program
* does initial settings for defaults and basic colors
* program entry defaults
*
clear all
* add additional ones that you use here...
set cursor off         && turn on only when in the GET mode
set delimiters off     && defaulting to just reverse fields for gets
set intensity on       && get fields will come out in the enhanced setting
set scoreboard off     && doesn't show messages at first line of screen
set wrap on            && menu moving bar rotates choices in a circle
setcancel (.f.)        && disables Alt-C halt key inside the compiled code

* program wide color settings
public sc_norm, sc_titl, sc_mess, sc_help, sc_warn, sc_err, sc_grp, sc_data,;
  sc_win1, sc_win2, sc_win3, sc_bar, sc_rev, sc_blk, sc_rev, sc_brt,sc_pop
if iscolor()
  sc_norm = 'w/b'
  sc_bar  = 'gr+/g'
  sc_titl = 'b+/'
  sc_mess = 'w+/g'
  sc_help = 'w+/br'
  sc_warn = 'r+/b'
  sc_err  = 'gr+*/r'
  sc_grp  = 'bg+/g'
  sc_data = 'g/'
  sc_win1 = 'gr+/'
  sc_win2 = 'w+/bg'
  sc_win3 = 'b+/b'
  sc_blk  = 'r+*/b'
  sc_rev  = 'gr+/r'
  sc_brt  = 'w+/b'
  sc_pop  = 'w+/br'
else
  sc_norm = 'w/'
  sc_bar  = '+/w'
  sc_titl = 'w+/'
  sc_mess = 'w+/'
  sc_help = 'w+/'
  sc_warn = 'w+*/'
  sc_err  = 'w+*/'
  sc_grp  = 'w+/'
  sc_data = '+/w'
  sc_win1 = '+/w'
  sc_win2 = '+/w'
  sc_win3 = 'w/'
  sc_blk  = 'w+*/'
  sc_rev  = '+/w'
  sc_brt  = 'w+/'
  sc_pop  = 'w+/'
endif
return

*------------------------------------------------------------------------------
function bongmenu
parameters menu_no
*
* autosensing feature for both color or monochrome adapter
* generates menu options, colors, setup, and screen painting 
* -- all in one shot --
*
* calculate all positions
meno = str(menu_no,1,0)
top = (19-menu&meno[2])/2 + 4
left = (80-menu&meno[1])/2 
bottom = top + menu&meno[2] - 1
right = left + menu&meno[1] - 1
tmenu_t = menu&meno[4]

* initial screen paint
set color to &sc_win3
if iscolor()
   @ 00,00 clear
else
   @ 00,00,24,79 box replicate ('',9)
endif

if iscolor()
   c2 = alltrim(substr(sc_rev,at('/',sc_rev)+1))
   c1 = alltrim(substr(sc_win2,1,at('/',sc_win2)-1))
   set color to &c1/&c2
else
   set color to &sc_rev
endif
tprogram = progname
@ 00,00 clear to 02,79
@ 00,00 to 02,79
@ 01,03 say trim(tprogram)
@ 01,63 say 'Date: '
@ 01,69 say date() picture '@D'

* the top half part of menu
set color to &sc_win1
@ top,left clear to top+1,right
do centring with alltrim(tmenu_t),top+1
@ top+2,left,top+2,right box '_'

* the shadow
if iscolor()
   color_string = alltrim(substr(sc_win3,at('/',sc_win3)+1))
   set color to &color_string/n                
   @ top+1,right+1,bottom,right+2 box ''
   @ bottom+1,left+2,bottom+1,right+2 box ''
else
   set color to &sc_norm
   @ top+1,right+1,bottom,right+2 box ' '
   @ bottom+1,left+2,bottom+1,right+2 box ' '
endif   

* clear the last line
if iscolor()
   set color to &color_string+/n                
else 
   set color to &sc_brt
endif
@ 24,00 clear to 24,79

* you can put in your own text here (e.g. your copyright messages, etc.)
@ 24,00 say '<Esc> = Exit' + space(56) + 'Version 1.00'
do centring with 'Copyright (c) 1990 Bernard Ong, California',24

* second half of menu window
if iscolor()
   set color to &sc_win2,&sc_rev
else
   set color to &sc_win2,&sc_brt
endif
@ top+3,left clear to bottom,right        

* now let's slap in all the options
option_counter = 0
tmax_op = menu&meno[3]
for option_counter = 5 to (tmax_op+4)
   counter = option_counter
   tdesc = substr(menu&meno[counter],1,at(',',menu&meno[counter])-1)
   row = substr(menu&meno[counter],at(',',menu&meno[counter])+1,2)
   col = substr(menu&meno[counter],at(',',menu&meno[counter])+3,2)
   @ val(row),val(col) say '[   ]  &tdesc'
next option_counter

for option_counter = 5 to (tmax_op+4)
   counter = option_counter
   row = substr(menu&meno[counter],at(',',menu&meno[counter])+1,2)
   col = substr(menu&meno[counter],at(',',menu&meno[counter])+3,2)
   c_string = str(val(alltrim(str(counter)))-4,1,0)
   @ val(row),val(col)+1 prompt ' &c_string '
next option_counter

choice = 1
menu to choice
set color to &sc_norm, &sc_rev
return choice

*------------------------------------------------------------------------------
procedure centring
parameters string, row

* string : is the string needed to be centered
* row    : at which row for the above string to be centered
tempon = (78-len(string))/2  
tempos = ' '+string+' '
@ row,tempon say tempos
return

*------------------------------------------------------------------------------
procedure termination

* ensures proper program exit 
* called with <Esc> key from Main Menu
commit
close all
clear all
set color to w/n
clear
set cursor on
quit
*
* end of a fairy tale... it was just a dream after all.
* Copyright (c) 1988 Bernard Ong. CIS # 73667,1516
*
