* System       : Customer Access System - Personal Computer
* File         : zGETDATE.prg (Black Box)
* Procedure    : none
* Called from  : Everywhere
* Description  : Get a date/date range from the user.
* Databases    : none
* Calls        : none
* UDF Calls    : none
* Written      : 03/17/89 DKA
* Tested       :
* Parameters   : <Mode>,<Title>,<Default1>,<Default2>
* Requirments  : none
*

******************************** NOTES ********************************
*
* COMMENTS     : Program will reset color to color set previous.
*
*                The program will return the users choice in public variables
*                called zDATE1 and zDATE2.  These are DATE type variables.
*                They should be publiced in your main public variable routine.
*
*                If the user hits escape, zDATE1 and zDATE2 are set to
*                ctod(""), and zRETURN is set to .F., otherwise zRETURN
*                is set to .T. - indicating they selected a date(s).
*
*                Title will be truncated if it is larger than 33 characters.
*
* PARAMETERS   : ALL PARAMETERS MUST BE OF TYPE CHARACTER!!!!
*
*                <Mode>    - Number from 1 to 7,
*                               1) Get one full date.
*                               2) Get two full dates.
*                               3) Get Month and Year.
*                               4) Get Month and Day.
*                               5) Just Day.
*                               6) Just Month.
*                               7) Just Year.
*                <Title>    - Up to 33 Characters.
*                <Default1> - If mode 1 or 2, must be in mm/dd/yy format.  "" will give todays date.
*                             If mode 3 or 6, must be number from 1 thru 12.  "" will give current month number.
*                             If mode 4 or 5, must be number from 1 thru 31.  "" will give current day number.
*                             If mode 7, must be number from 0 thru 9999.
*                             
*                <Default2> - Mode 2, must be in mm/dd/yy format.  "" will give todays date.
*                             Mode 3, must be number from 1 thru 12.  "" will give current month number.
*                             Mode 4, must be number from 1 thru 31.  "" will give current day number.
*                             All other modes parameter ignored.
*
* EXAMPLE      : do zGETDATE with '2','Enter date range for report',dtoc(date()-30),''
*
*                Defaults in above example will be 30 days ago and todays date.
*
******************************** NOTES ********************************

****
* Assign passed question and valid responses to internal variables.
parameters mPARAM1,mPARAM2,mPARAM3,mPARAM4
****

****
* Initialize other internal variables.
private mPARAM1,mPARAM2,mPARAM3,mPARAM4,mVAR
private mSCREEN,mMODE,mTITLE,mDEFAULT1,mDEFAULT2,mDATE1,mDATE2,mCOL,mDEPTH
private mCOLOR
****

****
* If the return variables - zDATE1, zDATE2 and zRETURN - are not publiced as of yet, public them!
if type("zDATE1") = "U"
   public zDATE1
endif
if type("zDATE2") = "U"
   public zDATE2
endif
if type("zRETURN") = "U"
   public zRETURN
endif
****

***** Define internal variables.
mCOLOR    = sys(2001,"COLOR")
mMODE     = val(mPARAM1)
mTITLE    = iif(len(mPARAM2)>33,left(mPARAM2,33),mPARAM2)
do CASE

   CASE mMODE=1
      if mPARAM3 == ""
         mDEFAULT1 = date()
      else
         mDEFAULT1 = ctod(mPARAM3)
      endif

   CASE mMODE=2
      if mPARAM3 == ""
         mDEFAULT1 = date()
      else
         mDEFAULT1 = ctod(mPARAM3)
      endif
      if mPARAM4 == ""
         mDEFAULT2 = date()
      else
         mDEFAULT2 = ctod(mPARAM4)
      endif

   CASE mMODE=3
      if mPARAM3 == ""
         mDEFAULT1 = month(date())
      else
         mDEFAULT1 = val(mPARAM3)
      endif
      if mPARAM4 == ""
         mDEFAULT2 = year(date())
      else
         mDEFAULT2 = val(mPARAM4)
      endif

   CASE mMODE=4
      if mPARAM3 == ""
         mDEFAULT1 = month(date())
      else
         mDEFAULT1 = val(mPARAM3)
      endif
      if mPARAM4 == ""
         mDEFAULT2 = day(date())
      else
         mDEFAULT2 = val(mPARAM4)
      endif

   CASE mMODE=5
      if mPARAM3 == ""
         mDEFAULT1 = day(date())
      else
         mDEFAULT1 = val(mPARAM3)
      endif

   CASE mMODE=6
      if mPARAM3 == ""
         mDEFAULT1 = month(date())
      else
         mDEFAULT1 = val(mPARAM3)
      endif

   CASE mMODE=7
      if mPARAM3 == ""
         mDEFAULT1 = year(date())
      else
         mDEFAULT1 = val(mPARAM3)
      endif

   OTHERWISE
      do zMESSAGE with "Unknown mode call for zGETDATE black box, press any key...","w/r"
      set console off
      wait
      set console on
      cancel
ENDCASE
****

**** Save the screen for when they return.
save screen to mSCREEN
****

**** If they are supposed to select a month, do that first.
if mMODE = 3 .or. mMODE = 4 .or. mMODE = 6
   * Pop the right sized box.
   do zWINDOW with 8,24,21,56,"+w/b",1,1

   * Display the title, if there is one.
   mCOL = 40-int(len(mTITLE)/2)
   set color to +gr/b
   if mTITLE > "!"
      @ 8,mCOL say " " + mTITLE + " "
   endif

   * Display an information line
   do zMESSAGE with "Select a month","+w/r"

   * Display the selections
   set color to +w/b,n/bg
   @ 09,37 prompt "January"
   @ 10,37 prompt "February"
   @ 11,37 prompt "March"
   @ 12,37 prompt "April"
   @ 13,37 prompt "May"
   @ 14,37 prompt "June"
   @ 15,37 prompt "July"
   @ 16,37 prompt "August"
   @ 17,37 prompt "September"
   @ 18,37 prompt "October"
   @ 19,37 prompt "November"
   @ 20,37 prompt "December"

   * Have them select one, with it pointing to default to select.
   mVAR = mDEFAULT1
   menu to mVAR

   * Put the original screen backup.
   restore screen from mSCREEN

   * If they hit escape, set all return variables and exit, stage left.  Else store 
   * choice to variable used in CASE statements below (Cases 3,4, and 6).
   if mVAR = 0
      zRETURN = .F.
      zDATE1  = ctod("")
      zDATE2  = ctod("")
      set color to &mCOLOR
      return
   else
      mDEFAULT1 = mVAR
   endif
endif

****

**** Then ask the rest of the questions.
* Pop the right sized box.
mDEPTH = iif(mMODE=2,15,14)
do zWINDOW with 10,20,mDEPTH,60,"+w/b",1,1

* Display the title, if there is one.
mCOL = 40-int(len(mTITLE)/2)
set color to +gr/b
if mTITLE > "!"
   @ 10,mCOL say " " + mTITLE + " "
endif

* Set color for the entry screen.
set color to w/b,n/bg

* Do a get based on what the calling program wants (see notes), except for month select (done above).
do CASE

   Case mMODE = 1
      @ 12,25 say "Enter date  " get mDEFAULT1 pict "@D"
      read
      zDATE1 = mDEFAULT1
      zDATE2 = ctod("")

   Case mMODE = 2
      @ 12,25 say "Enter first date   " get mDEFAULT1 pict "@D"
      @ 13,25 say "Enter second date  " get mDEFAULT2 pict "@D"
      read
      zDATE1 = mDEFAULT1
      zDATE2 = mDEFAULT2

   Case mMODE = 3
      @ 12,25 say "Enter year   " get mDEFAULT2 pict "9999" range 1900,1999
      read
      mVAR     = trim(ltrim(str(mDEFAULT1)))+"/01/"+trim(ltrim(str(mDEFAULT2)))
      zDATE1 = ctod(mVAR)
      zDATE2 = ctod("")

   Case mMODE = 4
      @ 12,25 say "Enter day    " get mDEFAULT2 pict "99" range 1,31
      read
      mVAR     = trim(ltrim(str(mDEFAULT1)))+"/"+trim(ltrim(str(mDEFAULT2)))+"/"+trim(ltrim(str(year(date()))))
      zDATE1 = ctod(mVAR)
      zDATE2 = ctod("")

   Case mMODE = 5
      @ 12,25 say "Enter day    " get mDEFAULT1 pict "99" range 1,31
      read
      mVAR     = trim(ltrim(str(month(date()))))+"/"+trim(ltrim(str(mDEFAULT1)))+"/"+trim(ltrim(str(year(date()))))
      zDATE1 = ctod(mVAR)
      zDATE2 = ctod("")

   Case mMODE = 6
      mVAR     = trim(ltrim(str(mDEFAULT1)))+"/01/"+trim(ltrim(str(year(date()))))
      zDATE1 = ctod(mVAR)
      zDATE2 = ctod("")

   Case mMODE = 7
      @ 12,25 say "Enter year   " get mDEFAULT1 pict "9999" range 1900,1999
      read
      mVAR     = "01/01/"+trim(ltrim(str(mDEFAULT1)))
      zDATE1 = ctod(mVAR)
      zDATE2 = ctod("")

endcase
****

**** Finish up.
* If they hit escape in any of the reads in the Cases, set all public variables and return.
if readkey() = 12 .or. readkey() = 268
   zDATE1  = ctod("")
   zDATE2  = ctod("")
   zRETURN = .F.
else
   zRETURN = .T.
endif

* Restore the screen and color to calling programs, if defined.
restore screen from mSCREEN
set color to &mCOLOR

return
