* System       : Customer Access System - Personal Computer
* File         : zWINDOW.prg (Black Box)
* Called from  : Everywhere
* Description  : Pop's a window with shadow at caller specified location/color
* Databases    : None
* Calls        : None
* UDF Calls    : none
* Written      : 03/17/89 DKA
* Tested       :
* Parameters   : top,left,bottom,right,color,border,shadow - see below.
* Requirements : none - may use sCOLOR, see NOTE below.
*

******************************** NOTES ********************************
* EXCEPTIONS   : 
*
* COMMENTS     : Program will reset color to previous setting prior to return.
*
******************
* Get passed parameters into local variables, you must pass 7 in this order -
*      First   - VALUE corresponding to row for top of box         Ex.) 5
*      Second  - VALUE corresponding to col for left side of box   Ex.) 10
*      Third   - VALUE corresponding to row for bottom of box      Ex.) 19
*      Fourth  - VALUE corresponding to row for right side of box  Ex.) 70
*      Fifth   - String corresponding to color setting.            Ex.) "+w/b"
*                (Pass "" for it to use current color setting)
*      Sixth   - Value, BORDER - 0 none, 1 single, 2 double        Ex.) 2
*      Seventh - Value, SHADOW - 0 none, 1 Left, 2 Center, 3 Right Ex.) 3
*
* Ex.) To put up a red box with a white single line border at row 5, column 10 
*      thats 9 deep and 60 wide, with a shadow along the bottom and right edges,
*
*      do window with 5,10,19,70,"+w/r",1,3 
*      
******************
*
******************************** NOTES ********************************

**** Receive passed parameters.
parameter mTOP,mLEFT,mBOTTOM,mRIGHT,mCOLOR,mBORDER,mSHADOW

**** Private internal variables.
private mTOP,mLEFT,mBOTTOM,mRIGHT,mCOLOR,mBORDER,mSHADOW
private mTOP2,mLEFT2,mBOTTOM2,mRIGHT2
private mCOL
private mCOLOR_OLD

**** Check for bad parameters - split up the if for readability.
if mTOP>mBOTTOM.or.;
   mLEFT>mRIGHT.or.;
   mLEFT<0.or.mLEFT>80.or.;
   mRIGHT<0.or.mRIGHT>80.or.;
   mTOP<0.or.mTOP>24.or.;
   mBOTTOM<0.or.mBOTTOM>24.or.;
   mBORDER<0.or.mBORDER>2.or.;
   mSHADOW<0.or.mSHADOW>3.or.;
   type("mCOLOR")<>"C"

   * What an if statement!  Phew!!!

   * Clear the screen to a lovely BLOOD red.
   set color to +w/r
   clear

   * Beep them they did something wrong.
   ?? chr(7)

   * Display what they tried to use.
   @ 1,5 say "    PARAMETERS"
   @ 3,5 say "Top    " + chr(16) + " " + trim(ltrim(str(mTOP)))
   @ 4,5 say "Left   " + chr(16) + " " + trim(ltrim(str(mLEFT)))
   @ 5,5 say "Bottom " + chr(16) + " " + trim(ltrim(str(mBOTTOM)))
   @ 6,5 say "Right  " + chr(16) + " " + trim(ltrim(str(mRIGHT)))
   @ 7,5 say "Color  " + chr(16) + " " + iif(type("mCOLOR")="C",mCOLOR,"<- Invalid")
   @ 8,5 say "Border " + chr(16) + " " + iif(mBORDER=0,"None",iif(mBORDER=1,"Single",iif(mBORDER=2,"Double",trim(ltrim(str(mBORDER))))))
   @ 9,5 say "Shadow " + chr(16) + " " + iif(mSHADOW=0,"None",iif(mSHADOW=1,"Left",iif(mSHADOW=2,"Centered",iif(mSHADOW=3,"Right",trim(ltrim(str(mBORDER)))))))

   * Tell them why they couldn't, lots of different possibilities!!!!
   mCOL = 11
   if mTOP > mBOTTOM
      @ mCOL,30  say "Top is below the bottom!"
      mCOL = mCOL + 1
      @ 3,25 say "<- INVALID"
      @ 5,25 say "<- INVALID"
   endif
   if mLEFT > mRIGHT
      @ mCOL,30  say "Left side to right of right side!"
      mCOL = mCOL + 1
      @ 4,25 say "<- INVALID"
      @ 6,25 say "<- INVALID"
   endif
   if mLEFT < 0 .or. mRIGHT < 0
      if mLEFT < 0
         @ 4,25 say "<- INVALID"
         @ mCOL,30  say "Left side off the screen, dude!"
         mCOL = mCOL + 1
      endif
      if mRIGHT < 0
         @ 6,25 say "<- INVALID"
         @ mCOL,30  say "Right side off the screen, dude!"
         mCOL = mCOL + 1
      endif
   endif
   if mRIGHT > 80 .or. mLEFT > 80
      @ mCOL,30 say "Sorry, 80 column monitor support only!"
      mCOL = mCOL + 1
      if mLEFT > 80
         @ 4,25 say "<- INVALID"
      endif
      if mRIGHT > 80
         @ 6,25 say "<- INVALID"
      endif
   endif
   if mTOP < 0 .or. mBOTTOM < 0
      if mTOP < 0
         @ 3,25 say "<- INVALID"
         @ mCOL,30 say "Top is to far up."
         mCOL = mCOL + 1
      endif
      if mBOTTOM < 0
         @ 5,25 say "<- INVALID"
         @ mCOL,30 say "Bottom is to far up."
         mCOL = mCOL + 1
      endif
   endif
   if mBOTTOM > 24 .or. mTOP > 24
      if mTOP > 24
         @ 3,25 say "<- INVALID"
         @ mCOL,30 say "Top is below bottom of screen, dude!"
         mCOL = mCOL + 1
      endif
      if mBOTTOM > 24
         @ 5,25 say "<- INVALID"
         @ mCOL,30 say "Bottom would be off the screen, dude!"
         mCOL = mCOL + 1
      endif
   endif
   if type("mCOLOR") <> "C"
      @ mCOL,30 say "The color setting must be passed as STRING."
      mCOL = mCOL + 1
      @ mCOL,30 say '(ie "+w/r", or "r/n", or whatever!)' 
      mCOL = mCOL + 1
   endif
   if mBORDER < 0 .or. mBORDER > 2
      @ mCOL,30 say "Please use 0, 1 or 2 for the border."
      mCOL = mCOL + 1
      @ mCOL,30 say "  (None, single line, double line)"
      mCOL = mCOL + 1
      @ 8,25 say "<- INVALID"
   endif
   if mSHADOW < 0 .or. mSHADOW > 3
      @ mCOL,30 say "Please use 0, 1, 2 or 3 for the shadow."
      mCOL = mCOL + 1
      @ mCOL,30 say "  (None, Throw Left, Throw Center, Throw Right)"
      mCOL = mCOL + 1
      @ 9,25 say "<- INVALID"
   endif

   * Put cursor on 20th line and cancel ("do cancelled" will appear there).
   @ 20,0 say ""
   cancel
endif

**** Okay, everything passed parameter checking, lets do the box

** Set up internal variables
* Store calling programs color setting for restoration prior to return.
mCOLOR_OLD = sys(2001,"COLOR")
* If they passed a color, try to set to that color.  NOTE IF YOU PASS A BAD ONE, PROGRAM WILL CRASH!
if mCOLOR > "!"
   set color to &mCOLOR
endif
* Set beginning coordinates to a dot in the center of the requested POP area.
mTOP2    = mTOP  + int((mBOTTOM-mTOP)/2)
mLEFT2   = mLEFT + int((mRIGHT-mLEFT)/2)
mBOTTOM2 = mTOP  + int((mBOTTOM-mTOP)/2)
mRIGHT2  = mLEFT + int((mRIGHT-mLEFT)/2)

** Expand BOX till you reach full size, starting in center of specs.
do while mLEFT2>mLEFT .or. mTOP2>mTOP .or. mBOTTOM2<mBOTTOM .or. mRIGHT2<mRIGHT
   * Clear the growing region
   @ mTOP2,mLEFT2 clear to mBOTTOM2,mRIGHT2
   * Increment the temp counters for position up/down by one
   if mTOP2 > mTOP
      mTOP2=mTOP2-1
   endif
   if mBOTTOM2 < mBOTTOM
      mBOTTOM2=mBOTTOM2+1
   endif
   * Increment the left/right counters by two, making sure they don't go past.
   if mLEFT2 > mLEFT
      mLEFT2 = mLEFT2 - 2
      if mLEFT2 < mLEFT
         mLEFT2 = mLEFT
      endif
   endif
   if mRIGHT2 < mRIGHT
      mRIGHT2 = mRIGHT2 + 2
      if mRIGHT2 > mRIGHT
         mRIGHT2 = mRIGHT
      endif
   endif
enddo

** Draw the full box.
@ mTOP,mLEFT clear to mBOTTOM,mRIGHT

** Draw a border, if requested.
if mBORDER > 0
   if mBORDER = 2
      @ mTOP,mLEFT to mBOTTOM,mRIGHT double
   else
      @ mTOP,mLEFT to mBOTTOM,mRIGHT
   endif
endif

** Create that 3d awesome effect, if requested.
Do Case
   * Throw shadow left - first the left side, then the bottom - if there is room on screen for it.
   case mSHADOW = 1 .and. mLEFT > 1 .and. mBOTTOM < 24
      set color to w/n
      if mTOP <> mBOTTOM                            && No shadow on single line boxes.
         @ mTOP+1,mLEFT-2 clear to mBOTTOM,mLEFT-1
      endif
      if mLEFT <> mRIGHT                            && No shadow on single column boxes.
         @ mBOTTOM+1,mLEFT-2 clear to mBOTTOM+1,mRIGHT-2
      endif
   * Throw shadow CENTERED - just the bottom - if there is room on screen for it.
   case mSHADOW = 2 .and. mBOTTOM < 24
      set color to w/n                              && No shadow on single column boxes.
      if (mLEFT+2) < (mRIGHT-2)
         @ mBOTTOM+1,mLEFT+2 clear to mBOTTOM+1,mRIGHT-2
      endif
   * Throw shadow right - first the right side, then the bottom - if there is room on screen for it.
   case mSHADOW = 3 .and. mRIGHT < 79 .and. mBOTTOM < 24
      set color to w/n
      if mTOP <> mBOTTOM                            && No shadow on single line boxes.
         @ mTOP+1,mRIGHT+1 clear to mBOTTOM,mRIGHT+2
      endif
      if mLEFT <> mRIGHT                            && No shadow on single column boxes.
         @ mBOTTOM+1,mLEFT+2 clear to mBOTTOM+1,mRIGHT+2
      endif
endcase

** Reset color to setting prior to call.
set color to &mCOLOR_OLD
return
