* System       : Customer Access System - Personal Computer
* File         : zSCROLL.prg
* Procedure    : None
* Called from  : Everywhere.
* Description  : Scroll and select black box routine.
* Databases    : Uses database in current select area.
* Calls        : None
* UDF Calls    : none
* Written      : 03/17/89 DKA
* Updated      : 
* Tested       : 
* Parameters   : Parameter 1 - "FIELD1[size],FIELD2[size],...FIELDn[size]"
* Parameters   : Parameter 2 - "TOP,LEFT,BOTT,RIGHT,TITLES"
* Parameters   : Parameter 3 - "COLOR1,COLOR2,COLOR3"
* Requirements : See below.
*

******************************** NOTES ************************************
* 
* REQUIREMENTS:  There must be a database open in the current select area.
* 
*                Public variables zRETURN, zOPTION, and sCOLOR should be
*                defined (if not, zRETURN and zOPTION will be publiced).
* 
*                User may exit in two ways - by hitting escape or by hitting 
*                Enter.  ESCAPE - zRETURN = .f., zOPTION = "".
*                        ENTER  - zRETURN = .t., zOPTION = Contents of FIELD1.
* 
*                Upon completion, database is returned to previous record if
*                ESCAPE was hit, or selected record if ENTER was hit.
* 
*                Index orders are not messed with, it is assumed you will put
*                the database in the correct order before running the routine.
* 
*           PARAMETER1 - FIELDS, NAMES & SIZES
*              NAMES:
*                Each field name passed must be delimited by commas.
*                
*                No two commas may follow each other.  Use format
*                "<field><[size]>, . . .,<field><[size]>" strictly.  Notice
*                no trailing comma after last field!
*                
*                The first field passed must be the active index key.
*                All field names passed must exist in current select areas' dbf
*                
*              SIZES:
*                Field sizes are optional.  You need not pass anything for
*                any one field size.  EXCEPTION - Numeric fields require a
*                size (No way of knowing how big they are!).
*                
*                Field sizes must be bracketed with [].  Brackets must balance,
*                and all opens ([) must preceed the closes (]).  Every set of
*                brackets must have a number in them, if not two numbers de-
*                limited with a comma.  No field should have more than one
*                bracket set following it.  Use format [<total>,<decimal>]
*                (or just [<total>]!) strictly.
*                
*                Field sizes for date and logical fields will be ignored.
*                
*                Field sizes for character fields behave as follows - 
*                    Size passed >= size of field     IGNORED - Entire field displayed
*                    Size passed < size of field      FIELD CONTENTS TRUNCATED
*                    No size passed                   Entire field displayed.
* 
*                Numeric field sizes (required) will default to 0 decimal
*                places, unless two numbers are in the brackets seperated
*                by a comma, in which case the first number is the total 
*                size of the number, and the 2nd is the number of decimal
*                places.
* 
*                NOTE - if you truncate a character field by passing a small
*                size, the minimum size will be the length of the FIELD NAME
*                itself, for the FIELD NAME must appear on top of the column.
*                Any columns minimum width will be the size of the FIELD NAME.
*                
*           PARAMETER2 - WINDOW DIMENSIONS AND TITLE
* 
*                The four window dimensions must be passed.
* 
*                Window height (Bottom - Top) must be > 5 (allows for 3 lines
*                of scroll minimum).
* 
*                Window width must be greater by 2 than the sum of all the
*                field widths.
* 
*                Left & Right must be > 0 and <= 80, Top & Bottom must be
*                > 0 and <= 24.
* 
*                Title width may not be > Window width minus 2.
* 
*           PARAMETER3 - DISPLAY COLORS
* 
*                Each display color must be a valid foxbase color.
*                Any or all of the colors may be omitted.
* 
*                COLOR1 - Box color for window, display color for scroll text.
*                COLOR2 - Highlight scroll bar color.
*                COLOR3 - Window Titles display color.
* 
*                If any or all of the colors are omitted, and sCOLOR is defined,
*                COLOR1 = sCOLOR, COLOR2 = enhanced portion of sCOLOR, or n/w if
*                sCOLOR does not contain the enhanced portion (+w/b,n/bg),
*                COLOR3 = sCOLOR.                          Enhanced -^^-
* 
*                If sCOLOR is not defined and any or all of the colors are
*                omitted, COLOR1 = w/n, COLOR2 = n/w, COLOR3 = w/n.
* 
*                Parsing routine below can handle any of these combinations -
*                   "w/b,w/b,w/b"         "w/b,w/b"         "w/b"
*                   "w/b,,"               "w/b,"
*                   ",,w/b"               ",w/b,"
*                   "w/b,,w/b"            and so on...  
* 
*                Whatever you omit will be set to default (either sCOLOR or
*                black on white stuff - see above).
* 
* EXAMPLES - 
*      ** Scroll and select patient, display first 10 characters of last name.
*      do zSCROLL with "SSN,LAST[10]","5,40,20,78,SELECT PATIENT","+w/b,n/w,+gr/b"
*      if .not. zRETURN       && They did not select any customer.
*         ...                    && 
*      endif                  &&
*       . . .
* --------------------
*    ** Have user select a social security number to edit.  Use full SSN Field in column.
*    do zSCROLL with "SSN","2,65,22,78,PICK SSN",""
*    if .not. zRETURN       && They did not select a SSN.
*       return                 && Abandon editing.
*    endif                  &&
*    ** Get rest of information for edit.
*    mSSN  = zOPTION        && zOPTION and SSN Field would be same, for 
*    mLAST = LASTNAME       && zSCROLL pointed to record with SSN required.
*    mFIRST
*     . . .
* --------------------
******************************** END NOTES ********************************

******** Receive passed parameters.
parameters mPARAM1,mPARAM2,mPARAM3

******** Public necessary variables if they are not.
if type("zRETURN") = "U"                  && 
   public zRETURN                            && 
endif                                     && 
if type("zOPTION") = "U"                  && 
   public zOPTION                            && 
endif                                     && 

******** Private internal variables.
private mCOUNT,mCOUNTER
private mVAR,mVAR2,mVAR3,mVAR4
private mROW,mCOL,mREC,mREC_OLD,mREC_ORIG,mNUM_RECS
private mLINE,mLINE_OLD,mLINES,mNUM_FLDS
private mARRAY,mARRAY2
private mA_FIELD,mA_TYPE,mA_WIDTH,mA_DECIMALS
private mHOME,mEND,mKEY,mFLAG
private mTOP,mBOTTOM,mLEFT,mRIGHT,mTITLE,mWIDTH
private mCOLOR,mCOLOR1,mCOLOR2,mCOLOR3
private mSCREEN
private mSCREEN2,mCOLOR_A,mPICTURE

******** Define variables, parse out parameters (check validity of parameters somewhat).
mCOLOR  = sys(2001,"COLOR")            && Store previous color setting for restoral before return.
zRETURN = .F.                          && Store default values to return variables.
zOPTION = ""                           &&       "           "
mA_FIELD    = 1                        && Field name element in mARRAY.
mA_TYPE     = 2                        && Field type element in mARRAY.
mA_WIDTH    = 3                        && Field width element in mARRAY.
mA_DECIMALS = 4                        && Number of decimals for numeric field element in mARRAY.
save screen to mSCREEN                 && Store current screen to temporary variable for restoral before return.

******** Store current record number in database to a variable for restoring later, and current screen.
if eof() .or. bof()                    && Don't store something that will cause an error later,
   go top                                 && make it behave.
endif                                  && 
if eof() .or. bof()
   do zMESSAGE with "NO RECORDS TO SCROLL THRU IN "+alias()+", press any key...","+w/r"
   set console off
   wait
   set console on
   return
endif
mREC_ORIG  = recno()                   && Store current record number so we can return to it if they hit escape.

**** Parse parameter 1
** Check if parameter blank.
mVAR = trim(ltrim(mPARAM1))               && Store parameter 1 to a temporary variable.
if mVAR == ""                             && If parameter one was empty,
   do zMESSAGE with "zSCROLL FATAL ERROR - At least one field (parameter 1) is required...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif                                     && 

** Check if parameter contains trailing commas.
if right(mVAR,1) = ','                    && If parameter one contains trailing commas,
   do zMESSAGE with "zSCROLL FATAL ERROR - Trailing commas in parameter 1 ("+mVAR+")...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif                                     && 

** Check brackets - correct opens and closes, and contents are numbers.
mVAR   = trim(ltrim(mPARAM1))             && Store parameter 1 to a temporary variable.
mCOUNT = 0                                && Start with a count of 0 bracket sets.
do while "["$mVAR .or. "]"$mVAR           && Loop while there are open brackets.
   mCOUNT = mCOUNT + 1                       && Keep count of how many brackets they have.
   if at("[",mVAR) > at("]",mVAR)            && Trap for preceeding or missing CLOSE brackets.
      do zMESSAGE with "zSCROLL FATAL ERROR - Bracket set "+ltrim(str(mCOUNT))+" not balanced in "+mPARAM1+"...","+w/r"
      ?? chr(7)                                 && Beep.
      cancel                                    && Display fatal error and BOMB.
   endif                                     && 
   if at("[",mVAR)=0 .and. at("]",mVAR)>0    && Trap for close brackets with no preceeding open bracket.
      do zMESSAGE with "zSCROLL FATAL ERROR - No OPEN Bracket in set "+ltrim(str(mCOUNT))+" of "+mPARAM1+"...","+w/r"
      ?? chr(7)                                 && Beep.
      cancel                                    && Display fatal error and BOMB.
   endif
   mVAR2  = substr(mVAR,at("[",mVAR)+1)      && Get contents of bracket set.   
   mVAR2  = left(mVAR2,at("]",mVAR2)-1)      && Now have contents of bracket set.
   if val(mVAR2)=0                           && If the first part of the bracket is not a number,
      do zMESSAGE with "zSCROLL FATAL ERROR - Bracket set "+ltrim(str(mCOUNT))+" not a number ("+mVAR2+") in "+mVAR+"...","+w/r"
      ?? chr(7)                                 && Beep.
      cancel                                    && Display fatal error and BOMB.
   endif                                     && 
   if ","$mVAR2                              && If there is supposed to be a second number in the bracket, evaluate it.
      mVAR3 = iif(at(",",mVAR2)=len(mVAR2),0,val(substr(mVAR2,at(",",mVAR2)+1)))
      if mVAR3=0                             && If the second part of the bracket is not a number,
         do zMESSAGE with "zSCROLL FATAL ERROR - Bracket set "+ltrim(str(mCOUNT))+" not numbers ("+mVAR2+") in "+mVAR+"...","+w/r"
         ?? chr(7)                                 && Beep.
         cancel                                    && Display fatal error and BOMB.
      endif                                     && 
   endif                                     && 
   * Bracket set passed with flying colors, dump everything up to and including close bracket.  Store NULL if close bracket is end.
   mVAR = iif(at("]",MVAR)=len(mVAR),"",substr(mVAR,at("]",mVAR)+1))
   * If the next bracket set comes before the next field (delimited with commas),
   * and there is another bracket set (note - if there is not another field, first line will
   * evaluate false - 0, no comma, is not > 0, no bracket),
   if at(",",mVAR) > at("[",mVAR) .and. at(",",mVAR) > at("]",mVAR) .and. at("[",mVAR) > 0 .and. at("]",mVAR) > 0
      do zMESSAGE with "zSCROLL FATAL ERROR - Bracket set "+ltrim(str(mCOUNT+1))+" preceeds next field in "+mVAR+"...","+w/r"
      ?? chr(7)                                 && Beep.
      cancel                                    && Display fatal error and BOMB.
   endif                                     &&
enddo                                     && 

** Count the number of fields passed in parameter one.
mVAR      = trim(ltrim(mPARAM1))          && Store parameter 1 to a temporary variable.
mNUM_FLDS = 1                             && Set number of fields in parameter to default 1.
do while ','$mVAR                         && Enter a parsing loop looking for comma delimiters,
   if "["$mVAR .and. at("[",mVAR) < at(",",mVAR)   && If there is a bracket set, since it could have a comma in it,
      * Strip off field name and bracket set, and let loop count just the comma
      mVAR = iif(at("]",MVAR)=len(mVAR),"",substr(mVAR,at("]",mVAR)+1))
   else                                      && seperating it from the next field (if no next field, drops out of loop and # flds is 1).
      mNUM_FLDS = mNUM_FLDS + 1                 && for each comma found, increment number of fields in parameter
      mVAR = substr(mVAR,at(',',mVAR)+1)        && and remove that field and comma from temporary variable.
   endif
enddo                                     && Keeps looping, taking off one field at a time.

** Create an array with 4 elements for each field - NAME, TYPE, SIZE, DECIMALS.  Initialize with "".
dimension mARRAY(mNUM_FLDS,4)             && Create SCROLL array (privated above) with 4 elements for each FIELD to be displayed.
mARRAY = ""

** Store field names and sizes to the ARRAY.  Handles one or multiple arrays.  Checks for brackets with no field names also.
mVAR = trim(ltrim(mPARAM1))               && Reset temp var to whole FIELD NAME parameter again.
if mNUM_FLDS = 1                          && If there is only one field,
   if "["$mVAR                               && and there is a bracket set,
      mVAR2 = left(mVAR,at("[",mVAR)-1)         && Strip off brackets and
      mARRAY(1,mA_FIELD)=trim(ltrim(mVAR2))     && store the FIELD NAME to the first element of the array.
      mVAR2 = substr(mVAR,at("[",mVAR)+1)       && Now store what's in the brackets to
      mVAR2 = left(mVAR2,at("]",mVAR2)-1)       && a temporary variable and,
      if ","$mVAR2                              && if there are two numbers in the brackets,
         mARRAY(1,mA_WIDTH) = val(mVAR2)           && store the first to the size element and the second to the decimal,
         mARRAY(1,mA_DECIMALS) = val(substr(mVAR2,at(",",mVAR2)+1))
      else                                      && otherwise,
         mARRAY(1,mA_WIDTH) = val(mVAR2)           && store it to the size element
         mARRAY(1,mA_DECIMALS) = 0                 && and 0 to decimals element.
      endif                                     &&
   else                                      && Otherwise, just
      mARRAY(1,mA_FIELD)=mVAR                   && store the FIELD NAME to the first element of the array,
      mARRAY(1,mA_WIDTH)=0                      && and 0 to size element
      mARRAY(1,mA_DECIMALS)=0                   && and decimals element.
   endif                                     &&
   if mARRAY(1,mA_FIELD)==""                        && 
      do zMESSAGE with "zSCROLL FATAL ERROR - Parameter 1 has just brackets, no field name ("+mVAR+")...","+w/r"
      ?? chr(7)                                 && Beep.
      cancel                                    && Display fatal error and BOMB.
   endif                                     && 
else                                      && 
   mCOUNTER = 1                              && start at first field
   do while mCOUNTER <= mNUM_FLDS            && and loop thru all of the fields defining array with FIELD NAMES.
      * If there is a bracket before the next field (comma), or a bracket with single number in the last field (no commas),
      if "["$mVAR .and. (at("[",mVAR) < at(",",mVAR) .or. at(",",MVAR)=0)
         mVAR2 = left(mVAR,at("[",mVAR)-1)         && Strip off brackets and
         mARRAY(mCOUNTER,mA_FIELD)=trim(ltrim(mVAR2)) && store the FIELD NAME to the array.
         if mARRAY(mCOUNTER,mA_FIELD) == ""           && If there was no FIELD NAME before the bracket,
            do zMESSAGE with "zSCROLL FATAL ERROR - Just brackets found in field "+ltrim(str(mCOUNTER))+", parameter 1 ("+mPARAM1+")...","+w/r"
            ?? chr(7)                                 && Beep.
            cancel                                    && Display fatal error and BOMB.
         endif                                     && 
         mVAR2 = substr(mVAR,at("[",mVAR)+1)       && Now store what's in the brackets to
         mVAR2 = left(mVAR2,at("]",mVAR2)-1)       && a temporary variable and,
         if ","$mVAR2                              && if there are two numbers in the brackets,
            mARRAY(mCOUNTER,mA_WIDTH) = val(mVAR2)    && store the 1st to the size element and the 2nd to the decimal element,
            mARRAY(mCOUNTER,mA_DECIMALS) = val(substr(mVAR2,at(",",mVAR2)+1))
         else                                      && otherwise, put the one number in the brackets
            mARRAY(mCOUNTER,mA_WIDTH) = val(mVAR2)    && into the size element
            mARRAY(mCOUNTER,mA_DECIMALS) = 0          && and 0 to decimals element.
         endif                                     &&
         * Take FIELD NAME and bracket off of looping variable.
         mVAR = iif(at("]",MVAR)=len(mVAR),"",substr(mVAR,at("]",mVAR)+1))
         if .not. mVAR == ""
            mVAR = substr(mVAR,at(',',mVAR)+1)        && Take comma delimiter off (if there is one) of temp variable.
         endif
      else                                      &&
         * Store up to end of parameter or next comma.
         mARRAY(mCOUNTER,mA_FIELD) = left(mVAR,iif(at(',',mVAR)=0,len(mVAR),at(',',mVAR)-1))
         if mARRAY(mCOUNTER,mA_FIELD) == ""        && If any FIELD NAMES have more than one delimiter seperating,
            do zMESSAGE with "zSCROLL FATAL ERROR - Illegal use of delimiters in parameter 1 ("+mPARAM1+")...","+w/r"
            ?? chr(7)                                 && Beep.
            cancel                                    && Display fatal error and BOMB.
         endif                                     && 
         mARRAY(mCOUNTER,mA_WIDTH) = 0             && Store 0 to size element
         mARRAY(mCOUNTER,mA_DECIMALS) = 0          && and 0 to decimals element indicating default.
         mVAR = substr(mVAR,at(',',mVAR)+1)        && Take FIELD NAME (if not already trimmed) and comma delimiter off of temp variable.
      endif
      mCOUNTER = mCOUNTER+1                     && and increment looping counter.
   enddo                                     && Keep examing temporary variable till all FIELD NAMES parsed into ARRAY.
endif                                     && 

**** Parse parameter 2
mTOP    = 0                               && 
mLEFT   = 0                               && 
mBOTTOM = 0                               && 
mRIGHT  = 0                               && 
mTITLE  = ""                              && 
** Check if parameter is blank.
mVAR = trim(ltrim(mPARAM2))               && Store parameter 2 to a temporary variable.
if mVAR == ""                             && If parameter one was empty,
   do zMESSAGE with "zSCROLL FATAL ERROR - 4 window coordinates are required (parameter 2)...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif                                     && 

** Check if parameter contains trailing commas.
if right(mVAR,1) = ','                    && If parameter two contains trailing commas,
   do zMESSAGE with "zSCROLL FATAL ERROR - Trailing commas in parameter 2 ("+mVAR+")...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif                                     && 

** Count number of coordiantes passed in parameter 2.  Must be at least four.
mVAR  = trim(ltrim(mPARAM2))              && Store parameter 2 to a temporary variable.
mVAR2 = 1                                 && Set number of coordinates to default as one.
do while ','$mVAR                         && Enter a parsing loop looking for comma delimiters,
   mVAR2 = mVAR2 + 1                         && for each comma found, increment number of coord's in parameter
   mVAR = substr(mVAR,at(',',mVAR)+1)        && and remove that up to and including the comma from the variable.
enddo                                     && Keeps looping, taking off one field at a time.
if mVAR2 < 4                              && If there weren't four comma delimited coord's,
   do zMESSAGE with "zSCROLL FATAL ERROR - Less than 4 coordinates found in parameter 2 ("+mPARAM2+")...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif                                      && 

** Store each passed coordinate (and TITLE, if any) to variables.
mVAR     = trim(ltrim(mPARAM2))            && Store parameter 2 to a temporary variable.
mCOUNTER = 1                               && 
do while mCOUNTER <= mVAR2
   do CASE
      case mCOUNTER = 1
         mTOP    = val(mVAR)
      case mCOUNTER = 2 
         mLEFT   = val(mVAR)
      case mCOUNTER = 3
         mBOTTOM = val(mVAR)
      case mCOUNTER = 4
         mRIGHT  = val(mVAR)
      case mCOUNTER = 5
         mTITLE  = mVAR
   endcase
   mCOUNTER = mCOUNTER + 1
   mVAR = substr(mVAR,at(',',mVAR)+1)
enddo

**** Parse parameter 3
mCOLOR1 = ""                              && Store NULL to each of the 
mCOLOR2 = ""                              && three colors to be defined.
mCOLOR3 = ""                              && 
** Store the parameter or null to the three color variables.
mVAR    = mPARAM3                         && Store parameter three to temporary variable.
mCOLOR1 = left(mvar,iif(at(',',mvar)=0,len(mvar),at(',',mvar)-1))        && Whole param or up to 1st comma to color1 (could be null).
if ','$mVAR .and. .not. at(',',mVAR)=len(mVAR)                           && If the temp var has commas,
   mVAR    = substr(mVAR,at(',',mVAR)+1)                                 && Strip the first color up to and including comma off.
   mCOLOR2 = left(mVAR,iif(at(',',mVAR)=0,len(mVAR),at(',',mVAR)-1))     && Contents up to next comma to color2 (could also be null).
   if ','$mVAR .and. .not. at(',',mVAR)=len(mVAR)                        && If there are still more commas,
      mVAR    = substr(mVAR,at(',',mVAR)+1)                              && Strip second color argument off - including comma,
      mCOLOR3 = left(mVAR,iif(at(',',mVAR)=0,len(mVAR),at(',',mVAR)-1))  && and store what's left up to any other commas to color3.
   endif                                                                 && NOTE - to add a forth comma is easy, just add another IF.
endif                                     && 
** Get default color (system color if defined, black on white if not).
if type("sCOLOR") = "U"                   && If system color undefined,
   mVAR = "w/n,n/w"                          && store default white on black, black on white enhanced.
else                                      && Otherwise
   mVAR = sCOLOR                             && Store system color.
   if .not. ','$mVAR                         && If system color does not have enhanced display,
      mVAR = mVAR + ",n/w"                      && tack the default enhanced display on.
   endif                                     && 
endif                                     && 
** Store default color to undefined color parameters.
if mCOLOR1==""                            && If normal display color is undefined, 
   mCOLOR1 = mVAR                            && store default color to it.
endif                                     && 
if mCOLOR2==""                            && If high light bar color is undefined,
   mCOLOR2 = substr(mVAR,at(',',mVAR)+1)     && store default enhanced color to it.
endif                                     && 
if mCOLOR3==""                            && If window titles display color is undefined,
   mCOLOR3 = mVAR                            && 
endif                                     && 

******** Check validity of passed parameters some more.

**** PARAMETER 1 - Make sure each field can be accessed.  Store type information, and sizes, to array.  Increment mWIDTH (total width).
if alias() == ""                          && 
   do zMESSAGE with "zSCROLL FATAL ERROR - No database open in current work area...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif                                     && 
mFLAG    = .f.                            && Display flag - not displayed.
mCOUNTER = 1                              && Start at first field, go through all in parameter.
mWIDTH   = 0                              && Set TOTAL field widths to 0.
do while mCOUNTER <= mNUM_FLDS            && Go thru each field defined.
   mVAR=alias()+"->"+mARRAY(mCOUNTER,mA_FIELD)  && Store field name to variable.  Use database alias to avoid mem var conflicts.
   if type(mVAR) = "U"                       && If field does not exist in database, 
      if .not. mFLAG                            && Display error titles just once,
         clear                                     && Clear the screen.
         @ 8,0 say 'PARAMETER ONE INVALID - "'+mPARAM1+'"'
         mFLAG = .t.                               && Set display flag to indicate TITLE displayed.
      endif                                     && Display Illegal field names.
      @ 10+iif(mCOUNTER>10,1,mCOUNTER),iif(mCOUNTER>10,40,0) say "Field"+ltrim(str(mCOUNTER))+" = "+mARRAY(mCOUNTER,mA_FIELD)
      @ 10+iif(mCOUNTER>10,1,mCOUNTER),iif(mCOUNTER>10,62,21) say "ILLEGAL FIELD NAME"
   else
      * Define types, widths, and bomb where necessary (Numerics with no sizes, etc...)
      mVAR2 = type(mVAR)                        && 
      mVAR4 = mARRAY(mCOUNTER,mA_FIELD)         && Store field name to variable.
      do CASE                                   && 
         case mVAR2 = "C"                          && 
            if mARRAY(mCOUNTER,mA_WIDTH) = 0          && If they did not pass a size for the character field, 
               * define it to length of field name or size of field, whichever is greater.
               mARRAY(mCOUNTER,mA_WIDTH) = iif(len(mVAR4)>len(&mVAR4),len(mVAR4),len(&mVAR4))
            else                                      && otherwise,
               if mARRAY(mCOUNTER,mA_WIDTH)<len(mVAR4)   && if the size they did pass is smaller than the field name itself,
                  mARRAY(mCOUNTER,mA_WIDTH)=len(mVAR4)      && over-ride it with the length of the field name.
               endif                                     && 
               if mARRAY(mCOUNTER,mA_WIDTH)>len(&mVAR4)  && If the size they passed is larger than the size of the field,
                  mARRAY(mCOUNTER,mA_WIDTH)=len(&mVAR4)     && store the size of the field to the width element.
               endif                                     && 
            endif                                     && 
            mARRAY(mCOUNTER,mA_DECIMALS) = 0          && Set decimals to 0.
            mWIDTH = mWIDTH + mARRAY(mCOUNTER,mA_WIDTH)  && Add width of this field to total width of all fields.
         case mVAR2 = "N"                          && 
            if mARRAY(mCOUNTER,mA_WIDTH) = 0          && If they did not pass a size for a NUMERIC field,
               do zMESSAGE with "zSCROLL FATAL ERROR - Field #"+ltrim(str(mCOUNTER))+" is numeric, must have [SIZE] parameter...","+w/r"
               ?? chr(7)                                 && Beep.
               cancel                                    && Display fatal error and BOMB.
            endif                                     &&
            if len(mVAR4) > mARRAY(mCOUNTER,mA_WIDTH) && 
               mWIDTH = mWIDTH + len(mVAR4)              && Add width of the field name to total width of all fields.
            else                                      && 
               mWIDTH=mWIDTH+mARRAY(mCOUNTER,mA_WIDTH)   && Add total size of this field to total width of all fields.
            endif                                     && 
         case mVAR2 = "L"                          && If field is logical,
            mARRAY(mCOUNTER,mA_WIDTH) = len(mVAR4)    && force size to length of field name.
            mARRAY(mCOUNTER,mA_DECIMALS) = 0          && Set decimals to 0.
            mWIDTH = mWIDTH + mARRAY(mCOUNTER,mA_WIDTH)  && Add width of this field to total width of all fields.
         case mVAR2 = "D"                          && If field is date,
            * Force width to length of field name, or 8 (date width), whichever is greater.
            mARRAY(mCOUNTER,mA_WIDTH) = iif(len(mVAR4)>8,len(mVAR4),8)
            mARRAY(mCOUNTER,mA_DECIMALS) = 0          && Set decimals to 0.
            mWIDTH=mWIDTH+mARRAY(mCOUNTER,mA_WIDTH)   && Add width of this field to total width of all fields.
         otherwise                                 && If it is a memo field, or anything else,
            do zMESSAGE with "zSCROLL FATAL ERROR - Unsupported field type "+mVAR2+", field #"+ltrim(str(mCOUNTER))+"...","+w/r"
            ?? chr(7)                                 && Beep.
            cancel                                    && Display fatal error and BOMB.
      endcase                                   &&
      mARRAY(mCOUNTER,mA_TYPE) = mVAR2          && Store type to the array.
   endif                                     && 
   mCOUNTER = mCOUNTER+1                     && Go to next field.
enddo                                     && 
if mFLAG                                  && If there was an error,
   @ 22,0 say "Database - "+alias()          && Database name in current work area.
   do zMESSAGE with "zSCROLL FATAL ERROR - Parameter one contains illegal field names, press a key...","+w/r"
   ?? chr(7)                                 && Beep, show fatal error and BOMB.
   set console off                           && 
   wait                                      && 
   set console on                            && 
   cancel                                    && 
endif                                     && Phew!

**** PARAMETER 2 - Check window coordinates.
if mTOP <= 0 .or. mBOTTOM <= 0 .or. mRIGHT <= 0 .or. mLEFT <= 0
   do zMESSAGE with "zSCROLL FATAL ERROR - Window coordinates ("+mPARAM2+") evaluate to zero or less...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif                                     && 
if mTOP > mBOTTOM .or. (mBOTTOM - mTOP) < 6
   do zMESSAGE with "zSCROLL FATAL ERROR - Window must be at least 6 lines deep - parameter 2 ("+mPARAM2+")...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif
if mLEFT > mRIGHT
   do zMESSAGE with "zSCROLL FATAL ERROR - Left > Right, parameter 2 ("+mPARAM2+")...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif
if len(mTITLE) > (mRIGHT-mLEFT)-2
   do zMESSAGE with "zSCROLL FATAL ERROR - Title exceeds window width, parameter 2 ("+mPARAM2+")...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif
if (mRIGHT-mLEFT) < (mWIDTH + 2 + mNUM_FLDS)
   do zMESSAGE with "zSCROLL FATAL ERROR - Window width ("+ltrim(str(mRIGHT-mLEFT))+") < fields width ("+ltrim(str(mWIDTH+2+mNUM_FLDS))+")...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif
if mBOTTOM > 24 .or. mTOP > 24 .or. mLEFT > 80 .or. mRIGHT > 80
   do zMESSAGE with "zSCROLL FATAL ERROR - Window coordinates ("+mPARAM2+") exceed screen...","+w/r"
   ?? chr(7)                                 && Beep.
   cancel                                    && Display fatal error and BOMB.
endif

**** PARAMETER 3 - Test each color variable.
mVAR = .f.                                && 
* REMEMBER - NO REMARKS ON SAME LINE AS RUN COMMANDS OR ON <blah> COMMANDS!
on error mVAR = .t.                        
set color to &mCOLOR1                     && 
if mVAR                                   && 
   do zMESSAGE with "zSCROLL FATAL ERROR - color number 1 invalid ("+mCOLOR1+"), press any key...","+w/r"
   ?? chr(7)                                 && 
   cancel                                    && 
endif                                     && 
set color to &mCOLOR2                     && 
if mVAR                                   && 
   do zMESSAGE with "zSCROLL FATAL ERROR - color number 2 invalid ("+mCOLOR2+"), press any key...","+w/r"
   ?? chr(7)                                 && 
   cancel                                    && 
endif                                     && 
set color to &mCOLOR3                     && 
if mVAR                                   && 
   do zMESSAGE with "zSCROLL FATAL ERROR - color number 3 invalid ("+mCOLOR3+"), press any key...","+w/r"
   ?? chr(7)                                 && 
   cancel                                    && 
endif                                     && 
* REMEMBER - NO REMARKS ON SAME LINE AS RUN COMMANDS OR ON <blah> COMMANDS!
on error

******** Open scroll window.
do zWINDOW with mTOP,mLEFT,mBOTTOM,mRIGHT,"&mCOLOR1",1,3

******** Display scroll window title, field name titles, and instruction bar.
set color to &mCOLOR3                  && Set color to the titles display color.
if mTITLE > "!"                        && Display the window title centered, if their is one.
   @ mTOP,mLEFT+int((mRIGHT-mLEFT)/2-(len(mTITLE)+2)/2) say " "+mTITLE+" "
endif                                  && 
mROW   = mTOP+1                        && Set first row
mCOL   = mLEFT+2                       && and column coordinates based on window coordinates.
mCOUNT = 1                             && Start with first field
do while mCOUNT <= mNUM_FLDS           && and loop thru all of the titles to be displayed.
   if mARRAY(mCOUNT,mA_TYPE) = "N"        && If the field is type NUMERIC, the width is either as defined in array, or total size of field name.
      mVAR = iif(len(mARRAY(mCOUNT,mA_FIELD))>mARRAY(mCOUNT,mA_WIDTH),len(mARRAY(mCOUNT,mA_FIELD)),mARRAY(mCOUNT,mA_WIDTH))
   else                                   && otherwise,
      mVAR = mARRAY(mCOUNT,mA_WIDTH)         && the width is as defined in the array.
   endif                                  && 
   @ mROW,mCOL say upper(mARRAY(mCOUNT,mA_FIELD))    && Display the field name as a title.
   @ mROW+1,mCOL say replicate(chr(196),mVAR)        && Underline the titles.
   mCOL   = mCOL + mVAR + 1               && Increment column counter.
   mCOUNT = mCOUNT + 1                    && Increment looping counter.
enddo                                  && 
do zMESSAGE with "ESC Exit    --    PGUP     PGDN    HOME    END     Select","+w/r"

******** Enter MAIN loop till ESC or ENTER.
mLINE     = 1                          && Start highlight bar on top line.
mLINE_OLD = 0                          && and last highlight bar as non-existent.
mLINES  = (mBOTTOM-1) - (mTOP+2)       && Determine the number of lines that can fit on one page.
dimension mARRAY2(mLINES)              && Create an array with 1 element for each line on a page.
mARRAY2 = ""                           && Initialize array with NULL character.
go top                                 && Start scroll loop at top of database.
mREC       = recno()                   && Store current record number to be top of page.
mREC_OLD   = 0                         && Set old top of page to 0, for page refresh inside loop.
mNUM_RECS  = reccount()                && Store total number of records in database to variable.
mKEY       = 0                         && Store 0 to USER KEYSTROKE HIT variable.
mHOME      = .f.                       && Store KEY NOT HIT indicator to HOME KEY flag,
mEND       = .f.                       && and to END KEY flag.
do while .t.                           && Enter loop,
   **** Display PAGE of data if it's a new page (mREC # mREC_OLD)
   if mREC # mREC_OLD                     && 
      set color to &mCOLOR1                  && 
      go mREC                                && go to top of page.
      mCOUNT = 1                             && Loop thru number of lines that can fit on one page and NOT EOF()!
      do while mCOUNT <= mLINES .and. .not. eof()
         mVAR2    = ""                          && Store NULL to variable which will contain entire lines text,
         mCOUNTER = 1                           && Loop thru from first field to 
         do while mCOUNTER <= mNUM_FLDS         && number of fields per line to be displayed, building the line of text in mVAR2.
            mVAR = mARRAY(mCOUNTER,mA_FIELD)       && Store field name to variable.
            mVAR = &mVAR                           && Store contents of field to variable.
            do CASE                                && Determine what part of the field is to be displayed (substr, etc...).
               case mARRAY(mCOUNTER,mA_TYPE) = "C"    && Display width defined for character fields .
                  mVAR = substr(mVAR,1,mARRAY(mCOUNTER,mA_WIDTH))
               case mARRAY(mCOUNTER,mA_TYPE) = "N"    && Display numeric fields with str(width,decimals) from array..
                  mVAR = str(mVAR,mARRAY(mCOUNTER,mA_WIDTH),mARRAY(mCOUNTER,mA_DECIMALS))
               case mARRAY(mCOUNTER,mA_TYPE) = "L"    && Display logicals as Y/N.
                  mVAR = iif(mVAR,"Y","N")               && 
            endcase                                && 
            mVAR2 = mVAR2 + mVAR + space(1)        && Build the line text variable.
            mCOUNTER = mCOUNTER + 1                && Increment looping counter.
         enddo                                  && end of loop.
         @ mTOP+2+mCOUNT,mLEFT+2 say mVAR2      && Display the line of text built in loop above, 
         mARRAY2(mCOUNT) = mVAR2                && and store it to an array.
         mCOUNT = mCOUNT + 1                    && Increment looping counter..
         skip                                   && Skip in database..
      enddo                                  && end of loop..
      if mCOUNT-1<mLINES .and. mLINES<mNUM_RECS             && If last line displayed is not at the bottom of the available window, and if there are more records than can fit in one window,
         @ mTOP+2+mCOUNT,mLEFT+2 clear to mBOTTOM-1,mRIGHT-2   && Clear out any lines that may be left over from last page.
      endif                                  && 

      **** Move to the current line on the new page (Put RECORD POINTER in database and LINE NUMBER to match each other).
      go mREC                                && Go to record at top of page.
      mCOUNT = 2                             && Set counter to start with second line and go to line number.  If first line, everything is cool.
      do while mCOUNT<=mLINE .and. .not. eof() && Loop untill you get to current line #, or you hit eof().
         skip                                   && skip.
         mCOUNT = mCOUNT + 1                    && increment counter.
      enddo                                  && End of loop.
      if eof()                               && if they hit the end of file, 
         mLINE = mCOUNT - 1                     && then reset current line number to match,
         go bottom                              && and go back to bottom of database..
      endif                                  && endif.
      **** Finish up
      mLINE_OLD = 0                          && Set old line to 0 - don't low light anything..
      mREC_OLD = mREC                        && Set old top of page to this top of page..
   endif                                  && 
   
   **** Display high light bar if necessary.
   if mLINE # mLINE_OLD
      if mLINE_OLD # 0                       && If there was an old highlight bar lowlight it.
         set color to &mCOLOR1                  && Set color to normal display color and display the text from the array.
         @ mTOP+2+mLINE_OLD,mLEFT+2 say mARRAY2(mLINE_OLD)
      endif
      set color to &mCOLOR2                  && Set color to high-lite bar display color and display the text from the array.
      @ mTOP+2+mLINE,mLEFT+2 say mARRAY2(mLINE)
      mLINE_OLD = mLINE                      && Reset old high-lite line number to current line number.
   endif

   **** Get user keystroke.
   mKEY = inkey()

   **** Operate on their choice...
   do CASE
      case mKEY=27 .or. mKEY = 13            && Escape or Enter.
         exit                                   && Exit loop.
      case mKEY=5 .or. mKEY=19               && Up or Left.
         mLINE = mLINE - 1                      && Decrement line number.
         skip -1                                && Skip back one record.
         if bof()                               && If your before the top of the database, loop around to the bottom and display that page of data.
            if mNUM_RECS  > mLINES                 && If there are more records in the file than fit on one screen,
               go bottom                              && Go to the bottom of the database (last record).
               skip -mLINES                           && Skip back number of lines for one screen, thus last line on page is last line in database.
               mREC = recno()                         && Store the new top of page (mREC to current record number).
               mLINE = mLINES                         && set the line number to number of lines on one screen - ie the bottom line of the page!
            else                                   && Otherwise,
               mLINE = mNUM_RECS                      && Set the line number to the # records in database 
               go bottom                              && and the record pointer to the bottom of the database - ie move line to bottom of displayed page!
            endif                                  && 
         else                                   && Otherwise
            if mLINE = 0                           && If the line number = 0, ie they were at the top of the page when they hit UP,
               mLINE = mLINES                         && Set line number = number of lines (bottom of next screen).
               go mREC                                && go to the top record of this screen (mREC).
               skip -mLINES                           && Skip back one full screen (mLINES).
               if bof()                               && If that put them before the first record in the file,
                  go top                                 && just go up to the top of the database,
               endif                                  && 
               mREC = recno()                         && and store current record # to mREC - top record of new page.
            endif                                  && 
         endif                                  && 
         mHOME = .f.                            && Unset HOME and END flags.
         mEND  = .f.                            && 

      case mKEY=4 .or. mKEY=24               && Down or Right.
         mLINE = mLINE + 1                      && Increment line number.
         skip                                   && Skip forward one record.
         if eof()                               && If your below the bottom record in the database - (mREC will change for more rec's than fit on one screen, otherwise won't => display routine only called when needed!).
            go top                                 && go to the top of the database
            mREC = recno()                         && set mREC to current record number.
            mLINE = 1                              && Set the line number to 1.
         else                                   && Otherwise
            if mLINE > mLINES                      && If the line number (mLINE) > number of lines per screen (mLINES).
               mLINE = 1                              && Set line number = 1, top of new page.
               mREC = recno()                         && Set mREC to recno() - top of new page (will force redisplay of screen).
            endif                                  && 
         endif                                  && 
         mHOME = .f.                            && Unset HOME and END flags.
         mEND  = .f.                            && 

      case mKEY=1 .or. mKEY=6                && Home or End.
         if mKEY = 1                            && Home was hit,  &&& DO YOU REALLY NEED THE HOME FLAG, FOR THE GUY IS HOME FIRST TIME ANY WAY (CAN TELL BE RECNO()!!!).
            if mHOME .or. mREC = recno()           && If HOME flag is set (second time home hit in a row), or they are at the top of the page, go to the top of the database.
               go top                                 && Go to top of database
               if mREC = recno()                      && If in same place, then they were already at HOME,
                  ?? chr(7)                              && Beep
               else                                   && otherwise
                  mREC = recno()                         && Store current record to new top of page,
                  mHOME = .f.                            && Unset HOME flag.   
                  mLINE = 1                              && 
               endif                                  && Reset line number to top of page.
            else                                   && Otherwise
               mHOME = .t.                            && Set the HOME flag (first time home was hit - go top of page).
               go mREC                                && go mREC   (go to the top of the screen).
               mLINE = 1                              && Reset line number to top of page.
            endif                                  && 
            mEND = .f.                             && Unset END Flag.
         else                                   && Otherwise END was hit,
            mTEMP = recno()                        && Store current record number to temp var
            if mEND                                && If END flag is set (ie END has been hit once before),
               go bottom                              && Go to bottom of database.
               if mTEMP = recno()                     && If they did not move,
                  ?? chr(7)                              && Beep.
               else                                   && otherwise
                  skip -mLINES                           && Skip back one page from the bottom,
                  mREC = recno()                         && Store new top of page to variable,
                  mLINE = mLINES                         && Set line number to bottom of page,
                  mEND = .f.                             && Unset END flag.   
               endif                                  && 
            else                                   && Otherwise
               mEND = .t.                             && Set END flag
               if mLINES >= mNUM_RECS                 && If everything in database can fit on one screen,
                  go bottom                              && go to the bottom of the database,
                  mLINE = mNUM_RECS                      && Set line number to last line in database.
               else                                   && Otherwise,
                  do while mLINE < mLINES .and. .not. eof() && Move record and line to last displayed record on page.
                     mline = mline + 1                      && Move forward one line at a time
                     skip                                   && Move forward one record at a time.
                  enddo                                  && 
                  if eof()                               && if they hit the bottom on the way down,
                     mLINE = mLINE - 1                      && Went one to far, reset line number and
                     go bottom                              && record pointer.
                  endif                                  && 
                  if mLINE = mLINE_OLD                   && if they didn't go anywhere!)
                     ?? chr(7)                              && BEEP
                  endif                                  && 
               endif                                  && 
            endif                                  && 
            mHOME = .f.                            && Unset HOME Flag.
         endif                                  && 

      case mKEY=18 .or. mKEY=3               && Pgup or Pgdn : NOTE - THE DISPLAY ROUTINE AT THE TOP OF LOOP WILL DISPLAY THE NEW PAGE OF DATA, AND KEEP THE LINE NUMBER THE SAME.
         if mKEY = 18                           && If pgup, go up one page and reset top of page variable (mREC).
            go mREC                                && Go top of page (mREC)
            skip -mLINES                           && Skip back number of lines per page (mLINES)
            if bof()                               && If before top of database,
               go top                                 && go top
               if mREC = recno()                      && If Top of page (mREC) is same as top record (Recno())
                  ?? chr(7)                              && beep.
               endif                                  && 
            endif                                  && endif
            mREC = recno()                         && Set top of page (mREC) to top record (recno())
         else                                   && Otherwise, PGDN
            mTEMP = recno()                        && Store current record number to temporary variable (mTEMP).
            go mREC                                && Go top of page (mREC)
            skip mLINES                            && Skip forward number of lines per page (mLINES)
            if eof()                               && if below the bottom record in the database, 
               ?? chr(7)                              && beep - cannot page down from here!
               go mTEMP                               && go back to where they were (mTEMP).
            else                                   && otherwise
               mREC = recno()                         && Set top of page (mREC) to current record (recno())
            endif                                  && 
         endif                                  && 
         mHOME = .f.                            && Unset HOME and END flags.
         mEND  = .f.                            && 

      ** Entry of alpha numeric.
      case mKEY=32.or.(mKEY>=48.and.mKEY<=57).or.(mKEY>=65.and.mKEY<=90).or.(mKEY>=97.and.mKEY<=122)
         mVAR = upper(chr(mKEY))
         if (mARRAY(1,mA_TYPE)="N" .or. mARRAY(1,mA_TYPE) = "D") .and. .not. mVAR$"0123456789"
            ?? chr(7)
         else
            seek mVAR 
            if .not. found()                       && 
               mTEMP = recno(0)                       && Store next closest match to temp variable.
               if mTEMP = 0                           && If nothing matches closely, display the last page of data.
                  go bottom                              && Go to the bottom.
                  skip -mLINES                           && Skip back one page from the bottom,
                  if bof()                               && If that put them at bof(),
                     go top                                 && Go top of database.
                  endif                                  && 
                  mREC = recno()                         && Store new top of page to variable,
                  mLINE = iif(mLINES>=mNUM_RECS,mNUM_RECS,mLINES) && Set line number to bottom of page,
               else                                   && Somthing did sort of match.
                  if mLINES>=mNUM_RECS                   && If there is only one page,
                     go mREC                                && go to the top of the page,
                     mLINE = 1                              && set the line number to top of page
                     do while recno() # mTEMP               && Loop thru database looking for record number matching that found
                        skip                                   && Move to next record in database and
                        mLINE = mLINE + 1                      && increment the line number.
                     enddo                                  && Exit loop once your on record found.
                  else                                   && More than one page, set found record to be in center of page.
                     go mTEMP                               && Go to that record.
                     mLINE = 1                              && Set line number = top of page, 1.
                     do while mLINE>int(mLINES/2)+1 .and. .not. bof() && Move top of page up, keeping line number on found line.
                        skip -1                                     && Move back one record in database and
                        mLINE = mLINE + 1                           && Keep line number pointing to correct display line.
                     enddo                                  && 
                     mREC = recno()                         && Store new top of page record number to variable.
                     go mTEMP                               && Point back to newly found record - line number is all set.
                  endif                                  && 
               endif                                  && 
            else                                   && 
               mTEMP = recno()                        && Store found record number to temporary variable.
               if mLINES>=mNUM_RECS                   && If there is only one page,
                  go mREC                                && go to the top of the page,
                  mLINE = 1                              && set the line number to top of page
                  do while recno() # mTEMP               && Loop thru database looking for record number matching that found
                     skip                                   && Move to next record in database and
                     mLINE = mLINE + 1                      && increment the line number.
                  enddo                                  && Exit loop once your on record found.
               else                                   && More than one page, set found record to be in center of page.
                  go mTEMP                               && Go to that record.
                  mLINE = 1                              && Set line number = top of page, 1.
                  do while mLINE>int(mLINES/2)+1 .and. .not. bof() && Move top of page up, keeping line number on found line.
                     skip -1                                     && Move back one record in database and
                     mLINE = mLINE + 1                           && Keep line number pointing to correct display line.
                  enddo                                  && 
                  mREC = recno()                         && Store new top of page record number to variable.
                  go mTEMP                               && Point back to newly found record - line number is all set.
               endif                                  && 
            endif                                  && 
            mHOME = .f.                            && Unset HOME and END flags.
            mEND  = .f.                            && 
         endif

      Otherwise                              && They did not hit a defined key,
         if mKEY # 0                            && If they did hit some key,
            ?? chr(7)                              && beep
            mKEY = 0                               && reset storage of keystroke variable
         endif                                  && 
   endcase                                && 
enddo                                  && 

******** If ESC was hit,
if mKEY = 27                           && 
   go mREC_ORIG                           && return to previous record.
else                                   && 
   **** Store .t. to zreturn and FIELD contents to zOPTION.
   zRETURN = .t.                          && 
   mVAR = mARRAY(1,mA_FIELD)                     && 
   zOPTION = &mVAR                        && 
endif                                  && 

******** Return to calling program.
set color to &mCOLOR
restore screen from mSCREEN
return 
