* System       : Customer Access System - Personal Computer
* File         : zERROR.prg 
* Procedure    : none
* Called from  : zREQUEST.prg
* Description  : Trap multi-user collisions for zREQUEST, set system variable.
* Databases    : none
* Calls        : none
* UDF Calls    : none
* Written      : 03/17/89 DKA
* Updated      : 
* Tested       :
* Parameters   : [Error #],[Error message],[File error occured in]
* Requirements : none
*

******************************** NOTES ************************************
* EXCEPTIONS   : 
*
* COMMENTS     : Use error(), message(), and sys(16) for passing in your 
*                program (ie on error do zerror with error(),message(),sys(16)).
*                Also note that you can use message(1) to get the source code
*                that caused the error.
* 
******************************** END NOTES ********************************

* Assign passed parameters to internal variables.
parameters mPARAM1,mPARAM2,mPARAM3

* Private all internal variables.
private mERR_NUM,mERR_MESS,mERR_FILE

* Assign internal variables.
mERR_NUM  = mPARAM1
mERR_MESS = mPARAM2
mERR_FILE = mPARAM3

* Ensure zERROR is publiced
if type("zERROR")="U"
   public zERROR
endif
if type("zDEBUG")="U"
   public zDEBUG
endif

* Log error into error system?

* Set zERROR to .T.            - Public variable
zERROR = .T.

********************** Keep this section REMARKED.  Only un-REMARK it during
*                      debugging!
if zDEBUG
   private mSCREEN,mVAR
   private mVAR1,mVAR2,mVAR3,mVAR4,mWIDTH
   private mLEFT,mRIGHT
   private mCOLOR

   mCOLOR = sys(2001,"COLOR")
   mVAR1 = " Error encountered in "+mERR_FILE+" "
   mVAR2 = "Error number  - "+ltrim(str(mERR_NUM))
   mVAR3 = "Error message - "+mERR_MESS
   mVAR4 = " Press any key "
   mWIDTH = 40
   mWIDTH = iif(len(mVAR1)>mWIDTH,len(mVAR1),mWIDTH)
   mWIDTH = iif(len(mVAR2)>mWIDTH,len(mVAR2),mWIDTH)
   mWIDTH = iif(len(mVAR3)>mWIDTH,len(mVAR3),mWIDTH)
   mWIDTH = iif(len(mVAR4)>mWIDTH,len(mVAR4),mWIDTH)
   mLEFT  = 40-int((mWIDTH/2)+.5)-2
   mRIGHT = 40+int((mWIDTH/2)-.5)+2
   save screen to mSCREEN
   do zWINDOW with 10,mLEFT,15,mRIGHT,"+w/r",2,1
   set color to +gr/r
   @ 10,40-int(len(mVAR1)/2+.5) say mVAR1
   set color to +w/r
   @ 12,mLEFT+2 say mVAR2
   @ 13,mLEFT+2 say mVAR3
   @ 15,40-int(len(mVAR4)/2+.5) say mVAR4
   mVAR = inkey(0)
   restore screen from mSCREEN
   set color to &mCOLOR
endif
**********************

* Return                         - Calling program tests pubERROR after each 
*                                  potential error causing request.
return
