* System       : Customer Access System - Personal Computer
* File         : zASK.prg (black box)
* Procedure    : none
* Called from  : everywhere
* Description  : Ask a one line question of the user, get a limited response.
* Databases    : none
* Calls        : none
* UDF Calls    : none
* Written      : 03/17/89 DKA
* Tested       :
* Parameters   : Question,String of valid responses,Default response,Color for question.
* Requirments  : zANSWER must be defined - see notes.
*

******************************** NOTES ********************************
*
* COMMENTS     : Program will reset color to color set when called.
*
*                The program will return the users choice in a public variable 
*                called zANSWER.  It is not necessary, but the variable should
*                publiced in your main public variable routine.
*
*                Question will be truncated if it is longer than 74 characters.
*
******************************** NOTES ********************************

* Assign passed question and valid responses to internal variables.
parameters mPARAM1,mPARAM2,mPARAM3,mPARAM4

* Initialize other internal variables.
private mPARAM1,mPARAM2,mPARAM3,mPARAM4
private mQUESTION,mRESONSE,mPASSES,mPOSITION,mSCREEN,mCOLOR
private mCOLOR_OLD

* If the return variable - zANSWER - is not publiced as of yet, public it!.
if type("zANSWER") = "U"
   public zANSWER
endif

* Define internal variables.
mQUESTION  = substr(mPARAM1,1,74)
mRESPONSE  = upper(mPARAM2)
zANSWER    = mPARAM3
mPASSES    = 0
mPOSITION  = 40 - int(len(mQUESTION)/2)
mCOLOR     = mPARAM4
mCOLOR_OLD = sys(2001,"COLOR")

* If they didn't pass a color, and their is a system default color, use it.
if .not. mCOLOR > "!" .and. .not. type("sCOLOR")="U"
   mCOLOR = sCOLOR
endif

* If they passed '' as default, use a blank space.
if .not. zANSWER > "!"
   zANSWER = " "
endif

* Save the screen for when they return.
save screen to mSCREEN

* Set color for the question.
set color to &mCOLOR

* Loop untill they hit a valid response.
do while .not. zANSWER$mRESPONSE .or. mPASSES = 0
   mPASSES = mPASSES + 1           && ^ forces loop through at least once.
   * Attempts to use invalid response get a beep and a reset of vars
   if mPASSES > 1
      ?? chr(7)
      zANSWER = " "
   endif
   @ 24,0
   @ 24,mPOSITION say mQUESTION get zANSWER pict "!"
   ?? sys(2002,1)                         && Turn cursor on.
   read
   ?? sys(2002)                           && Shut cursor off.
   zANSWER=upper(zANSWER)
enddo

* Restore the screen and color to it's original state.
restore screen from mSCREEN
set color to &mCOLOR_OLD              && Restore to calling programs color.
return

