*******************************************************************************
* Askinp.prg                                                                  *
* Version # 1.01                                      DATE:OCT-26-1992        *
* Programmed by: Alain Grothe                                                 *
*                                                                             *
* Descriptions:                                                               *
*                                                                             *
* This function is used to read information from a field from screen in a     *
* window. It will display a title before that field before being read, and    *
* adjust itself accordingly. Then it returns the value read                   *
*                                                                             *
*                                                                             *
* You don't need to define a field type, but you must define a default value  *
* which will initialize the value read and define it's field type             *
*                                                                             *
* Warning: Field and Field title must fit in 78 char                          *
*                                                                             *
*                                                                             *
* The first four parameters are required.                                     *
*                                                                             *
* Parameters:                                                                 *
* FieldTit : This is the field title                                          *
* FieldPic : This is the picture of the field to be read                      *
* FieldSiz : This is the size of the field to be read                         *
* FieldDef : Default Value for field                                          *
* WindowTit: This is the title to put on top of window                        *
* PageFoot : This is the page footer if any                                   *
*                                                                             *
* Returns:                                                                    *
* Value read from the input                                                   *
*                                                                             *
*******************************************************************************
PARAMETERS m.FieldTit,m.FieldPic,m.FieldSiz,m.FieldDef,m.WindowTit,m.PageFoot

IF parameters()<6
   IF parameters()<5
      PRIVATE m.WindowTit,M.PageFoot
      STORE "" TO m.WindowTit,M.PageFoot
   ELSE
      PRIVATE m.PageFoot
      STORE "" TO m.PageFoot
   ENDIF
ENDIF


*******************************************************************************
*** Definition of function variables                                        ***
*******************************************************************************
    PRIVATE m.winsize,m.fieldread,m.textsize,m.startpos,m.x,m.winname
    m.winsize = 40                    && This is the mininum size of the window
    m.textsize = 0                    && This is the size of the text
    m.startpos = 0                    && This is where we start printing our text
    m.x = 0                           && Startpos for the window
    m.winname = sys(2015)             && Define a random window name

*******************************************************************************
*** Determine the size of the window                                        ***
*******************************************************************************
    m.textsize = len(trim(m.FieldTit))+m.FieldSiz+1
    m.winsize  = IIF(m.textsize+10>m.winsize,m.textsize+10,m.winsize)
    m.winsize  = IIF(m.winsize<len(trim(m.pagefoot)),len(trim(m.pagefoot))+3,m.winsize)
    m.startpos = ((m.winsize - m.textsize)/2) - 1
    m.x = (80 - m.winsize) / 2

*******************************************************************************
*** Define the window                                                       ***
*******************************************************************************
    DO WHILE wexist(m.winname)          && find's a unique window name
       m.winname = sys(2015)
       = inkey(.05)
    ENDDO

    DEFINE WINDOW (m.winname) ;
           FROM 11,m.x TO 13,m.x+m.winsize;
           TITLE TRIM(m.WindowTit);
           FOOTER TRIM(m.pagefoot);
           NOFLOAT NOCLOSE SHADOW COLOR SCHEME 1

*******************************************************************************
*** Display window on screen and read info for field                        ***
*******************************************************************************
    ACTIVATE WINDOW (m.winname)
    @ 0,m.startpos SAY TRIM(m.FieldTit);
                   GET m.fieldread DEFAULT m.FieldDef PICTURE m.FieldPic
    READ

*******************************************************************************
*** Clean-Up and return result                                              ***
*******************************************************************************
    RELEASE WINDOW (m.winname)
    RELEASE m.winsize,m.textsize,m.startpos,m.x,m.winname
    RETURN m.fieldread
*** EOF:askinp.prg ************************************************************



