;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;                      ASCII table for brief
;;
;;    Macro to display an ascii table in Brief.  I found the core to 
;;    this macro about six months ago from the source. My version has 
;;    been almost completely rewritten and new features added. The 
;;    macro consists of the following files:
;;
;;       ascii.m     source code, this file
;;       ascii.cm    compiled macro
;;       ascii.tab   actual ascii table ; read only
;;
;;    ENTER inserts the character under cursor to the edit buffer and
;;    ESC just displays its data on the status line.
;;
;;    Hope you find this useful, this macro has been pretty handy for me 
;;    during the past 6 months. Distribute freely, 100% Public Domain.
;;
;;    Jussi Seppl
;;    ALM-Systems Oy
;;    00160  HELSINKI
;;    FINLAND
;;    76200,2077
;;

(macro id_char
	(
		(string in_char)
		(int ascii)
		(= in_char (read 1))
		(= ascii (atoi in_char 0))
		(if (< ascii 0)
	      (= ascii (+ ascii 256))
		)
		(message "Character %c: #%d decimal, #%x hex." ascii ascii ascii)
	)
)
(macro mup
   (
      (up)
      (up)
      (id_char)
   )
)
(macro mdun
   (
      (int line)
      (inq_position line)
      (if (<= line 13)
         (
            (down)
            (down)
            (id_char)
         )
      )
   )
)
(macro mnxtw
   (
      (int line col)
      (inq_position line col)
      (if (< col 63)
         (
            (next_char)
            (next_char)
         )
      ;else
         (if (< line 15)
            (
               (beginning_of_line)
               (down)
               (down)
            )
         )
      )
      (id_char)
   )
)
(macro mprvw
   (
      (int line col)
      (inq_position line col)
      (if (&& (== col 1) (> line 1))
         (
            (end_of_line)
            (prev_char)
            (up)
            (up)
         )
      ;else
         (
            (prev_char)
            (prev_char)
         )
      )
      (id_char)
   )
)
(macro mhome
   (
      (top_of_buffer)
      (id_char)
   )
)
(macro mend
   (
      (end_of_buffer)
      (prev_char)
      (id_char)
   )
)
(macro mergchar
   (
      (int domerge)
      (string mergchr)
      (global domerge mergchr)
      (= domerge 1)
      (= mergchr (read 1))
      (exit)
   )
)
(macro ascii
	(
		(int under_buf over_buf begin end no_table)
		(string bpath table_path bpath_part)
      (= domerge 0)
		(= bpath (inq_environment "BPATH"))
		(= no_table 0)
		(= table_path "ascii.tab")
		(while (&& (! (exist table_path)) (! no_table))
			(
				(if (!= 0 (= end (index bpath "\;")))
					(				
						(= begin 1)
						(= bpath_part (substr bpath begin (- end 1)))
						(= table_path (+ bpath_part "\\ascii.tab"))
						(= bpath (substr bpath (+ end 1)))
					)
				; else
					(
						(= table_path (+ bpath "\\ascii.tab"))
						(if (! (exist table_path))
							(
								(error "ASCII table not found.")
								(= no_table 1)
							)
						)
					)
				)
			)
		)
		(if (! no_table)
			(
				(= under_buf (inq_buffer))
				(= over_buf (create_buffer "ASCII Table" table_path 0))
				(create_window 8 18 72 1 "Use  or , [Esc] end, [ENTER] end & insert char - Jusa'88")
				(attach_buffer over_buf)
				(set_buffer over_buf)
				(refresh)
				(keyboard_push)
				(assign_to_key "#27" "exit")
				(assign_to_key "%#45" "exit")
 				(assign_to_key "%#72" "mup")
				(assign_to_key "%#77" "mnxtw")
				(assign_to_key "%#80" "mdun")
				(assign_to_key "%#75" "mprvw")
            (assign_to_key "#29696" "mnxtw")
				(assign_to_key "#29440" "mprvw")
		      (assign_to_key "#18176" "mhome")
		      (assign_to_key "#20224" "mend")
            (assign_to_key "#7181" "mergchar")
            (id_char)
				(process)
 				(keyboard_pop)
				(delete_window)
				(delete_buffer over_buf)
				(set_buffer under_buf)
				(attach_buffer under_buf)
            (if (== domerge 1)
                  (insert mergchr)
            )
			)
		)
 	)
)
