/****************************************************************************/
/* AR_STRUCT() -> Array initialized to the current open data base structure */
/* main.prg or function/procedure                                           */
/* LOCAL aArray := {}                                                       */
/*  AADD( aArray, AR_STRUCT() )                                             */
/****************************************************************************/
FUNCTION AR_STRUCT( )

  LOCAL aDBStruct := {}   // array of database structure information - currently empty
  LOCAL aArray := {}      // empty array
  LOCAL i := 1
  LOCAL aLen := 0         // used to avoid re-evaluating the length of the array on every loop

  #include "DBSTRUCT.CH"  // defines positions of data in the aDBStruct array

  aDBStruct := DBSTRUCT()
  aArray := ARRAY( FCOUNT() + 2 )  // I needed two positions in front of the array
  aLen := LEN( aArray )

  aArray[ DEL ] := CHR( 95 )   // '_' blank  user multiple choice position
  aArray[ RECN ] := 0          // 0  RECORD NUMBER

  FOR  i := 3 TO aLen
    DO CASE
    CASE aDBStruct[ i - 2 ][ DBS_TYPE ] = "C"
       aArray[ i ] := SPACE( aDBStruct[ i - 2 ][ DBS_LEN ] )
    CASE aDBStruct[ i - 2 ][ DBS_TYPE ] = "N"
       IF ( aDBStruct[ i - 2 ][ DBS_DEC ] > 0 )
	  aArray[ i ] := 0.00  // this is probably the same as := 0
       ELSE
	  aArray[ i ] := 0
       ENDIF
    CASE aDBStruct[ i - 2 ][ DBS_TYPE ] = "D"
       aArray[ i ] := CTOD("") // empty date format
    CASE aDBStruct[ i - 2 ][ DBS_TYPE ] = "L"
       aArray[ i ] := .F.
    CASE aDBStruct[ i - 2 ][ DBS_TYPE ] = "M"
       aArray[ i ] := SPACE( 10 )  // length of all memo fields
    ENDCASE
  NEXT
  RETURN ( aArray )
