PARAMETERS pnRCnt, pcTitle, pnTimeout
EXTERNAL ARRAY gaField, gaFunction, gaFilter

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFilter([<expN1>][,<expC>[,<expN2>]])                          :
* : Version  1.0                                 Date: 1993/01/05  :
* : Programmed by: Sylvain Tanguay                                 :
* : FoxPro Version 2.0                                             :
* :                                                                :
* : Parameters:                                                    :
* :   <expN1> Number of items to display horizontally              :
* :   <expC>  Title at top of window                               :
* :   <expN2> Timeout valid (0 is no timeout)                      :
* :                                                                :
* : This procedure allows entry of simple filter strings in an     :
* : external array using the FOXPRO SQL HAVING format.             :
* : This procedure assumes that the following variables exists     :
* : prior to call:                                                 :
* :     gaFilter  : Global array [x,8] containing entries to be    :
* :                 edited.                                        :
* :     gaField   : Global array [x,4] containing fields allowed   :
* :                 to be selected (same format as AFIELDS).       :
* :     gaFunction: Global array [x,y] containing functions        :
* :                 allowed to be selected.  The column 1 holds    :
* :                 the labels to be displayed.                    :
* :                                                                :
* : When leaving this procedure, Error variable will indicate      :
* : action how procedure terminated (Error = 0 - succesful).       :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=

PUSH KEY CLEAR

PRIVATE lcTalkStat
PRIVATE lcCompStat
PRIVATE lcExact

m.lcTalkStat = SET("TALK")
SET TALK OFF
m.lcCompStat = SET("COMPATIBLE")
SET COMPATIBLE FOXPLUS
m.lcExact = SET("EXACT")
SET EXACT OFF

IF PARAMETERS() = 0
	m.pnRCnt = SROWS()-11
	m.pcTitle = "Filter Definition"
	m.pnTimeout = 0
ELSE
	IF PARAMETERS() = 1
		IF TYPE("m.pnRCnt")="N"
			m.pcTitle = "Filter Definition"
			IF m.pnRCnt > SROWS()-11
				m.pnRCnt = SROWS()-11
			ENDIF
			m.pnRCnt = MAX(m.pnRCnt,5)
			m.pnTimeout = 0
		ELSE
			m.pcTitle = m.pnRCnt
			m.pnRCnt = SROWS()-11
			m.pnTimeout = 0
		ENDIF
	ELSE
		IF PARAMETERS() = 2
			IF TYPE("m.pnRCnt")="N"
				IF m.pnRCnt > SROWS()-11
					m.pnRCnt = SROWS()-11
				ENDIF
				m.pnRCnt = MAX(m.pnRCnt,5)
				m.pnTimeout = 0
			ELSE
				IF TYPE("m.pnRCnt")="C"
					m.pcTitle = m.pnRCnt
					m.pnRCnt = SROWS()-11
				ENDIF
			ENDIF
		ENDIF
	ENDIF
ENDIF

PRIVATE lnObject		&& Object number
PRIVATE lnRow			&& Row number relative to list box
PRIVATE lnCol			&& Column number relative to list box
PRIVATE lnTopRow		&& Top row position in array
PRIVATE lnLastRow		&& Last selectable row position relative to list box
PRIVATE lnVElev			&& Elevator cursor position relative to list box
PRIVATE llExit			&& Signals exit from the main loop
PRIVATE llMouseHit		&& If mouse hit on window (used for top border)
PRIVATE lcColorNormal
PRIVATE lcColorEnabled
PRIVATE lcColorSelected
PRIVATE lcColorHotKey
PRIVATE lcColorDisabled
PRIVATE lcColorElevator
PRIVATE laBackup
PRIVATE laObject

m.Error     = 0
m.lnObject  = 0
m.lnRow     = 1
m.lnCol     = 1
m.lnTopRow  = 1
m.lnLastRow = MIN(m.pnRCnt,ALEN(gaFilter,1),ALEN(gaFilter,1)-m.lnTopRow+1)
m.lnVElev   = 0
m.llExit    = .F.
m.llMouseHit = .F.
m.lcColorNormal   = SCHEME(5,1)
m.lcColorEnabled  = SCHEME(5,2)
m.lcColorSelected = SCHEME(5,6)
m.lcColorHotKey   = SCHEME(5,7)
m.lcColorDisabled = SCHEME(5,10)
m.lcColorElevator = SUBSTR(SCHEME(5,10),AT("/",SCHEME(5,10))+1)+"/"+SUBSTR(SCHEME(5,10),1,AT("/",SCHEME(5,10))-1)
= ACOPY(gaFilter,laBackup)
DIMENSION laObject[5,4]
laObject[1,1] = "< \<Insert  >"
laObject[1,2] = m.pnRCnt+5
laObject[1,3] = 3
laObject[1,4] = .T.
laObject[2,1] = "< \<Remove  >"
laObject[2,2] = m.pnRCnt+5
laObject[2,3] = 15
laObject[2,4] = .T.
laObject[3,1] = "<   \<OR    >"
laObject[3,2] = m.pnRCnt+5
laObject[3,3] = 27
laObject[3,4] = .T.
laObject[4,1] = ".   OK    /"
laObject[4,2] = m.pnRCnt+5 
laObject[4,3] = 42
laObject[4,4] = .T.
laObject[5,1] = "< Cancel  >"
laObject[5,2] = m.pnRCnt+5 
laObject[5,3] = 55
laObject[5,4] = .T.

IF NOT WEXIST("AFILTER")
	DEFINE WINDOW afilter ;
		FROM INT((SROW()-(m.pnRCnt+9))/2),INT((SCOL()-69)/2) ;
		TO INT((SROW()-(m.pnRCnt+9))/2)+(m.pnRCnt+8),INT((SCOL()-69)/2)+68 ;
		NOCLOSE ;
		FLOAT ;
		NOGROW ;
		NOZOOM ;
		DOUBLE ;
		SHADOW ;
		COLOR SCHEME 5
ENDIF
IF WVISIBLE("AFILTER")
	ACTIVATE WINDOW afilter SAME
ELSE
	ACTIVATE WINDOW afilter NOSHOW
ENDIF

@ 0, 0 SAY PADC(m.pcTitle,WCOLS())
@ 1, 4 SAY "Field"
@ 1,26 SAY "Not"
@ 1,30 SAY "Function"
@ 1,41 SAY "Expression"
@ 1,61 SAY "Hi/Lo"
@ m.pnRCnt+4, 1 TO m.pnRCnt+6,39

DO AFltRedraw
DO AFltDrawElevator
DO AFltEnableObject WITH 1
DO AFltEnableObject WITH 2
DO AFltEnableObject WITH 3
DO AFltEnableObject WITH 4
DO AFltEnableObject WITH 5
DO AFilterWhen
DO AFltSelectObject

ACTIVATE WINDOW afilter

*** Define popup for operator selection

RELEASE BAR ALL OF afltoper
DEFINE POPUP afltoper ;
	MARGIN ;
	MARK "" ;
	COLOR SCHEME 5
ON SELECTION POPUP afltoper DO AFltShowOperator
DO AFltMakeOperPop

RELEASE BAR ALL OF afltfield
DEFINE POPUP afltfield ;
	MARGIN ;
	MARK "" ;
	COLOR SCHEME 5
ON SELECTION POPUP afltfield DO AFltShowField
DO AFltMakeFieldPop

ON KEY LABEL MOUSE m.llMouseHit = MWINDOW("AFILTER")
READ VALID AFilterValid()

RELEASE WINDOW afilter
RELEASE POPUP afltoper
RELEASE POPUP afltfield

IF NOT EMPTY(m.Error)
	DIMENSION gaFilter[1]
	= ACOPY(laBackup,gaFilter)
ENDIF

IF m.lcExact = "ON"
	SET EXACT ON
ENDIF
IF m.lcCompStat = "ON"
	SET COMPATIBLE ON
ENDIF
IF m.lcTalkStat = "ON"
	SET TALK ON
ENDIF
POP KEY

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFilterWhen()                                                   :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFilterWhen
IF ALEN(gaFilter,1) = 1 AND EMPTY(gaFilter[1])
	DO AFltDisableObject WITH 1
	DO AFltDisableObject WITH 2
	DO AFltDisableObject WITH 3
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFilterValid()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
FUNCTION AFilterValid
PRIVATE lnKeypress
m.lnKeypress = 255

IF NOT WONTOP("AFILTER")
	?? CHR(7)
	ACTIVATE WINDOW AFILTER TOP

ELSE
	IF READKEY(1) > 1 OR ;
		(MROW() = -1 AND m.llMouseHit)
		m.llMouseHit = .F.
		KEYBOARD CHR(255)
		RETURN .F.
	ELSE
		m.llMouseHit = .F.

		***************************
		***                     ***
		***   MOUSE Processing  ***
		***                     ***
		***************************

		IF MDOWN()
			PRIVATE lnMRow, lnMCol
			m.lnMRow = MROW()
			m.lnMCol = MCOL()

			DO CASE
			CASE m.lnMRow = -1 OR m.lnMCol = -1
				?? CHR(7)

			*** Insert Push Button
			CASE m.lnMRow = laObject[1,2] AND BETWEEN(m.lnMCol,3,13) AND laObject[1,4]
				@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
				DO AFltUnselectObject
				m.lnObject = 1
				DO AFltSelectObject
				IF AFltMouseDown(m.pnRCnt+5, 3,13)
					m.lnKeypress = 13
				ENDIF

			*** Remove Push Button
			CASE m.lnMRow = laObject[2,2] AND BETWEEN(m.lnMCol,15,25) AND laObject[2,4]
				@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
				DO AFltUnselectObject
				m.lnObject = 2
				DO AFltSelectObject
				IF AFltMouseDown(m.pnRCnt+5,15,25)
					m.lnKeypress = 13
				ENDIF

			*** Or Push Button
			CASE m.lnMRow = laObject[3,2] AND BETWEEN(m.lnMCol,27,37) AND laObject[3,4]
				@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
				DO AFltUnselectObject
				m.lnObject = 3
				DO AFltSelectObject
				IF AFltMouseDown(m.pnRCnt+5,27,37)
					m.lnKeypress = 13
				ENDIF

			*** OK Push Button
			CASE m.lnMRow = laObject[4,2] AND BETWEEN(m.lnMCol,42,52) AND laObject[4,4]
				@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
				DO AFltUnselectObject
				m.lnObject = 4
				DO AFltSelectObject
				IF AFltMouseDown(m.pnRCnt+5,42,52)
					m.lnKeypress = 13
				ENDIF

			*** Cancel Push Button
			CASE m.lnMRow = laObject[5,2] AND BETWEEN(m.lnMCol,55,65) AND laObject[5,4]
				@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
				DO AFltUnselectObject
				m.lnObject = 5
				DO AFltSelectObject
				IF AFltMouseDown(m.pnRCnt+5,55,65)
					m.lnKeypress = 13
				ENDIF

			*** Edit field entry
			CASE BETWEEN(m.lnMRow,3,m.lnLastRow+2) AND BETWEEN(m.lnMCol,4,24)
				DO AFltUnselectObject
				m.lnObject = 0
				m.lnRow = m.lnMRow-2
				m.lnCol = 1
				DO AFltDrawElevator
				DO AFltSelectObject
				m.lnKeypress = 13

			*** Edit NOT switch entry
			CASE BETWEEN(m.lnMRow,3,m.lnLastRow+2) AND BETWEEN(m.lnMCol,26,28)
				IF m.lnMRow+m.lnTopRow-3 = ALEN(gaFilter,1) OR ;
					gaFilter[m.lnMRow+m.lnTopRow-3,2] $ "L"
				ELSE
					DO AFltUnselectObject
					m.lnObject = 0
					m.lnRow = m.lnMRow-2
					m.lnCol = 2
					DO AFltDrawElevator
					DO AFltSelectObject
					m.lnKeypress = 13
				ENDIF

			*** Edit operator entry
			CASE BETWEEN(m.lnMRow,3,m.lnLastRow+2) AND BETWEEN(m.lnMCol,30,39)
				IF m.lnMRow+m.lnTopRow-3 = ALEN(gaFilter,1)
				ELSE
					DO AFltUnselectObject
					m.lnObject = 0
					m.lnRow = m.lnMRow-2
					m.lnCol = 3
					DO AFltDrawElevator
					DO AFltSelectObject
					m.lnKeypress = 13
				ENDIF

			*** Edit expression entry
			CASE BETWEEN(m.lnMRow,3,m.lnLastRow+2) AND BETWEEN(m.lnMCol,41,60)
				IF m.lnMRow+m.lnTopRow-3 = ALEN(gaFilter,1)
				ELSE
					DO AFltUnselectObject
					m.lnObject = 0
					m.lnRow = m.lnMRow-2
					m.lnCol = 4
					DO AFltDrawElevator
					DO AFltSelectObject
					m.lnKeypress = 13
				ENDIF

			*** Edit Hi/Lo switch entry
			CASE BETWEEN(m.lnMRow,3,m.lnLastRow+2) AND BETWEEN(m.lnMCol,62,64)
				IF m.lnMRow+m.lnTopRow-3 = ALEN(gaFilter,1) OR ;
					gaFilter[m.lnMRow+m.lnTopRow-3,2] $ "DFLN"
				ELSE
					DO AFltUnselectObject
					m.lnObject = 0
					m.lnRow = m.lnMRow-2
					m.lnCol = 5
					DO AFltDrawElevator
					DO AFltSelectObject
					m.lnKeypress = 13
				ENDIF

			*** Check vertical elevator
			CASE m.lnMCol = 65 AND m.lnLastRow < ALEN(gaFilter,1)
				DO AFltUnselectObject
				@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
				m.lnObject = 0
				DO CASE
				*** Up elevator arrow
				CASE m.lnMRow = 3
					DO AFltMoveUp
					DO AFltSelectObject
					= INKEY(0.06,"HM")		&& Pause
					DO WHILE MDOWN()
						IF MCOL() = 65 AND MROW() = 3
							DO AFltUnselectObject
							DO AFltMoveUp
							DO AFltSelectObject
						ENDIF
					ENDDO

				*** Down elevator arrow
				CASE m.lnMRow = m.pnRCnt+2
					DO AFltMoveDown
					DO AFltSelectObject
					= INKEY(0.06,"HM")		&& Pause
					DO WHILE MDOWN()
						IF MCOL() = 65 AND MROW() = m.pnRCnt+2
							DO AFltUnselectObject
							DO AFltMoveDown
							DO AFltSelectObject
						ENDIF
					ENDDO

				*** Elevator zone
				CASE BETWEEN(m.lnMRow,4,m.pnRCnt+1)
					IF m.lnMRow < m.lnVElev+4
						DO AFltUpScreen
					ELSE
						IF m.lnMRow > m.lnVElev+4
							DO AFltDownScreen
						ENDIF
					ENDIF
					DO AFltSelectObject

				ENDCASE
				DO AFltWhenList
				RETURN .F.

			*** Mover Arrows
			CASE m.lnMCol = 2 AND BETWEEN(m.lnMRow,3,m.lnLastRow+2)
				DO AFltUnselectObject
				@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
				m.lnObject = 0
				m.lnRow = m.lnMRow-2
				@ m.lnRow+2, 2 FILL TO m.lnRow+2,64 COLOR (m.lcColorSelected)
				DO WHILE MDOWN()
					m.lnMRow = MROW()
					m.lnMCol = MCOL()
					IF m.lnMRow >= 0
						DO CASE
						CASE m.lnMRow < 3
							DO AFltMoveCell WITH m.lnRow+m.lnTopRow-2
							@ m.lnRow+2, 2 FILL TO m.lnRow+2,64 COLOR (m.lcColorSelected)
						CASE m.lnMRow-2 < m.lnRow
							DO AFltMoveCell WITH m.lnMRow+m.lnTopRow-3
							@ m.lnRow+2, 2 FILL TO m.lnRow+2,64 COLOR (m.lcColorSelected)
						CASE m.lnMRow > m.lnLastRow+2
							DO AFltMoveCell WITH m.lnRow+m.lnTopRow
							@ m.lnRow+2, 2 FILL TO m.lnRow+2,64 COLOR (m.lcColorSelected)
						CASE m.lnMRow-2 > m.lnRow
							DO AFltMoveCell WITH m.lnMRow+m.lnTopRow-3
							@ m.lnRow+2, 2 FILL TO m.lnRow+2,64 COLOR (m.lcColorSelected)
						ENDCASE
					ENDIF
				ENDDO
				@ m.lnRow+2, 2 FILL TO m.lnRow+2,64 COLOR (m.lcColorNormal)
				DO AFltDrawCell
				DO AFltSelectObject
				RETURN .F.

			OTHERWISE
				DO AFltUnselectObject
			ENDCASE
		ELSE

		***************************
		***                     ***
		*** KEYBOARD Processing ***
		***                     ***
		***************************

			m.lnKeypress = LASTKEY()
			IF m.lnKeypress < 255
				DO AFltUnselectObject
			ENDIF
		ENDIF
	ENDIF
ENDIF

IF m.lnKeypress < 255
	DO WHILE .T.
		DO CASE

		*** CTRL+Enter Key
		CASE m.lnKeypress = 10 AND laObject[4,4]
			DO AFltExit WITH "OK"
			m.lnObject = 4

		*** Escape Key
		CASE m.lnKeypress = 27 AND laObject[5,4]
			DO AFltExit WITH "Cancel"
			m.lnObject = 5

		*** Tab Key
		CASE m.lnKeypress = 9
			m.lnObject = MOD(m.lnObject+1,6)

		*** Shift+Tab Key
		CASE m.lnKeypress = 15
			m.lnObject = MOD(m.lnObject-1,6)

		*** Insert Push Button
		CASE INLIST(m.lnKeypress,73,105) AND laObject[1,4]
			m.lnKeypress = 9
			DO AFltInsert

		*** Remove Push Button
		CASE INLIST(m.lnKeypress,82,114) AND laObject[2,4]
			m.lnKeypress = 9
			DO AFltRemove

		*** OR Push Button
		CASE INLIST(m.lnKeypress,79,111) AND laObject[3,4]
			m.lnKeypress = 9
			DO AFltOr

		*** List Object
		CASE m.lnObject = 0
			DO CASE

			*** Right Arrow
			CASE m.lnKeypress = 4
				DO AFltMoveRight
				IF NOT AFltValidColumn()
					LOOP
				ENDIF

			*** Left Arrow
			CASE m.lnKeypress = 19
				DO AFltMoveLeft
				IF NOT AFltValidColumn()
					LOOP
				ENDIF

			*** Down Arrow
			CASE m.lnKeypress = 24
				DO AFltMoveDown
				IF NOT AFltValidColumn()
					LOOP
				ENDIF

			*** Up Arrow
			CASE m.lnKeypress = 5
				DO AFltMoveUp
				IF NOT AFltValidColumn()
					LOOP
				ENDIF

			*** Home Key
			CASE m.lnKeypress = 1
				DO AFltMoveHome

			*** End Key
			CASE m.lnKeypress = 6
				DO AFltMoveEnd

			*** Page up Key
			CASE m.lnKeypress = 18
				m.lnKeypress = 5
				DO AFltUpScreen
				IF NOT AFltValidColumn()
					LOOP
				ENDIF

			*** Page down Key
			CASE m.lnKeypress = 3
				m.lnKeypress = 24
				DO AFltDownScreen
				IF NOT AFltValidColumn()
					LOOP
				ENDIF

			*** CTRL+Page up Key
			CASE m.lnKeypress = 31
				DO AFltMoveFirst
				IF NOT AFltValidColumn()
					LOOP
				ENDIF

			*** CTRL+Page down Key
			CASE m.lnKeypress = 30
				DO AFltMoveLast
				IF NOT AFltValidColumn()
					LOOP
				ENDIF

			*** Enter/Space Keys
			CASE INLIST(m.lnKeypress,13,32) AND ;
				NOT gaFilter[m.lnRow+m.lnTopRow-1,1] = "M"
				DO AFltEditList

			CASE BETWEEN(m.lnKeypress,32,254) AND m.lnCol = 4 AND ;
				NOT gaFilter[m.lnRow+m.lnTopRow-1,1] = "M"
				KEYBOARD CHR(m.lnKeypress)
				DO AFltEditExpression

			*** DEL Key
			CASE m.lnKeypress = 7 AND m.lnCol = 4 AND ;
				NOT gaFilter[m.lnRow+m.lnTopRow-1,1] = "M"
				gaFilter[m.lnRow+m.lnTopRow-1,7] = ""
				DO AFltDrawCell

			CASE m.lnRow+m.lnTopRow-1 = ALEN(gaFilter,1)
				?? CHR(7)

			*** CTRL+Up Arrow
			CASE m.lnKeypress = 141
				DO AFltMoveCell WITH m.lnRow+m.lnTopRow-2

			*** CTRL+Down Arrow
			CASE m.lnKeypress = 145
				DO AFltMoveCell WITH m.lnRow+m.lnTopRow

			OTHERWISE
				?? CHR(7)
			ENDCASE

		*** Right/Down Arrows
		CASE INLIST(m.lnKeypress,4,24)
			m.lnObject = MOD(m.lnObject+1,6)

		*** Left/Up Arrows
		CASE INLIST(m.lnKeypress,19,5)
			m.lnObject = MOD(m.lnObject-1,6)

		*** Insert Push Button Object - Enter/Space Keys
		CASE m.lnObject = 1 AND INLIST(m.lnKeypress,13,32)
			m.lnKeypress = 9
			DO AFltInsert

		*** Remove Push Button Object - Enter/Space Keys
		CASE m.lnObject = 2 AND INLIST(m.lnKeypress,13,32)
			m.lnKeypress = 9
			DO AFltRemove
			IF ALEN(gaFilter,1) = 1 AND EMPTY(gaFilter[1])
				DO AFltDisableObject WITH 1
				DO AFltDisableObject WITH 2
				DO AFltDisableObject WITH 3
			ENDIF

		*** OR Push Button Object - Enter/Space Keys
		CASE m.lnObject = 3 AND INLIST(m.lnKeypress,13,32)
			m.lnKeypress = 9
			DO AFltOr

		*** OK Push Button Object - Enter/Space Keys
		CASE m.lnObject = 4 AND INLIST(m.lnKeypress,13,32)
			DO AFltExit WITH "OK"
			DO AFltSelectObject
			EXIT

		*** Cancel Push Button Object - Enter/Space Keys
		CASE m.lnObject = 5 AND INLIST(m.lnKeypress,13,32)
			DO AFltExit WITH "Cancel"
			DO AFltSelectObject
			EXIT

		OTHERWISE
			?? CHR(7)
		ENDCASE

		IF EMPTY(m.lnObject)
			DO AFltWhenList
		ELSE
			IF NOT laObject[m.lnObject,4]
				LOOP
			ENDIF
		ENDIF
		DO AFltSelectObject
		EXIT
	ENDDO
ENDIF
RETURN (m.llExit)

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMouseDown()                                                 :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
FUNCTION AFltMouseDown
PARAMETERS lnRow1, lnCol1, lnCol2
PRIVATE llOut
m.llOut = .F.
DO WHILE MDOWN()
	IF MROW() = m.lnRow1 AND BETWEEN(MCOL(), m.lnCol1, m.lnCol2)
		IF m.llOut
			m.llOut = .F.
			DO AFltSelectObject
			LOOP
		ENDIF
	ELSE
		IF m.llOut
		ELSE
			m.llOut = .T.
			DO AFltUnselectObject
			LOOP
		ENDIF
	ENDIF
	= INKEY("HM")		&& Show Mouse Pointer
ENDDO
RETURN NOT m.llOut

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltSelectObject()                                              :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltSelectObject
IF EMPTY(m.lnObject)
	@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
	DO CASE
	CASE m.lnCol = 1	&& Field entry
		@ m.lnRow+2, 4 FILL TO m.lnRow+2,24 COLOR (m.lcColorSelected)
	CASE m.lnCol = 2	&& Not switch
		@ m.lnRow+2,26 FILL TO m.lnRow+2,28 COLOR (m.lcColorSelected)
	CASE m.lnCol = 3	&& Operator
		@ m.lnRow+2,30 FILL TO m.lnRow+2,39 COLOR (m.lcColorSelected)
	CASE m.lnCol = 4	&& Expression
		@ m.lnRow+2,41 FILL TO m.lnRow+2,60 COLOR (m.lcColorSelected)
	CASE m.lnCol = 5	&& Hi/Lo switch
		@ m.lnRow+2,62 FILL TO m.lnRow+2,64 COLOR (m.lcColorSelected)
	ENDCASE
ELSE
	@ m.lnRow+2, 3 SAY "" COLOR (m.lcColorNormal)
	@ laObject[m.lnObject,2], laObject[m.lnObject,3] SAY STRTRAN(laObject[m.lnObject,1],"\<","") COLOR (m.lcColorSelected)
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltUnselectObject()                                            :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltUnselectObject
IF EMPTY(m.lnObject)
	DO CASE
	CASE m.lnCol = 1	&& Field entry
		@ m.lnRow+2, 4 FILL TO m.lnRow+2,24 COLOR (m.lcColorEnabled)
	CASE m.lnCol = 2	&& Not switch
		@ m.lnRow+2,26 FILL TO m.lnRow+2,28 COLOR (m.lcColorNormal)
	CASE m.lnCol = 3	&& Operator
		@ m.lnRow+2,30 FILL TO m.lnRow+2,39 COLOR (m.lcColorEnabled)
	CASE m.lnCol = 4	&& Expression
		@ m.lnRow+2,41 FILL TO m.lnRow+2,60 COLOR (m.lcColorEnabled)
	CASE m.lnCol = 5	&& Hi/Lo switch
		@ m.lnRow+2,62 FILL TO m.lnRow+2,64 COLOR (m.lcColorNormal)
	ENDCASE
ELSE
	@ laObject[m.lnObject,2], laObject[m.lnObject,3] SAY STRTRAN(laObject[m.lnObject,1],"\<","") COLOR (m.lcColorNormal)
	IF AT("\<",laObject[m.lnObject,1]) > 0
		@ laObject[m.lnObject,2], laObject[m.lnObject,3]+AT("\<",laObject[m.lnObject,1])-1 FILL TO laObject[m.lnObject,2], laObject[m.lnObject,3]+AT("\<",laObject[m.lnObject,1])-1 COLOR (m.lcColorHotKey)
	ENDIF
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltEnableObject()                                              :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltEnableObject
PARAMETERS lnIndice
laObject[m.lnIndice,4] = .T.
@ laObject[m.lnIndice,2],laObject[m.lnIndice,3] SAY STRTRAN(laObject[m.lnIndice,1],"\<","") COLOR (m.lcColorNormal)
IF AT("\<",laObject[m.lnIndice,1]) > 0
	@ laObject[m.lnIndice,2], laObject[m.lnIndice,3]+AT("\<",laObject[m.lnIndice,1])-1 FILL TO laObject[m.lnIndice,2], laObject[m.lnIndice,3]+AT("\<",laObject[m.lnIndice,1])-1 COLOR (m.lcColorHotKey)
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltDisableObject()                                             :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltDisableObject
PARAMETERS lnIndice
laObject[m.lnIndice,4] = .F.
@ laObject[m.lnIndice,2],laObject[m.lnIndice,3] SAY STRTRAN(laObject[m.lnIndice,1],"\<","") COLOR (m.lcColorDisable)

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltRedraw()                                                    :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltRedraw
PRIVATE i, j
*** Draw cells
j = ALEN(gaFilter,1)
m.lnLastRow = MIN(m.pnRCnt,m.j,m.j-m.lnTopRow+1)
FOR i = 1 TO m.pnRCnt
	IF m.i > m.lnLastRow
		@ m.i+2, 2 SAY SPACE(63) COLOR (m.lcColorNormal)
	ELSE
		@ m.i+2, 4 SAY gaFilter[m.lnTopRow+m.i-1,1] SIZE 1,21 COLOR (m.lcColorEnabled)
		IF m.i+m.lnTopRow-1 = m.j AND EMPTY(gaFilter[m.lnTopRow+m.i-1,1])
			@ m.i+2, 2 SAY "  " COLOR (m.lcColorNormal)
			@ m.i+2,26 SAY SPACE(39) COLOR (m.lcColorNormal)
		ELSE
			@ m.i+2, 2 SAY " " COLOR (m.lcColorDisabled)
			@ m.i+2,25 SAY " " COLOR (m.lcColorNormal)
			IF gaFilter[m.lnTopRow+m.i-1,2] $ "L"
				@ m.i+2,26 SAY "[ ]" COLOR (m.lcColorDisable)
			ELSE
				@ m.i+2,26 SAY IIF(gaFilter[m.lnTopRow+m.i-1,5],"[X]","[ ]") COLOR (m.lcColorNormal)
			ENDIF
			@ m.i+2,29 SAY " " COLOR (m.lcColorNormal)
			@ m.i+2,40 SAY " " COLOR (m.lcColorNormal)
			IF gaFilter[m.lnTopRow+m.i-1,1] = "M"
				@ m.i+2,30 SAY "MMM OR MMM" COLOR (m.lcColorEnabled)
				@ m.i+2,41 SAY "MMMMMMMMMMMMMMMMMMMM" COLOR (m.lcColorEnabled)
			ELSE
				@ m.i+2,30 SAY gaFunction[gaFilter[m.lnTopRow+i-1,6],1] SIZE 1,10 COLOR (m.lcColorEnabled)
				@ m.i+2,41 SAY gaFilter[m.lnTopRow+m.i-1,7] SIZE 1,20 COLOR (m.lcColorEnabled)
			ENDIF
			@ m.i+2,61 SAY " " COLOR (m.lcColorNormal)
			IF gaFilter[m.lnTopRow+m.i-1,2] $ "DFLN"
				@ m.i+2,62 SAY "[ ]" COLOR (m.lcColorDisable)
			ELSE
				@ m.i+2,62 SAY IIF(gaFilter[m.lnTopRow+m.i-1,8],"[X]","[ ]") COLOR (m.lcColorNormal)
			ENDIF
		ENDIF
	ENDIF
ENDFOR

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltDrawCell()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltDrawCell
m.lnLastRow = MIN(m.pnRCnt,ALEN(gaFilter,1),ALEN(gaFilter,1)-m.lnTopRow+1)
IF m.lnRow > m.lnLastRow
	@ m.lnRow+2, 2 SAY SPACE(63) COLOR (m.lcColorNormal)
ELSE
	@ m.lnRow+2, 4 SAY gaFilter[m.lnRow+m.lnTopRow-1,1] SIZE 1,21 COLOR (m.lcColorEnabled)
	IF m.lnRow+m.lnTopRow-1 = ALEN(gaFilter,1) AND EMPTY(gaFilter[m.lnRow+m.lnTopRow-1,1])
		@ m.lnRow+2, 2 SAY "  " COLOR (m.lcColorNormal)
		@ m.lnRow+2,26 SAY SPACE(39) COLOR (m.lcColorNormal)
	ELSE
		@ m.lnRow+2, 2 SAY " " COLOR (m.lcColorDisabled)
		@ m.lnRow+2,25 SAY " " COLOR (m.lcColorNormal)
		IF gaFilter[m.lnRow+m.lnTopRow-1,2] $ "L"
			@ m.lnRow+2,26 SAY "[ ]" COLOR (m.lcColorDisable)
		ELSE
			@ m.lnRow+2,26 SAY IIF(gaFilter[lnRow+m.lnTopRow-1,5],"[X]","[ ]") COLOR (m.lcColorNormal)
		ENDIF
		@ m.lnRow+2,29 SAY " " COLOR (m.lcColorNormal)
		@ m.lnRow+2,40 SAY " " COLOR (m.lcColorNormal)
		IF gaFilter[m.lnRow+m.lnTopRow-1,1] = "M"
			@ m.lnRow+2,30 SAY "MMM OR MMM" COLOR (m.lcColorEnabled)
			@ m.lnRow+2,41 SAY "MMMMMMMMMMMMMMMMMMMM" COLOR (m.lcColorEnabled)
		ELSE
			@ m.lnRow+2,30 SAY gaFunction[gaFilter[m.lnRow+m.lnTopRow-1,6],1] SIZE 1,10 COLOR (m.lcColorEnabled)
			@ m.lnRow+2,41 SAY gaFilter[m.lnRow+m.lnTopRow-1,7] SIZE 1,20 COLOR (m.lcColorEnabled)
		ENDIF
		@ m.lnRow+2,61 SAY " " COLOR (m.lcColorNormal)
		IF gaFilter[m.lnRow+m.lnTopRow-1,2] $ "DFLN"
			@ m.lnRow+2,62 SAY "[ ]" COLOR (m.lcColorDisable)
		ELSE
			@ m.lnRow+2,62 SAY IIF(gaFilter[m.lnRow+m.lnTopRow-1,8],"[X]","[ ]") COLOR (m.lcColorNormal)
		ENDIF
	ENDIF
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltDrawElevator()                                              :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltDrawElevator
IF m.lnLastRow < ALEN(gaFilter,1)
	m.lnVElev = ROUND(((m.lnRow+m.lnTopRow-1)*(m.lnLastRow-3))/ALEN(gaFilter,1),0)
	@ 2,1 TO m.pnRCnt+3,65 "D","D","3","[","Z","\","@","_" COLOR (m.lcColorDisabled)
	@ 3,65 SAY "" COLOR (m.lcColorElevator)
	@ m.lnVElev+4,65 SAY "" COLOR (m.lcColorElevator)
	@ m.pnRCnt+2,65 SAY "" COLOR (m.lcColorElevator)
ELSE
	@ 2,1 TO m.pnRCnt+3,65 "D","D","3","3","Z","?","@","Y" COLOR (m.lcColorDisabled)
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltWhenList()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltWhenList
*IF gaFilter[m.lnRow+m.lnTopRow-1,1] = "M"
*	DO AFltEnableObject WITH 1
*	DO AFltEnableObject WITH 2
*	DO AFltDisableObject WITH 3
*ELSE
	IF m.lnRow+m.lnTopRow-1 = ALEN(gaFilter,1)
		DO AFltDisableObject WITH 1
		DO AFltDisableObject WITH 2
		DO AFltDisableObject WITH 3
	ELSE
		DO AFltEnableObject WITH 1
		DO AFltEnableObject WITH 2
		DO AFltEnableObject WITH 3
	ENDIF
*ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltValidColumn()                                               :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
FUNCTION AFltValidColumn
IF m.lnCol = 5 AND gaFilter[m.lnRow+m.lnTopRow-1,2] $ "DFLN"
	RETURN .F.
ELSE
	IF m.lnCol = 2 AND gaFilter[m.lnRow+m.lnTopRow-1,2] $ "L"
		RETURN .F.
	ENDIF
ENDIF
RETURN .T.

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMoveLeft()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMoveLeft
IF m.lnCol = 1
	IF m.lnRow+m.lnTopRow-1 = 1
		m.lnObject = 5
	ELSE
		m.lnCol = 5
		DO AFltMoveUp
	ENDIF
ELSE
	m.lnCol = m.lnCol - 1
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMoveRight()                                                 :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMoveRight
IF m.lnRow+m.lnTopRow-1 = ALEN(gaFilter,1)
	IF m.lnCol = 1 AND EMPTY(gaFilter[m.lnRow+m.lnTopRow-1,1])
		m.lnObject = 1
		RETURN
	ENDIF
ENDIF
IF m.lnCol = 5
	m.lnCol = 1
	DO AFltMoveDown
ELSE
	m.lnCol = m.lnCol + 1
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMoveUp()                                                    :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMoveUp
IF m.lnRow = 1
	IF m.lnTopRow > 1
		m.lnTopRow = m.lnTopRow - 1
		SCROLL 3, 2, m.pnRCnt+2, 65, -1
		DO AFltDrawCell
		DO AFltDrawElevator
	ELSE
		IF m.lnCol > 1
			DO AFltMoveLeft
		ENDIF
	ENDIF
ELSE
	m.lnRow = m.lnRow - 1
	DO AFltDrawElevator
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMoveDown()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMoveDown
IF m.lnRow = m.lnLastRow
	IF m.lnRow+m.lnTopRow-1 < ALEN(gaFilter,1)
		m.lnTopRow = m.lnTopRow + 1
		SCROLL 3, 2, m.pnRCnt+2, 65, 1
		DO AFltDrawCell
		DO AFltDrawElevator
	ELSE
		IF m.lnCol > 1
			DO AFltMoveRight
			RETURN
		ENDIF
	ENDIF
ELSE
	m.lnRow = m.lnRow + 1
	DO AFltDrawElevator
ENDIF
IF m.lnRow+m.lnTopRow-1 = ALEN(gaFilter,1) AND EMPTY(gaFilter[m.lnRow+m.lnTopRow-1,1])
	m.lnCol = 1
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMoveHome()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMoveHome
m.lnCol = 1

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMoveEnd()                                                   :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMoveEnd
m.lnCol = IIF(m.lnRow+m.lnTopRow-1=ALEN(gaFilter,1),1,IIF(gaFilter[m.lnRow+m.lnTopRow-1,2]$"DFLN",4,5))

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMoveFirst()                                                 :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMoveFirst
PRIVATE llTemp
m.lltemp = (m.lnTopRow>1)
m.lnTopRow = 1
m.lnRow = 1
m.lnCol = 1
IF m.llTemp
	DO AFltRedraw
ENDIF
DO AFltDrawElevator

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMoveLast()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMoveLast
PRIVATE llTemp
m.llTemp = (m.lnTopRow<ALEN(gaFilter,1)-m.lnLastRow+1)
m.lnRow = m.lnLastRow
m.lnTopRow = ALEN(gaFilter,1)-m.lnRow+1
m.lnCol = IIF(EMPTY(gaFilter[m.lnRow+m.lnTopRow-1,1]),1,IIF(gaFilter[m.lnRow+m.lnTopRow-1,2]$"DFLN",4,5))
IF m.llTemp
	DO AFltRedraw
ENDIF
DO AFltDrawElevator

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltUpScreen()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltUpScreen
IF m.lnRow > 1
	m.lnRow = 1
ELSE
	m.lnTopRow = IIF((m.lnTopRow-m.lnLastRow+1)<1,1,m.lnTopRow-m.lnLastRow+1)
	DO AFltRedraw
ENDIF
DO AFltDrawElevator

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltDownScreen()                                                :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltDownScreen
IF m.lnRow < m.lnLastRow
	m.lnRow = m.lnLastRow
ELSE
	m.lnTopRow = IIF((m.lnTopRow+m.lnLastRow-1)>(ALEN(gaFilter,1)-m.lnLastRow+1),ALEN(gaFilter,1)-m.lnLastRow+1,m.lnTopRow+m.lnLastRow-1)
	DO AFltRedraw
ENDIF
IF m.lnRow+m.lnTopRow-1 = ALEN(gaFilter,1) AND EMPTY(gaFilter[m.lnRow+m.lnTopRow-1,1]) AND m.lnCol > 1
	m.lnRow = m.lnRow - 1
ENDIF
DO AFltDrawElevator

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMoveCell()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMoveCell
PARAMETERS lnPosition
IF BETWEEN(m.lnPosition,1,ALEN(gaFilter,1)-1) AND m.lnRow+m.lnTopRow-1 <> m.lnPosition
	PRIVATE lcField, lnSize, lnDecimal, lcType, llNot, lnOperator, lcValue, llHilo
	m.lcField    = gaFilter[m.lnRow+m.lnTopRow-1,1]
	m.lnSize     = gaFilter[m.lnRow+m.lnTopRow-1,2]
	m.lnDecimal  = gaFilter[m.lnRow+m.lnTopRow-1,3]
	m.lcType     = gaFilter[m.lnRow+m.lnTopRow-1,4]
	m.llNot      = gaFilter[m.lnRow+m.lnTopRow-1,5]
	m.lnOperator = gaFilter[m.lnRow+m.lnTopRow-1,6]
	m.lcValue    = gaFilter[m.lnRow+m.lnTopRow-1,7]
	m.llHilo     = gaFilter[m.lnRow+m.lnTopRow-1,8]

	= ADEL(gaFilter,m.lnRow+m.lnTopRow-1)
	= AINS(gaFilter,m.lnPosition)

	gaFilter[m.lnPosition,1] = m.lcField
	gaFilter[m.lnPosition,2] = m.lnSize
	gaFilter[m.lnPosition,3] = m.lnDecimal
	gaFilter[m.lnPosition,4] = m.lcType
	gaFilter[m.lnPosition,5] = m.llNot
	gaFilter[m.lnPosition,6] = m.lnOperator
	gaFilter[m.lnPosition,7] = m.lcValue
	gaFilter[m.lnPosition,8] = m.llHilo

	IF m.lnPosition < m.lnTopRow
		m.lnTopRow = m.lnPosition
		m.lnRow = 1
		DO AFltRedraw
	ELSE
		IF m.lnPosition > m.lnTopRow+m.lnLastRow-1
			m.lnTopRow = m.lnPosition-m.lnLastRow+1
			m.lnRow = m.lnLastRow
			DO AFltRedraw
		ELSE
			IF m.lnPosition-m.lnTopRow+1 < m.lnRow
				SCROLL m.lnPosition-m.lnTopRow+3, 2, m.lnRow+2, 65, -1
				m.lnRow = m.lnPosition - m.lnTopRow + 1
				DO AFltDrawCell
			ELSE
				IF m.lnPosition-m.lnTopRow+1 > m.lnRow
					SCROLL m.lnRow+2, 2, m.lnPosition-m.lnTopRow+3, 65, 1
					m.lnRow = m.lnPosition - m.lnTopRow + 1
					DO AFltDrawCell
				ENDIF
			ENDIF
		ENDIF
	ENDIF
	DO AFltDrawElevator
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltEditList()                                                  :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltEditList
DO CASE
CASE m.lnCol = 1	&& Field entry
	DO AFltEditField
	DO AFltSelectObject
CASE m.lnCol = 2	&& Not switch
	gaFilter[m.lnRow+m.lnTopRow-1,5] = NOT gaFilter[m.lnRow+m.lnTopRow-1,5]
	@ m.lnRow+2,26 SAY IIF(gaFilter[m.lnRow+m.lnTopRow-1,5],"[X]","[ ]") COLOR (m.lcColorSelected)
CASE m.lnCol = 3	&& Operator
	DO AFltEditOperator
	DO AFltSelectObject
CASE m.lnCol = 4	&& Expression
	DO AFltEditExpression
	DO AFltSelectObject
CASE m.lnCol = 5	&& Hi/Lo switch
	gaFilter[m.lnRow+m.lnTopRow-1,8] = NOT gaFilter[m.lnRow+m.lnTopRow-1,8]
	@ m.lnRow+2,62 SAY IIF(gaFilter[m.lnRow+m.lnTopRow-1,8],"[X]","[ ]") COLOR (m.lcColorSelected)
ENDCASE

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltShowField()                                                 :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltShowField
IF gaFilter[m.lnRow+m.lnTopRow-1,1] = PROMPT()
ELSE
	HIDE POPUP afltfield
	PRIVATE lnPos
	m.lnPos = Pos1Fld(PROMPT())
	IF m.lnRow+m.lnTopRow-1 = ALEN(gaFilter,1)
		IF AFltNewCell()
			gaFilter[m.lnRow+m.lnTopRow-1,1] = gaField[m.lnPos,1]
			gaFilter[m.lnRow+m.lnTopRow-1,2] = gaField[m.lnPos,2]
			gaFilter[m.lnRow+m.lnTopRow-1,3] = gaField[m.lnPos,3]
			gaFilter[m.lnRow+m.lnTopRow-1,4] = gaField[m.lnPos,4]
			gaFilter[m.lnRow+m.lnTopRow-1,5] = .F.
			gaFilter[m.lnRow+m.lnTopRow-1,6] = 1
			gaFilter[m.lnRow+m.lnTopRow-1,7] = IIF(gaField[m.lnPos,2]="L","VRAI","")
			gaFilter[m.lnRow+m.lnTopRow-1,8] = .F.
			IF m.lnRow < m.pnRCnt
				SCROLL m.lnRow+2, 2, m.pnRCnt+2, 65, -1
				DO AFltDrawCell
				m.lnRow = m.lnRow + 1
			ELSE
				DO AFltDrawCell
				SCROLL 3, 2, m.pnRCnt+2, 65, 1
				m.lnTopRow = m.lnTopRow + 1
			ENDIF
			DO AFltDrawElevator
		ENDIF
	ELSE
		gaFilter[m.lnRow+m.lnTopRow-1,1] = gaField[m.lnPos,1]
		gaFilter[m.lnRow+m.lnTopRow-1,2] = gaField[m.lnPos,2]
		gaFilter[m.lnRow+m.lnTopRow-1,3] = gaField[m.lnPos,3]
		gaFilter[m.lnRow+m.lnTopRow-1,4] = gaField[m.lnPos,4]
		gaFilter[m.lnRow+m.lnTopRow-1,5] = .F.
		gaFilter[m.lnRow+m.lnTopRow-1,6] = 1
		gaFilter[m.lnRow+m.lnTopRow-1,7] = IIF(gaField[m.lnPos,2]="L","TRUE","")
		gaFilter[m.lnRow+m.lnTopRow-1,8] = .F.
		DO AFltDrawCell
	ENDIF
ENDIF
DEACTIVATE POPUP afltfield

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltEditField()                                                 :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltEditField
PRIVATE lcConfirm, lnBar
m.lcConfirm = (SET("CONFIRM")="OFF")
SET CONFIRM ON
m.lnBar = Pos1Fld(gaFilter[m.lnRow+m.lnTopRow-1,1])
m.lnBar = IIF(EMPTY(m.lnBar),1,m.lnBar)
ACTIVATE POPUP afltfield BAR (m.lnBar) AT m.lnRow+2,2
IF m.lcConfirm
	SET CONFIRM OFF
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltShowOperator()                                              :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltShowOperator
IF gaFilter[m.lnRow+m.lnTopRow-1,6] = BAR()
ELSE
	gaFilter[m.lnRow+m.lnTopRow-1,6] = BAR()
	HIDE POPUP afltoper
	DO AFltDrawCell
ENDIF
DEACTIVATE POPUP afltoper

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltEditOperator()                                              :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltEditOperator
PRIVATE lcConfirm, lnBar
m.lcConfirm = (SET("CONFIRM")="OFF")
SET CONFIRM ON
m.lnBar = gaFilter[m.lnRow+m.lnTopRow-1,6]
ACTIVATE POPUP afltoper BAR (m.lnBar) AT m.lnRow+2,28
IF m.lcConfirm
	SET CONFIRM OFF
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltEditExpression()                                            :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltEditExpression
PRIVATE lcEntry
m.lcEntry = PADR(gaFilter[m.lnRow+m.lnTopRow-1,7],60)
@ lnRow+2,41 GET m.lcEntry ;
	PICTURE "@S60" ;
	SIZE 1,20 ;
	DEFAULT " "
READ DEACTIVATE AFltDeactivate()
gaFilter[m.lnRow+m.lnTopRow-1,7] = RTRIM(m.lcEntry)

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltDeactivate()                                                :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
FUNCTION AFltDeactivate
?? CHR(7)
ACTIVATE WINDOW afilter TOP
RETURN .F.

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltInsert()                                                    :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltInsert
IF AFltNewCell()
	@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
	IF m.lnRow < m.pnRCnt
		m.lnRow = m.lnRow + 1
		SCROLL m.lnRow+2, 2, m.pnRCnt+2, 65, -1
		DO AFltDrawCell
	ELSE
		SCROLL 3, 2, m.pnRCnt+2, 65, 1
		m.lnTopRow = m.lnTopRow + 1
		DO AFltDrawCell
	ENDIF
	DO AFltDrawElevator
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltRemove()                                                    :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltRemove
IF m.lnRow+m.lnTopRow-1 = ALEN(gaFilter,1)
	m.lnCol = 1
	IF EMPTY(gaFilter[m.lnRow+m.lnTopRow-1,1])
	ELSE
		gaFilter[m.lnRow+m.lnTopRow-1,1] = ""
		DO AFltDrawCell
	ENDIF
ELSE
	PRIVATE lnPosition
	= ADEL(gaFilter,m.lnRow+m.lnTopRow-1)
	DIMENSION gaFilter[ALEN(gaFilter,1)-1,8]
	IF m.lnRow+m.lnTopRow-1 < ALEN(gaFilter,1)
		SCROLL m.lnRow+2, 2, m.pnRCnt+2, 65, 1
		m.lnPosition = m.lnRow
		m.lnRow = m.lnLastRow
		DO AFltDrawCell
		m.lnRow = m.lnPosition
	ELSE
		IF m.lnRow > 1
			SCROLL m.lnRow+2, 2, m.pnRCnt+2, 65, 1
			DO AFltDrawCell
			m.lnRow = m.lnRow - 1
		ELSE
			IF m.lnTopRow > 1
				m.lnTopRow = m.lnTopRow - 1
			ELSE
				SCROLL m.lnRow+2, 2, m.pnRCnt+2, 65, 1
				m.lnCol = 1
			ENDIF
		ENDIF
		DO AFltDrawCell
	ENDIF
	DO AFltDrawElevator
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltOr()                                                        :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltOr
IF AFltNewCell()
	gaFilter[m.lnRow+m.lnTopRow,1] = REPLICATE("M",21)
	@ m.lnRow+2, 3 SAY " " COLOR (m.lcColorNormal)
	IF m.lnRow < m.pnRCnt
		m.lnRow = m.lnRow + 1
		SCROLL m.lnRow+2, 2, m.pnRCnt+2, 65, -1
		DO AFltDrawCell
	ELSE
		SCROLL 3, 2, m.pnRCnt+2, 65, 1
		m.lnTopRow = m.lnTopRow + 1
		DO AFltDrawCell
	ENDIF
	DO AFltDrawElevator
ENDIF

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltExit()                                                      :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltExit
PARAMETERS lcStat
m.llExit = .T.
m.Error = IIF(m.lcStat="OK",0,2)

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltNewCell()                                                   :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
FUNCTION AFltNewCell
IF ALEN(gaFilter,1) < 450
	DIMENSION gaFilter[ALEN(gaFilter,1)+1,8]
	= AINS(gaFilter,m.lnRow+m.lnTopRow)
	gaFilter[m.lnRow+m.lnTopRow,1] = ""
	gaFilter[m.lnRow+m.lnTopRow,2] = ""
	gaFilter[m.lnRow+m.lnTopRow,3] = 0
	gaFilter[m.lnRow+m.lnTopRow,4] = 0
	gaFilter[m.lnRow+m.lnTopRow,5] = .F.
	gaFilter[m.lnRow+m.lnTopRow,6] = 1
	gaFilter[m.lnRow+m.lnTopRow,7] = ""
	gaFilter[m.lnRow+m.lnTopRow,8] = .F.
ELSE
	WAIT WINDOW "Maximum Capacity Reached!" NOWAIT
	RETURN .F.
ENDIF
RETURN .T.

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMakeFieldPop()                                             :
* :                                                                :
* : Builds the popup AFLTFIELD using the GAFIELD array. A separator:
* : is added to separate different ALIAS.                          :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMakeFieldPop
PRIVATE lcBreak, i, j
m.lcBreak = ""
m.j = 1
FOR i = 1 TO ALEN(gaField,1)
	IF gaField[i,1] = m.lcBreak
	ELSE
		DEFINE BAR (j) OF afltfield PROMPT "\-"
		m.j = m.j + 1
	ENDIF
	DEFINE BAR (j) OF afltfield PROMPT (gaField[i,1])
	IF gaField[i,2] = "M"
		SET SKIP OF BAR (j) OF afltfield .T.
	ENDIF
	IF AT(".",gaField[i,1]) > 0
		m.lcBreak = LEFT(gaField[i,1],AT(".",gaField[i,1])-1)
	ENDIF
	m.j = m.j + 1
ENDFOR

* VDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD7
* : AFltMakeOperPop()                                              :
* :                                                                :
* : Builds the popup AFLTOPER using the GAFUNCTION array.          :
* SDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD=
PROCEDURE AFltMakeOperPop
PRIVATE i
FOR i = 1 TO ALEN(gaFunction,1)
	DEFINE BAR (i) OF afltoper PROMPT gaFunction[i,1]
ENDFOR