t* Program..: AddRec.PRG
* Purpose..: Positions record pointer at blank
*            record; replaces APPEND BLANK
*
*	RECALLs a deleted record if available, 
*       otherwise APPENDs a BLANK record
*   If the DBF does not have a tag in the structural
*       .CDX indexed on DELETED() records, AddRec() 
*       creates a tag on the fly named "_Deleted".
*	If the DBF does not have a structural CDX file,
*       one will be created and the "_Deleted" tag
*       added.
*   Single user version.
*
* Syntax...:   =AddRec()
*
* Returns..: Logical .T. if all goes well, else
*            Logical .F. 
*
* The Players:  
*       m.nCounter   - Loop counter
*       m.cSetTalk   - Original TALK setting
*       m.cSetDelete - Original DELETED setting
*       m.cSetOrder  - Original controlling index
*       m.cCDXName   - Name of structural CDX file
*       m.cTagKey    - Tag index expression
*       aBlankRec    - Array holds blank record data
*
* Author...: Bill Lawder
* ==================================================

PRIVATE m.nCounter, m.cSetTalk, m.cSetDelete, ;
       m.cSetOrder, m.cCDXName, m.cTagKey

* ----- Save current environmental information
m.cSetTalk   = SET("TALK")
SET TALK OFF
m.cSetOrder  = SET("ORDER")
m.cSetDelete = SET("DELETED")
SET DELETED OFF

* ---------- Make sure there's a table open in
*                             current work area
IF EMPTY(DBF())
  =RestoreEnv()
  RETURN .F.
ENDIF   no DBF in current work area


* ---------- See if structural .CDX exists
m.cCDXName = ;
    IIF((LEFT(CDX(1), RAT(".", CDX(1))-1)) == ;
        (LEFT(DBF(),  RAT(".", DBF()) -1)),   ;
        CDX(1), "")


* ---------- Index on deleted records
IF EMPTY(m.cCDXName)
  * ----- No structural CDX; create it
  INDEX ON DELETED() ;
        TAG _Deleted ;
        ADDITIVE

ELSE
  * ---------- Structural CDX already exists;
  *            check existing tag expressions
  FOR m.nCounter = 1 TO 256
    m.cTagKey = KEY((m.cCDXName), m.nCounter)
    IF NOT EMPTY(m.cTagKey)
      IF m.cTagKey == "DELETED()"
        * ----- We have a winner;
        *       make this the controlling tag
        SET ORDER TO ;
            TAG TAG((m.cCDXName), m.nCounter) ;
            OF (m.cCDXName)
        EXIT
      ENDIF   tag indexed on deleted() records

    ELSE   We've run out of tags; create one
      INDEX ON DELETED() ;
            TAG _Deleted ;
            ADDITIVE
      EXIT
    ENDIF   there is an index expression
  ENDFOR   tag index checking loop
ENDIF     no structural CDX


* ---------- Any deleted records here?
IF SEEK(.T.)
  * ----- Bingo; recycle the deleted record
  RECALL
  * ----- Wipe out record's data
  PRIVATE aBlankRec[FCOUNT()]
  SCATTER MEMO TO   aBlankRec BLANK
  GATHER  MEMO FROM aBlankRec

ELSE   no deleted records in table
  APPEND BLANK
ENDIF  found a deleted record


=RestoreEnv()

RETURN .T.


* --------------------------------------------------
PROCEDURE RestoreEnv
* Reset the Environment

SET ORDER TO &cSetOrder

IF m.cSetDelete = "ON"
  SET DELETED ON
ENDIF

IF m.cSetTalk = "ON"
  SET TALK ON
ENDIF

RETURN

* ============================================== eof
