#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>

#define BUFSIZE 1024

main(argc,argv)
int argc;
char *argv[];
{
    int fh1,fh2,result;
    char buf[BUFSIZE],*cp;
    unsigned int bytesread,byteswritten,nbytes,nrecs,srec,pass=0;
    size_t ln;

    if (argc < 4)   /* Do we have enough information */
    {
        fprintf(stdout,"Usage: ACRLF Input_file Output_file Record_size [Start record] [Record quantity]");
        exit(1);
    }
    fprintf(stdout,"ADDCRLF - Copyright (c) Glenn M. Belton 1990 - All Rights Reserved\n (703) 670-5535\n");

    fh1 = open(argv[1],O_RDONLY|O_BINARY);      /* Open the Input file */
    if (fh1 == -1)
    {
        perror("Unable to Open Input file\n");
        exit(1);
    }
    if((ln = lseek(fh1,0L,SEEK_END)) == -1L)    /* How Big is the File */
    {
        perror("Error seeking end of file");
        exit(1);
    }

    /* Open the Output file */
    fh2 = open(argv[2],O_WRONLY|O_CREAT|O_EXCL|O_BINARY,S_IREAD|S_IWRITE);
    if (fh2 == -1)
    {
        perror("Error opening output file");
        exit(1);
    }
    nbytes = (unsigned) atoi(argv[3]);          /* How Big are the records */

    if (nbytes > ln)                            /* Lets compare sizes */
    {
        fprintf(stderr,"Record size exceeds file size");
        exit(1);
    }

    if (argc >= 5)                              /* Start at specific record? */
    {
        srec = (unsigned) atoi(argv[4]);
        if (srec == 0)
            srec = 1;

        if (argc > 5)                           /* Quantity? */
            nrecs = (unsigned) atoi(argv[5]);
        else
            nrecs = 0;                           /* No Quantity, then all */

        if (((nrecs + srec)*nbytes) > ln)    /* Exceeds file size? */
        {
            fprintf(stderr,"Your parameters would exceed the file size\n");
            exit(1);
        }
        else                                    /* Jump to the start position */
        {
            if((ln = lseek(fh1,(srec-1)*nbytes,SEEK_SET)) == -1L)
            {
                perror("Error seeking record offset");
                exit(1);
            }
        }
    }
    else
    {
        nrecs = 0;
        if((ln = lseek(fh1,0L,SEEK_SET)) == -1L)    /* Lets Rewind the input file */
        {
            perror("Error seeking begining of file");
            exit(1);
        }
    }

    while ((bytesread = read(fh1,buf,nbytes)) > 0) /* Read records in a loop */
    {
        if ((byteswritten = write(fh2,buf,bytesread)) == -1) /* write a record */
            perror("Error writing output file");
        if ((byteswritten =write(fh2,"\r\n",2)) == -1)       /* append CR LF */
            perror("Error writing output file");
        ++pass;
        if (nrecs)                              /* Specific quantity? */
            if (pass == nrecs)                  /* Got them? */
                break;
    }
    if (bytesread < 0)                          /* Error while reading file? */
    {
        perror("Error reading input file");
        exit(1);
    }
    else                                        /* No error we're at the EOF */
    {
        fprintf(stdout,"%u Records written",pass);
        result = close(fh1);                    /* Close the input file */
        if (result)
            perror("Error closing input file");
        result = close(fh2);                    /* Close the output file */
        if (result)
            perror("Error closing output file");
    }
}   /* Thats all Folks */
