*!*****************************************************************************
*!
*!      Procedure: 3DPANEL
*!
*!      Called by: programs generated by 3DGENSCR.PRG
*!
*!*****************************************************************************

parameters nTop,nLeft,nBott,nRight,nThickness,lRaised
private cColor1,cColor2,nCnt
PRIVATE tTop, tBott, tLeft, tRight

if lRaised
  cColor1 = "rgb(255,255,255,,,)"
  ccolor2 = "rgb(128,128,128,128,128,128)"
else
  cColor1 = "rgb(128,128,128,128,128,128)"
  ccolor2 = "rgb(255,255,255,,,)"
endif

for nCnt = 0 to nThickness - 1
    *
    * Moved these function calls up here.  Removes repetative calls (speed improvement).
    *
    tTop = Pix2Frac(Frac2Pix(nTop,.t.) + nCnt,.t.)
    tLeft = Pix2Frac(Frac2Pix(nLeft,.f.) + nCnt,.f.)
    tBott = Pix2Frac(Frac2Pix(nBott,.t.) - nCnt,.t.)
    tRight = Pix2Frac(Frac2Pix(nRight,.f.) - nCnt,.f.)
    
    @ tTop, tLeft TO tTop, tRight ;
    pen 1,8 ;
    style "1" ;
    color (cColor1)

    @ tTop, tLeft TO tBott, tLeft ;
    pen 1,8 ;
    style "1" ;
    color (cColor1)

    *
    * Make Right Bars 1 Pixel Longer (Line was too short - Left a gap at lower right corner)
    *
    @ tTop, tRight TO Pix2Frac(Frac2Pix(nBott,.t.) - nCnt + 1,.t.), tRight ;
    pen 1,8 ;
    style "1" ;
    color (cColor2)

    *
    * Make Bottom Bars 1 Pixel Longer (Line was too short - Left a gap at lower right corner)
    *
    @ tBott, tLeft TO tBott, Pix2Frac(Frac2Pix(nRight,.f.) - nCnt + 1,.f.) ;
    pen 1,8 ;
    style "1" ;
    color (cColor2)

endfor
return


*!*****************************************************************************
*!
*!      Procedure: PIX2FRAC
*!
*!      Called by: 3DPANEL            (procedure in 3DPANEL.PRG)
*!
*!*****************************************************************************

function Pix2Frac
  parameters nPix,lRow
return nPix / fontmetric(iif(lRow,1,6))


*!*****************************************************************************
*!
*!      Procedure: FRAC2PIX
*!
*!      Called by: 3DPANEL            (procedure in 3DPANEL.PRG)
*!
*!*****************************************************************************

function Frac2Pix
  parameters nFrac,lRow
return nFrac * fontmetric(iif(lRow,1,6))


