***************************************************************************
*
* Procedure file: 3DDEMO.PRG
*         System: GenScrnX
*        Version: 1.5
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* 3DDEMO - Build project 3DSAMPLE.PJX and execute README3D.SPR.
*
PARAMETERS m.build_all
PRIVATE m.build_all,m.lastselect,m.lastdefault,m.progpath

SET MESSAGE TO
SET PROCEDURE TO
WAIT CLEAR
ACTIVATE SCREEN
CLEAR
CLOSE DATABASES
IF .NOT._WINDOWS
  WAIT 'This program requires FoxPro for Windows' WINDOW NOWAIT
  RETURN
ENDIF
IF ATC('.APP',SYS(16,0))>0
  DO README3D.SPR
  RETURN
ENDIF
IF ATC('GENSCRNX',_GENSCRN)=0
  WAIT "_GENSCRN='GENSCRNX.PRG' must be set in CONFIG.FPW or from Command window";
       WINDOW NOWAIT
  RETURN
ENDIF
m.lastdefault=SYS(5)+CURDIR()
m.progpath=ALLTRIM(FULLPATH(' ',SYS(16)))
SET DEFAULT TO (m.progpath)
IF .NOT.FILE('3DSAMPLE.PJX')
  WAIT "File '3DSAMPLE.PJX' does not exist" WINDOW NOWAIT
  SET DEFAULT TO (m.lastdefault)
  RETURN
ENDIF
IF .NOT.FILE('README3D.SPR')
  m.build_all=.T.
ENDIF
IF m.build_all
  m.lastselect=SELECT()
  SELECT 0
  USE 3DSAMPLE.PJX
  REPLACE ALL TIMESTAMP WITH 0 FOR UPPER(TYPE)=='S'
  USE
  SELECT (m.lastselect)
ENDIF
WAIT 'Building project 3DSAMPLE...' WINDOW NOWAIT
BUILD PROJECT 3DSAMPLE
WAIT CLEAR
SET MESSAGE TO
ACTIVATE SCREEN
IF FILE('README3D.SPR')
  DO README3D.SPR
ELSE
  WAIT "File 'README3D.SPR' does not exist" WINDOW NOWAIT
ENDIF
CLOSE DATABASES
ACTIVATE SCREEN
SET DEFAULT TO (m.lastdefault)
RETURN 

* END readme3d
