***************************************************************************
*
* Procedure file: 3DSHOW.PRG
*         System: 3DBox
*        Version: 1.1
*         Author: Bill Anderson
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* 3DSHOW - Demonstration of the 3D Box Generator 3DBOX.PRG.
*
* Description:
* This program is used to demonstrate the multiple parameters of 3DBOX and
* their effects.
*
*                  * * *  DECLARED MEMORY VARIABLES  * * *
*
*            m_setcurs  = holds the previous SET CURSOR setting.
*            m_count1   = a counter.
*            m_count2   = a counter.
*            m_count3   = a counter.
*            m_rand01   = a random number between 0 and 1.
*            m_rand02   = a random number between 0 and 1.
*            m_rand03   = a random number between 0 and 1.
*            m_rand04   = a random number between 0 and 1.
*            m_rand05   = a random number between 0 and 1.
*            m_rand06   = a random number between 0 and 1.
*            m_rand07   = a random number between 0 and 1.
*            m_rand08   = a random number between 0 and 1.
*            m_rand09   = a random number between 0 and 1.
*            m_rand10   = a random number between 0 and 1.
*            m_rand11   = a random number between 0 and 1.
*            m_rand12   = a random number between 0 and 1.
*            m_rand13   = a random number between 0 and 1.
*            m_rand14   = a random number between 0 and 1.
*            m_rand15   = a random number between 0 and 1.
*            m_rand16   = a random number between 0 and 1.
*            m_rand17   = a random number between 0 and 1.
*            m_seconds  = holds the number of seconds past midnight.
*

PRIVATE m_setcurs, m_count1, m_count2, m_count3, ;
m_rand01, m_rand02, m_rand03, m_rand04, m_rand05, ;
m_rand06, m_rand07, m_rand08, m_rand09, m_rand10, ;
m_rand11, m_rand12, m_rand13, m_rand14, m_rand15, ;
m_rand16, m_rand17, m_seconds

** Windows platform test
IF .NOT._WINDOWS

  WAIT 'This program requires FoxPro for Windows' WINDOW NOWAIT
  RETURN

ENDIF
** End Windows platform test

CLEAR WINDOWS
ACTIVATE SCREEN
CLEAR
DEFINE WINDOW wtest FROM 5, 10 TO SROW() - 5, SCOL() - 10 ;
TITLE [3-D Show] CLOSE FLOAT GROW MINIMIZE MDI SHADOW ZOOM COLOR W+/B
ACTIVATE WINDOW wtest
m_setcurs = SET([CURSOR])
SET CURSOR OFF

WAIT WINDOW [Various lengths can be used.] NOWAIT

= RAND(-1)

** 3D drawing loop
FOR m_count1 = 1 TO 8

  m_rand01 = RAND()
  CLEAR
  DO 3DBOX.PRG WITH  5, 10, 5, CEILING(m_rand01 * 20), 2,  ;
  255, 255, 255, 128, 128, 128, 192, 192, 192, 0, 0, 0, 1, -1
  m_seconds = SECONDS()

  DO WHILE ABS(SECONDS() - m_seconds) < 0.25
  ENDDO

ENDFOR m_count1 = 1 TO 8
** End 3D drawing loop

WAIT WINDOW [Various heights can be used.] NOWAIT

= RAND(-1)

** 3D drawing loop
FOR m_count1 = 1 TO 8

  m_rand01 = RAND()
  CLEAR
  DO 3DBOX.PRG WITH  5, 5, CEILING(m_rand01 * 10), 10, 2,  ;
  255, 255, 255, 128, 128, 128, 192, 192, 192, 0, 0, 0, 1, -1
  m_seconds = SECONDS()

  DO WHILE ABS(SECONDS() - m_seconds) < 0.25
  ENDDO

ENDFOR m_count1 = 1 TO 8
** End 3D drawing loop

CLEAR
WAIT WINDOW [These 3-D boxes show a RAISED effect.] NOWAIT

** 3D drawing loop
FOR m_count1 = 1 TO 22

  DO 3DBOX.PRG WITH  5, 10, 5, 10, m_count1, 255, 255, ;
  255, 128, 128, 128, 192, 192, 192, 0, 0, 0, 1, -1
  m_seconds = SECONDS()

  DO WHILE ABS(SECONDS() - m_seconds) < 0.05
  ENDDO

ENDFOR m_count1 = 1 TO 22
** End 3D drawing loop

WAIT WINDOW [And now we'll show an INSET effect.] NOWAIT

** 3D drawing loop
FOR m_count1 = 22 TO 1 STEP -1

  DO 3DBOX.PRG WITH 5, 10, 5, 10, m_count1, 255, 255, ;
  255, 128, 128, 128, 192, 192, 192, 0, 0, 0, 1, -1
  m_seconds = SECONDS()

  DO WHILE ABS(SECONDS() - m_seconds) < 0.05
  ENDDO

ENDFOR m_count1 = 22 TO 1 STEP -1
** End 3D drawing loop

** 3D drawing loop
FOR m_count1 = 1 TO 22

  DO 3DBOX.PRG WITH 5, 10, 5, 10, m_count1, 128, 128, ;
  128, 255, 255, 255, 192, 192, 192, 0, 0, 0, 1, -1
  m_seconds = SECONDS()

  DO WHILE ABS(SECONDS() - m_seconds) < 0.05
  ENDDO

ENDFOR m_count1 = 1 TO 22
** End 3D drawing loop

WAIT WINDOW [And back to normal.] NOWAIT

** 3D drawing loop
FOR m_count1 = 22 TO 1 STEP -1

  DO 3DBOX.PRG WITH 5, 10, 5, 10, m_count1, 128, 128, ;
  128, 255, 255, 255, 192, 192, 192, 0, 0, 0, 1, -1
  m_seconds = SECONDS()

  DO WHILE ABS(SECONDS() - m_seconds) < 0.05
  ENDDO

ENDFOR m_count1 = 22 TO 1 STEP -1
** End 3D drawing loop

WAIT CLEAR
DEFINE WINDOW wtest FROM 1, 1 TO SROW() - 1, SCOL() - 1 ;
TITLE [3-D Show] CLOSE FLOAT GROW MINIMIZE MDI SHADOW ZOOM
ACTIVATE WINDOW wtest
WAIT WINDOW [Various sun colors can be used.] NOWAIT
= RAND(-1)

** 3D drawing loop
FOR m_count1 = 1 TO 8

  m_rand01 = RAND()
  m_rand02 = RAND()
  m_rand03 = RAND()
  DO 3DBOX.PRG WITH  5, 10, 5, 10, 6,  ;
  255 * m_rand01, 255 * m_rand02, 255 * m_rand03, ;
  128, 128, 128, 192, 192, 192, 0, 0, 0, 1, -1
  m_seconds = SECONDS()
  
  DO WHILE ABS(SECONDS() - m_seconds) < 0.25
  ENDDO

ENDFOR m_count1 = 1 TO 8
** End 3D drawing loop

WAIT WINDOW [Various shadow colors can be used.] NOWAIT
= RAND(-1)

** 3D drawing loop
FOR m_count1 = 1 TO 8

  m_rand01 = RAND()
  m_rand02 = RAND()
  m_rand03 = RAND()
  DO 3DBOX.PRG WITH  5, 10, 5, 10, 6, 255, 255, 255, ;
  255 * m_rand01, 255 * m_rand02, 255 * m_rand03, ;
  192, 192, 192, 0, 0, 0, 1, -1
  m_seconds = SECONDS()

  DO WHILE ABS(SECONDS() - m_seconds) < 0.25
  ENDDO

ENDFOR m_count1 = 1 TO 8
** End 3D drawing loop

WAIT WINDOW [Various face colors can be used.] NOWAIT
= RAND(-1)

** 3D drawing loop
FOR m_count1 = 1 TO 8

  m_rand01 = RAND()
  m_rand02 = RAND()
  m_rand03 = RAND()
  DO 3DBOX.PRG WITH 5, 10, 5, 10, 6,  ;
  255, 255, 255, 128, 128, 128, ;
  255 * m_rand01, 255 * m_rand02, 255 * m_rand03, ;
  0, 0, 0, 1, -1
  m_seconds = SECONDS()
  
  DO WHILE ABS(SECONDS() - m_seconds) < 0.25
  ENDDO

ENDFOR m_count1 = 1 TO 8
** End 3D drawing loop

WAIT WINDOW [Various outline colors can be used.] NOWAIT
= RAND(-1)

** 3D drawing loop
FOR m_count1 = 1 TO 8

  m_rand01 = RAND()
  m_rand02 = RAND()
  m_rand03 = RAND()
  DO 3DBOX.PRG WITH 5, 10, 5, 10, 6,  ;
  255, 255, 255, 128, 128, 128, 192, 192, 192, ;
  255 * m_rand01, 255 * m_rand02, 255 * m_rand03, 1, -1
  m_seconds = SECONDS()
  
  DO WHILE ABS(SECONDS() - m_seconds) < 0.25
  ENDDO

ENDFOR m_count1 = 1 TO 8
** End 3D drawing loop

WAIT WINDOW [8 different face patterns can be used.] NOWAIT
= RAND(-1)

** 3D drawing loop
FOR m_count1 = 1 TO 8

  m_rand01 = RAND()
  DO 3DBOX.PRG WITH  5, 10, 5, 10, 6,  ;
  255, 255, 255, 128, 128, 128, 192, 192, 192, 0, 0, 0, ;
  INT(m_rand01 * 8), -1
  m_seconds = SECONDS()

  DO WHILE ABS(SECONDS() - m_seconds) < 0.25
  ENDDO

ENDFOR m_count1 = 1 TO 8
** End 3D drawing loop

WAIT WINDOW [6 different pen lines can be used.] NOWAIT
= RAND(-1)

** 3D drawing loop
FOR m_count1 = 1 TO 8

  m_rand01 = RAND()
  DO 3DBOX.PRG WITH  5, 10, 5, 10, 6,  ;
  255, 255, 255, 128, 128, 128, 192, 192, 192, 0, 0, 0, 1, ;
  INT(m_rand01 * 6) - 1
  m_seconds = SECONDS()

  DO WHILE ABS(SECONDS() - m_seconds) < 0.25
  ENDDO

ENDFOR m_count1 = 1 TO 8
** End 3D drawing loop

WAIT WINDOW [And now for some random 3-D boxes ] + ;
[(Press any key to abort).] NOWAIT

** 3D drawing loop
FOR m_count1 = 1 TO 16

  ** Bailout test
  IF CHRSAW()
  
    EXIT

  ENDIF CHRSAW()
  ** End bailout test
  
  = RAND(-1)
  m_rand01 = RAND()
  m_rand02 = RAND()
  m_rand03 = RAND()
  m_rand04 = RAND()
  m_rand05 = RAND()
  m_rand06 = RAND()
  m_rand07 = RAND()
  m_rand08 = RAND()
  m_rand09 = RAND()
  m_rand10 = RAND()
  m_rand11 = RAND()
  m_rand12 = RAND()
  m_rand13 = RAND()
  m_rand14 = RAND()
  m_rand15 = RAND()
  m_rand16 = RAND()
  m_rand17 = RAND()
  CLEAR
  
  DO 3DBOX.PRG WITH 10 - ((CEILING(m_rand01 * 10) + 10) / 2), ;
  14 - ((CEILING(m_rand02 * 10) + 6) / 2), ;
  CEILING(m_rand02 * 10) + 6, ;
  CEILING(m_rand01 * 10) + 10, INT(m_rand03 * 22),  ;
  m_rand04 * 255, m_rand05 * 255, m_rand06 * 255, ;
  m_rand07 * 255, m_rand08 * 255, m_rand09 * 255, ;
  m_rand10 * 255, m_rand11 * 255, m_rand12 * 255, ;
  m_rand13 * 255, m_rand14 * 255, m_rand15 * 255, ;
  INT(m_rand16 * 8), INT(m_rand17 * 6) - 1
  m_seconds = SECONDS()
  
  DO WHILE ABS(SECONDS() - m_seconds) < 0.25
  ENDDO

ENDFOR m_count1 = 1 TO 255
** End 3D drawing loop

WAIT CLEAR
CLEAR WINDOWS

SET CURSOR &m_setcurs

RETURN

* EOF: 3DSHOW.PRG