/* zip.h - defines for directory structures for ZIP			     *
 *	   derived from distribution info with release 0.9		     */

#define LFH_SIG 0x04054B50L
#define CDH_SIG 0x02014B50L
#define CDT_SIG 0x06054B50L

typedef struct local_file_hdr {
    unsigned long sig;
    unsigned extr_ver;
    unsigned bit_flag;
    unsigned method;
    unsigned ftime;
    unsigned fdate;
    unsigned long crc;
    unsigned long comp_size;
    unsigned long ur_size;
    unsigned fname_len;
    unsigned extra_len;
    char buff[2];
    } LFH;

typedef struct central_dir_hdr {
    unsigned long sig;
    unsigned comp_ver;
    unsigned extr_ver;
    unsigned bit_flag;
    unsigned method;
    unsigned ftime;
    unsigned fdate;
    unsigned long crc;
    unsigned long comp_size;
    unsigned long ur_size;
    unsigned fname_len;
    unsigned extra_len;
    unsigned cmnt_len;
    unsigned dno;
    unsigned int_attr;
    unsigned long ext_attr;
    unsigned long lfh_off;
    char buf[2];
    } CDH;

typedef struct central_dir_trlr {
    unsigned long sig;
    unsigned dno;
    unsigned dno_cdh;
    unsigned cnt_here;
    unsigned cnt_all;
    unsigned long cd_size;
    unsigned long cd_off;
    unsigned cmnt_len;
    char buf[2];
    } CDT;
