//	Program name..	Zinc Interface Library
//	Filename......	D_ICON.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <graphics.h>
#include <ui_win.hpp>
#include "d_demo.hpp"
#include "d_help.hlh"

static USHORT zincBitmap1[] =
{
	32, 32,
	0xFFFF, 0xFFFF, 	0xFFFF, 0xFFFE, 	0xFFFF, 0xFFFC,		0xFFFF, 0xFFF8,
	0xFFFF, 0xFFF0, 	0xFFFF, 0xFFE0, 	0xFFFF, 0xFFC0,		0xFFFF, 0xFF80,
	0xFFFF, 0xFF00, 	0xFFFF, 0xFE00, 	0xFFFF, 0xFC00,		0xFFFF, 0xF800,
	0xFFFF, 0xF000, 	0xFFFF, 0xE000, 	0xFFFF, 0xC000,		0xFFFF, 0x8000,
	0xFFFF, 0x0000,		0xFFFE, 0x0000, 	0xFFFC, 0x0000,		0xFFF8, 0x0000,
	0xFFF0, 0x0000, 	0xFFE0, 0x0000, 	0xFFC0, 0x0000,		0xFF80, 0x0000,
	0xFF00, 0x0000, 	0xFE00, 0x0000, 	0xFC00, 0x0000,		0xF800, 0x0000,
	0xF000, 0x0000, 	0xE000, 0x0000, 	0xC000, 0x0000,		0x8000, 0x0000
};
static USHORT zincBitmap2[] =
{
	32, 32,
	0x0000, 0x0001, 	0x0000, 0x0003, 	0x0000, 0x0007, 	0x0000, 0x000F,
	0x0000, 0x001F, 	0x0000, 0x003F, 	0x0000, 0x007F, 	0x0000, 0x00FF,
	0x0000, 0x01FF, 	0x0000, 0x03FF,		0x0000, 0x07FF, 	0x0000, 0x0FFF,
	0x0000, 0x1FFF, 	0x0000, 0x3FFF, 	0x0000, 0x7FFF, 	0x0000, 0xFFFF,
	0x0001, 0xFFFF, 	0x0003, 0xFFFF, 	0x0007, 0xFFFF,		0x000F, 0xFFFF,
	0x001F, 0xFFFF, 	0x003F, 0xFFFF, 	0x007F, 0xFFFF, 	0x00FF, 0xFFFF,
	0x01FF, 0xFFFF, 	0x03FF, 0xFFFF,		0x07FF, 0xFFFF, 	0x0FFF, 0xFFFF,
	0x1FFF, 0xFFFF, 	0x3FFF, 0xFFFF, 	0x7FFF, 0xFFFF, 	0xFFFF, 0xFFFF
};
static USHORT zincBitmap3[] =
{
	32, 32,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0003, 0xC000, 	0x0007, 0xC000, 	0x000F, 0xF000,
	0x000F, 0xF000, 	0x0007, 0xC000, 	0x0003, 0xC000,		0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000
};
static USHORT zincBitmap4[] =
{
	32, 32,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0003, 0xC000, 	0x0000, 0x8000,
	0x0001, 0x0000, 	0x0003, 0xC000, 	0x0000, 0x0000,		0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000,
	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000, 	0x0000, 0x0000
};

USHORT *zincBitmaps[] = { zincBitmap1, zincBitmap2, zincBitmap3, zincBitmap4, 0 };

UI_PALETTE zincPalettes[] =
{
	{
		'\260', attrib(DARKGRAY, DARKGRAY), attrib(MONO_DIM, MONO_BLACK),
			INTERLEAVE_FILL, attrib(DARKGRAY, DARKGRAY), attrib(BW_WHITE, BW_WHITE),
			attrib(GS_GRAY, GS_GRAY)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
			INTERLEAVE_FILL, attrib(BLACK, BLACK), attrib(BW_BLACK, BW_BLACK),
			attrib(GS_BLACK, GS_BLACK)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_DIM, MONO_BLACK),
			INTERLEAVE_FILL, attrib(BLACK, BLACK), attrib(BW_BLACK, BW_BLACK),
			attrib(GS_BLACK, GS_BLACK)
	},
	{
		'\260', attrib(YELLOW, YELLOW), attrib(MONO_DIM, MONO_BLACK),
			INTERLEAVE_FILL, attrib(YELLOW, YELLOW), attrib(BW_WHITE, BW_WHITE),
			attrib(GS_WHITE, GS_WHITE)
	}
};

static USHORT handBitmap1[] =
{
	32, 15,
	0x0001, 0x8000,
	0x0006, 0x6000,
	0x0F18, 0x1FF0,
	0x0DE0, 0x0808,
	0x0D00, 0x0808,
	0x0D01, 0xFFF0,
	0x0D02, 0x0080,
	0x0D02, 0x0080,
	0x0D01, 0xFF00,
	0x0D02, 0x0100,
	0x0D02, 0x0100,
	0x0D01, 0xFE00,
	0x0DE1, 0x0200,
	0x0F1F, 0x0200,
	0x0001, 0xFE00
};

static USHORT handBitmap2[] =
{
	32, 15,
	0x0000, 0x0000,
	0x0000, 0x0000,
	0x0000, 0x0000,
	0x0000, 0x0000,
	0x0200, 0x0000,
	0x0200, 0x0000,
	0x0200, 0x0000,
	0x0200, 0x0000,
	0x0200, 0x0000,
	0x0200, 0x0000,
	0x0200, 0x0000,
	0x0000, 0x0000,
	0x0000, 0x0000,
	0x0000, 0x0000,
	0x0000, 0x0000
};

USHORT *handBitmaps[] = { handBitmap1, handBitmap2, 0 };

static UI_PALETTE handPalettes[] =
{
	{
		'\260', attrib(BLACK, WHITE), attrib(MONO_BLACK, MONO_NORMAL),
			INTERLEAVE_FILL, attrib(BLACK, WHITE), attrib(BW_BLACK, BW_WHITE),
			attrib(GS_BLACK, GS_GRAY)
	},
	{
		'\260', attrib(YELLOW, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
			INTERLEAVE_FILL, attrib(YELLOW, WHITE), attrib(BW_WHITE, BW_WHITE),
			attrib(GS_BLACK, GS_GRAY)
	}
};

static USHORT worldBitmap1[] =
{
64, 64,
0x0000, 0x0040, 0x0200, 0x0000,
0x0000, 0x0400, 0x0040, 0x0000,
0x0000, 0x1000, 0x2088, 0x0000,
0x0000, 0x8000, 0x3082, 0x0000,
0x0001, 0x001C, 0x1CFC, 0x8000,
0x0004, 0x0000, 0x07FE, 0x4000,
0x000A, 0x0000, 0x03FF, 0x1000,
0x0016, 0x0000, 0x01FF, 0xC800,
0x005C, 0x0000, 0x01FF, 0xE400,
0x00B8, 0x0000, 0x07FF, 0xF200,
0x0170, 0x0000, 0x7FFF, 0xF100,
0x01F0, 0x0000, 0xFFFE, 0x3880,
0x03F0, 0x0001, 0xFFFF, 0x1840,
0x05F0, 0x0001, 0xFFFF, 0xFE40,
0x0BF0, 0x0003, 0xDFFF, 0xFA20,
0x0FF0, 0x000F, 0xFFFF, 0xFE20,
0x17F0, 0x008F, 0xFFFF, 0xFC10,
0x1FF0, 0x0FC3, 0xFFFF, 0xFE08,
0x3FF8, 0x0FE1, 0xFFFF, 0xFE08,
0x3FF8, 0x0F80, 0xFFFF, 0xFE08,
0x5FFE, 0x0C00, 0xFFFF, 0xFE04,
0x5FFE, 0x00F0, 0x07FF, 0xFF04,
0x7FFF, 0x00F2, 0x83FF, 0xFB02,
0x7FFF, 0xC03F, 0xFBFF, 0xFD02,
0xFFFF, 0xF83F, 0xF9FF, 0xFF82,
0xFFFF, 0xFE3C, 0x3BFF, 0xFF82,
0xFFFF, 0xFF00, 0x03FF, 0xFFC1,
0xFFFF, 0xFF80, 0x01FF, 0xFFC1,
0xFFFF, 0xFEF0, 0x003F, 0xFFE1,
0xFFFF, 0xFFD0, 0x000F, 0xFFE1,
0xFFFF, 0xFFF0, 0x000F, 0xFFFF,
0xFFFF, 0xFBE0, 0x000F, 0xFFFD,
0xFFFF, 0xF9E0, 0x0001, 0xFFFF,
0xFFFF, 0xFFE0, 0x0000, 0x7FFF,
0xFFFF, 0xFFC0, 0x0000, 0x1FFF,
0xFFFF, 0xFFC0, 0x0000, 0x1FFF,
0xDFFF, 0xFFE0, 0x0000, 0x1FDF,
0x9FFF, 0xFFF0, 0x0000, 0x1FFD,
0xBFFF, 0xFFF0, 0x0000, 0x3FFE,
0xFFFF, 0xFFF8, 0x0000, 0x3FFE,
0x5FFF, 0xFFF8, 0x0000, 0x7FEE,
0x5FFF, 0xFFFE, 0x0000, 0x7FFA,
0x7FFF, 0xFFFF, 0x0000, 0xFFFC,
0x5FFF, 0xFFFF, 0x0000, 0xEFFC,
0x2BFF, 0xFFFF, 0x0001, 0xFFF4,
0x3EFF, 0xFFFF, 0x0007, 0xFFF8,
0x17FD, 0x7FF7, 0x000F, 0xFFE8,
0x17FF, 0xFFFE, 0x001F, 0xFFF0,
0x0FFF, 0xFFFE, 0x003F, 0xFFD0,
0x0BFF, 0xFFE6, 0x007F, 0xFFE0,
0x05FF, 0xFFFE, 0x00FF, 0xFFC0,
0x03FF, 0xFFFE, 0x01FF, 0xFB40,
0x01FF, 0xFFFE, 0x03FF, 0xFA80,
0x017F, 0xFFFE, 0x0FFF, 0xFD00,
0x00BF, 0xFFFC, 0x1FFF, 0xFA00,
0x005F, 0xFFFC, 0x3FFF, 0xF400,
0x0017, 0xFFFC, 0x3FFF, 0xE800,
0x000B, 0xFFFC, 0x27DF, 0xD000,
0x0005, 0xFFFE, 0x3FCF, 0x4000,
0x0001, 0x7FFF, 0xFDCE, 0x8000,
0x0000, 0x9FFF, 0x87FA, 0x0000,
0x0000, 0x17F6, 0x1FC8, 0x0000,
0x0000, 0x0400, 0x3840, 0x0000,
0x0000, 0x0040, 0x0200, 0x0000
};


static USHORT worldBitmap2[] =
{
64, 64,
0x0000, 0x007F, 0xFE00, 0x0000, 
0x0000, 0x07FF, 0xFFC0, 0x0000, 
0x0000, 0x1FFF, 0xDF78, 0x0000, 
0x0000, 0xFFFF, 0xCF7E, 0x0000, 
0x0001, 0xFFE3, 0xE303, 0x8000, 
0x0007, 0xFFFF, 0xF801, 0xC000, 
0x000D, 0xFFFF, 0xFC00, 0xF000, 
0x0019, 0xFFFF, 0xFE00, 0x3800, 
0x0063, 0xFFFF, 0xFE00, 0x1C00, 
0x00C7, 0xFFFF, 0xF800, 0x0E00, 
0x018F, 0xFFFF, 0x8000, 0x0F00, 
0x010F, 0xFFFF, 0x0001, 0xC780, 
0x020F, 0xFFFE, 0x0000, 0xE7C0, 
0x060F, 0xFFFE, 0x0000, 0x01C0, 
0x0C0F, 0xFFFC, 0x2000, 0x05E0, 
0x080F, 0xFFF0, 0x0000, 0x01E0, 
0x180F, 0xFF70, 0x0000, 0x03F0, 
0x100F, 0xF03C, 0x0000, 0x01F8, 
0x2007, 0xF01E, 0x0000, 0x01F8, 
0x2007, 0xF07F, 0x0000, 0x01F8, 
0x6001, 0xF3FF, 0x0000, 0x01FC, 
0x6001, 0xFF0F, 0xF800, 0x00FC, 
0x4000, 0xFF0D, 0x7C00, 0x04FE, 
0x4000, 0x3FC0, 0x0400, 0x02FE, 
0x8000, 0x07C0, 0x0600, 0x007E, 
0x8000, 0x01C3, 0xC400, 0x007E, 
0x8000, 0x00FF, 0xFC00, 0x003F, 
0x8000, 0x007F, 0xFE00, 0x003F, 
0x8000, 0x010F, 0xFFC0, 0x001F, 
0x8000, 0x002F, 0xFFF0, 0x001F, 
0x8000, 0x000F, 0xFFF0, 0x0001, 
0x8000, 0x041F, 0xFFF0, 0x0003, 
0x8000, 0x061F, 0xFFFE, 0x0001, 
0x8000, 0x001F, 0xFFFF, 0x8001, 
0x8000, 0x003F, 0xFFFF, 0xE001, 
0x8000, 0x003F, 0xFFFF, 0xE001, 
0xA000, 0x001F, 0xFFFF, 0xE021, 
0xE000, 0x000F, 0xFFFF, 0xE003, 
0xC000, 0x000F, 0xFFFF, 0xC002, 
0x8000, 0x0007, 0xFFFF, 0xC002, 
0x6000, 0x0007, 0xFFFF, 0x8012, 
0x6000, 0x0001, 0xFFFF, 0x8006, 
0x4000, 0x0000, 0xFFFF, 0x0004, 
0x6000, 0x0000, 0xFFFF, 0x1004, 
0x3400, 0x0000, 0xFFFE, 0x000C, 
0x2100, 0x0000, 0xFFF8, 0x0008, 
0x1802, 0x8008, 0xFFF0, 0x0018, 
0x1800, 0x0001, 0xFFE0, 0x0010, 
0x0800, 0x0001, 0xFFC0, 0x0030, 
0x0C00, 0x0019, 0xFF80, 0x0020, 
0x0600, 0x0001, 0xFF00, 0x0040, 
0x0200, 0x0001, 0xFE00, 0x04C0, 
0x0100, 0x0001, 0xFC00, 0x0580, 
0x0180, 0x0001, 0xF000, 0x0300, 
0x00C0, 0x0003, 0xE000, 0x0600, 
0x0060, 0x0003, 0xC000, 0x0C00, 
0x0018, 0x0003, 0xC000, 0x1800, 
0x000C, 0x0003, 0xD820, 0x3000, 
0x0006, 0x0001, 0xC030, 0xC000, 
0x0001, 0x8000, 0x0231, 0x8000, 
0x0000, 0xE000, 0x7806, 0x0000, 
0x0000, 0x1809, 0xE038, 0x0000, 
0x0000, 0x07FF, 0xC7C0, 0x0000, 
0x0000, 0x007F, 0xFE00, 0x0000 
};


USHORT *worldBitmaps[] = { worldBitmap1, worldBitmap2, 0 };

static UI_PALETTE worldPalettes[] =
{
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_NORMAL, MONO_NORMAL),
			SOLID_FILL, attrib(LIGHTGREEN, WHITE), attrib(BW_WHITE, BW_WHITE),
			attrib(GS_GRAY, GS_WHITE)
	},
	{
		'\260', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_NORMAL),
			SOLID_FILL, attrib(LIGHTBLUE, WHITE), attrib(BW_BLACK, BW_WHITE),
			attrib(GS_BLACK, GS_WHITE)
	}
};


#pragma argsused
void SampleIcons(void *item, UI_EVENT &event)
{
	UIW_WINDOW *window = UIW_WINDOW::GENERIC(14, 15, 67, 11, WOF_NO_FLAGS,
		WOAF_NO_FLAGS, INFO_ICON, " Sample icons ");
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About icons ", MNF_NO_FLAGS, INFO_ICON)
			+ new HELP_PULL_DOWN_ITEM(" ~Options ", MNF_NO_FLAGS, OPTIONS_ICON));

	if (!_display->isText)
		*window
			+ new UIW_ICON(5, 1, handBitmaps , handPalettes, ICF_TRANSPARENT, WOF_NO_FLAGS)
			+ new UIW_ICON(5, 3, zincBitmaps , zincPalettes, ICF_NO_FLAGS, WOF_NO_FLAGS)
			+ new UIW_ICON(15, 1, worldBitmaps , worldPalettes, ICF_TRANSPARENT, WOF_NO_FLAGS);

	*window
		+ new UIW_TEXT(26, 1, 25, 5,
			"These bit-mapped icons are available only in graphics mode. ",
			128, TXF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER);


	*_windowManager + window;
}

