//	Program name..	Zinc Interface Library
//	Filename......  D_DEMO.CPP
//	Version.......	1.0
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

extern UI_DISPLAY *_display;
extern UI_EVENT_MANAGER *_eventManager;
extern UI_WINDOW_MANAGER *_windowManager;
extern TEXT_DISPLAY_MODE _currentMode;
extern UIW_PULL_DOWN_MENU *_controlMenu;

const int L_CLEAR_SCREEN = 10001;

const int DA_OFF = 0x2000;		// Special control for auto-feed
const int DA_ON = 0x2001;

class DIRECTORY_WINDOW : public UIW_WINDOW
{
public:
	DIRECTORY_WINDOW(void);

	UIW_MATRIX *matrix;
	UIW_PULL_DOWN_MENU *pullDownMenu;

	static void Cleanup(void);
	void FileUserFunction(UIW_POP_UP_ITEM *item);
	void DirectoryUserFunction(UIW_POP_UP_ITEM *item);
	void Matrix(void);
	void PullDownMenu(UIW_PULL_DOWN_ITEM *item, const char *directory);

private:
	static UIW_WINDOW *fileWindow;	// Only one copy since it is modal.
	static UIW_TITLE *fileTitle;
	static UIW_DATE *fileDate;
	static UIW_TIME *fileTime;
	static UIW_NUMBER *fileSize;

	void Path(char *path);
	static int CompareFunction(void *file1, void *file2);
	static void D_DirectoryUserFunction(void *item, UI_EVENT &event);
	static void D_FileUserFunction(void *item, UI_EVENT &event);
};

const int E_EVENT_MONITOR = 98;
class EVENT_MONITOR : public UI_DEVICE, public UIW_WINDOW
{
public:
	int installed;

	EVENT_MONITOR(void);
	~EVENT_MONITOR(void);

private:
	static int active;
	long oldTime;
	long lastTime;
	UIW_STRING *keyboard[3];
	UI_EVENT kEvent;
	UIW_STRING *mouse[3];
	UI_EVENT mEvent;
	UIW_STRING *system;
	UI_EVENT sEvent;
	UIW_STRING *elapsedTime;

	UI_DEVICE *device;
	UIW_WINDOW *window;

	int Event(const UI_EVENT &event);
	void Poll(void);
};

class HELP_POP_UP_ITEM : public UIW_POP_UP_ITEM
{
public:
	int helpContext;

	HELP_POP_UP_ITEM(char *string, USHORT mniFlags, USHORT btFlags,
		USHORT woFlags, int a_helpContext);

protected:
	static void UserFunction(void *helpItem, UI_EVENT &event);
};

class HELP_PULL_DOWN_ITEM : public UIW_PULL_DOWN_ITEM
{
public:
	int helpContext;

	HELP_PULL_DOWN_ITEM(char *string, USHORT mnFlags, int a_helpContext);

protected:
	static void UserFunction(void *helpItem, UI_EVENT &event);
};

class DISPLAY_POP_UP_ITEM : public UIW_POP_UP_ITEM
{
public:
	TEXT_DISPLAY_MODE mode;

	DISPLAY_POP_UP_ITEM(char *string, USHORT mniFlags, USHORT btFlags,
		USHORT woFlags, TEXT_DISPLAY_MODE a_mode);

protected:
	static void UserFunction(void *displayItem, UI_EVENT &event);
};

// Demo functions
extern void InitializeSystem(TEXT_DISPLAY_MODE mode);
extern void RestoreSystem(int finish);
