//	Program name..	Zinc Interface Library
//	Filename......	D_DATA.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <graphics.h>
#include <ui_win.hpp>
#include "d_demo.hpp"
#include "d_help.hlh"

extern USHORT *zincBitmaps[];

extern UI_PALETTE zincPalettes[];

// Button validate procedure for 'Esc=Exit' button.
void ExitButton(void *object, UI_EVENT &event)
{
	// Put a delete level message on the event queue to exit the program.
	event.type = S_DELETE_LEVEL;
	((UIW_BUTTON *)object)->eventManager->Put(event, Q_BEGIN);
}

#pragma argsused
void DataEntry(void *item, UI_EVENT &event)
{
	long value = 0L;
	UI_DATE date("March 21, 1990");

	UIW_WINDOW *window = UIW_WINDOW::GENERIC(0, 1, 54, 12, WOF_NO_FLAGS,
		WOAF_NO_FLAGS, INFO_DATA_ENTRY, " Employee Information ");
	*window
		+ &(*new UIW_PULL_DOWN_MENU(0, WOF_NO_FLAGS, WOAF_NO_FLAGS)
			+ new HELP_PULL_DOWN_ITEM(" ~About data entry ", MNF_NO_FLAGS, INFO_DATA_ENTRY));

	UIW_WINDOW *popup = new UIW_WINDOW(-20, 1, 40 , 12, WOF_NO_FLAGS,
		WOAF_MODAL | WOAF_NO_SIZE | WOAF_NO_MOVE);

	*popup
		+ new UIW_BORDER
		+ new UIW_TITLE("Salary Sub-Window", WOF_JUSTIFY_CENTER)

		+ new UIW_PROMPT(2, 1, "Starting Date....", WOF_NO_FLAGS)
		+ new UIW_DATE(20, 1, 17, &date, "", DTF_ALPHA_MONTH, WOF_BORDER)

		+ new UIW_PROMPT(2, 2, "Starting Salary..", WOF_NO_FLAGS)
		+ new UIW_NUMBER(20, 2, 17, &value, "",
			NMF_CURRENCY | NMF_DECIMAL(2), WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 3, "Current Salary...", WOF_NO_FLAGS)
		+ new UIW_NUMBER(20, 3, 17, &value, "",
			NMF_CURRENCY | NMF_DECIMAL(2), WOF_BORDER | WOF_AUTO_CLEAR)

		+ new UIW_PROMPT(2, 4, "Comments...", WOF_NO_FLAGS)
		+ new UIW_TEXT(14, 4, 23, 3, "Hourly Wages", 1024, TXF_NO_FLAGS, WOF_BORDER)

		+ new UIW_BUTTON(15, 8, 10, "Esc=Exit", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, ExitButton);

	*window
		+ new UIW_PROMPT(8, 1, "Name.....", WOF_NO_FLAGS)
		+ new UIW_STRING(20, 1, 31, "Joe Programmer", 64, STF_NO_FLAGS, WOF_BORDER)

		+ new UIW_PROMPT(8, 2, "Address..", WOF_NO_FLAGS)
		+ new UIW_STRING(20, 2, 31, "405 South 100 East  Suite 201", 64, STF_NO_FLAGS, WOF_BORDER)
		+ new UIW_STRING(20, 3, 31, "Pleasant Grove, UT", 64, STF_NO_FLAGS, WOF_BORDER)

		+ new UIW_PROMPT(8, 5, "Salary Info......", WOF_NO_FLAGS)
		+ new UIW_POP_UP_WINDOW(28, 5, 22, "See Sub-Window", popup, BTF_NO_FLAGS, WOF_NO_FLAGS)

		+ new UIW_ICON(2, 1, zincBitmaps , zincPalettes, ICF_NO_FLAGS, WOF_NON_SELECTABLE)

		+ new UIW_BUTTON(21, 7, 10, "Esc=Exit", BTF_NO_TOGGLE, WOF_JUSTIFY_CENTER, ExitButton);

	*_windowManager + window;
}

