//	Program name..	Zinc Interface Library
//	Filename......	D_CLASS.CPP
//	
//	COPYRIGHT (C) 1990.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <stdio.h>
#include <stdlib.h>
#include <ui_win.hpp>
#include "d_demo.hpp"

const int MAX_WINDOWS = 25;

#pragma argsused
void WindowClassic(void *item, UI_EVENT &event)
{
	char title[16];
	UIW_WINDOW *window[MAX_WINDOWS];
	int left, top, width, height;
	int minHeight = _display->isText ? 2 : 28;
	int minWidth = _display->isText ? 15 : 140;
	UI_REGION region;
	region.left = region.top = 0;
	region.right = _display->columns - 1;
	region.bottom = _display->lines - 1;

	// Hide the input devices while we display the windows.
	_eventManager->DevicesHide(region);

	// Put windows up in random locations on the screen.
	randomize();
	for (int i = 0; i < MAX_WINDOWS; i++)
	{
		sprintf(title, "Window %i", i);
		width = minWidth + random(_display->columns / 2 - minWidth);
		height = minHeight + random(_display->lines / 2 - minHeight);
		left = random(_display->columns - width + 1);
		top = random(_display->lines - height + 1);
		window[i] = UIW_WINDOW::GENERIC(left, top, width, height,
			WOF_NO_FLAGS, WOAF_NO_SIZE, NO_HELP_CONTEXT, title);
		if (i % 3 == 1)
			window[i]->paletteMapTable = _helpPaletteMapTable;
		else if (i % 3 == 2)
			window[i]->paletteMapTable = _errorPaletteMapTable;
		if (!_display->isText)
			window[i]->woStatus |= WOS_GRAPHICS;
		*_windowManager + window[i];

		// Give the event manager some time.
		_eventManager->Get(event, Q_NO_BLOCK | Q_BEGIN | Q_NO_DESTROY);
	}

	// Take the windows off the screen.
	for (i = 0; i < MAX_WINDOWS; i++)
	{
		*_windowManager - window[i];
		delete window[i];

		// Give the event manager some time.
		_eventManager->Get(event, Q_NO_BLOCK | Q_BEGIN | Q_NO_DESTROY);
	}

	// Redisplay the input devices.
	_eventManager->DevicesShow(region);
}
