
//	MUTANT.CPP - a slightly modified version of biomorph

//	Program:	Biomorph   (generate non-standard fractals)
//	Version:        1.02   17-Mar-1990 mods by Ashley Roeckelein
//			1.01   31-Oct-1989
//	Language:	C++ 2.0;  Environ: Any;  Compilers: Zortech C++ 2.01
//	Purpose:	Generates fractals based on complex number formula
//			iterations.
//	Written by:	Scott Robert Ladd, 705 West Virginia, Gunnison CO 81230
//			BBS (303)641-6438; FidoNet 1:104/708

//	***** Modified to work with Zortech's Flash Graphics Library *****

#include <conio.h>
#include <fg.h>
#include "complex.hpp"

Complex		c, z, power;
double		range, xInc, yInc, xMax, yMax, xOrig, yOrig;
int		x, y, i, iter, species;

void		getParms ();
int		main ();

void
getParms (
	void
) {
	cout << "Biomorph 1.02 - complex-plane fractal generator\n\n";
	cout << "This program generates these species of biomorphs...\n";
	cout << "  Species 0: z^x + c	      Species 1: sin(z) + exp(z) + c\n";
	cout << "  Species 2: z^x + z^x + c   Species 3: sin(z) + z^x + c\n";
	do {
		cout << "What species do you want (0..3)? ";
		cin >> species;
	} while ( ( species < 0) || ( species > 3));
	cout << "\nWe need one or two complex numbers.  These can be entered\n";
	cout << "in the following formats (where 'f' indicates a floating-point\n";
	cout << "value:\n";
	cout << "    f -or- (f)  (just a real number)\n";
	cout << "    (f,f)	 (entering both the real and imaginary parts)\n";
	if ( species != 1) {
		cout << "Enter the complex power applied to z: ";
		cin >> power;
	}
	cout << "Enter the complex constant c: ";
	cin >> c;
	cout << "The next two numbers are floating point values representing the\n";
	cout << "origin point on the complex plane of the area being viewed.\n\n";
	cout << "Enter the X location of the center of the picture: ";
	cin >> xOrig;
	cout << "Enter the Y location of the center of the picture: ";
	cin >> yOrig;
	cout << "\nThe next number represents the distance the graph extends away\n";
	cout << "from the above origin.\n\n";
	cout << "Enter the range of the graph: ";
	cin >> range;
	cout << "\nFinally, how many iterations should the program perform?";
	cin >> iter;
}

int
main (
) {
	getParms ();
	fg_init_all ();
	if ( fg_display == FG_CGAHIRES) {
		fg_term ();
		fg_init_cgamedres ();
	}
	yMax = fg_displaybox [ FG_Y2] + 1;
	xMax = fg_displaybox [ FG_X2] + 1;
	yInc = 2.0 * range / yMax;
	xInc = 2.0 * range / xMax;
	range = -range;
	for ( x = 0; x < xMax; x++) {
		for ( y = 0; y < yMax; y++) {
			z = Complex ( range + xInc * x + xOrig,
				range + yInc * y + yOrig);
			for ( i = 0; i < iter; i++) {
				switch ( species) {
					case 0:	z = pow ( z, power) + c;
						break;
					case 1: z = sin ( z) + exp ( z) + c;
						break;
					case 2:	z = pow ( z, z) +
							pow ( z, power) + c;
						break;
					case 3:	z = sin ( z) +
							pow ( z, power) + c;
						break;
				}
				if ( abs ( real ( z)) > 10.0 ||
					abs ( imag ( z)) > 10.0 ||
					norm ( z) >= 100.0)
					break;
			}
			fg_drawdot ( ( fg_color_t) ( ( int) abs ( z)) %
				fg_ncolormap, FG_MODE_SET, ~0, x, y);
		}
		if ( kbhit ())
			break;
	} while ( !kbhit ());
	if ( !getch ())
		getch ();
	fg_term ();
	return 0;
}



