#define STRICT
#include <windows.h>
#include <io.h>
#include <string.h>
#include "winutil.h"

//***************************************************************************
//
//  FUNCTION:   ReadFileIntoEdit()
//
//  PURPOSE:
//
//  COMMENTS:
//
//**************************************************************************

BOOL ReadFileIntoEdit(
    HWND hwnd,
    LPSTR lpszFileName)
{
    GLOBALMEM glbmemFile;
    HFILE hFile;
    OFSTRUCT of;
    unsigned long lFileSize;
    unsigned long lBufSize;
    
    hFile = OpenFile (lpszFileName, &of, OF_READ);
    if (hFile != HFILE_ERROR)
    {
        lFileSize = (unsigned long) _filelength (hFile);
        if (lFileSize < MAX_EDIT_SIZE)
            lBufSize = lFileSize;
        else
            lBufSize = MAX_EDIT_SIZE;
        
        AllocMem (&glbmemFile);
        ReAllocMem (&glbmemFile, lBufSize+1);
            
        _hread (hFile, glbmemFile.lpvMem, lBufSize);

        _lclose (hFile);

        SetWindowText (hwnd, glbmemFile.lpvMem);
        //SendMessage (hwnd, EM_SETHANDLE, glbmemFile.lpvMem, 0L);
        
        FreeMem (&glbmemFile);
        return (TRUE);
    }
    else
    {
        return (FALSE);
    }

}

//***************************************************************************
//
//  FUNCTION:   WriteFileFromEdit()
//
//  PURPOSE:
//
//  COMMENTS:
//
//**************************************************************************

BOOL WriteFileFromEdit(
    HWND hEdit,
    LPSTR lpszFileName)
{
    GLOBALMEM glbmemFile;
    HFILE hFile;
    OFSTRUCT of;
    LRESULT lTextLen;

    // No need to do this, the Common Dialogs take care of this
    // Check if file exists before saving over it
    // hFile = OpenFile (lpszFileName, &of, OF_EXIST);

    hFile = OpenFile (lpszFileName, &of, OF_CREATE);
    if (hFile != HFILE_ERROR)
    {
        lTextLen = SendMessage(hEdit,
            WM_GETTEXTLENGTH,
            0,
            0);

        AllocMem (&glbmemFile);
        ReAllocMem (&glbmemFile, (DWORD)(lTextLen+1));

        SendMessage(hEdit,
            WM_GETTEXT,
            (WPARAM)(lTextLen+1),
            (LPARAM)(glbmemFile.lpvMem));

        _hwrite (hFile, glbmemFile.lpvMem, lstrlen(glbmemFile.lpvMem));
        _lclose (hFile);
        
        FreeMem (&glbmemFile);
        return (TRUE);
    }
    else
    {
        return (FALSE);
    }
}

//***************************************************************************
//
//  FUNCTION:   FreeMem()
//
//  PURPOSE:    Free memory
//
//  COMMENTS:
//
//**************************************************************************

BOOL FreeMem(
    GLOBALMEM *pglbmem)
{
    GlobalUnlock(pglbmem->hglbMem);
    GlobalFree(pglbmem->hglbMem);
    return (TRUE);
}

//**************************************************************************
//
//  FUNCTION:   AllocMem()
//
//  PURPOSE:    Allocate new memory
//
//  COMMENTS:
//
//**************************************************************************

BOOL AllocMem(
    GLOBALMEM *pglbmem)
{
    HGLOBAL hglbNew;        // new handle to memory buffer
    void FAR * lpvNew;      // new pointer to memory buffer

    hglbNew = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, 100);
    if (hglbNew)
    {
        lpvNew = GlobalLock (hglbNew);
        if (lpvNew)
        {
            pglbmem->hglbMem = hglbNew;
            pglbmem->lpvMem = lpvNew;
            pglbmem->nMemSize = GlobalSize (hglbNew);
            return (TRUE);
        }
    }
    if (!hglbNew || !lpvNew)
    {
        // not enough memory to realloc
        return (FALSE);
    }
}

//***************************************************************************
//
//  FUNCTION:   ReAllocMem()
//
//  PURPOSE:    Reallocate to add more memory if necessary
//
//  COMMENTS:
//
//**************************************************************************

BOOL ReAllocMem(
    GLOBALMEM *pglbmem,
    DWORD nTotalSize)
{
    HGLOBAL hglbNew;        // new handle to memory buffer
    void FAR * lpvNew;      // new pointer to memory buffer

    if (nTotalSize > pglbmem->nMemSize)
    {
        hglbNew = GlobalReAlloc (pglbmem->hglbMem,
            nTotalSize,
            GMEM_MOVEABLE | GMEM_ZEROINIT);
        if (hglbNew)
        {
            // need to relock
            GlobalUnlock(pglbmem->hglbMem);
            lpvNew = GlobalLock (hglbNew);
            if (lpvNew)
            {
                pglbmem->hglbMem = hglbNew;
                pglbmem->lpvMem = lpvNew;
                pglbmem->nMemSize = GlobalSize (hglbNew);
                return (TRUE);
            }
        }
        if (!hglbNew || !lpvNew)
        {
            // not enough memory to realloc
            return (FALSE);
        }
    }
    else
    {
        return (TRUE);
    }
}

//***************************************************************************
//
//  FUNCTION:   AddLineToMem()
//
//  PURPOSE:
//
//  COMMENTS:
//
//**************************************************************************

BOOL AddLineToMem(
    GLOBALMEM *pglbmem,
    LPSTR lpstr)
{

    if (!AddStrToMem (pglbmem, lpstr))
        return (FALSE);
    if (!AddStrToMem (pglbmem, "\r\n"))
        return (FALSE);
    return (TRUE);
}

//***************************************************************************
//
//  FUNCTION:   AddStrToMem()
//
//  PURPOSE:
//
//  COMMENTS:
//
//**************************************************************************

BOOL AddStrToMem(
    GLOBALMEM *pglbmem,
    LPSTR lpstr)
{
    long unsigned int nMemStrLen, nAddStrLen;

#if defined (WIN32)
    nMemStrLen = lstrlen(pglbmem->lpvMem);
#else
    nMemStrLen = _fstrlen(pglbmem->lpvMem);
#endif

    nAddStrLen = lstrlen(lpstr);

    if ((nMemStrLen + nAddStrLen) > (MAX_EDIT_SIZE-2000))
        return (FALSE);
        
    if (ReAllocMem (pglbmem, (nMemStrLen+nAddStrLen+1)))
    {
        lstrcat(pglbmem->lpvMem,lpstr);
        return (TRUE);
    }
    else
    {
        return (FALSE);
    }

}

//***************************************************************************
//
//  FUNCTION:   EditLineCat()
//
//  PURPOSE:    Adds a line of text to an edit control
//
//  RETURN:
//
//  COMMENTS:
//
//**************************************************************************

BOOL EditLineCat (
    HWND hEdit,
    LPSTR lpLine)
{
    EditStrCat (hEdit, lpLine);
    EditStrCat (hEdit, "\r\n");
    return (TRUE);
}

//***************************************************************************
//
//  FUNCTION:   EditStrCat()
//
//  PURPOSE:    Appends a string to the end of an edit control
//
//  RETURN:
//
//  COMMENTS:
//
//**************************************************************************

BOOL EditStrCat (
    HWND hEdit,
    LPSTR lpLine)
{
    LRESULT wEndIndex,      // char index of last place in edit control
        dwLines,            // number of lines in edit control
        dwCharIndex,        // index of char in edit control
        dwLen;              // length of last line

    // get number of lines in edit control
    dwLines = SendMessage (hEdit,
        EM_GETLINECOUNT,
        0,
        0);

    // get index of first char in last line
    dwCharIndex = SendMessage (hEdit,
        EM_LINEINDEX,
        (WPARAM)(dwLines-1),
        0);

    // get length of last line
    dwLen = SendMessage (hEdit,
        EM_LINELENGTH,
        (WPARAM)dwCharIndex,
        0);

    wEndIndex = dwCharIndex + dwLen;

#if defined (WIN32)
    // set selection to index at end of edit control text
    SendMessage (hEdit,
        EM_SETSEL,
        wEndIndex,
        wEndIndex);
#else
    // set selection to index at end of edit control text
    SendMessage (hEdit,
        EM_SETSEL,
        0,
        MAKELPARAM(wEndIndex,wEndIndex));

#endif

    // replace above selection with string
    SendMessage (hEdit,
        EM_REPLACESEL,
        0,
        (LPARAM)lpLine);

    return (TRUE);
}

