PROGRAM X_Plot;
{
Programa demonstrativo do uso da interface XView para PC com graficos.
Por Antonio Carlos Moreirao de Queiroz - COPPE/DEEL/UFRJ.
Compile com Turbo Pascal 7.0, usando as "units" XVIEW.TPU e MICKEY.TPU.
}

USES Graph,Crt,XView;

{Objetos da interface}
VAR
  MenuPrincipal,MenuGrafico:Xv_opaque;
  fmensagens,tmsg:Xv_opaque;
  fescalas,bplotar,tymax,tymin,txmax,
  txmin:Xv_opaque;
  fEscreverArquivo,tEscreverArquivo:Xv_opaque;
  fLerArquivo,tLerArquivo:Xv_opaque;
  fprincipal,cgrafico:Xv_opaque;

CONST
  versao='1.0 de 19/08/92';
  pontos=400;  {Pontos no grafico}
  xmin0=0;     {Limites iniciais}
  xmax0=50;
  ymin0=-1;
  ymax0=1;
  grafico_valido:BOOLEAN=FALSE;  {Se existe grafico valido}
  ultimo:INTEGER=0;              {Ultimo ponto calculado}

VAR
  xmin,xmax,ymin,ymax:INTEGER;    {Limites do grafico em pixels no cgrafico}
  cursor:INTEGER;                 {Cursor, em pixels no cgrafico}
  ax,bx,ay,by,delta:REAL;         {Mapeamento}
  gx,gy:ARRAY[1..pontos] OF REAL; {Valores X e Y no grafico}
  {Nao precisaria guardar X, mas assim e mais simples}

FUNCTION Sre(x:REAL; cm,dc:INTEGER):STRING;
VAR
  txt:STRING;
BEGIN
  Str(x:cm:dc,txt);
  Sre:=txt
END;

{$F+}

{Callbacks}

PROCEDURE EscreverArquivo(obj:Xv_opaque);
BEGIN
  {Notify handler para tEscreverArquivo}
  ttysw_output(tmsg,'Seria escrito o arquivo '+tEscreverArquivo^.panel_value+^M^J);
END;

PROCEDURE LerArquivo(obj:Xv_opaque);
BEGIN
  {Notify handler para tLerArquivo}
  ttysw_output(tmsg,'Seria lido o arquivo '+tLerArquivo^.panel_value+^M^J);
END;

PROCEDURE DesenharGrafico(obj:Xv_opaque);
VAR
  i,xg,yg:INTEGER;
  x,y:REAL;
BEGIN
  {Notify handler para cgrafico}
  IF obj<>cgrafico THEN BEGIN
    SetFillStyle(SolidFill,cgrafico^.back_color);
    Bar(0,0,cgrafico^.dx,cgrafico^.dy);
  END;
  IF not grafico_valido THEN ultimo:=0;
  {Eixos}
  SetColor(cgrafico^.fore_color);
  Line(60,10,60,cgrafico^.dy-12);
  Line(60,cgrafico^.dy-12,cgrafico^.dx-10,cgrafico^.dy-12);
  SetTextJustify(RightText,TopText);
  OutTextXY(60,10,Sre(tymax^.panel_real,5,2));
  SetTextJustify(RightText,BottomText);
  OutTextXY(60,cgrafico^.dy-10,Sre(tymin^.panel_real,5,2));
  SetTextJustify(RightText,TopText);
  OutTextXY(cgrafico^.dx-10,cgrafico^.dy-10,Sre(txmax^.panel_real,5,2));
  SetTextJustify(LeftText,TopText);
  OutTextXY(60,cgrafico^.dy-10,Sre(txmin^.panel_real,5,2));
  {Mapeamento}
  xmin:=60;
  xmax:=cgrafico^.dx-10;
  ymin:=10;
  ymax:=cgrafico^.dy-12;
  ay:=(ymax-ymin)/(tymin^.panel_real-tymax^.panel_real);
  by:=ymax-ay*tymin^.panel_real;
  ax:=(xmax-xmin)/(txmax^.panel_real-txmin^.panel_real);
  bx:=xmax-ax*txmax^.panel_real;
  {Calculo e plotagem}
  cursor:=-10;
  grafico_valido:=TRUE;
  delta:=(txmax^.panel_real-txmin^.panel_real)/(pontos-1);
  x:=txmin^.panel_real;
  FOR i:=1 TO pontos DO BEGIN
    IF i>ultimo THEN BEGIN {So calcula se necessario}

      {----------------}

      {Calcula aqui}

      y:=exp(-x/10)*Sin(x);

      {----------------}

      gy[i]:=y;
      gx[i]:=x;
    END;
    xg:=Round(ax*gx[i]+bx);
    yg:=Round(ay*gy[i]+by);
    IF i>1 THEN LineTo(xg,yg) ELSE MoveTo(xg,yg);
    x:=x+delta;
    IF KeyPressed THEN BEGIN
      ultimo:=i;
      Exit;
    END;
  END;
  ultimo:=pontos;
END;

PROCEDURE TratarEventos(obj:Xv_opaque);
VAR
  i:INTEGER;
BEGIN
  {Event handler para cgrafico}
  IF grafico_valido and (ie_shiftcode=1) THEN
    {Acha o ponto mais proximo}
    {Precisa do 1.0 multiplicando}
    i:=Round(1.0*(pontos-1)*(ie_locx-xmin)/(xmax-xmin))+1;
    IF (i>=1) and (i<=ultimo) THEN BEGIN
      {Coloca o cursor}
      SetWriteMode(XorPut);
      SetColor(c_white);
      Line(cursor,ymin,cursor,ymax);
      cursor:=Round(ax*gx[i]+bx);
      Line(cursor,ymin,cursor,ymax);
      SetWriteMode(NormalPut);
      SetFillStyle(SolidFill,cgrafico^.back_color);
      SetColor(cgrafico^.fore_color);
      Bar3d(cgrafico^.dx-76,7,cgrafico^.dx-10,25,0,FALSE);
      OutTextXY(cgrafico^.dx-74,9,'X:'+Sre(gx[i],5,2));
      OutTextXY(cgrafico^.dx-74,17,'Y:'+Sre(gy[i],5,2));
    END;
END;

PROCEDURE TratarMenuPrincipal(obj:Xv_opaque);
BEGIN
  {Notify handler para MenuPrincipal}
  CASE obj^.sel_menu OF
    1:{Ler Dados}
      open_window(fLerArquivo);
    2:{Escrever Dados}
      open_window(fEscreverArquivo);
    3:{Processar Dados}
      open_window(fescalas);
    4:{Mensagens}
      open_window(fMensagens);
    5:{Informacoes}
      BEGIN
        ttysw_output(tmsg,'Programa demonstrativo de plotagem de um grafico'+
        ' em escala linear usando a interface XView para PC'^M^J);
        ttysw_output(tmsg,'Por Antonio Carlos Moreirao de Queiroz'^M^J);
        ttysw_output(tmsg,'COPPE/DEEL/UFRJ - Versao '+versao+^M^J);
      END;
    6:{Terminar}
      xv_end:=TRUE;
  END;
END;

PROCEDURE TratarMenuGrafico(obj:Xv_opaque);
BEGIN
  {Notify handler para MenuGrafico}
  CASE obj^.sel_menu OF
    1:{Mudar Escalas}
      open_window(fescalas);
    2:{Menu Principal}
      ttysw_output(tmsg,'Aperte o botao direito para acessar o submenu'^M^J);
  END;
END;

PROCEDURE Plotar(obj:Xv_opaque);
BEGIN
  {Notify handler para bplotar}
  WHILE active_w<>fprincipal DO close_window(active_w);
  DesenharGrafico(nil);
END;

PROCEDURE InvalidarGrafico(obj:Xv_opaque);
BEGIN
  {Notify handler para txmax e txmin}
  grafico_valido:=FALSE;
END;

{$F-}

BEGIN
  {Inicializacao}
  xv_init(0,0);
  {Menus}
  {Menu for fmensagens, fEscreverArquivo, fLerArquivo e fprincipal}
  MenuPrincipal:=xv_create(menu);
  WITH MenuPrincipal^ DO BEGIN
    xv_label:='Menu:';
    item_create('ler dados');
    item_create('escrever dados');
    item_create('setar escalas');
    item_create('mensagens');
    item_create('informacoes');
    item_create('terminar');
    notify_handler:=TratarMenuPrincipal;
  END;
  {Menu para cgrafico}
  MenuGrafico:=xv_create(menu);
  WITH MenuGrafico^ DO BEGIN
    xv_label:='Grafico:';
    item_create('mudar escalas');
    item_create('menu principal');
    notify_handler:=TratarMenuGrafico;
    item_submenu[2]:=MenuPrincipal;
  END;
  {Criacao dos objetos da interface}
  fescalas:=xv_create(frame);
  WITH fescalas^ DO BEGIN
    xv_label:='Escalas';
    x:=320;
    y:=23;
    dx:=250;
    dy:=99;
  END;
  bplotar:=xv_create(button);
  WITH bplotar^ DO BEGIN
    xv_label:='Plotar';
    y:=60;
    notify_handler:=Plotar;
  END;
  tymax:=xv_create(textfield);
  WITH tymax^ DO BEGIN
    xv_label:='y maximo';
    y:=45;
    field_type:=real_field;
    panel_real:=ymax0;
  END;
  tymin:=xv_create(textfield);
  WITH tymin^ DO BEGIN
    xv_label:='y minimo';
    y:=30;
    field_type:=real_field;
    panel_real:=ymin0;
  END;
  txmax:=xv_create(textfield);
  WITH txmax^ DO BEGIN
    xv_label:='x maximo';
    y:=15;
    field_type:=real_field;
    panel_real:=xmax0;
    notify_handler:=InvalidarGrafico;
  END;
  txmin:=xv_create(textfield);
  WITH txmin^ DO BEGIN
    xv_label:='x minimo';
    field_type:=real_field;
    panel_real:=xmin0;
    notify_handler:=InvalidarGrafico;
  END;
  fmensagens:=xv_create(frame);
  WITH fmensagens^ DO BEGIN
    xv_label:='Mensagens';
    x:=6;
    y:=111;
    dx:=319;
    dy:=159;
    menu_name:=MenuPrincipal;
  END;
  tmsg:=xv_create(tty);
  WITH tmsg^ DO BEGIN
  END;
  fEscreverArquivo:=xv_create(frame);
  WITH fEscreverArquivo^ DO BEGIN
    xv_label:='Escrever Arquivo';
    x:=6;
    y:=67;
    dx:=319;
    dy:=43;
    dymin:=27;
    menu_name:=MenuPrincipal;
  END;
  tEscreverArquivo:=xv_create(textfield);
  WITH tEscreverArquivo^ DO BEGIN
    xv_label:='Arquivo';
    value_length:=30;
    notify_handler:=EscreverArquivo;
    owner^.mouse_obj:=tEscreverArquivo;
  END;
  fLerArquivo:=xv_create(frame);
  WITH fLerArquivo^ DO BEGIN
    xv_label:='Ler Arquivo';
    x:=6;
    y:=23;
    dx:=319;
    dy:=43;
    dymin:=27;
    menu_name:=MenuPrincipal;
  END;
  tLerArquivo:=xv_create(textfield);
  WITH tLerArquivo^ DO BEGIN
    xv_label:='Arquivo';
    value_length:=30;
    notify_handler:=LerArquivo;
    owner^.mouse_obj:=tLerArquivo;
  END;
  fprincipal:=xv_create(frame);
  WITH fprincipal^ DO BEGIN
    xv_label:='Programa Demonstrativo de Grafico';
    dx:=GetMaxX;
    dy:=GetMaxY;
    menu_name:=MenuPrincipal;
    adjust_exit:=FALSE;
    mouse_obj:=fprincipal;
  END;
  cgrafico:=xv_create(canvas);
  WITH cgrafico^ DO BEGIN
    notify_handler:=DesenharGrafico;
    event_handler:=TratarEventos;
    menu_name:=MenuGrafico;
    fore_color:=c_white;
    back_color:=c_black;
  END;
  xv_main_loop(fprincipal);
  {Fim}
  TextMode(80);
END.
