/* This is a test program for the XView-PC interface in C */

#include <xview.h>
#include <graphics.h>
#include <string.h>

int color=RED;
char buf[200];

/* Declaration of the interface objects */
Xv_opaque menu1;
Xv_opaque frame1,tty1,button1,button2,button3,
  button4,button5,text2,text3,text4,
  button6;
Xv_opaque frame2,canvas1,message1;
Xv_opaque frame3,setting1,setting2,setting3,button7,message2;

/* Callback procedures */

void Open1(Xv_opaque obj)
{
  /* Notify handler for button1 */
  open_window(frame2);
}

void Open2(Xv_opaque obj)
{
  /* Notify handler for button2 */
  open_window(frame3);
}

void Quit(Xv_opaque obj)
{
  /* Notify handler for button3 */
  xv_end=1;
}

void Car1(Xv_opaque obj)
{
  /* Notify handler for button4 */
  ttysw_output(tty1,"Car #1\r\n");
}

void Car2(Xv_opaque obj)
{
  /* Notify handler for button5 */
  ttysw_output(tty1,"Car #2\r\n");
}

void EnterText(Xv_opaque obj)
{
  /* Notify handler for text2 */
  sprintf(buf,"Text: %s\r\n",obj->v.stextfield.panel_value);
  ttysw_output(tty1,buf);
}

void EnterInt(Xv_opaque obj)
{
  /* Notify handler for text3 */
  sprintf(buf,"Integer: %d\r\n",obj->v.stextfield.panel_int);
  ttysw_output(tty1,buf);
}

void EnterReal(Xv_opaque obj)
{
  /* Notify handler for text4 */
  sprintf(buf,"Real: %g\r\n",obj->v.stextfield.panel_real);
  ttysw_output(tty1,buf);
}

void Cars3(Xv_opaque obj)
{
  /* Notify handler for button6 */
  ttysw_output(tty1,"Car #3\r\n");
}

void Close2(Xv_opaque obj)
{
  /* Notify handler for frame2 */
  /* Notify handler for frame3 */
  sprintf(buf,"Closed %s\r\n",obj->xv_label);
  ttysw_output(tty1,buf);
}

void Draw(Xv_opaque obj)
{
  /* Event handler for canvas1 */
  sprintf(buf,"x:%d y:%d",ie_locx,ie_locy);
  xv_set(message1,buf);
  if (ie_shiftcode) {
    setfillstyle(SOLID_FILL,color);
    bar(ie_locx-5,ie_locy-5,ie_locx,ie_locy);
  }
}

void Set1(Xv_opaque obj)
{
  /* Notify handler for setting1 */
  /* Notify handler for setting1 */
  sprintf(buf,"Selection=%d\r\n",obj->v.ssetting.sel_setting);
  ttysw_output(tty1,buf);
}

void ChangeColor(Xv_opaque obj)
{
  /* Notify handler for setting3 */
  switch (obj->v.ssetting.sel_setting) {
    case 1: color=RED; break;
    case 2: color=GREEN; break;
    case 3: color=BLUE;
  }
}

void Options(Xv_opaque obj)
{
  /* Notify handler for menu1 */
  switch (obj->v.smenu.sel_menu) {
    case 1: /* close 1 */; close_window(frame1); break;
    case 2: /* close 2 */; close_window(frame2); break;
    case 3: /* close 3 */; close_window(frame3); break;
    case 4: /* open 1 */; open_window(frame1); break;
    case 5: /* open 2 */; open_window(frame2); break;
    case 6: /* open 3 */; open_window(frame3); break;
    case 7: /* quit */; xv_end=1; break;
    case 8: /* more... */; break;
  }
}

void ListEvents(Xv_opaque obj)
{
  /* Event handler for message2 */
  sprintf(buf,"Event: %d",ie_code);
  xv_set(message2,buf);
}

void main()
{
  /* Inicialization */
  use_palette=0;
  xv_init(0,0);
  /* Menu creation */
  /* Menu for frame1 */
  /* Menu for frame2 */
  /* Menu for frame3 */
  /* Submenu for item 8 of 'menu1' */
  menu1=xv_create(menu);
    strcpy(menu1->xv_label,"menu");
    item_create("close 1");
    item_create("close 2");
    item_create("close 3");
    item_create("open 1");
    item_create("open 2");
    item_create("open 3");
    item_create("quit");
    item_create("more...");
    menu1->v.smenu.item_submenu[7]=menu1;
    menu1->v.smenu.sel_menu=1;
    menu1->notify_handler=(xv_handler)Options;
  /* Interface objects creation */
  frame1=xv_create(frame);
    strcpy(frame1->xv_label,"XView-PC test program");
    frame1->dx=218;
    frame1->dy=162;
    frame1->v.sframe.dxmin=218;
    frame1->v.sframe.dymin=162;
    frame1->menu_name=menu1;
    frame1->v.sframe.adjust_exit=0;
  tty1=xv_create(tty);
    tty1->v.scanvas.can_yext=0; tty1->dy=42;
  button1=xv_create(button);
    strcpy(button1->xv_label,"popup 2..");
    button1->y=46;
    button1->notify_handler=(xv_handler)Open1;
  button2=xv_create(button);
    strcpy(button2->xv_label,"popup 3..");
    button2->y=61;
    button2->notify_handler=(xv_handler)Open2;
  button3=xv_create(button);
    strcpy(button3->xv_label,"quit");
    button3->y=76;
    button3->notify_handler=(xv_handler)Quit;
  button4=xv_create(button);
    strcpy(button4->xv_label,"cars.bmp");
    button4->x=80;
    button4->y=46;
  button4->v.sbutton.icon_label=1;
    button4->notify_handler=(xv_handler)Car1;
  button5=xv_create(button);
    strcpy(button5->xv_label,"cars.bmp");
    button5->x=126;
    button5->y=46;
  button5->v.sbutton.icon_label=1;
    button5->notify_handler=(xv_handler)Car2;
  text2=xv_create(textfield);
    strcpy(text2->xv_label,"Text:");
    text2->y=91;
    text2->notify_handler=(xv_handler)EnterText;
  text3=xv_create(textfield);
    strcpy(text3->xv_label,"Integer:");
    text3->y=106;
    text3->v.stextfield.value_length=17;
    text3->v.stextfield.field_type=int_field;
    text3->notify_handler=(xv_handler)EnterInt;
  text4=xv_create(textfield);
    strcpy(text4->xv_label,"Real:");
    text4->y=121;
    text4->v.stextfield.field_type=real_field;
    text4->notify_handler=(xv_handler)EnterReal;
  button6=xv_create(button);
    strcpy(button6->xv_label,"cars.bmp");
    button6->x=171;
    button6->y=46;
    button6->v.sbutton.icon_label=1;
    button6->notify_handler=(xv_handler)Cars3;
  frame2=xv_create(frame);
    strcpy(frame2->xv_label,"Window 2");
    frame2->x=18;
    frame2->y=20;
    frame2->dx=218;
    frame2->dy=160;
    frame2->notify_handler=(xv_handler)Close2;
    frame2->menu_name=menu1;
  canvas1=xv_create(canvas);
    canvas1->y=15;
    canvas1->event_handler=(xv_handler)Draw;
  message1=xv_create(message);
    strcpy(message1->xv_label,"x: y:");
  frame3=xv_create(frame);
    strcpy(frame3->xv_label,"Window 3");
    frame3->x=39;
    frame3->y=42;
    frame3->dx=216;
    frame3->dy=86;
    frame3->v.sframe.dymin=30;
    frame3->notify_handler=(xv_handler)Close2;
    frame3->menu_name=menu1;
  setting1=xv_create(setting);
    strcpy(setting1->xv_label,"exclusive");
    item_create("1");
    item_create("2");
    item_create("3");
    item_create("4");
    item_create("5");
    item_create("6");
    item_create("7");
    item_create("8");
    item_create("9");
    item_create("0");
    setting1->v.ssetting.exclusive=1;
    setting1->v.ssetting.sel_setting=1;
    setting1->notify_handler=(xv_handler)Set1;
  setting2=xv_create(setting);
    strcpy(setting2->xv_label,"non excl.");
    setting2->y=15;
    item_create("a");
    item_create("b");
    item_create("c");
    item_create("d");
    item_create("e");
    item_create("f");
    item_create("g");
    item_create("h");
    item_create("i");
    item_create("j");
  setting2->notify_handler=(xv_handler)Set1;
  setting3=xv_create(setting);
    strcpy(setting3->xv_label,"color");
    setting3->x=51;
    setting3->y=30;
    item_create("red");
    item_create("green");
    item_create("blue");
    setting3->v.ssetting.exclusive=1;
    setting3->v.ssetting.sel_setting=1;
    setting3->notify_handler=(xv_handler)ChangeColor;
  button7=xv_create(button);
    strcpy(button7->xv_label,"events");
    button7->y=45;
    button7->event_handler=(xv_handler)ListEvents;
  message2=xv_create(message);
    message2->y=45;
    message2->x=100;
  xv_main_loop(frame1);
  /* Exit */
  restorecrtmode();
}
