#ifndef XVIEWH
#define XVIEWH

#include <graphics.h>

/*
 Interface XView-PC para Turbo C
 Antonio Carlos Moreirao de Queiroz - COPPE/DEEL/UFRJ
 Versao 1.4a de 16/07/92
 Versao 1.4b de 04/08/92 Corrigido bug nos submenus. mrgx, mrgy no .H
 Versao 1.4c de 02/09/92 De acordo com novo Mickey
 Versao 1.4d de 25/09/92 Mudada inicializacao de active_w (Pascal 1.4c)
 Versao 1.5  de 09/07/93 Bitmaps nos botoes (Pascal 1.5)
 Versao 1.5a de 23/10/93 Ordem dos eventos e suporte de "mouse" de 2 botoes
 Versao 1.5b de 18/11/93 Melhor leitura de bitmaps
 Versao 1.6  de 20/11/93 Eliminado o limite de 64K. Minimo codigo

Este modulo implementa uma interface grafica que procura ser similar ao
"toolkit" XView, usado nas "WorkStations" Sun, em uma forma simplificada.
O que pode ser feito com esta interface pode ser repetido com o XView nas
"WorkStations" com X-Windows, sem grandes modificacoes de estrutura, embora
com diferencas devidas as varias simplificacoes feitas.
O transporte para o sistema Windows tambem nao e muito complexo.
O uso da interface acrescenta pouco mais de 20K ao codigo do programa.

O conjunto e formado pelos arquivos:
XVIEW.H, XVIEW.OBJ: As rotinas da interface.
MICKEY.H, MICKEY.OBJ: Tratamento do "mouse".
X_MAKE.EXE: Editor de interfaces em Pascal e C.

Para compilar:
- Abra um projeto com os arquivos .OBJ e o programa fonte em C.
- Ligue o "link" com as bibliotecas graficas e de ponto flutuante.
- Ligue a opcao "word align".
- Use o modelo "large".

A documentacao aqui cobre apenas as diferencas entre as versoes em Pascal
e em C. Ver o arquivo XVIEW.DOC para maiores detalhes sobre a utilizacao
da interface.

Observacoes gerais:

Os campos do "union" "xv_widget" sao acessados de forma mais complexa que
na versao em Pascal. Exemplos:
obj^.x torna-se obj->x
obj^.sel_menu torna-se obj->v.smenu.sel_menu
obj^.gr_out.x1 torna_se obj->v.sframe.gra-out.left
Uma boa ideia e implementar "defines" para campos muito usados, ou funcoes
como as xv_set e xv_get do XView da Sun.

Uso de memoria:

Cada objeto ocupa na "heap":
- "sizeof(xv_widget)" bytes (por volta de 272).
- O tamanho dos "buffer"s usados nos "tty"s, dado por "bsize"+1.
- Sua area na tela, se for um "frame" colocado sobre outro, "areaw".
- Os nomes dos itens dos "menus" e "settings" ficam no codigo.
********************************************************************************
*/

/*
 * As variaveis marcadas * sao reservadas, e nao devem ser modificadas.
 * As variaveis marcadas # sao as que usualmente sao inicializadas.
 * As outras podem ser mudadas livremente
 */

#define LOC_MOVE 256
  /* evento: "mouse" andou */
#define LOC_DRAG 257
  /* evento: "mouse" andou com botoes apertados */
#define MS_LEFT 1001
  /* evento: botao "select" apertado */
#define MS_MIDDLE 1004
  /* evento: botao "adjust" apertado */
#define MS_RIGHT 1002
  /* evento: botao "menu" acionado */
#define m_itens 20
  /* maximo no. de itens nos menus e settings  (so 16 nos settings) */
#define m_chars 60
  /* caracteres nas strings */
#define mrgx 5
  /* margens laterais e do fundo das janelas */
#define mrgy 22
  /* margem superior das janelas */

#define Xv_opaque struct widget *

  typedef struct figstruct {              /* estrutura para imagens */
    int blocks;                           /* numero de blocos de imagem -1 */
    unsigned int blocksize,lastblocksize; /* tamanhos dos blocos de imagem alocados */
    void *v[2001];                        /* somente alocado ate "blocks" */
  } figstruct;
  typedef struct figstruct* ptrfig;       /* apontador de imagem */

  typedef void (*xv_handler)(Xv_opaque obj);
  typedef enum { frame,button,textfield,setting,message,canvas,tty,menu } xv_package;
  typedef char xv_label_type[m_chars+1];
  typedef struct widget {
   xv_label_type xv_label;              /* # titulo do objeto */
   int           x,y,dx,dy;             /* # posicao e tamanho */
   int           fore_color,back_color; /* # cores */
   Xv_opaque     owner;                 /* * janela onde esta */
   Xv_opaque     next;                  /* * proximo objeto */
   Xv_opaque     menu_name;             /* # menu associado */
   xv_handler    notify_handler;        /* # funcao associada */
   xv_handler    event_handler;         /* # tratador de eventos */
   void          *client_data;          /* # outros valores associados */
   xv_package o_type;                   /* * tipo do objeto */
    union {
     struct { Xv_opaque over;
              Xv_opaque under;        /* * janelas vizinhas */
              ptrfig    Pw;           /* * imagem encoberta */
              long int areaw;         /* * tamanho da imagem */
	      int       dxmin, dymin; /* # minimas dimensoes */
	      int       interfere;    /* * usado em reordenacao */
	      int       mapped;       /* * se a janela esta na tela */
	      int       adjust_exit;  /* # desativa com botao do meio */
	      Xv_opaque mouse_obj;    /* # objeto default, se nao nil */
	      struct viewporttype gr_out; } sframe;  /* * viewport */
     struct { int       icon_label;   /* # se o "xv_label" e o nome de um "bitmap" */
              ptrfig    Pimageb; } sbutton;  /* * imagem do botao */
     struct { int       icon_msg;     /* # se o "xv_label" e o nome de um "bitmap" */
              ptrfig    Pimagem; } smessage; /* * imagem da mensagem */
     struct { xv_label_type panel_value;    /* # texto atual */
	      double panel_real;            /* # real correspondente ao texto */
	      int   panel_int;              /* # inteiro " */
	      int   min_value, max_value;   /* # limites para inteiros */
	      int   value_length;           /* # no. de caracteres mostrados */
	      enum { text_field,real_field,int_field } field_type;  } stextfield;  /* # tipo */
     struct { int itens_setting;            /* * no. de itens */
	      int      sel_setting;         /* # selecao */
	      char     *item_setting[m_itens]; /* * itens */
	      int exclusive; } ssetting;       /* # selecao exclusiva */
     struct { int can_xext,can_yext; } scanvas;  /* # extensao ate as bordas */
     struct { int tty_xext,tty_yext;             /* # " */
	      int xc,yc;                   /* * cursores graficos */
	      unsigned int bsize;          /* * tamanho do "buffer" */
	      unsigned bcsr;               /* * cursor do "buffer" */
	      unsigned bstart,tstart,tend; /* * apontadores no "buffer" */
	      int dxtty;                   /* * largura efetiva do painel */
	      char *Pb; } stty;            /* * "buffer" de texto */
     struct { int itens_menu;           /* * no. de itens */
	      int sel_menu;             /* # item selecionado */
	      char *item_menu[m_itens]; /* * itens */
	      Xv_opaque item_submenu[m_itens]; } smenu;  /* # submenus */
   } v;
  } widget;

#undef Xv_opaque

  typedef struct widget * Xv_opaque;
  extern int wallpaper;   /* 0 # reter o fundo original */
  extern unsigned int normal_bsize;  /* # "bsize" (tty) atribuido por "xv_create" */
  extern unsigned int normal_length; /* # "value_length" (textfield) atribuido por "xv_create" */
  extern int c_normal;    /* LIGHTGRAY     fundo dos objetos */
  extern int c_active;    /* GREEN         botoes apertados */
  extern int c_light;     /* WHITE         cantos iluminados */
  extern int c_shadow;    /* BLACK         cantos escuros */
  extern int c_white;     /* WHITE         back_color default */
  extern int c_black;     /* BLACK         fore_color default */
  extern int c_overwrite; /* LIGHTRED      na edicao dos textfields */
  extern int c_edit;      /* BLUE          " */
  extern int c_insert;    /* YELLOW        " */
  extern int c_hatch;     /* CYAN          cor do padrao de fundo */
  extern int type_hatch;        /* XHATCH_FILL  padrao do fundo */
  extern int use_palette;       /* 1 obedecer "palette" dos "bitmaps" */
  extern void *normal_client_data; /* NULL atribuido a "client_data" por "xv_create" */
  extern int          nlines;   /* * 60, numero de linhas por bloco de imagem */
  extern int          insert;   /* insercao de texto no editor */
  extern int          xv_ok;    /* * resultado da ultima manipulacao de janelas */
  extern int          xv_end;   /* encerra o xv_main_loop */
  extern xv_label_type   ulttxt;    /* ultimo texto lido nos textfields */
  extern int          ie_locx,ie_locy;   /* * posicao do mouse relativo ao objeto ou janela */
  extern int          ie_code;      /* * codigo do evento */
  extern int          ie_shiftcode; /* * estado dos botoes do "mouse" */
  extern Xv_opaque    active_w;     /* * aponta a janela ativa */
  extern Xv_opaque    active_o;     /* * aponta o objeto ativo */
  extern Xv_opaque    w_base;       /* janela base para xv_create */
  extern Xv_opaque    o_base;       /* objeto base para item_create */
  extern int redrawing_frame;       /* se uma janela esta sendo redesenhada */

extern void xv_init(int placa,int modo);
/* Inicializacao geral */

extern Xv_opaque xv_create(xv_package obj_type);
/* Aloca e inicializa com valores "default" um objeto. Retorna seu apontador
   Aloca o "tbuffer" dos "tty"s com Pb=malloc(bsize+1)
*/

extern void item_create(const char *txt);
/* Cria item de menu ou setting.
   Os itens sao numerados a partir de 0. Nenhuma memoria e alocada
*/

extern void xv_main_loop(Xv_opaque w);
/* Abre uma janela e entra no ciclo espera evento - trata evento */

extern void open_window(Xv_opaque w);
/* Ativa uma janela */

extern void close_window(Xv_opaque w);
/* Fecha uma janela, apagando-a da tela */

extern void ttysw_output(Xv_opaque terminal, const char *texto);
/* Escreve um texto no "tty" <terminal> */

extern void Back(void);
/* Circula para tras as janelas, colocando a ativa atual no fundo */

extern void xv_set(Xv_opaque obj, char *new_label);
/* Atualiza o "xv_label" de um objeto, ativando sua janela e redesenhando-o */

extern void menu_show(Xv_opaque obj);
/* Ativa um "menu" em (mousex,mousey) */

extern void draw_object(Xv_opaque obj, int complete);
/* Desenha um objeto */

extern void nothing(Xv_opaque obj);
/* "Notify_handler" e "event-handler" default, que nao faz nada */

extern void wait_button(void);
/* Espera ate que botoes do "mouse" sejam soltos */

extern void drawbitmap(int x,int y,int* dw, int* dh, ptrfig *Pimg, const char *filename);
/* Desenha um bitmap de 16 cores do Windows */
/* O "filename" deve usar "/" e nao "\" como separador de subdiretorios */

/* As rotinas abaixo sao para operacao com imagens que ocupam mais de 64K
Sao usadas internamente para operacoes com janelas e na "drawbitmap" */

extern long int figuresize(int x1,int y1,int x2,int y2);
/* Memoria necessaria para uma figura a ser usada com as outras rotinas */

extern void getfiguremem(ptrfig *p,int dw,int dh);
/* Aloca apontador para figura. "dw" e "dh" sao largura-1 e altura-1 */

extern void freefiguremem(ptrfig p);
/* Libera memoria alocada para figura */

extern void getfigure(int x1,int y1,int x2,int y2,ptrfig p);
/* Captura figura da tela */

extern void putfigure(int x,int y,ptrfig p,unsigned int bitblt);
/* Desenha figura na tela */

#endif

