{
XView-PC demonstration:
A window with a directory display for file selection.
Note that no memory is used for the directory.
}

USES Dos,Graph,XView;

VAR
  names,total,k:INTEGER;

VAR
  fmsg,ttymsg:Xv_opaque;
  fdirectory,cdirectory,tmask,tfile:Xv_opaque;

{$F+}

PROCEDURE ReadDirectory(obj:Xv_opaque);
VAR
  srec:SearchRec;

BEGIN
  SetTextStyle(smallfont,horizdir,4);
  IF obj<>cdirectory THEN BEGIN
    SetFillStyle(SolidFill,cdirectory^.back_color);
    Bar(0,0,cdirectory^.dx,cdirectory^.dy)
  END;
  names:=(cdirectory^.dx) div 78;
  k:=0;
  FindFirst(tmask^.panel_value,AnyFile,srec);
  WHILE DosError=0 DO BEGIN
    OutTextXY(3+(k mod names)*78,(k div names)*8,srec.Name);
    FindNext(srec);
    Inc(k)
  END;
  total:=k-1
END;

PROCEDURE SelectFile(obj:Xv_opaque);
VAR
  srec:SearchRec;
  i:INTEGER;
  D:DirStr;
  N:NameStr;
  E:ExtStr;

BEGIN
  IF ie_code=MS_LEFT THEN BEGIN
    k:=(ie_locx-3) div 78;
    IF k<names THEN BEGIN
      k:=k+((ie_locy-3) div 8)*names;
      IF k<=total THEN BEGIN
        i:=0;
        FindFirst(tmask^.panel_value,AnyFile,srec);
        WHILE (DosError=0) and (i<k) DO BEGIN
          FindNext(srec);
          Inc(i)
        END;
        FSplit(tmask^.panel_value,D,N,E);
        tfile^.panel_value:=FExpand(D+srec.Name);
        xv_set(tfile,tfile^.xv_label)
      END
    END
  END
END;

PROCEDURE OpenFile(obj:Xv_opaque);
BEGIN
  ttysw_output(ttymsg,'Selected file: '+tfile^.panel_value+^M^J);
END;

{$F-}

BEGIN
  xv_init(0,0);
  fmsg:=xv_create(frame);
  WITH fmsg^ DO BEGIN
    xv_label:='Messages';
    y:=160;
    dx:=319;
    dy:=159;
  END;
  ttymsg:=xv_create(tty);
  WITH ttymsg^ DO BEGIN
  END;
  fdirectory:=xv_create(frame);
  WITH fdirectory^ DO BEGIN
    xv_label:='File selection';
    dx:=319;
    dy:=159;
  END;
  cdirectory:=xv_create(canvas);
  WITH cdirectory^ DO BEGIN
    y:=30;
    notify_handler:=ReadDirectory;
    event_handler:=SelectFile;
  END;
  tmask:=xv_create(textfield);
  WITH tmask^ DO BEGIN
    xv_label:='Mask';
    y:=15;
    value_length:=33;
    panel_value:='*.*';
    notify_handler:=ReadDirectory;
  END;
  tfile:=xv_create(textfield);
  WITH tfile^ DO BEGIN
    xv_label:='File';
    value_length:=33;
    notify_handler:=OpenFile;
  END;
  xv_main_loop(fdirectory);
END.
