{
XView-PC demonstration:
How to open a window, and return the execution to the starting point when the
window is closed.
}

USES XView;

VAR
  frame2,bok,bstate,tty2:Xv_opaque;
  frame1,bWindow,bWindow1,bWindow2,tty1:Xv_opaque;

{$F+}

PROCEDURE State(obj:Xv_opaque);
BEGIN
  ttysw_output(tty2,'active:'+active_w^.xv_label+^M^J);
  ttysw_output(tty2,'1 over: '+frame1^.over^.xv_label+^M^J);
  ttysw_output(tty2,'1 under:'+frame1^.under^.xv_label+^M^J);
  ttysw_output(tty2,'2 over: '+frame2^.over^.xv_label+^M^J);
  ttysw_output(tty2,'2 under:'+frame2^.under^.xv_label+^M^J);
END;

PROCEDURE CloseWindow(obj:Xv_opaque);
BEGIN
  close_window(frame2);
  xv_end:=TRUE {This ends the last "xv_main_loop"}
END;

PROCEDURE OpenExclusive(obj:Xv_opaque);
VAR
  temp:Xv_opaque;
BEGIN
  IF frame2^.mapped THEN BEGIN
     ttysw_output(tty1,'An already mapped window cannot be opened in this way'^M^j);
    Exit
  END;
  ttysw_output(tty1,'Will open exclusive window'^M^J);
  ttysw_output(tty1,'active:'+active_w^.xv_label+^M^J);
  ttysw_output(tty1,'over: '+active_w^.over^.xv_label+^M^J);
  ttysw_output(tty1,'under:'+active_w^.under^.xv_label+^M^J);
  wallpaper:=TRUE;
  temp:=active_w;
  active_w:=nil;
  xv_main_loop(frame2);
  active_w:=temp;
  xv_end:=FALSE;
  wallpaper:=FALSE;
  ttysw_output(tty1,'Returned'^M^J);
  ttysw_output(tty1,'active:'+active_w^.xv_label+^M^J);
  ttysw_output(tty1,'over: '+active_w^.over^.xv_label+^M^J);
  ttysw_output(tty1,'under:'+active_w^.under^.xv_label+^M^J);
END;

PROCEDURE OpenNonExclusive(obj:Xv_opaque);
VAR
  temp:Xv_opaque;
BEGIN
  ttysw_output(tty1,'Will open non exclusive window'^M^J);
  ttysw_output(tty1,'active:'+active_w^.xv_label+^M^J);
  ttysw_output(tty1,'over: '+active_w^.over^.xv_label+^M^J);
  ttysw_output(tty1,'under:'+active_w^.under^.xv_label+^M^J);
  xv_main_loop(frame2);
  xv_end:=FALSE;
  ttysw_output(tty1,'Returned'^M^J);
  ttysw_output(tty1,'active:'+active_w^.xv_label+^M^J);
  ttysw_output(tty1,'over: '+active_w^.over^.xv_label+^M^J);
  ttysw_output(tty1,'under:'+active_w^.under^.xv_label+^M^J);
END;

PROCEDURE OpenWindow(obj:Xv_opaque);
BEGIN
  ttysw_output(tty1,'Will open conventional window'^M^J);
  ttysw_output(tty1,'active:'+active_w^.xv_label+^M^J);
  ttysw_output(tty1,'over: '+active_w^.over^.xv_label+^M^J);
  ttysw_output(tty1,'under:'+active_w^.under^.xv_label+^M^J);
  open_window(frame2);
  ttysw_output(tty1,'Window opened'^M^J);
  ttysw_output(tty1,'active:'+active_w^.xv_label+^M^J);
  ttysw_output(tty1,'over: '+active_w^.over^.xv_label+^M^J);
  ttysw_output(tty1,'under:'+active_w^.under^.xv_label+^M^J);
END;

{$F-}

BEGIN
  xv_init(0,0);
  frame2:=xv_create(frame);
  WITH frame2^ DO BEGIN
    xv_label:='Window 2';
    y:=163;
    dx:=290;
    dy:=117;
    adjust_exit:=FALSE {Only the ok button closes the window}
  END;
  bok:=xv_create(button);
  WITH bok^ DO BEGIN
    xv_label:='ok';
    notify_handler:=CloseWindow;
  END;
  bstate:=xv_create(button);
  WITH bstate^ DO BEGIN
    x:=30;
    xv_label:='state';
    notify_handler:=state;
  END;
  tty2:=xv_create(tty);
  tty2^.y:=15;
  frame1:=xv_create(frame);
  WITH frame1^ DO BEGIN
    xv_label:='Window 1';
    x:=1;
    y:=1;
    dx:=306;
    dy:=156;
  END;
  tty1:=xv_create(tty);
  WITH tty1^ DO BEGIN
    y:=45;
  END;
  bWindow1:=xv_create(button);
  WITH bWindow1^ DO BEGIN
    xv_label:='Open exclusive window';
    notify_handler:=OpenExclusive;
  END;
  bWindow2:=xv_create(button);
  WITH bWindow2^ DO BEGIN
    xv_label:='Open non exclusive window';
    notify_handler:=OpenNonExclusive;
    y:=15;
  END;
  bWindow:=xv_create(button);
  WITH bWindow^ DO BEGIN
    xv_label:='Open normal window';
    y:=30;
    notify_handler:=OpenWindow;
  END;
  xv_main_loop(frame1);
END.
