{
XView-PC demonstration:
Demonstration of how to work with several "canvas" objects in the same window.
The viewport must be set directly by any routine other than the "canvas"
"notify_handler", when drawing.
}

{Interface generated by X_MAKE}
{Version 1.1c - 29/07/92}
USES Graph,XView;

{Declaration of the interface objects}
VAR
  frame2,canvas2,canvas1:Xv_opaque;
  frame1,canvas5,canvas4,canvas3:Xv_opaque;

{$F+}

{Callback procedures}

PROCEDURE NotCanvas(obj:Xv_opaque);
BEGIN
  {Notify handler for canvas2}
  {Notify handler for canvas1}
  {Notify handler for canvas5}
  {Notify handler for canvas4}
  {Notify handler for canvas3}
  Line(0,0,obj^.dx,obj^.dy);
END;

PROCEDURE EvCanvas(obj:Xv_opaque);
VAR
  x1,y1:INTEGER;
BEGIN
  {Event handler for canvas2}
  {Event handler for canvas1}
  {Event handler for canvas5}
  {Event handler for canvas4}
  {Event handler for canvas3}
  IF ie_shiftcode=1 THEN BEGIN
    {Sets the viewport}
    x1:=active_w^.x+obj^.x+mrgx+1;
    y1:=active_w^.y+obj^.y+mrgy+1;
    SetViewPort(x1,y1,x1+obj^.dx-2,y1+obj^.dy-2,ClipOn);
    PutPixel(ie_locx,ie_locy,XorPut);
  END
END;

{$F-}

BEGIN
  {Inicialization}
  xv_init(0,0);
  {Menu creation}
  {Interface objects creation}
  frame2:=xv_create(frame);
  WITH frame2^ DO BEGIN
    xv_label:='frame 2';
    y:=161;
    dx:=319;
    dy:=159;
  END;
  canvas2:=xv_create(canvas);
  WITH canvas2^ DO BEGIN
    x:=156;
    notify_handler:=NotCanvas;
    event_handler:=EvCanvas;
  END;
  canvas1:=xv_create(canvas);
  WITH canvas1^ DO BEGIN
    can_xext:=FALSE; dx:=154;
    notify_handler:=NotCanvas;
    event_handler:=EvCanvas;
  END;
  frame1:=xv_create(frame);
  WITH frame1^ DO BEGIN
    xv_label:='frame 1';
    dx:=319;
    dy:=159;
  END;
  canvas5:=xv_create(canvas);
  WITH canvas5^ DO BEGIN
    x:=116;
    can_yext:=FALSE; dy:=65;
    notify_handler:=NotCanvas;
    event_handler:=EvCanvas;
  END;
  canvas4:=xv_create(canvas);
  WITH canvas4^ DO BEGIN
    y:=67;
    notify_handler:=NotCanvas;
    event_handler:=EvCanvas;
  END;
  canvas3:=xv_create(canvas);
  WITH canvas3^ DO BEGIN
    can_xext:=FALSE; dx:=114;
    can_yext:=FALSE; dy:=65;
    notify_handler:=NotCanvas;
    event_handler:=EvCanvas;
  END;
  xv_main_loop(frame1);
  {Exit}
END.
