//----------------------------------------------------------------------------
// Extended VBX Control, using Exceptions and Basic-like syntax
// Copyright Dieter Menne, Biomed Software, Tbingen, Germany
// Defines TVbxControlX, TVbxControlX::TXVbx
//----------------------------------------------------------------------------
#if !defined(__OWL_VBXCTLX_H)
#define __OWL_VBXCTLX_H

#if !defined(__OWL_VBXCTL_H)
  #include <owl\vbxctl.h>
#endif


class TVbxControlX : public TVbxControl
{
  // This is almost the same as TVbxControl, but the
  // property functions all return void and trigger
  // the exception TVbxControlX::TXVbx on errors returns
  // from the VBXControl
  public:
    TVbxControlX(TWindow*        parent,
                int             id,
                const char far* vbxName,
                const char far* vbxClass,
                const char far* title,
                int             x,
                int             y,
                int             w,
                int             h,
                long            initLen = 0,
                void far*       initData = 0,
                TModule*        module = 0):
      TVbxControl(parent,id,vbxName,vbxClass,title,x,y,w,h,initLen,initData,
                  module) {};

    TVbxControlX(TWindow* parent, int resourceId, TModule* module = 0):
      TVbxControl(parent,resourceId,module) {}

    class TXVbx // Exception triggered on error
    {
      public:
        int PropIndex;
        TXVbx(int index) : PropIndex(index) {}
    };

    void GetPropX(int propIndex, int& value)
       { if (!GetProp(propIndex,value)) throw TXVbx(propIndex);}
    void GetPropX(int propIndex, long& value)
       { if (!GetProp(propIndex,value)) throw TXVbx(propIndex);}
    void GetPropX(int propIndex, ENUM& value)
       { if (!GetProp(propIndex,value)) throw TXVbx(propIndex);}
    void GetPropX(int propIndex, HPIC& value)
       { if (!GetProp(propIndex,value)) throw TXVbx(propIndex);}
    void GetPropX(int propIndex, float& value)
       { if (!GetProp(propIndex,value)) throw TXVbx(propIndex);}
    void GetPropX(int propIndex, COLORREF& value)
       { if (!GetProp(propIndex,value)) throw TXVbx(propIndex);}

    void GetPropX(int propIndex, string& value)
       { if (!GetProp(propIndex,value)) throw TXVbx(propIndex);}


    void SetPropX(int propIndex, int value)
       { if (!SetProp(propIndex,value)) throw TXVbx(propIndex);}
    void SetPropX(int propIndex, long value)
       { if (!SetProp(propIndex,value)) throw TXVbx(propIndex);}
    void SetPropX(int propIndex, ENUM value)
       { if (!SetProp(propIndex,value)) throw TXVbx(propIndex);}
    void SetPropX(int propIndex, HPIC value)
       { if (!SetProp(propIndex,value)) throw TXVbx(propIndex);}
    void SetPropX(int propIndex, float value)
       { if (!SetProp(propIndex,value)) throw TXVbx(propIndex);}
    void SetPropX(int propIndex, COLORREF value)
       { if (!SetProp(propIndex,value)) throw TXVbx(propIndex);}
    void SetPropX(int propIndex, string & value)
       { if (!SetProp(propIndex,value)) throw TXVbx(propIndex);}
    void SetPropX(int propIndex, const char far* value)
       { if (!SetProp(propIndex,value)) throw TXVbx(propIndex);}

};

/* I would have preferred to use a template here, but I could not
   get the offsetof-trick to access the parent's class "this"
   to work with the template. Any good idea to replace this macros
   are appreciated. But make sure you proposed solution does not
   need a pointer to the parent class in each property class.

   Acknowledgment: the offsetof trick is stolen from MS's OLE
   implementation in MFC. I hope they have no patent on this one...
*/
#define VBX_PROPERTY( vbx, prop, typ, index)\
class VBX_PCLASS_##prop {\
  private: \
    vbx *pThis(){return((vbx*)((char*)(this)-offsetof(vbx,prop)));}\
  public:\
    VBX_PCLASS_##prop() {}\
    VBX_PCLASS_##prop &operator=(const typ &v) { \
      pThis()->SetPropX(index,v);  return *this;  }\
    operator typ() {typ v; pThis()->GetPropX(index,v); return v;}\
};\
VBX_PCLASS_##prop prop

#define VBX_STR_PROPERTY( vbx, prop, index)\
class VBX_STRP_CLASS_##prop {\
  private: \
    vbx *pThis(){return((vbx*)((char*)(this)-offsetof(vbx,prop)));}\
  public:\
    VBX_STRP_CLASS_##prop() {}\
    VBX_STRP_CLASS_##prop &operator=(string &v)\
      {pThis()->SetPropX(index,v); return *this;}\
    VBX_STRP_CLASS_##prop &operator=(const char far *v)\
      {pThis()->SetPropX(index,v); return *this;}\
    operator string() {string v; pThis()->GetPropX(index,v); return v;}\
};\
VBX_STRP_CLASS_##prop prop



#pragma warn -inl

#endif // vbxctlx.h

