/* SWTEST.CPP
  Example to use the extended VBX Control syntax with
  SWITCH.VBX, a little control from BC4\EXAMPLES\OWL\OWLAPI\vbxctl.

  To use: Generate a new Windows project SWTEST.IDE, adding
  files SWTEST.CPP, SWTEST.RC, SWTEST.DEF and Borland's
  BIVBX.LIB.
  The files SWITCH.H and VBXCTLX.H must be in your project directory.

  Copy BC4\EXAMPLES\OWL\OWLAPI\switch.vbx to \Windows\system or
  to your project directory.

  Run the project.

  To (re)generate your own SWITCH.H header file:
    Run Borland's VBXGEN on SWITCH.VBX, generating SWITCH.H
    Run "XVBXGEN switch.h" from the DOS prompt; on success,
    SWITCH.H is replaced by a header file for use with extended
    syntax.
    Rebuild the project.

    If it works or does not work, tell me via CIS EMail 100016,2125
*/

#include <owl\applicat.h>
#include <owl\framewin.h>
#include <owl\dialog.h>
#include "swtest.rh"

#pragma hdrstop

// Here comes the important include file; use the supplied
// switch.h for first test, then regenerate it.
#define USE_EVENTS
#include "switch.h"
class TSwitchDialog: public TDialog,public TVbxEventHandler
{
  private:
    TVbxBISWITCH* Switch;

  public:
    TSwitchDialog(): TDialog(0,DIALOG_1),TWindow(0,"")
    {
      Switch = new TVbxBISWITCH(this, IDC_BISWITCH);
      // Don't do things like Switch->On=0 here;
      // the Control has no valid Window handle yet.
      // Wait till SetupWindow
    }

    void SetupWindow()
    {
      TDialog::SetupWindow();
      // Here is the first place to play with the switch!
      // Using pointer syntax
      Switch->On=1;
    }

    void HandlePlay() // Pressed the "Play" button
    {
      try  // Move and change something
      {
        // If you want to be fancy, use reference syntax.
        // It looks so nice...
        TVbxBISWITCH & RSwitch=*Switch;
        RSwitch.On= !RSwitch.On;
        RSwitch.BorderStyle=RSwitch.BorderStyle? 0: 1;
        RSwitch.TextPosition=(RSwitch.TextPosition+1)%4;
        RSwitch.Caption=RSwitch.Caption+".";
        RSwitch.Left=RSwitch.Left+10;
        RSwitch.Width=RSwitch.Width+4;
        RSwitch.Top=RSwitch.Top+10;
        RSwitch.Refresh();
      }
      catch (TVbxControlX::TXVbx & x)
      {
        char Mess[80]={""};// avoid a strange "possible use" warning
        wsprintf(Mess,"VBX Exception for property%i",x.PropIndex);
        MessageBox(Mess);
      }
    }
    void HandleException() // Pressed the "Exception" button
    {
      try
      {
        //  Setting CtlName triggers an exception
        string  Name;
        Switch->CtlName="Biermann";
      }
      catch (TVbxControlX::TXVbx & x)
      {
        char Mess[80]={""};
        wsprintf(Mess,"Evoked VBX Exception in property %i",x.PropIndex);
        MessageBox(Mess);
      }
    }
  DECLARE_RESPONSE_TABLE(TSwitchDialog);
};

DEFINE_RESPONSE_TABLE2(TSwitchDialog, TDialog, TVbxEventHandler)
  EV_COMMAND(IDHELP,HandlePlay),
  EV_COMMAND(ID_EXCEPTION,HandleException),
END_RESPONSE_TABLE;


class TSwitchApp: public TApplication
{
  public:
    TSwitchApp(): TApplication("Switch Test"){  EnableCtl3d();}
    void InitMainWindow()
    {
      SetMainWindow (new TFrameWindow(0,"Switch Test",
                     new TSwitchDialog(), TRUE));
    }
};

int OwlMain(int , char**)
{
  TBIVbxLibrary vbxlib;
  return TSwitchApp().Run();
}

