/********************************************************************/
/*                                                                  */
/*                              XTAB.C                              */
/*                  Written for: Turbo C v 1.0                      */
/*                                                                  */
/*   By: Mark Thomas                                   8/15/87      */
/*                                                                  */
/********************************************************************/


#include "stdio.h"
#include "fcntl.h"
#include "io.h"
#include "dos.h"
#include "dir.h"
#include "string.h"
#include "errno.h"



#define TABCHAR 9
#define DEFTAB 8

#define WORK_FILESPEC "XTAB.$$$"
#define BACKUP_EXT "TBU"



#define MAXFILES 2000
static char du_names[MAXFILES][13];
static struct ffblk du_ffblk;
static char du_path[128];
static int du_pathlen;

char *du_ffirst ();
char *du_fnext ();


/*#page**********************************************************************/

main (argc, argv)
int argc;
char *argv[];
  {
  register int x;
  static char fn_file[128];
  static char fn_work[128];
  static int numfiles;
  int tabvalue = DEFTAB;
  int buflag = 1;


/***** Check for proper number of command line arguments *****/

  if (argc < 2 || argc > 4)
    help ();


/***** Get optional parameters (tab length and/or backup flag) *****/

  if (argc > 2)
    for (x=2; x<argc; x++)
      if (*argv[x] == '-')
        if (toupper (*(argv[x]+1)) != 'B')
          help ();
        else
          buflag = 0;
      else
        sscanf (argv[x], "%d", &tabvalue);

  strupr (argv[1]);
  printf ("Tab length: %d,  Backups: %s\n\n", tabvalue, buflag ? "ON" : "OFF");


/***** Find all matching files *****/
  if ( (numfiles = du_ffiles (argv[1], 0)) == 0)
    {
    printf ("No files found for \"%s\"\n", argv[1]);
    exit (1);
    }


/***** Convert tabs for each file *****/
  while (numfiles--)
    {
    if (! du_isext (du_names[numfiles], BACKUP_EXT))
      {
      strcpy (fn_file, du_path);
      strcpy (fn_file+du_pathlen, du_names[numfiles]);
      strncpy (fn_work, fn_file, 128);
      du_chext (fn_work, BACKUP_EXT);
      printf ("%12s: ", du_names[numfiles]);
      cvttab (fn_file, fn_work, tabvalue, buflag);
      }
    }
  unlink (WORK_FILESPEC);
  }



/*#page**********************************************************************/

cvttab (fs_input, fs_backup, tablen, bu)
char *fs_input;      /* Name of file to convert */
char *fs_backup;     /* Name for backup file */
int tablen;          /* Tab length */
int bu;              /* Non-Zero to keep backup file after done */
  {
  register int curcol;
  register int c;
  static int x;
  static FILE *infile;
  static FILE *outfile;



/*****  Open input file  *****/
  if ((infile = fopen(fs_input, "rb")) == NULL )
    {
    printf ("Can't find file\n");
    return;
    }

/*****  Open output (work) file  *****/
  if ((outfile = fopen (WORK_FILESPEC, "wb")) == NULL )
    {
    printf ("Can't create work file");
    fatal ();
    }

/*****  Convert tabs to spaces  *****/
  printf ("Expanding tabs ... ");
  curcol = 0;
  while (((c = getc (infile)) != EOF) && (c != 0x1a))
    {
    switch (c)
      {
      case 0x0d:
      case 0x0a:
        if (putc (c, outfile) != c)
          {
          printf ("Out of disk space");
          fclose (outfile);
          fatal ();
          }
        curcol = 0;
        break;
      case TABCHAR:
        x = tablen - (curcol % tablen);
        curcol += x;
        while (x-- > 0)
        if (putc (' ', outfile) != ' ')
          {
          printf ("Out of disk space");
          fclose (outfile);
          fatal ();
          }
        break;
      default:
        if (putc (c, outfile) != c)
          {
          printf ("Out of disk space");
          fclose (outfile);
          fatal ();
          }
        curcol++;
        break;
      }
    }

/*#page**********************************************************************/

/*****  Close both files  *****/
  fclose (infile);
  fclose (outfile);


if (bu)             /* If backups enabled ... */
  {
  /*****  Delete old backup file  *****/
  if (unlink (fs_backup))
    if (errno != ENOENT)
      {
      printf ("Can't delete old backup ... file not converted\n");
      return;
      }

  /*****  Rename input filespec to backup filespec *****/
  if (rename (fs_input, fs_backup))
    {
    printf ("Strange DOS error #1");
    abort ();
    }
  }

else                 /* If backups NOT enabled ... */
  {
  /*****  Delete old (input) file  ******/
  if (!bu && unlink (fs_input))
    {
    printf ("Can't delete old file - File not converted\n");
    return;
    }
  }


/*****  Rename work filespec to original (input) filespec *****/
  if (rename (WORK_FILESPEC, fs_input))
    {
    printf ("Strange DOS error #2 - File not converted\n");
    return;
    }

  printf (" DONE\n");
  }




/*#page**********************************************************************/

du_parspath (pathbuf, instring)
char *pathbuf;
char *instring;
  {
  int len = strlen (instring);
  register int x;

  for (x=len-1; x>=0; x--)
    if (instring[x] == ':' || instring[x] == '\\')
      break;

  if (x < 0)
    pathbuf[0] = '\0';
  else
    {
    strncpy (pathbuf, instring, x+1);
    pathbuf [x+1] = '\0';
    }
  }



du_chext (pathname, newext)
char *pathname;
char *newext;
  {
  while (*pathname != '.' && *pathname != '\0')
    pathname++;
  *pathname++ = '.';
  strcpy (pathname, newext);
  }




int du_isext (pathname, checkext)
char *pathname;
char *checkext;
  {
  char *work;

  if ((work = strchr (pathname, '.')) == NULL)
    return (0);
  return (!strcmp (work+1, checkext));
  }


/*#page**********************************************************************/

int du_ffiles (pathname, fileattr)
char *pathname;
int fileattr;
  {
  int retval;
  register int du_numfiles = 0;

  du_parspath (du_path, pathname);
  du_pathlen = strlen (du_path);


  retval = findfirst (pathname, &du_ffblk, fileattr);

  while (retval == 0)
    {
    strcpy (du_names[du_numfiles], du_ffblk.ff_name);
    if (du_numfiles++ >= MAXFILES)
      {
      printf ("Sorry, can't handle more than %d files", MAXFILES);
      fatal ();
      }
    retval = findnext (&du_ffblk);
    }
  return (du_numfiles);
  }


/*#page**********************************************************************/

fatal ()
  {
  printf ("\n\n Program aborting ...");
  unlink (WORK_FILESPEC);
  exit (1);
  }




help ()
  {
  register int x;
  static char *helpmess[] =
    {
    "ͻ",
    "          Command Line:  XTAB AMBIG_NAME [TABSTOP] [-B]             ",
    "ͼ\n",
    "  XTAB expands tab characters to spaces as determined by TABSTOP. If",
    "  TABSTOP is not specified, a default value of eight is used. One or",
    "  more files can be specified using a valid DOS ambiguous filename.\n",
    " Original  file  backups are kept with filename extensions of:  \"TBU\".",
    " If the optional switch -B is specified, backup files will not be made.",
    "\n                  By: Mark Thomas ---- 8/15/87"
    };

  for (x=0; x < (sizeof(helpmess) / sizeof(char *)) ;x++)
    fprintf (stderr, "%s\n", helpmess[x]);

  exit (1);
  }

