/*****************************************************************************\

               TriHex XMS Extended Memory ToolBox - Version 2.00

                  Copyright (c) 1991 TriHex Universal Systems.
                              All rights reserved.


        Class       : XMS Extended Memory Managment (Version 2.00)

        Author      : Fernando Manuel Incio Carreiro

        File        : XMS_200.H (for XMS_200.C)

        Description : Header file for XMS Extended Memory Toolbox.

        Portability : ANSI Standard C

        Dependency  : Borland Turbo C++ (Version 1.00)
                      Borland Turbo Assembler (Version 2.0)
                      XMS Memory Handler (Version 2.00 or later)
                      IBM PC-DOS Version 3.3 or later
                      IBM PC/XT/AT Hardware Environment

\*****************************************************************************/

/* Check if Header file has been included allready */

   #ifndef __XMS_200

      #define __XMS_200

      /* Include Files */

         #include <TypeDefs.H> // Special Type Definitions


      /* Define XMS Data Types */

         typedef uword  XMS_Handle;  // XMS Handle
         typedef ubyte  XMS_Status;  // XMS Error Status
         typedef udword XMS_Address; // 32-Bit Linear Address
         typedef uword  XMS_UMB_Seg; // XMS Upper Memory Block Segment

         typedef
           union
             {
               udword    Offset;  // 32-bit Offset into XMS Block
               void far *Pointer; // Seg:Ofs Pointer into Standard Memory
             }
           XMS_Pointer;

         typedef
           struct
             {
               uword       Handle;   // XMS Handle / 0000h - Standard Memory
               XMS_Pointer Position; // Offset or Pointer
             }
           XMS_Position;

         typedef
           struct
             {
               udword       Size;        // Number of bytes to transfer
               XMS_Position Source,      // Source Position
                            Destination; // Destination Position
             }
           XMS_Transfer; // XMS Copy Transfer Information Structure



      /* Define XMS Constants */

         #define XMS_All_Memory        0xFFFF // Request all memory


      /* Define XMS Version 2.00 Status & Errors */

         #define XMS_Ok                0x00 // Succesful

         #define XMS_Not_Implemented   0x80 // Function not implemented
         #define XMS_VDisk_Detected    0x81 // VDisk was detected
         #define XMS_A20_Error         0x82 // An A20 error occurred
         #define XMS_General_Error     0x8E // A general driver error
         #define XMS_Unrecoverable     0x8F // Unrecoverable driver error
         #define XMS_No_HMA            0x90 // HMA does not exist
         #define XMS_HMA_In_Use        0x91 // HMA is already in use
         #define XMS_DX_Less_HMAMin    0x92 // DX is less than /HMAMin=
         #define XMS_HMA_Not_Alloc     0x93 // HMA is not allocated
         #define XMS_A20_Active        0x94 // A20 line is still enabled
         #define XMS_Memory_Allocated  0xA0 // All Extended memory allocated
         #define XMS_Handles_Allocated 0xA1 // All Handles allocated
         #define XMS_Invalid_Handle    0xA2 // Invalid Handle
         #define XMS_Src_Hdl_Invalid   0xA3 // Source      Handle Invalid
         #define XMS_Src_Ofs_Invalid   0xA4 // Source      Offset Invalid
         #define XMS_Dst_Hdl_Invalid   0xA5 // Destination Handle Invalid
         #define XMS_Dst_Ofs_Invalid   0xA6 // Destination Offset Invalid
         #define XMS_Length_Invalid    0xA7 // Length Invalid
         #define XMS_Overlap_Invalid   0xA8 // Move has an Invalid Overlap
         #define XMS_Parity_Error      0xA9 // Parity Error Occured
         #define XMS_Block_Not_Locked  0xAA // Block is not locked
         #define XMS_Block_Locked      0xAB // Block is Locked
         #define XMS_Lock_Overflow     0xAC // Block Lock count Overflowed
         #define XMS_Lock_Failed       0xAD // Block Lock Failed
         #define XMS_Only_Smaller_UMB  0xB0 // Only smaller UMB available
         #define XMS_No_UMB_Available  0xB1 // No UMB Available
         #define XMS_UMB_Invalid       0xB2 // UMB Segment number invalid


      /* Define XMS A20 Line Types */

         #define XMS_A20_Global        0x03 // A20 Global Enable/Disable
         #define XMS_A20_Local         0x05 // A20 Local  Enable/Disable


      /* Define XMS Access Functions */

         /* Check if XMS Exists */

            boolean pascal _XMS_Check(void);

              // Must be called, before using other functions
              // Returns TRUE if XMS exists, FALSE otherwise


         /* Get XMS Version */

            udword pascal _XMS_Version(void);

              // Returns Double Word, LSW = Revision(BCD), USW = Version(BCD)


         /* Check if HMA Exists */

            boolean pascal _XMS_Check_HMA(void);

              // Returns TRUE if HMA exists, FALSE otherwise


         /* Request HMA */

            XMS_Status pascal _XMS_Request_HMA(uword Size);

              // Size = XMS_All_Memory if Application Request
              // Returns the XMS Status


         /* Release HMA */

            XMS_Status pascal _XMS_Release_HMA(void);

              // Returns the XMS Status


         /* Enable/Disable A20 Line */

            XMS_Status pascal _XMS_A20_Line(ubyte Type, toggle State);

              // Type = XMS_Global or XMS_Local
              // State = ON or OFF
              // Returns the XMS Status


         /* Query State of A20 Line */

            XMS_Status pascal _XMS_A20_State(toggle *State);

              // Returns State = ON or OFF
              // Returns the XMS Status


         /* Query State of XMS Total & Largest Available Block Memory */

            XMS_Status pascal _XMS_Memory_State(uword *Total, uword *Largest);

              // Returns Total = Total Amount of Free XMS in KBytes
              // Returns Largets = Largest Free XMS Block in KBytes
              // Returns the XMS Status


         /* Allocate XMS Memory */

            XMS_Status pascal _XMS_Allocate(uword Size, XMS_Handle *Handle);

              // Size = Amount of XMS to Allocate in KBytes
              // Returns Handle = XMS Block Handle
              // Returns the XMS Status


         /* ReAllocate XMS Memory */

            XMS_Status pascal _XMS_ReAllocate(uword Size, XMS_Handle Handle);

              // Size   = Amount of XMS to ReAllocate in KBytes
              // Handle = XMS Block Handle to Adjust Size
              // Returns the XMS Status


         /* Release XMS Memory */

            XMS_Status pascal _XMS_Release(XMS_Handle Handle);

              // Handle = XMS Block Handle to Release
              // Returns the XMS Status


         /* Copy XMS Memory */

            XMS_Status pascal _XMS_Copy(XMS_Transfer *Copy_Info);

              // Copy_Info = XMS_Transfer Structure Information for Copy
              // Returns the XMS Status


         /* Lock XMS Memory */

            XMS_Status pascal _XMS_Lock
              (XMS_Handle Handle, XMS_Address *Address);

              // Handle = XMS Block Handle to Lock
              // Returns Address = 32-Bit Linear Address of Block
              // Returns the XMS Status


         /* UnLock XMS Memory */

            XMS_Status pascal _XMS_UnLock(XMS_Handle Handle);

              // Handle = XMS Block Handle to UnLock
              // Returns the XMS Status


         /* Get XMS Handle Information */

            XMS_Status pascal _XMS_Handle_Info
              ( XMS_Handle  Handle, uword *Size, ubyte *Lock_Count,
                                           ubyte *Available_Handles );

              // Handle = XMS Block Handle to get Information
              // Returns Size = Size of XMS Block in KBytes
              // Returns Lock_Count = Count of Locks on Handle
              // Returns Available_Handles = Number of Free Handles
              // Returns the XMS Status


         /* Request Upper Memory Block */

            XMS_Status pascal _XMS_Request_UMB
              (uword *Size, XMS_UMB_Seg *Segment);

              // Size = Size Required for UMB
              // Returns Size = Actual Largest Available Size
              // Returns Segment = Segment of UMB or 0 if Error
              // Returns the XMS Status


         /* Release Upper Memory Block */

            XMS_Status pascal _XMS_Release_UMB(XMS_UMB_Seg Segment);

              // Segment = Segment of UMB
              // Returns the XMS Status


   #endif


/*****************************************************************************/