/*****************************************************************************\

               TriHex XMS Extended Memory ToolBox - Version 2.00

                  Copyright (c) 1991 TriHex Universal Systems.
                              All rights reserved.


        Class       : XMS Extended Memory Managment (Version 2.00)

        Author      : Fernando Manuel Incio Carreiro

        File        : XMS_200.C

        Description : Definition of Classes to access XMS.

        Portability : ANSI Standard C

        Dependency  : Borland Turbo C++ (Version 1.00)
                      Borland Turbo Assembler (Version 2.0)
                      XMS Memory Handler (Version 2.00 or later)
                      IBM PC-DOS Version 3.3 or later
                      IBM PC/XT/AT Hardware Environment

            Borland Turbo C++ (Version 1.00) :

                Compiler Options :

                    Code Generation :

                        Model : Any
                          Code supports all models
                          (Tiny/Small/Medium/Compact/Large/Huge)

                        Overlay Support : Yes/No
                          `Yes' for generating safe code for Overlays.

                        Word Alignment : Yes/No
                          `Yes' for faster code, `No' for smaller code.

                        Duplicate Strings Merged : Yes
                          Produces faster, smaller code.

                        Unsigned Characters : Yes/No
                          `Yes' for preffered use of unsigned chars.

                        Standard Stack Frame : Yes/No
                          `Yes' for Debugging,
                          `No' for preffered faster, smaller code.

                        Test Stack Overflow : No
                          `No' because code use the "interrupt" keyword.

                        Floating Point : None
                          `None' because no floating point is used.

                        Instruction Set : Any
                          `8086/8088 / 80186 / 80286' can be used.

                        Calling Convention : C/Pascal
                          `Pascal' for preffered faster, smaller code.

                        Generate Underbars : Yes
                          `Yes' uses Standard Library calls.

                        Line Numbers Debug Info : Yes/No
                          `Yes' for Debbuging,
                          `No' for preffered smaller code.

                        Debug Info in OBJs : Yes/No
                          `Yes' for Debbuging,
                          `No' for preffered smaller code.

                        Treat enums as ints : Yes/No
                          `Yes' for standard code,
                          `No' for preffered faster, smaller code.

                        Fast Floating Point : Yes/No
                          No floating point used.

                        Assume SS not equal to DS : Yes/No
                          Dependant on model.


                    C++ Options :

                        C++ Virtual Tables : Smart
                          `Smart' for faster/smaller code.

                        Out-of-line Inline Functions : Yes/No
                          `Yes' for Debbuging only, else 'No'.


                    Optimizations :

                        Register Optimization : No
                          `No' uses "interrupt" keyword.

                        Jump Optimization : Yes/No
                          `Yes' for preffered faster code.

                        Register Variables : None
                          `None' uses "interrupt" keyword.

                        Optimize for : Size/Speed
                          'Speed' for faster code,
                          'Size' for smaller code.


                    Source :

                        Nested Comments : Yes
                          `Yes' uses nested comments.

                        Keywords : Turbo C++
                          `Turbo C++' for C++ and other dependant keywords.


                    Messages :

                        NB! All Warnings & Error Detection On


                    Segment Names :

                       All default Segment names.


                    Linker : (Linkage Options to be set by main Project)

                       Warn duplicate Symbols : Yes

                       Case Sensitive Link    : Yes

                       "No Stack" Warning     : Yes
                         (Unless Tiny Model)


\*****************************************************************************/

/* Define Inline Assembly */

   #pragma inline


/* Check for C compilation and not C++ */

   #ifdef __cplusplus
      #error "Compile this file in C only!"
   #endif


/* Include Files */

   #include <XMS_200.H>  // Header file for this file


/* Define Constants */

   #define Multiplex_Interrupt 0x2F // XMS Interrupt (Multiplex)
   #define XMS_ID              0x80 // XMS ID Byte


/* Define XMS Function Codes */

   #define XMS_Install_Check    0x4300 // XMS Instalation Check
   #define XMS_Driver_Address   0x4310 // XMS Get Driver Address


/* Define XMS Version 2.00 Sub-Function Codes */

   #define XMS_Version          0x00 // Get XMS Version Number
   #define XMS_Request_HMA      0x01 // Request High Memory Area
   #define XMS_Release_HMA      0x02 // Release High Memory Area
   #define XMS_Glb_Ena_A20      0x03 // Global Enable  A20 for HMA
   #define XMS_Glb_Dis_A20      0x04 // Global Disable A20
   #define XMS_Lcl_Ena_A20      0x05 // Local  Enable  A20 for direct
   #define XMS_Lcl_Dis_A20      0x06 // Local  Disable A20
   #define XMS_Query_State_A20  0x07 // Query State of A20
   #define XMS_Query_Free_Mem   0x08 // Query free XMS Memory (not HMA)
   #define XMS_Allocate_Mem     0x09 // Allocate   XMS Memory Block
   #define XMS_Release_Mem      0x0A // Release    XMS Memory Block
   #define XMS_Move_Mem         0x0B // Move/Copy  XMS Memory Block
   #define XMS_Lock_Mem         0x0C //   Lock     XMS Memory Block
   #define XMS_UnLock_Mem       0x0D // UnLock     XMS Memory Block
   #define XMS_Get_Handle_Info  0x0E // Get Handle Information
   #define XMS_ReAllocate_Mem   0x0F // ReAllocate XMS Memory Block
   #define XMS_Request_UMB      0x10 // Request Upper Memory Block
   #define XMS_Release_UMB      0x11 // Release Upper Memory Block


/* Define Static Variables */

   static void (far *_XMS_Driver)(void) = NULL; // Pointer to XMS Driver


/* Define Functions */

   #pragma warn -rvl // All Functions returns values in Assemler

   /* Check if XMS Exists (It will also set the XMS Driver pointer) */

      boolean pascal _XMS_Check(void)
        {
               asm Mov AX,XMS_Install_Check
               asm INT Multiplex_Interrupt
               asm Sub DX,DX
               asm Mov ES,DX
               asm Cmp AL,XMS_ID
               asm Mov AL,0
               asm JNE Short XE0

               asm Mov AX,XMS_Driver_Address
               asm INT Multiplex_Interrupt
               asm Mov DX,BX
               asm Sub AL,AL
               asm Not AL

          XE0: asm Mov BX, Offset _XMS_Driver
               asm Mov [BX]  ,DX
               asm Mov [BX+2],ES
        }


   /* Get XMS Version (LSW = Revision, USW = Version) */

      udword pascal _XMS_Version(void)
        {
          asm Mov AH,XMS_Version
          asm Call DWord Ptr [Offset _XMS_Driver]
          asm Mov DX,AX
          asm Mov AX,BX
        }


   /* Check if HMA Exists */

      boolean pascal _XMS_Check_HMA(void)
        {
          asm Mov  AH,XMS_Version
          asm Call DWord Ptr [Offset _XMS_Driver]
          asm Mov  AL,DL
          asm Neg  AL
        }


   /* Request HMA */

      XMS_Status pascal _XMS_Request_HMA(uword Size)
        {
               asm Mov  AH,XMS_Request_HMA
               asm Mov  DX,Size
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JZ   Short RQH
               asm Mov  AL,BL

          RQH: ;
        }


   /* Release HMA */

      XMS_Status pascal _XMS_Release_HMA(void)
        {
               asm Mov  AH,XMS_Release_HMA
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JZ   Short RLH
               asm Mov  AL,BL

          RLH: ;
        }


   /* Enable/Disable A20 Line */

      #pragma warn -rvl

      XMS_Status pascal _XMS_A20_Line(ubyte Type, toggle State)
        {
               asm Mov  AH,State
               asm Inc  AH
               asm Add  AH,Type
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JZ   Short A20
               asm Mov  AL,BL

          A20: ;
        }


   /* Query State of A20 Line */

      XMS_Status pascal _XMS_A20_State(toggle *State)
        {
          asm Mov  AH,XMS_Query_State_A20
          asm Call DWord Ptr [Offset _XMS_Driver]
          asm Mov  AH,AL
          asm Neg  AH
          asm Mov  AL,BL

          *State = _AH;
        }


   /* Query State of XMS Total & Largest Available Block Memory */

      XMS_Status pascal _XMS_Memory_State(uword *Total, uword *Largest)
        {
          asm Mov  AH,XMS_Query_Free_Mem
          asm Call DWord Ptr [Offset _XMS_Driver]
          asm Mov  CL,BL

          *Total   = _DX;
          *Largest = _AX;

          asm Mov  AL,CL
        }


   /* Allocate XMS Memory */

      XMS_Status pascal _XMS_Allocate(uword Size, XMS_Handle *Handle)
        {
               asm Mov  DX,Size;
               asm Mov  AH,XMS_Allocate_Mem
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JZ   Short XAL
               asm Mov  AL,BL
               asm Sub  DX,DX
               asm Dec  DX

          XAL: *Handle = _DX;
        }


   /* ReAllocate XMS Memory */

      XMS_Status pascal _XMS_ReAllocate(uword Size, XMS_Handle Handle)
        {
               asm Mov  BX,Size;
               asm Mov  DX,Handle;
               asm Mov  AH,XMS_ReAllocate_Mem
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JZ   Short XRA
               asm Mov  AL,BL

          XRA: ;
        }


   /* Release XMS Memory */

      XMS_Status pascal _XMS_Release(XMS_Handle Handle)
        {
               asm Mov  DX,Handle;
               asm Mov  AH,XMS_Release_Mem
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JZ   Short XRL
               asm Mov  AL,BL

          XRL: ;
        }


   /* Copy XMS Memory */

      XMS_Status pascal _XMS_Copy(XMS_Transfer *Copy_Info)
        {
          #if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
             asm Mov SI,Copy_Info
          #else
             #if defined(__LARGE__)
                asm Push DS
             #endif

             asm LDS SI,Copy_Info
          #endif

               asm Mov  AH,XMS_Move_Mem
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JZ   Short XMV
               asm Mov  AL,BL

          XMV: ;
               #if defined(__LARGE__)
                  asm Pop  DS
               #endif
        }


   /* Lock XMS Memory */

      XMS_Status pascal _XMS_Lock(XMS_Handle Handle, XMS_Address *Address)
        {
               asm Mov  DX,Handle
               asm Mov  AH,XMS_Lock_Mem
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JNZ  Short XLK
               asm Mov  CX,BX

               #if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
                  asm Mov BX,Word Ptr Address
                  asm Mov Word Ptr [BX  ],CX
                  asm Mov Word Ptr [BX+2],DX
               #else
                  asm LES BX,DWord Ptr Address
                  asm Mov Word Ptr ES:[BX  ],CX
                  asm Mov Word Ptr ES:[BX+2],DX
               #endif
               asm Mov  BL,AL

          XLK: asm Mov  AL,BL
        }


   /* UnLock XMS Memory */

      #pragma warn -rvl

      XMS_Status pascal _XMS_UnLock(XMS_Handle Handle)
        {
               asm Mov  DX,Handle
               asm Mov  AH,XMS_UnLock_Mem
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JZ   Short XUL
               asm Mov  AL,BL

          XUL: ;
        }


   /* Get XMS Handle Information */

      #pragma warn -rvl

      XMS_Status pascal _XMS_Handle_Info
        ( XMS_Handle  Handle, uword *Size, ubyte *Lock_Count,
                                           ubyte *Available_Handles )
        {
               asm Mov  DX,Handle
               asm Mov  AH,XMS_Get_Handle_Info
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JNZ  Short XHI
               asm Mov  CX,BX

               *Size              = _DX;
               *Lock_Count        = _CH;
               *Available_Handles = _CL;

               asm Mov  BL,AL

          XHI: asm Mov  AL,BL
        }


   /* Request Upper Memory Block */

      XMS_Status pascal _XMS_Request_UMB(uword *Size, XMS_UMB_Seg *Segment)
        {
               _DX = *Size;

               asm Mov  AH,XMS_Request_UMB
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Mov  CX,BX
               asm Dec  AL
               asm JZ   Short XQU
               asm Mov  AL,BL
               asm Sub  CX,CX

          XQU: *Size    = _DX;
               *Segment = _CX;
        }


   /* Release Upper Memory Block */

      XMS_Status pascal _XMS_Release_UMB(XMS_UMB_Seg Segment)
        {
               asm Mov  DX,Segment;
               asm Mov  AH,XMS_Release_UMB
               asm Call DWord Ptr [Offset _XMS_Driver]
               asm Dec  AL
               asm JZ   Short XLU
               asm Mov  AL,BL

          XLU: ;
        }


   #pragma warn +rvl // No more functions with inline returns



/*****************************************************************************/