/*  Copyright 1990,1991 by Michael Graff.        USE AT YOUR OWN RISK       */
/*              See end of this file for more information.                  */
/*                                                                          */
/*  Version 1.2, 08-Mar-91                                                  */


#ifndef __LARGE__
    #error Hey!  You gotta use the LARGE memory model for this!
    /* well, I haven't tried others yet.  They SHOULD work, other than HUGE */
#endif

/* One thing for sure... */
#ifdef __HUGE__
    #error I KNOW the HUGE memory model will NOT work with XMSLIB AT ALL!
#endif

#include <dos.h>

void far *HMAAddr = MK_FP(0xffff, 0x0010);
    /*  Area of the HMA.  Can be used for data storage and code.            */

struct EMMMoveStruct {
    unsigned long int   Length;
    unsigned int        SourceHandle;
    unsigned long int   SourceOffset;
    unsigned int        DestHandle;
    unsigned long int   DestOffset;
};  /*  Needed for the 640k to extended memory move routines                */

extern unsigned int XMS_Setup(void);    /* MUST BE CALLED PRIOR TO OTHER    */
                                        /* XMS_ ROUTINES!                   */

extern unsigned char far XMS_FreeMem(   /* returns free and total extended  */
         unsigned int far *freemem,     /* free extended memory in K        */
         unsigned int far *totmem);     /* total extended memory in K       */

extern unsigned char far XMS_Version(   /* Returns version information      */
         unsigned int far *version,     /* BCD protocol version (2.0)       */
         unsigned int far *internal,    /* BCD internal version number      */
         unsigned int far *HMA);        /* is the HMA free?                 */

extern unsigned char far XMS_RequestHMA(    /* Try to allocate HMA          */
         unsigned int size);    /* amount you'll be using in K.             */
                                /*  Applications should use 0xffff to       */
                                /*  allocate all 64k                        */

extern unsigned char far XMS_ReleaseHMA(void);  /* give up the HMA          */

extern unsigned char far XMS_GlobalEnableA20(void);  /* when the A20 line   */
extern unsigned char far XMS_GlobalDisableA20(void); /* is enabled, the HMA */
extern unsigned char far XMS_LocalEnableA20(void);   /* can be accessed.    */
extern unsigned char far XMS_LocalDisableA20(void);

extern unsigned char far XMS_QueryA20(  /* Find out if A20 is enabled       */
         unsigned int far *state);

extern unsigned char far XMS_AllocEMB(  /* Allocate extended momory         */
         unsigned int size,         /* size in K needed                     */
         unsigned int far *handle); /* handle for this EMB                  */

extern unsigned char far XMS_FreeEMB(   /* Release an EMB                   */
         unsigned int handle);      /* handle to release                    */

extern unsigned char far XMS_MoveEMB(       /* Move between real memory and */
         struct EMMMoveStruct far *MoveRec);/* extended memory.             */

extern unsigned char far XMS_LockEMB(   /* make sure a memory block doesn't */
         unsigned int handle,           /* move.                            */
         void far *address);    /* LINEAR memory address for this block     */

extern unsigned char far XMS_UnlockEMB( /* undo a lock                      */
         unsigned int handle);

extern unsigned char far XMS_GetEMBHandleInfoEMB(   /* info on a handle     */
         unsigned int handle,               /* handle info wanted on        */
         unsigned char far *LockCount,      /* number of locks enabled      */
         unsigned char far *EMBHandlesFree, /* total handles free in system */
         unsigned int far *length);         /* size of this handle in K     */

extern unsigned char far XMS_ReallocEMB(    /* Try to change the size of    */
         unsigned int handle,               /* this block.                  */
         unsigned int newsize);             /* new size in K                */

extern unsigned char far XMS_RequestUMB(    /* request UPPER MEMORY BLOCK   */
         unsigned int SizeWanded,           /* size in PARAGRAPHS needed    */
         unsigned int far *segaddr,         /* segment address of block     */
         unsigned int far *SizeUgot);       /* size of block you got        */

extern unsigned char far XMS_ReleaseUMB(    /* Release UMB                  */
         unsigned int segaddr);

/*
------------------------------------------------------------------------------

If you find any errors, want to suggest improvements, or wish to use these
routines in a commercial application, please write me at the following
address:
            Michael Graff
            418 8th Avenue
            Grinnell, IA  50112

            E-MAIL:  explorer@iastate.edu, ga.mlg@isumvs.bitnet


You can use these routines for personal use without restrictions, other than
I would like to get a copy of YOUR source.

If you use these routines in a program and make a profit, please share some
small part of it with me!  (Donations of all kinds accepted, from very old
hardware to old compact disks to a copy of part or all of your source to
a thank you.)


--Michael


------------------------------------------------------------------------------


DEFINITIONS: ( stolen from the XMS 2.0 spec doc )
-------------------------------------------------

    Extended
    Memory      -   Memory in 80286 and 80386 based machines which is located
                    above the 1MB address boundary.

    High Memory
    Area (HMA)  -   The first 64K of extended memory.  The High Memory
            Area is unique because code can be executed in it while
            in real mode.  The HMA officially starts at FFFF:10h
            and ends at FFFF:FFFFh making it 64K-16 bytes in length.

    Upper Memory
    Blocks (UMBs)-  Blocks of memory available on some 80x86 based machines
                    which are located between DOS's 640K limit and the
                    1MB address boundary.  The number, size, and location
                    of these blocks vary widely depending upon the types
                    of hardware adapter cards installed in the machine.

    Extended Memory
    Blocks (EMBs)-  Blocks of extended memory located above the HMA which
                    can only be used for data storage.

    A20 Line    -   The 21st address line of 80x86 CPUs.  Enabling the A20
                    line allows access to the HMA.

HIGH MEMORY AREA RESTRICTIONS:
------------------------------

-   Far pointers to data located in the HMA cannot be passed to DOS.  DOS
    normalizes any pointer which is passed into it.  This will cause data
    addresses in the HMA to be invalidated.

-   Disk I/O directly into the HMA (via DOS, INT 13h, or otherwise) is not
    recommended.

-   Programs, especially drivers and TSRs, which use the HMA *MUST* use
    as much of it as possible.  If a driver or TSR is unable to use at
    least 90% of the available HMA (typically ~58K), they must provide
    a command line switch for overriding HMA usage.  This will allow
    the user to configure his machine for optimum use of the HMA.

-   Device drivers and TSRs cannot leave the A20 line permanently turned
    on.  Several applications rely on 1MB memory wrap and will overwrite the
    HMA if the A20 line is left enabled potentially causing a system crash.

-   Interrupt vectors must not point into the HMA.  This is a result of
    the previous restriction.  Note that interrupt vectors can point into
    any allocated upper memory blocks however.

ERROR CODE INDEX:   ( functions of type UNSIGNED CHAR return these codes )
--------------------------------------------------------------------------

    80h if the function is not implemented
    81h if a VDISK device is detected
    82h if an A20 error occurs
    8Eh if a general driver error occurs
    8Fh if an unrecoverable driver error occurs
    90h if the HMA does not exist
    91h if the HMA is already in use
    92h if DX is less than the /HMAMIN= parameter
    93h if the HMA is not allocated
    94h if the A20 line is still enabled
    A0h if all extended memory is allocated
    A1h if all available extended memory handles are in use
    A2h if the handle is invalid
    A3h if the SourceHandle is invalid
    A4h if the SourceOffset is invalid
    A5h if the DestHandle is invalid
    A6h if the DestOffset is invalid
    A7h if the Length is invalid
    A8h if the move has an invalid overlap
    A9h if a parity error occurs
    AAh if the block is not locked
    ABh if the block is locked
    ACh if the block's lock count overflows
    ADh if the lock fails
    B0h if a smaller UMB is available
    B1h if no UMBs are available
    B2h if the UMB segment number is invalid

*/
