//********************************
// Beginning of sample program to
// demonstrate the usage of
// extended memory using MS-XMS
//*******************************

#include <iostream.h>
#include <string.h>
#include "xms.h"

void print_msg( char *str );

// Print a message with little box lines on top and below
// very dumb, just used to make output look somewhat decent
void print_msg( char *str )
{
	int i, len;
	len = strlen( str );
	cout << "\n";
	for( i=0; i < len; i++ )
		cout << "-";
	cout << "\n" << str << "\n";
	for( i=0; i < len; i++ )
		cout << "-";
	cout << "\n";
}

int main( void )
{
	// To use the lib, declare an instance of the class
	XMSDriver XMM;
	long AMem;
	char Dude[ 10 ] = "Excellent";
	char ReadIn[ 22 ];
	char Block[22] = "Hi From Extended Mem!";

	// EMBHandles array will hold five EMB handles
	// i is a loop counter
	unsigned EMBHandles[ 5 ], i;

	// Determine the presence and availability of extended memory
	// (this section checks for 64K available)
	if( !XMM.Inst() || (XMM.GetAvail() < 64) )
	{
		cout << "Can't continue the XMS demo.\n";
		cout << "No extended memory manager installed, or\n";
		cout << "not enough extended memory available (needs 64k).\n";
		cout << "Add HIMEM.SYS to your config.sys file.\n";
		return( 1 );
	}
	
	print_msg( "Status Info" );
	AMem = XMM.GetAvail( );			// Get largest available block size

	// Note that, due to fragmentation, the largest free block is
	// not the same as the total sum of all free blocks...
	cout << "Available Extended Memory = ";
	cout << AMem << "\n";
	cout << "Total Available = " << XMM.GetTotal( ) << "\n";

	print_msg( "High Memory Area Functions" );
	cout << "Requesting HMA...\n";
	if( XMM.ReqHMA( ) )					// Request access to the HMA
		cout << "HMA gotten!\n";		// Returns 'True' on success
	else
		cout << "HMA gotten - NOT!\n";	// Unable to get HMA

	// To use the High Memory Area, you must enable the A20 line
	cout << "Enabling A20 line...\n";
	if( XMM.A20Enable( ) )
		cout << "A20 Enabled\n";
	else
		cout << "Error enabling A20\n";

	cout << "Checking current A20 state...\n";
	if( XMM.A20Query( ) )
	{
		cout << "A20 Enabled (disabling now).\n";
		XMM.A20Disable( );
	}
	else
		cout << "A20 Disabled.\n";

	if( XMM.HMAInst( ) )
	{
		// Note that the built in HMARead and HMAWrite routines
		// DO NOT enable the A20 line automatically
		XMM.A20Enable( );
		// Size, Index, Length, Data
		cout << "Writing " << Dude << " to HMA...\n";
		XMM.HMAWrite( 1, 5, 10, Dude );
		cout << "Attempting to read in...\n";
		XMM.HMARead( 1, 5, 10, ReadIn );
		cout << '\'' << ReadIn << "\' was read in from HMA.\n";
		XMM.A20Disable( );
		cout << "Freeing HMA...\n";
		XMM.RelHMA( );
	}
	
	print_msg( "Extended Memory Block Functions" );
	// Allocate five extended memory blocks
	for( i = 0; i < 4; i++ )
		EMBHandles[ i ] = XMM.EMBAlloc( (int) AMem / 5 );
	for( i = 0; i < 4; i++ )
		cout << "EMBHandle #" << i << " = " << EMBHandles[ i ] << "\n";
	// Free all but one extended memory block (EMBHandles[0])
	for( i = 1; i < 4; i++ )
		XMM.EMBFree( EMBHandles[ i ] );

	AMem = (long) AMem / 5 + 32;		// Reallocate 32k more
	if( XMM.EMBRealloc( EMBHandles[0], AMem + 32 ) )
		cout << "Reallocated to " << AMem + 32 << "k bytes...\n";
	else
		cout << "Cannot reallocate...\n";

	// Write to and read from extended memory
	cout << "Writing " << Block << " to extended memory...\n";
	XMM.EMBMoveToExt( EMBHandles[0], 24, Block, strlen( Block )+1 );
	XMM.EMBMoveToCon( ReadIn, EMBHandles[0], 24, strlen( Block )+1 );

	cout << "Read in from EMB...-> " << ReadIn << '\n';
	
	cout << "Freeing block...\n";
	XMM.EMBFree( EMBHandles[0] );
}
// END XMSDEMO.CPP
