// Microsoft eXtended Memory Specification
// C++ Interface Library Header File
// by Richard Vuduc 
// Copyright 1990, Richard Vuduc

#ifndef _XMSMGR
#define _XMSMGR 1

// Types and constants
enum boolean { False, True };	// analogous to Pascal's boolean
const HMASeg = 0xFFFF;		// Last physical segment in real-mode
const HMAOff = 0xA;		// 16 bytes + HMASeg = The 1 MB boundary

#ifndef NULL
#define NULL 0
#endif

class XMSDriver;			// Incomplete declaration
#include "xmshndl.h"

// Extended Memory Block Move structure
struct XMSMoveBlock
{
	unsigned long Length;		// Length of move block, in bytes
	unsigned int  SrcHandle;		// Source Handle #; 0 = conventional Mem
	unsigned long SrcOffset;		// Offset of source handle or off,seg
	unsigned int  DestHandle;	// Destination handle
	unsigned long DestOffset;	// Destination offset
};

// XMSDriver class
// Handles allocation and deallocation of XMS blocks
class XMSDriver
{
	static long Avail;		// Extended Memory available to application
	static long Total;		// Total extended memory installed
	static boolean Installed;	// XMM installed?
	boolean InstHMA;		// XMM HMA available
	char far *HMAPtr;		// Pointer into High Memory Area
	XMSHandle *CurrHandle,   // Linked list - Current handle
			*First,		// First handle in linked list
			*Last;		// Last handle in linked list
public:
	XMSDriver( void );		// constructor
	~XMSDriver( void );		// destructor

	// ***************** High Memory Area management functions (1024K-1088K)
	boolean   ReqHMA( void );	// Allocate HMA
	void      RelHMA( void );	// Deallocate HMA
	void far *GetHMAPtr( void );	// Get a pointer to HMA
	boolean   A20Enable( void );	// Globally enable A20 line
	void      A20Disable( void );	// Globally disable A20 line
	boolean   A20LEnable( void );	// Locally enable the A20 line
	void      A20LDisable( void );	// Locally disable the A20 line
	boolean   A20Query( void );	// Query state of A20 line
	void far *HMAWrite( unsigned ItemSize, unsigned Index, unsigned Length,
					void far *Data );	// Write a block to high memory
		// Read from HMA
	void far *HMARead( unsigned ItemSize, unsigned Index, unsigned Length, 
					void far *Data );

	// **************** Extended Memory Block Functions... (1088K+)
	unsigned EMBAlloc( unsigned size );		// Allocate EMB
	void     EMBFree( unsigned handle );		// Free EMB
	long     EMBLock( unsigned handle );		// Lock EMB
	boolean  EMBUnlock( unsigned handle );		// Unlock EMB
	boolean  EMBMoveToExt( unsigned dhandle, unsigned doff, 
					   void far *p, long size );
	boolean  EMBMoveToCon( void far *p, unsigned shandle, unsigned soff,
					   long size );
	boolean  EMBExtToExt( unsigned dhandle, unsigned doff,
					  unsigned shandle, unsigned soff, long size );
	boolean  EMBRealloc( unsigned handle, unsigned size );	// Realloc block

	// **************** Upper Memory Block management routines (640K - 1024K)

	// **************** Miscellaneous Management routines
	long    GetAvail( void );	// Get available Extended Memory
	boolean Inst( void ) { return Installed; }	// XMS Installed?
	boolean HMAInst( void ) { return InstHMA; }	// HMA Installed?
	long    GetTotal( void ) { return Total; }

	// **************** XMS Hi-Level Memory Managment Routines
	XMSHandle *HndReqPtr( unsigned handle );
	void       HndRelPtr( unsigned handle );
	
	// Internal functions - private only
private:
	void CopyBlock( char far *dest, char far *src, unsigned len );
	void XMSChainHandle( unsigned int handle, unsigned int size );
	XMSHandle *XMSFindLastHandle( void ) { return (CurrHandle=Last); }
	XMSHandle *XMSFindFirstHandle( void ) { return (CurrHandle=First); }
	XMSHandle *XMSFindHandle( unsigned handle );
};

#endif
// End XMS.H
