//********************************//
// XMSDEMO2.CPP                   //
// Beginning of sample program to //
// demonstrate the usage of       //
// extended memory using MS-XMS   //
// This prg. demonstrates the     //
// usage of the XMSHandle class.  //
//******************************* //

#include <iostream.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "xms.h"

// ***************** Constants, defines, whatever...
char far *vmem = (char far *)MK_FP( 0xB800, 0);	// text mode video memory
                                                // 0xB000 for mono
// *** Global vars...
XMSDriver XMM;                    // Declare an instance of XMSDriver
extern XMSDriver *xmsptr;         // Pointer to XMM (used by XMSHandle)

// Function prototypes...
void print_msg( char *str );
void fill_emb ( char lttr, XMSHandle *h, unsigned len );

// Fill extended memory block with a letter
void fill_emb( char lttr, XMSHandle *h, unsigned len )
{
	unsigned i;
	
	// Set the pointer to the beginning
	h->SetPtr( 0 );
	for( i = 0; i < len; i += 2 )   // <= the '+=2' skips the attribute byte
	{
 		h->Store( lttr );           // Stick in the letter
		h->Store( (char) 0x07 );    // Stick in the attribute byte
	}
}

// Print out a message with lines on the top and bottom of the string
void print_msg( char *str )
{
	int i, len;
	len = strlen( str );
	cout << "\n";
	for( i=0; i < len; i++ )
		cout << "-";
	cout << "\n" << str << "\n";
	for( i=0; i < len; i++ )
		cout << "-";
	cout << "\n";
}

int main( void )
{
	const numhandles = 3;       // The number of handles
	char a;                     // Temporary loop counter var
	int b;						// a temp int
	long c;						// a temp long
	unsigned hnum;				// Three extended memory block handles
	XMSHandle *hptr[numhandles];// Pointer to the Handle
	xmsptr = &XMM;              // xmsptr MUST be initialized to XMM

	// Determine the presence and availability of extended memory
	if( !XMM.Inst( ) || (XMM.GetAvail() < 12) )
	{
		cout <<  "Cannot run the demo...\n";
		cout <<  "Either HIMEM.SYS has not been properly installed,\n";
		cout <<  "or there is not enough extended memory (12k).\n";
		return( 1 );
	}
	// **************** The initialization of the program
	for( a = 0; a < 3; a++ )
	{
		// First step is to allocate a block of ext mem
		hnum = XMM.EMBAlloc( 4 );	// Allocate 4 KBytes (4096 bytes)
		if( !hnum )
		{
			cout << "An error has occurred allocating an EMB.\n";
			cout << "You may not have enough extended memory.\n";
			return( 1 );
		}

		// Second step is to request a class pointer to the block
		hptr[a] = XMM.HndReqPtr( hnum );

		// Increase the cache size (in bytes) for optimal performance
		// The default is 50 bytes, the minimum rec'd is 10 bytes.
		hptr[a]->CRealloc( 256 );

		// Now you can fill the block with data
		cout << "Please wait...Stuffing screen " << (int) a << "...\n";
		fill_emb( a+'a', hptr[a], 4000 );
	}

	// All three EMB's have been filled...It's time for the body
	// of this very corny program...
	cout << "Presenting the...(strike practically any key)\n";
	getch( );

	// Copy the blocks from extended memory to conventional memory
	for( a = 0; a < numhandles; a++ )
	{
		// Get a block of memory 4000 bytes long from the EMB
		// at offset 0, and stuff it into 'vmem'
		hptr[a]->Get( vmem, 4000, 0 );
		getch( );
	}
	cout << "\n        abc's of the XMSHandle class!          \n";

	// Finally, free all but one of the extended memory blocks...
	for( a=1; a < numhandles; a++ )
		XMM.HndRelPtr( hptr[a]->GetHandle() );

	// Write a character, a long, and an integer into extended mem.
	cout << "Enter a character -> ";
	cin >> a;
	cout << "Enter an integer -> ";
	cin >> b;
	cout << "Enter a long -> ";
	cin >> c;

	hptr[0]->SetPtr( 12 );		// Set the 'Index' pointer
	hptr[0]->Store( a );		// Write it!
	hptr[0]->Store( b );
	hptr[0]->Store( c );

	a = b = c = 0;				// Null vars so we can prove we read in
	cout << "A character, and integer, and a long...\n";

	// Set the pointer to 12 again, and then get the three values
	hptr[0]->SetPtr( 12 );
	hptr[0]->Get( a ); hptr[0]->Get( b ); hptr[0]->Get(c);

	cout << a << ", " << b << ", and " << c;	// Print 'em!

	XMM.HndRelPtr( hptr[0]->GetHandle() );
	return 0;
}
// END XMSDEMO2.CPP
