// Microsoft eXtended Memory Specification
// C++ Interface Library Header File
// by Richard Vuduc 
// Copyright 1990, Richard Vuduc

// Flags structure (union)
// Not fully implemented as of yet...
union SwapFlags
{
	unsigned char fbyte;
	struct {
		unsigned Present:1;		// Is data segment in conv. mem.?
		unsigned Accessed:1;	// Has data been accessed recently?
		unsigned Read:1;		// Is the data readable?
		unsigned Write:1;		// Is the data writable?
		unsigned Swap:1;		// Is the data swappable to ext. mem?
		unsigned Cache:1;		// Is the conv. mem. data cache on?
	} fbits;
};

// Element in the linked list of extended memory blocks
// In conjunction with the XMSDriver class, it provides a
// reasonable set of data managment commands
class XMSHandle
{
	unsigned Handle;  			// Extended Memory Handle No.
	long ByteSize;				// Size of 'Data' in bytes
	long Index;				// Index into the data
	SwapFlags SwFlags;			// Swapping Flags
	void *Data;				// Conventional Memory Cache
	long CStart;				// Cache start index
	long CLen;				// Cache end index
	long CIndex;				// Cache index
	XMSHandle *Prev, *Next;		// Pointers to next and prev. in the chain
public:
	XMSHandle( unsigned csize = 50 );		// Constructor
	~XMSHandle( void );					// Destructor
	boolean Realloc( unsigned ksize );		// Realloc block
	boolean CRealloc( unsigned size );		// Reallocate cache block

	boolean Bounds( long i ) {			// Is 'i' within length?
		return ((i < ByteSize) && (i >= 0) ? True : False);
	}	
	boolean SetPtr( long i );			// Set 'Index'
	long GetPtr( void ) { return Index; }	// Return Index
	void IncPtr( long size = 0 );			// Increment Index

	void SetSwap( boolean s ) {			// Set swappable flag
		SwFlags.fbits.Swap = s;
	}
	unsigned GetHandle( void ) {		    	// Get handle number
		return Handle;
	}
	boolean GetCache( void ) { 			// Is the cache on right now?
		return (boolean) SwFlags.fbits.Cache;
	}
	long GetSize( void ) { return ByteSize; }	// Get size of EMB

	void Get( char& a );   			// Get a character data item
	void Get( int&  a );   			// Get an integer data item
	void Get( long& a );   			// Get a long data item
	boolean Get( void far *a, unsigned& len, long off = -1 );

	void Store( char& a );			// Store a char into cur pos.
	void Store( int&  a );			// Store an integer
	void Store( long& a );			// Store a long into cur pos.
	boolean Store( void far *a, unsigned& len, long off = -1 );

	void SetCache( boolean s );			// Toggle cache buffer
	void CacheRead( void );				// Load the cache buffer
	void CacheWrite( void );				// Flush the cache buffer to EMB
	void CacheUpdate( unsigned chksize=1 ); // Update the cache buffer
	boolean CBounds( long i );			// Confirm that 'i' is in buffer
	friend XMSDriver;					// Allow XMSDriver access
};
// END XMSHNDL.H
