// This file demonstrates MI extensions to MFC.

// It starts off by defining two classes that are good candidates for a
// library.

// CFrameDialog is yet another 'the main window is a dialog box' case, a la
// Petzold's HexCalc.

// FixedWnd is not that useful: it is just a window that has a caption but
// can't be moved by dragging the caption.

# define AFX_VIRTUAL_WND_BASE

# include <afxwin.h>
# include <strstrea.h>
# include <limits.h>

# pragma warning(disable: 4250)

class CFrameDialog : public CFrameWnd, public CDialog
    {
    public:
        BOOL Create(LPCSTR lpszTemplateName);
        BOOL Create(UINT nIDTemplate);

    protected:
        virtual void OnOK();
        virtual void OnCancel();

        virtual void PostNcDestroy();

        afx_msg void OnClose();

        virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
        virtual BOOL PreTranslateMessage(MSG* pMsg);

        # ifdef _DEBUG
        virtual void AssertValid() const;
        virtual void Dump(CDumpContext& dc) const;
        # endif

    DECLARE_DYNAMIC(CFrameDialog)
    DECLARE_MESSAGE_MAP()
    };

BOOL CFrameDialog::Create(LPCSTR lpszTemplateName)
    {
    return CDialog::Create(lpszTemplateName);
    }

BOOL CFrameDialog::Create(UINT nIDTemplate)
    {
    return CDialog::Create(nIDTemplate);
    }

BOOL CFrameDialog::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
    {
    return CDialog::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo)
        || CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
    }

BOOL CFrameDialog::PreTranslateMessage(MSG* pMsg)
    {
    return CDialog::PreTranslateMessage(pMsg)
        || CFrameWnd::PreTranslateMessage(pMsg);
    }

void CFrameDialog::OnOK()
    {
    }

void CFrameDialog::OnCancel()
    {
    }

void CFrameDialog::OnClose()
    {
    PostQuitMessage(0);
    DestroyWindow();
    }

void CFrameDialog::PostNcDestroy()
    {
    delete this;
    }

# ifdef _DEBUG

void CFrameDialog::AssertValid() const
    {
    //TRACE1("CFrameDialog::AssertValid() at %p\n", this);
    AfxCheckMemory();
    CFrameWnd::AssertValid();
    CDialog::AssertValid();
    }

void CFrameDialog::Dump(CDumpContext& dc) const
    {
    CFrameWnd::Dump(dc);
    dc << "also a ";
    CDialog::Dump(dc);
    }

# endif

IMPLEMENT_DYNAMIC_2(CFrameDialog, CFrameWnd, CDialog)

BEGIN_MESSAGE_MAP_2(CFrameDialog, CFrameWnd, CDialog)
ON_WM_CLOSE()
END_MESSAGE_MAP()

class FixedWnd : public virtual CWnd
    {
    protected:
        afx_msg UINT OnNcHitTest(CPoint point);

    DECLARE_DYNAMIC(FixedWnd)
    DECLARE_MESSAGE_MAP()
    };

UINT FixedWnd::OnNcHitTest(CPoint point)
    {
    UINT where = CWnd::OnNcHitTest(point);
    return where == HTCAPTION ? HTNOWHERE : where;
    }

IMPLEMENT_DYNAMIC(FixedWnd, CWnd)
BEGIN_MESSAGE_MAP(FixedWnd, CWnd)
ON_WM_NCHITTEST()
END_MESSAGE_MAP()

class TestWnd : public CFrameDialog, public FixedWnd
    {
    DECLARE_DYNAMIC(TestWnd)
    DECLARE_MESSAGE_MAP()
    };

IMPLEMENT_DYNAMIC_2(TestWnd, CFrameDialog, FixedWnd)
BEGIN_MESSAGE_MAP_2(TestWnd, CFrameDialog, FixedWnd)
END_MESSAGE_MAP()

class TestApp : public CWinApp
    {
    public:
        virtual BOOL InitInstance();
    };

// Construct the TestApp's m_pMainWnd data member
BOOL TestApp::InitInstance()
    {                
    afxMemDF |= checkAlwaysMemDF;
    
    TestWnd* pMainWnd = new TestWnd;

    TRACE1("TestWnd = %p\n", (TestWnd*) pMainWnd);
    TRACE1("CFrameDialog = %p\n", (CFrameDialog*) pMainWnd);
    TRACE1("CDialog = %p\n", (CDialog*) pMainWnd);
    TRACE1("CFrameWnd = %p\n", (CFrameWnd*) pMainWnd);
    TRACE1("CWnd = %p\n", (CWnd*) pMainWnd);
    TRACE1("CObject = %p\n", (CObject*) pMainWnd);

    ASSERT_VALID(pMainWnd);

    m_pMainWnd = pMainWnd;

    pMainWnd->Create(100);
    pMainWnd->ShowWindow(m_nCmdShow);
    pMainWnd->UpdateWindow();

    return TRUE;
    }

TestApp TestApp;  // TestApp's constructor initializes and runs the app
