// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1993 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and Microsoft
// QuickHelp and/or WinHelp documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdafx.h"
#ifdef _WINDOWS
#include "winhand_.h"
#endif

#ifdef AFX_AUX_SEG
#pragma code_seg(AFX_AUX_SEG)
#endif

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CException

IMPLEMENT_DYNAMIC(CException, CObject)      // abstract class

/////////////////////////////////////////////////////////////////////////////
// AFX_EXCEPTION_CONTEXT (thread global state)

#ifdef _USRDLL
// global state for AFX_EXCEPTION_CONTEXT handle map
static CMapWordToPtr mapHTASK;

// global state for simple single task cache
static HTASK NEAR hTaskCache;
static AFX_EXCEPTION_CONTEXT* NEAR pContextCache;

#ifndef _PORTABLE
extern int cdecl AfxCriticalNewHandler(size_t nSize);
#endif

// out-of-line helper for getting exception context for current task
AFX_EXCEPTION_CONTEXT* AFXAPI AfxGetExceptionContext()
{
	HTASK hTaskCurrent = ::GetCurrentTask();
	ASSERT(hTaskCurrent != NULL);
	if (hTaskCurrent != hTaskCache)
	{
		AFX_EXCEPTION_CONTEXT* pContextLookup;
		if (!mapHTASK.Lookup((WORD)hTaskCurrent, (void*&)pContextLookup))
		{
			// need cached temporary task context for TRY below
			AFX_EXCEPTION_CONTEXT context;
			context.m_pLinkTop = (AFX_EXCEPTION_LINK*)BEFORE_START_POSITION;
			hTaskCache = hTaskCurrent;
			pContextCache = &context;

			TRY
			{
				// We don't want the user to see these memory
				//  allocations, so we turn tracing off.
#ifdef _DEBUG
				BOOL bEnable = AfxEnableMemoryTracking(FALSE);
#endif
#ifndef _PORTABLE
				_PNH pnhOldHandler = _AfxSetNewHandler(AfxCriticalNewHandler);
#endif

				// allocate new task local context
				pContextLookup = new AFX_EXCEPTION_CONTEXT;
				pContextLookup->m_pLinkTop = NULL;

				// and insert it into the map
				mapHTASK.SetAt((WORD)hTaskCurrent, pContextLookup);

#ifndef _PORTABLE
				_AfxSetNewHandler(pnhOldHandler);
#endif
#ifdef _DEBUG
				AfxEnableMemoryTracking(bEnable);
#endif
			}
			CATCH_ALL(e)
			{
				TRACE0("Error: Failed allocation of AFX_EXCEPTION_CONTEXT!\n");
				AfxTerminate();
				ASSERT(FALSE);  // not reached
			}
			END_CATCH_ALL
		}
		hTaskCache = hTaskCurrent;
		pContextCache = pContextLookup;
	}
	ASSERT(pContextCache != NULL);
	return pContextCache;
}

// simulate global variable afxExceptionContext
#define afxExceptionContext (*AfxGetExceptionContext())
#endif  // _USRDLL

// single threaded, assume 1 global exception context
#ifndef _WINDLL
static AFX_EXCEPTION_CONTEXT NEAR afxExceptionContext;
#define AfxGetExceptionContext() (&afxExceptionContext)
#endif

#ifdef _AFXDLL
#define afxExceptionContext (_AfxGetAppData()->appExceptionContext)
#define AfxGetExceptionContext() (&_AfxGetAppData()->appExceptionContext)
#endif

#ifndef _WINDOWS
extern "C" void __cdecl longjmp(int[_AFX_JBLEN], int);
#endif

/////////////////////////////////////////////////////////////////////////////
// AFX_EXCEPTION_LINK linked 'jmpbuf' and out-of-line helpers

AFX_EXCEPTION_LINK::AFX_EXCEPTION_LINK()
{
	// setup initial link state
	m_nType = 0;
	m_pException = NULL;            // no current exception for TRY block
	m_bAutoDelete = FALSE;

	// wire into top of exception link stack
	AFX_EXCEPTION_CONTEXT* pContext = AfxGetExceptionContext();
	m_pLinkPrev = pContext->m_pLinkTop;
	pContext->m_pLinkTop = this;
}

// out-of-line cleanup called from inline AFX_EXCEPTION_LINK destructor
void AFXAPI AfxTryCleanupProc()
{
	AFX_EXCEPTION_CONTEXT* pContext = AfxGetExceptionContext();
	AFX_EXCEPTION_LINK* pLinkTop = pContext->m_pLinkTop;
	ASSERT(pLinkTop != NULL);

	// delete current exception
	if (pLinkTop->m_pException && pLinkTop->m_bAutoDelete)
		delete pLinkTop->m_pException;

	// remove ourself from the top of the chain
	pContext->m_pLinkTop = pLinkTop->m_pLinkPrev;

#ifdef _USRDLL
	if (pLinkTop->m_pLinkPrev == NULL)
	{
		// current task should be cached
		ASSERT(pContext == pContextCache);
		ASSERT(hTaskCache == ::GetCurrentTask());

		// remove from the map and delete the temp handle
		VERIFY(mapHTASK.RemoveKey((WORD)hTaskCache));
		delete pContextCache;
		hTaskCache = NULL;
	}
#endif
}

// out-of-line implementation of CATCH and AND_CATCH
BOOL AFXAPI AfxCatchProc(CRuntimeClass* pClass)
{
	ASSERT(pClass != NULL);

	AFX_EXCEPTION_CONTEXT* pContext = AfxGetExceptionContext();
	ASSERT(pContext->m_pLinkTop != NULL);
	CException* pException = pContext->m_pLinkTop->m_pException;
	ASSERT(pException != NULL);
	return pException->IsKindOf(pClass);
}

// out-of-line implementation for END_CATCH and THROW_LAST
void AFXAPI AfxThrowLast()
{
	AfxThrow(NULL, FALSE);
}

// out-of-line implementation for THROW
void AFXAPI AfxThrow(CException* pNewException, BOOL bShared)
{
	// get current exception context for running task
	AFX_EXCEPTION_CONTEXT* pContext = AfxGetExceptionContext();

	// check for THROW_LAST() first
	if (pNewException == NULL)
	{
		ASSERT(pContext->m_pLinkTop != NULL);
		pNewException = pContext->m_pLinkTop->m_pException;
		bShared = !pContext->m_pLinkTop->m_bAutoDelete;
	}
	ASSERT_VALID(pNewException);

	TRACE1("Warning: Throwing an Exception of type %Fs\n",
		pNewException->GetRuntimeClass()->m_lpszClassName);

    CObject::ExceptionCleanup(); // jll

	// walk the handlers -- throw to first available
	for (;;)
	{
		if (pContext->m_pLinkTop == NULL)
		{
			// uncaught exception, terminate
			TRACE1("Error: Un-caught Exception (%Fs)\n",
				pNewException->GetRuntimeClass()->m_lpszClassName);
			AfxTerminate();
			ASSERT(FALSE);  // not reached
		}

		if (pContext->m_pLinkTop->m_pException != NULL)
		{
			// a THROW during a CATCH block -- this link will not be
			//  destructed, so it is necessary to do all the cleanup that
			//  the destructor would do.
			AFX_EXCEPTION_LINK* pTemp = pContext->m_pLinkTop;
			if (pTemp->m_pException != pNewException && pTemp->m_bAutoDelete)
				delete pTemp->m_pException;
			pTemp->m_pException = NULL;

			// unlink the top exception link
			pContext->m_pLinkTop = pTemp->m_pLinkPrev;
			pTemp->m_pLinkPrev = NULL;
		}
		else
		{
			// throw the exception to the top handler (if appropriate type)
			AFX_EXCEPTION_LINK* pReceiver = pContext->m_pLinkTop;
			if (pReceiver->m_nType == 0)
			{
				// setup the receiver's context for the new exception
				pReceiver->m_pException = pNewException;
				pReceiver->m_bAutoDelete = !bShared;

				// and jump into the handler...
#ifdef _WINDOWS
				::Throw(pReceiver->m_jumpBuf, 1);
#else
				::longjmp(pReceiver->m_jumpBuf, 1);
#endif
				ASSERT(FALSE);  // not reached
			}

			// otherwise just call cleanup proc
			(*pReceiver->m_callback.pfnCleanup)(pReceiver);
		}
	}

	ASSERT(FALSE);  // not reached
}

/////////////////////////////////////////////////////////////////////////////
// Global exception terminate handling - Obsolete API
//   (useful for non-Windows MS-DOS apps only)

#ifndef _AFXDLL
static AFX_TERM_PROC NEAR pfnTerminate = AfxAbort;

void AFXAPI AfxTerminate()
{
	TRACE0("AfxTerminate called\n");
	(*pfnTerminate)();
}

AFX_TERM_PROC AFXAPI AfxSetTerminate(AFX_TERM_PROC pfnNew)
{
	AFX_TERM_PROC pfnOld = pfnTerminate;
	pfnTerminate = pfnNew;
	return pfnOld;
}
#endif //!_AFXDLL

/////////////////////////////////////////////////////////////////////////////
// Standard exceptions

IMPLEMENT_DYNAMIC(CMemoryException, CException)
static CMemoryException NEAR simpleMemoryException;
void AFXAPI AfxThrowMemoryException()
	{ AfxThrow(&simpleMemoryException, TRUE); }

IMPLEMENT_DYNAMIC(CNotSupportedException, CException)
static CNotSupportedException NEAR simpleNotSupportedException;
void AFXAPI AfxThrowNotSupportedException()
	{ AfxThrow(&simpleNotSupportedException, TRUE); }

// jll

# ifdef _WIN32

static void NEAR* sptop;

static class InitUnwindStackTop
    {
    public:
        InitUnwindStackTop()
            {
            int dummy;
            sptop = (char NEAR*) &dummy + 0x80;
            }
    } initStackTop;

# endif

# pragma warning(disable:4704)

# ifdef _DOS
extern "C" unsigned __near _atopsp;
# endif

BOOL CObject::IsStackObject() const
    {
    # ifdef _WIN32

        void* p = (void*) this;
        return p > &p && p < sptop;


    # elif defined __TURBOC__

        void* p = (void*) this;
        return p > &p && p < sptop;

    # else

        void* p = (void*) this;

        # if defined(_M_I86LM) || defined(_M_I86CM) || defined(_M_I86HM)

            _asm
                {
                mov ax, word ptr p + 2
                mov bx, ss
                cmp ax, bx
                jne end
                }

        # endif

        _asm
            {
            mov ax, word ptr p
            cmp ax, sp
            jb  end // below stack pointer
            }

        # ifdef _WINDOWS
            __asm cmp ax, word ptr ss:0x000e
        # else
            __asm cmp ax, word ptr _atopsp
        # endif

        __asm ja  end // above stack top

    return TRUE;

    end:
        return FALSE;

    # endif
    }

# pragma warning(default:4704)

# ifndef _DEBUG

CObject::CObject()
    {
    if (IsStackObject())
        {
        ASSERT(usp > ustack);
        *--usp = this;
        }
    }

CObject::CObject(const CObject&)
    {
    if (IsStackObject())
        {
        while (usp < utop && !*usp)
            usp++;

        ASSERT(usp > ustack);
        *--usp = this;
        }
    }

# endif

CObject::~CObject()
    {
    if (!IsStackObject())
        return;

    while (usp < utop && !*usp)
        usp++;

    if (usp == utop)
        return;

    if (*usp == this)
        {
        usp++;
        return;
        }

    for (CObject** up = usp; up < utop; up++)
        if (*up == this)
            {
            # if 0
            # ifdef _DEBUG
                # ifdef _WINDOWS
                    ::MessageBox(NULL, "Yes it happens !", "CObject", MB_OK | MB_ICONINFORMATION | MB_TASKMODAL);
                # else
                    TRACE("CObject: Yes it happens !\n");
                # endif
            # endif
            # endif

            *up = NULL;

            return;
            }
    }

void CObject::SetUnwindObject()
    {
    if (IsStackObject())
        while (*usp != this)
            {
            ASSERT(usp < utop);
            usp++;
            }
    }

# ifdef _DEBUG

void CObject::DumpStack()
    {
    TRACE1("Dumping Unwind Stack (%d entries):\n", utop - usp);

    for (CObject** entry = usp; entry < utop; entry++)
        {
		if (*entry)
        	(*entry)->Dump(afxDump);
		else
			afxDump << (void*) NULL;

        afxDump << "\n";
        }
    }

BOOL CObject::traceUnwind;

# endif

CObject* CObject::ustack[EXCEPT_STACK_SIZE];
CObject **CObject::utop = ustack + EXCEPT_STACK_SIZE, **CObject::usp = utop;

void terminate()
    {
    TRACE("Exception thrown during stack unwinding\n");
    AfxAbort();
    }

static void operator delete(void* ptr)
    {
    }

void CObject::UnwindTop()
    {
    # ifdef _DEBUG
        if (traceUnwind)
			{
            if (*usp)
                (*usp)->Dump(afxDump);
            else
                afxDump << (void*) NULL;

            afxDump << "\n";
			}
    # endif

    if (*usp)
        ::delete *usp;
	else
		usp++;
    }

void CObject::ExceptionCleanup()
	{
	// Walk the stack, invoking destructors for objects that sit below
	// the current exception context, or all of them if no context has
	// been set.

    static BOOL reenter;

    if (reenter)
        terminate();

    reenter = TRUE;

    # ifdef _DEBUG
        if (traceUnwind)
            TRACE("Unwinding stack:\n");
    # endif

	if (afxExceptionContext.m_pLinkTop)
        while (usp < utop && *usp < (void*) afxExceptionContext.m_pLinkTop)
            UnwindTop();
	else
        while (usp < utop)
            UnwindTop();

    reenter = FALSE;
    }

// end jll

/////////////////////////////////////////////////////////////////////////////
