; Some Mode 13h utility functions for XTSRTOOL - the TSR bitmap capture program
;------------------------------------------------------------------------------
locals
.model small

SCREEN_SEGMENT      equ 0a000h  ;where screen memory is
GC_INDEX            equ 3ceh    ;Graphics Controller (GC) Index reg I/O port
SET_RESET           equ 0       ;Set/Reset register index in GC
G_MODE              equ 5       ;Graphics Mode register index in GC
BIT_MASK            equ 8       ;Bit Mask register index in GC
ENABLE_SET_RESET    equ 1
BYTE_OFFSET_SHIFT   equ 3
GC_ROTATE	    equ	3

.data
  global _width:word
  global _height:word
  global _m13h_rect:proc
  global _get_13h_rect:proc
  global _put_13h_rect:proc
  global _get_video_mode:proc
  global _get_line:proc

.code
_get_video_mode proc near
   push bp
   mov  bp,sp
   mov  ah,0fh
   int  10h
   xor  ah,ah
   pop  bp
   ret
_get_video_mode endp


; draw a rectangle in mode 13h
_m13h_rect proc near
ARG x:word,y:word,color:word
   push bp
   mov  bp,sp
   push di
   push si
   cld

   mov  ax,0A000h
   mov  es,ax

   mov  si,_width

   mov  ax,320
   mov  di,[x]
   mov  bx,[y]
   mul  bx
   add  di,ax        ; di = offset of first pixel

   push di

   mov  al,byte ptr [color]
   mov  cx,si
   rep  stosb

   mov  ax,320
   mov  di,[x]
   add  bx,_height
   dec  bx
   mul  bx
   add  di,ax        ; di = offset of first pixel

   mov  al,byte ptr [color]
   mov  cx,si
   rep  stosb

   ;======== Vertical lines =================

   pop  di
   mov  bx,di

   mov  cx,_height
   mov  ch,cl

@@loop1:
   mov  es:[di],al
   add  di,320
   dec  cl
   jnz @@loop1

   mov  di,si
   dec  di
   add  di,bx

@@loop2:
   mov  es:[di],al
   add  di,320
   dec  ch
   jnz @@loop2

   pop  si
   pop  di
   pop  bp
   ret
_m13h_rect endp

; get a rectangle in mode 13h
_get_13h_rect proc near
ARG x:word,y:word,dest:word
LOCAL w:word,h:word=stk
   push bp
   mov  bp,sp
   sub  sp,stk
   push ds
   push di
   push si

   mov  ax,_width
   mov  [w],ax
   mov  ax,_height
   mov  [h],ax

   mov  ax,ds
   mov  es,ax
   mov  ax,0A000h
   mov  ds,ax

   mov  di,[dest]
   mov  al,byte ptr [w]
   mov  ah,byte ptr [h]
   stosw

   mov  ax,320
   mov  bx,ax
   sub  bx,[w]     ; dx = increnment to start of next line

   mov  si,[x]
   mul  [y]
   add  si,ax


@@loop:
   mov  cx,[w]
   shr  cx,1
   rep  movsw
   adc  cx,0
   rep  movsb
   add  si,bx
   dec  [h]
   jnz  @@loop

   pop  si
   pop  di
   pop  ds
   mov  sp,bp
   pop  bp
   ret
_get_13h_rect endp


; put a rectangle in mode 13h
_put_13h_rect proc near
ARG x:word,y:word,src:word
LOCAL h:word=stk
   push bp
   mov  bp,sp
   sub  sp,stk
   push ds
   push di
   push si

   mov  ax,_height
   mov  [h],ax

   mov  ax,0A000h
   mov  es,ax
   mov  si,[src]
   lodsw

   mov  ax,320
   mov  bx,ax
   sub  bx,_width     ; dx = increnment to start of next line

   mov  di,[x]
   mul  [y]
   add  di,ax

@@loop:
   mov  cx,_width
   shr  cx,1
   rep  movsw
   adc  cx,0
   rep  movsb
   add  di,bx
   dec  [h]
   jnz  @@loop

   pop  si
   pop  di
   pop  ds
   mov  sp,bp
   pop  bp
   ret
_put_13h_rect endp


_get_line proc near
ARG y:word,dest:word
LOCAL w:word,h:word=stk
   push bp
   mov  bp,sp
   push ds
   push di
   push si

   mov  ax,ds
   mov  es,ax
   mov  ax,0A000h
   mov  ds,ax

   mov  di,[dest]

   mov  ax,320
   mul  [y]
   mov  si,ax

   mov  cx,160
   rep  movsw

   pop  si
   pop  di
   pop  ds
   pop  bp
   ret
_get_line endp


end
