#ifndef WWToolsIncluded
#define WWToolsIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <WW.h>

class ScreenImage
  {
      RootWindow* RW;  // which video device the image is from
      Bool Replaced;  //  whether or not this image has been put back
      Byte Where;
        //  0=One memory chunk; 1=Many memory chunks; 2=Disk; 255=not saved
      void* Ptr;
      #ifdef UseMouse
        Point OrigPos; // where the rect was recorded from
        Point OP;
          // the offset for when restoring in a different place than recording
      #endif
      #ifndef UseGraphics
        Rect R; // where the rect sits
      #endif
    public:
      ScreenImage(RootWindow& W,const Rect& R); // R must be in global device coords
      ~ScreenImage() {Restore();}
      void Restore();
      void Restore(Point P);  // for restoring in a different place
        // will work the same as "Restore()" in text mode
      void ThrowAway();  // the image won't be used, ditch it
  };

// do not access directly:  used by VertScrollBar and HorzScrollBar
class ScrollBar
  {
      LogicalWindow* W;  // includes the border
      #ifdef UseMouse
        Rect DecArrow; // local coords.  Arrow for decrementing position
        Rect IncArrow; // local coords.  Arrow for incrementing position
        Rect Elevator;  // local coords for where the elevator is now
        int  ScrollMin; // The smallest Y (X for HorzScrollBar) for Elevator
      #endif
      int Step; // 0..(StepRange-1):  the top line (left col for Horz) number
      int ScrollRange; // device pixels that the Elevator may be shifted
        //  0 if there is no elevator
      int StepRange;
        /* the number of steps that the scroll box may move. Example:  when
        trying to show a 30 line file on a 20 line window, StepRange is
        equal to 11.  There are 11 different positions that the text may
        appear on the window (including showing lines 0 to 19 or lines 10
        to 29) */
      Bool Vert; // is this a Vertical scroll bar?
      #ifdef UseMouse
        int CurElevatorPos();
        void SetWideAndHigh(int Wide,int High);
      #endif
      int StepToElevatorPos();
      void MoveElevatorToStep();
      //ScrollBar(LogicalWindow& ParentWin,int TotSteps,int CurStep,Bool V);
      ScrollBar(){}
      friend class VertScrollBar;
      friend class HorzScrollBar;
    public:
      ~ScrollBar(){delete W;}
      void Show();
      #ifdef UseMouse
        Bool Test(KeyType Key); // returns True if Step was changed
      #endif
      int CurStep(){return Step;}
      void SetStep(int S);
        // if you do a page up you'll want your scrollbar to reflect the change
      void SetStepRange(int S);
        // if you insert a line (currently not avail)
      int CurStepRange(){return StepRange;}
  };

class VertScrollBar: public ScrollBar
  {
    public:
      VertScrollBar(LogicalWindow& ParentWin,int TotSteps,int CurStep=0);
        //:(ParentWin,TotSteps,CurStep,True){}
  };

class HorzScrollBar: public ScrollBar
  {
    public:
      HorzScrollBar(LogicalWindow& ParentWin,int TotSteps,int CurStep=0);
        //:(ParentWin,TotSteps,CurStep,False){}
  };

class TextCursor
  {
      LogicalWindow* L;  // used for coord conversion
      Bool Ins; // are we in insert (narrow) mode?
      Bool Vis;  // whether the cursor is currently showing or not
      #ifdef UseGraphics
        Rect R;  // the cursor to draw
        Bool B;  // the blink state:  currently blinked on?
        VideoAtt A;  // the foreground color is used for the cursor color
        image* Image; // stores the image under the cursor
        Long LastTick;  // used for blinking
        Bool LeftEdge;  // insert cursor on left edge? (integral editing uses right edge)
        void Convert(int X, int Y);
        int ShiftVal(){return(L->GridCellWide()-2);}
          // difference in dev pixels for the X val of R depending on "LeftEdge"
      #endif
    public:
      TextCursor(LogicalWindow& LW, int X=1, int Y=1,VideoAtt Att=0,
          Bool OnOrOff=On);
      ~TextCursor();
      void Hide();
      void Show();
      void Adjust(int X, int Y=0);
      void Goto(Point P);
      void Goto(int X, int Y=Curs);
      void Blink(); // call when waiting for input so that the cursor will blink
      void SetInsertMode(Bool OnOrOff=On);
      #ifdef UseGraphics
        void SetLeftEdgeMode(Bool OnOrOff=On);
      #endif
  };

void BlinkingTextCursor(Bool OnOrOff);

KeyType FilterKey(const BitVector& B,char MaskToken,TextCursor* TC=NULL);

#endif
