#include "WWLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

#ifdef UseGraphics

  static void DrawChunk(Point P,char C,int Color)
    {
      TextMode(1);
      PenColor(Color);
      BackColor(Black);
      MoveTo(P.X(),P.Y());
      DrawChar(C);
      TextMode(7);
      BackColor(White);
      MoveTo(P.X(),P.Y());
      DrawChar(C);
    }

  void LogicalWindow::DrawArrowButton(Point P,int Dir)
    {
      //#ifdef UseGraphics
        P+=Point(DeviceRectA());
        PreserveMouseHideStatus(Off);
        PreservePenState();
        int Back,Bright,Dark;
        GetColors(WAtt,Back,Bright,Dark);
        char Part1,Part2;
        switch(Dir)
          {
            case Bottom: Part1=0xB5; Part2=0xB6; break;
            case Left:   Part1=0xB7; Part2=0xB8; break;
            case Right:  Part1=0xB9; Part2=0xBA; break;
            default:     Part1=0xB3; Part2=0xB4; break;
          }
        if (Root->FullColor())
          {
            DrawChunk(P,Part2,Dark);
            DrawChunk(P,Part1,Bright);
          }
        else
          {
            PenColor(!Back);
            BackColor(Back);
            TextMode(Back?7:1);
            MoveTo(P.X(),P.Y());
            DrawChar(Part1);
          }
        TextMode(0);
      //#else
      //  char* C="x";  //  a one char long string
      //  switch(Dir)
      //    {
      //      case Bottom: C[0]=31; break;
      //      case Left:   C[0]=17; break;
      //      case Right:  C[0]=16; break;
      //      default:     C[0]=30; break;
      //    }
      //  Display(C,P,ReverseAtt(WAtt));
      //#endif
    }

  static int ArrowWidth() // the width and height of an arrow in device pixels under the current font
    {
      TextFace(cProportional);
      int W=CharWidth(0xB3);
      TextFace(cNormal);
      return W;
    }

  static int ArrowOffset() // the distance, in device pixels, from the edge of the window to the arrow
    {
      return(int(Round(Double(ArrowWidth())*0.075)));
    }

#endif

VertScrollBar::VertScrollBar(LogicalWindow& ParentWin,int TotSteps,int CurStep):
    ScrollBar()
  {
    if (TotSteps<2) FatalError("cannot create a scroll bar with less than two steps");
    Vert=True;
    W = new LogicalWindow(ParentWin,ParentWin.Wide()+2,1,2,ParentWin.High());
    #ifdef UseGraphics
      int ArrSize=ArrowWidth();
      int ArrOffset=ArrowOffset();
      SetWideAndHigh(ArrSize+ArrOffset*2,W->DeviceHigh()-4);
      W->AdjustLogicalWindowCoords(Point(-(W->GridCellWide()/4),2));
      Step=CurStep;
      StepRange=TotSteps;
      Rect R=W->LocalDeviceRect();
      DecArrow=R;
      DecArrow.SetHigh(R.Wide());
      IncArrow=DecArrow;
      IncArrow.SetY(R.High()-DecArrow.High());
      int H=W->High();
      if (W->DeviceHigh()-DecArrow.High()*2-ArrOffset*2>6+1) // set up the elevator
        {
          Elevator=R;
          Elevator.Adjust(ArrOffset*2,DecArrow.High()+ArrOffset,-ArrOffset*4);
          int ScrollLen=R.High()-DecArrow.High()*2-ArrOffset*2;
          Double PercentVisibleText=Double(H)/Double(StepRange+H-1);
          Elevator.SetHigh(int(RoundDown(ScrollLen*PercentVisibleText)));
          if (Elevator.High()<6) Elevator.SetHigh(6);
          ScrollRange=ScrollLen-Elevator.High()+1;
          ScrollMin=CurElevatorPos();
          // adjust elevator to current choice
          Elevator.SetY(StepToElevatorPos());
        }
      else ScrollRange=0; // disable the elevator
      if (H==1)
        {
          // make arrows half height
          IncArrow.SetHigh(IncArrow.High()/2);
          DecArrow.SetHigh(DecArrow.High()/2);
        }
      else if (H==0) FatalError("cannot create scroll bar of height 0");
    #else
      Step=CurStep;
      StepRange=TotSteps;
      int H=W->High();
      if (H==0) FatalError("cannot create scroll bar of height less than 2");
      if (H>3) ScrollRange=H-2;
      else ScrollRange=0;
    #endif
  }

#ifdef UseMouse

  int ScrollBar::CurElevatorPos()
    {
      int P=(Elevator.Y()*Vert)+(Elevator.X()*(!Vert));
      return P;
    }

#endif

int ScrollBar::StepToElevatorPos()
  // returns a new Elevator.Y() (X for Horz)
  {
    double PercentPos=double(Step)/double(StepRange-1); // 0..1
    int Offset=int(Round(PercentPos*(ScrollRange-1)));
    return(Offset+2);
  }

void ScrollBar::Show()
  {
    #ifdef UseGraphics
      Rect R=W->LocalDeviceRect();
      R.Swell(2);
      W->DrawBeveledRect(R,W->Att(),Innie);
      int ArrAdj=ArrowOffset();
      Point AP(ArrAdj,ArrAdj);
      W->DrawArrowButton(AP,Vert?Top:Left);
      AP=Point(IncArrow);
      AP.Adjust(ArrAdj,ArrAdj);
      W->DrawArrowButton(AP,Vert?Bottom:Right);
      if (ScrollRange)
        {
          R=Elevator;
          W->DrawBeveledRect(R);
        }
    #else
      if (Vert)
        {
          W->Display("\x1e",1,1);  // top arrow
          W->Display("\x1f",1,Bottom);  // bottom arrow
        }
      else
        {
          W->Display("\x11",1,1);  // left arrow
          W->Display("\x10",Right,1);  // right arrow
        }
    #endif
    MoveElevatorToStep();
  }

#ifdef UseMouse

  Bool ScrollBar::Test(KeyType Key) // returns True if Step was changed
    {
      if (Key!=LeftMouseButtonUp) return False;
      Bool Change=False;
      Point CP=Key.MousePos()-(Point(W->DeviceRectA())); // CP: ClickPos
      if (PointOnRect(CP,W->LocalDeviceRect()))
        {
          if (PointOnRect(CP,DecArrow))
            {
              if (Step>0)
                {
                  Step--;
                  Change=True;
                }
            }
          else if (PointOnRect(CP,IncArrow))
            {
              if (Step<(StepRange-1))
                {
                  Step++;
                  Change=True;
                }
            }
          else if (ScrollRange!=0) // if there is an elevator to move...
            {
              int OldStep=Step;
              int Min=ScrollMin+(Vert*Elevator.High()/2)+((!Vert)*Elevator.Wide()/2);
              int Max=Min+ScrollRange-1;
              int P=(Vert*CP.Y())+((!Vert)*CP.X());
              if (P<=Min) Step=0;
              else if (P>=Max) Step=StepRange-1;
              else
                {
                  double Percent=double(P-Min)/(ScrollRange-1);
                  Step=int(Round(Percent*(StepRange-1)));
                }
              Change=(Step!=OldStep);
            }
        }
      MoveElevatorToStep();
      return Change;
    }

#endif

void ScrollBar::SetStep(int S)
  {
    if (S<StepRange)
      {
        Step=S;
        MoveElevatorToStep();
      }
  }

void ScrollBar::MoveElevatorToStep()
  {
    if (ScrollRange==0) return;
    #ifdef UseMouse
      int Adj=StepToElevatorPos()-CurElevatorPos();
      if (Adj!=0)
        {
          PreservePenState();
          BackColor(W->Att().Background());
          if (SmoothScroll)
            {
              int Distance=Abs(Adj);
              int Direction=((Adj>0)?1:-1);
              int VDir=(Vert?Direction:0);
              int HDir=(Vert?0:Direction);
              int I;
              For (I,Distance)
                {
                  rect r=rect(Elevator+Point(W->DeviceRectA()));
                  ScrollRect(&r,HDir,VDir);
                  Elevator.Adjust(HDir,VDir);
                }
            }
          else
            {
              rect r=rect(Elevator+Point(W->DeviceRectA()));
              int VAdj=(Vert?0:Adj);
              int HAdj=(Vert?Adj:0);
              ScrollRect(&r,VAdj,HAdj);
              Elevator.Adjust(VAdj,HAdj);
            }
        }
    #else
      int Pos=StepToElevatorPos();
      char* Elevator="\04";
      if (Vert)
        {
          int Bottom=W->WRect().Bottom();
          int I;
          for(I=2;I<Bottom;I++) W->Display("\xb1",1,I);
          W->Display(Elevator,1,Pos,ReverseAtt(W->Att()));
        }
      else
        {
          W->Display(StringOf(W->Wide()-2,char(177)),2,1);
          W->Display(Elevator,Pos,1,ReverseAtt(W->Att()));
        }
    #endif
  }

//void ScrollBar::SetStepRange(int S)
//  {
//
//  }

HorzScrollBar::HorzScrollBar(LogicalWindow& ParentWin,int TotSteps,int CurStep):
    ScrollBar()
  {
    if (TotSteps<2) FatalError("cannot create a scroll bar with less than two steps");
    Vert=False;
    W = new LogicalWindow(ParentWin,1,ParentWin.High()+1,ParentWin.Wide(),1);
    #ifdef UseMouse
      int ArrSize=ArrowWidth();
      int ArrOffset=ArrowOffset();
      SetWideAndHigh(W->DeviceWide()-4,ArrSize+ArrOffset*2);
      W->AdjustLogicalWindowCoords(Point(2,(W->GridCellHigh()/2)));
      Step=CurStep;
      StepRange=TotSteps;
      Rect R=W->LocalDeviceRect();
      DecArrow=R;
      DecArrow.SetWide(R.High());
      IncArrow=DecArrow;
      IncArrow.SetX(R.Wide()-DecArrow.Wide());
      int Width=W->Wide();
      if (W->DeviceWide()-DecArrow.Wide()*2-ArrOffset*2>6+1) // set up the elevator
        {
          Elevator=R;
          Elevator.Adjust(DecArrow.Wide()+ArrOffset,ArrOffset*2,0,-ArrOffset*4);
          int ScrollLen=R.Wide()-DecArrow.Wide()*2-ArrOffset*2;
          Double PercentVisibleText=Double(Width)/Double(StepRange+Width-1);
          Elevator.SetWide(int(RoundDown(ScrollLen*PercentVisibleText)));
          if (Elevator.Wide()<6) Elevator.SetWide(6);
          ScrollRange=ScrollLen-Elevator.Wide()+1;
          ScrollMin=CurElevatorPos();
          // adjust elevator to current choice
          Elevator.SetX(StepToElevatorPos());
        }
      else ScrollRange=0; // disable the elevator
      if (Width==1)
        {
          // make arrows half height
          IncArrow.SetWide(IncArrow.Wide()/2);
          DecArrow.SetWide(DecArrow.Wide()/2);
        }
      else if (Width==0) FatalError("cannot create scroll bar of width 0");
    #else
      Step=CurStep;
      StepRange=TotSteps;
      int Wide=W->Wide();
      if (Wide<2) FatalError("cannot create scroll bar of width less than 2");
      if (Wide>3) ScrollRange=Wide-2;
      else ScrollRange=0;
    #endif
  }

void LogicalWindow::ScrollDown(int Lines)
  {
    Root->Touch();
    #ifdef UseGraphics
      Rect R=WR;
      PreserveMouseHideStatus(Off);
      PreservePenState();
      PenColor(WAtt.Foreground());
      BackColor(WAtt.Background());
      int L=int(GridCellHigh())*int(Lines);
      if (SmoothScroll)
        {
          R.Adjust(0,0,0,-1);
          rect r=R;
          int I;
          For(I,L) ScrollRect(&r,0,1);
        }
      else
        {
          R.Adjust(0,0,0,-L);
          rect r=R;
          ScrollRect(&r,0,L);
        }
    #else
      Byte* Source=Root->ScreenMemoryPos();
      Source+=160*(High()-2)+(XA()-1)*2+(YA()-Lines)*160;
      Byte* Dest=Source+160*Lines;
      int CopyLen=Wide()*2;
      int I=High()-Lines;
      while (I>0)
        {
          memcpy(Dest,Source,CopyLen);
          Dest-=160;
          Source-=160;
          I--;
        }
      ClearToY(Lines);
    #endif
  }

void LogicalWindow::ScrollUp(int Lines)
  {
    Root->Touch();
    #ifdef UseGraphics
      Rect R=WR;
      PreserveMouseHideStatus(Off);
      PreservePenState();
      PenColor(WAtt.Foreground());
      BackColor(WAtt.Background());
      int L=int(GridCellHigh())*int(Lines);
      if (SmoothScroll)
        {
          R.Adjust(0,1,0,-1);
          rect r=R;
          int I;
          For(I,L) ScrollRect(&r,0,-1);
        }
      else
        {
          R.Adjust(0,L,0,-L);
          rect r=R;
          ScrollRect(&r,0,-L);
        }
    #else
      Byte* Dest=Root->ScreenMemoryPos()+(XA()-1)*2+(YA()-1)*160;
      Byte* Source=Dest+160*Lines;
      int CopyLen=Wide()*2;
      int I=High()-Lines;
      while (I>0)
        {
          memcpy(Dest,Source,CopyLen);
          Dest+=160;
          Source+=160;
          I--;
        }
      ClearFromY(High()-Lines+1);
    #endif
  }

#ifdef UseGraphics

  void ScrollBar::SetWideAndHigh(int Wide,int High)
    {
      W->WR.SetWide(Wide);
      W->WR.SetHigh(High);
    }

#endif


