#include "WWLocal.h"
#pragma hdrstop
#include <stdarg.h>

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

ScreenForm::~ScreenForm()
  {
    while (Size()) DelCurObj();
  }

void ScreenForm::Show()
  {
    int I;
    Last();
    For(I,Size()) Next().Show();
  }

//.parse

ScreenForm::ScreenForm(LogicalWindow& LW,const char* FileName,Word FormNum)
  {
    W=&LW;
    ReadFromDisk(FileName,FormNum);
  }

//.parse

int ScreenForm::HighParm()
  {
    int HP=0;
    int I;
    For(I,Size())
        if (Next().EditField)
            HP=Max(HP,int(((EditRec*)(&Cur()))->Parm));
    return HP;
  }

//.parse

ScreenForm::ScreenForm(LogicalWindow& LW,const char* FileName,Word FormNum,void* Parm0,...)
  {
    W=&LW;
    ReadFromDisk(FileName,FormNum);
    ScreenForm& SF=*this;
    MacroToMoveParmsToFields
  }

//.parse

KeyType ScreenForm::Activate()
  {
    PreserveMouseHideStatus(Off);
    PreserveHelpLine();
    int I;
    int TotEditFields=0;
    Root();
    For(I,Size())
        if (Next().EditField) TotEditFields++;
    if (TotEditFields)
      {
        if (CF>Size()-1) CF=0;
        while (!(Ref(CF).EditField))
          {
            Next();
            CF=int(Num());
          }
        Bool Done=False;
        KeyType Key;
        while (!Done)
          {
            if (Cur().InFunc!=NULL) (*Cur().InFunc)();
            if (Cur().HL!=NULL) Cur().HL->Show();
            Bool DoActivate=True;
            while (DoActivate)
              {
                Key=Cur().Activate();
                OKey=Key;
                if (Cur().OutFunc==NULL) DoActivate=False;
                else if ((*Cur().OutFunc)()) DoActivate=False;
              }
            switch(int(Key))
              {
                case EscKey:
                case F2Key:  Done=True; break;
                case EnterKey:
                case TabKey:
                case ArrowRightKey:
                case ArrowDownKey: while(!(Next().EditField)); break;
                case ShiftTabKey:
                case ArrowUpKey:
                case ArrowLeftKey: while(!(Prev().EditField)); break;
                default:
                  if (EKeys(int(Key))) Done=True;
                  break;
              }
          }
        if (Key==EscKey)
            For(I,Size()) Next().Restore();
        return Key;
      }
    return NullKey;
  }

//.parse

void ScreenForm::ReadFromDisk(const char* FileName,Word Token)
  {
    CF=0;
    Bool Found=False;
    TokenFile F(FileName);
    if (F.Seek(Token)>0)
      {
        Byte NumRecs;
        F.ReadThing(NumRecs);
        KeySetType KeySet(ArrowUpKey,ArrowDownKey,ArrowLeftKey,ArrowRightKey,
            EscKey,EnterKey,F2Key);
        Byte RecNum;
        For(RecNum,NumRecs)
          {
            Byte Code;
            F.ReadThing(Code);
            switch(Code)
              {
                // case ParmTextCode:   Add(*(new ParmTextRec(F)));   break;
                case FixedTextCode:  Add(*(new FixedTextRec(*W,F)));  break;
                case ColorBoxCode:   Add(*(new ColorBoxRec(*W,F)));   break;
                // case DrawBoxCode:    Add(*(new DrawBoxRec(F)));    break;
                case EditStringCode: Add(*(new EditStringRec(*W,F,KeySet))); break;
                case EditNumCode:    Add(*(new EditNumRec(*W,F,KeySet)));    break;
              }
          }
        Found=Bool(Size()>0);
      }
    if (!Found)
        VideoDevice1->Warning("No screen form "+Str(Token)+" in "+FileName);
  }

//.parse

void LogicalWindow::ShowScreenForm(const char* FileName, Word TokenNum)
  {
    ScreenForm SF(*this,FileName,TokenNum);
    SF.Show();
  }

//.parse

void LogicalWindow::ShowScreenForm(const char* FileName, Word TokenNum,
    void* Parm0, ...)
  {
    ScreenForm SF(*this,FileName,TokenNum);
    MacroToMoveParmsToFields
    SF.Show();
  }

//.parse

ColorBoxRec::ColorBoxRec(LogicalWindow& LW,File &F):FormRec(LW)
  {
    F.ReadThing(R);
    F.ReadThing(Color);
  }

//.parse

Bool ColorBoxRec::LocatedOnCell(Point P) { return PointOnRect(P,R); }
void ColorBoxRec::Show() { W->ColorBox(R,Color); }

//.parse

// to quiet warnings...
static void* XXX; // used to quiet warnings

ColorBoxRec::~ColorBoxRec()                     {                          }
void    ColorBoxRec::AdjustDataPointer(void** P){ XXX=*P;                  }
void    ColorBoxRec::Restore()                  {                          }
KeyType ColorBoxRec::Activate()                 {         return NullKey;  }
FixedTextRec::~FixedTextRec()                    { if (Text) delete Text;   }
void    FixedTextRec::AdjustDataPointer(void** P){ XXX=*P;                  }
void    FixedTextRec::Restore()                  {                          }
KeyType FixedTextRec::Activate()                 {         return NullKey;  }

//.parse

void FixedTextRec::Show()
  {
    W->Display(Text,Pt,Att);
  }

//.parse

Bool FixedTextRec::LocatedOnCell(Point P)
  {
    Byte Len=(Text?strlen(Text):0);
    return ((Pt.Y()==P.Y())&&(InRange(P.X(),Pt.X(),int(Pt.X()+Len-1))));
  }

//.parse

FixedTextRec::FixedTextRec(LogicalWindow& LW,File &F):FormRec(LW)
  {
    F.ReadThing(Pt);
    F.ReadThing(Att);
    Byte B;
    F.ReadThing(B);
    Text=new char[B+1];
    F.Read(Text,B);
    Text[B]=0;
  }


//.parse

KeyType LogicalWindow::EditScreenForm(const char* FileName, Word TokenNum,
    void* Parm0, ...)
  {
    ScreenForm SF(*this,FileName,TokenNum);
    MacroToMoveParmsToFields
    SF.Show();
    return SF.Activate();
  }

//.parse

void LogicalWindow::Goto(Point P)
  {
    TCP=P;
    #ifndef UseGraphics
      Registers Regs;
      Regs.AH()=2;
      Regs.DH()=YA()+P.Y()-2;
      Regs.DL()=XA()+P.X()-2;
      Regs.BH()=0;
      CallBIOS(0x10,Regs);
    #endif
  }

//.parse

void TextModeCursorOn(Bool Ins)
  {
    Registers Regs;
    Regs.AH()=1;
    Regs.CH()=(Ins?12:2);
    Regs.CL()=13;
    CallBIOS(0x10,Regs);
  }

//.parse

void TextModeCursorOff()
  {
    Registers Regs;
    Regs.AH()=1;
    Regs.CH()=32;
    Regs.CL()=13;
    CallBIOS(0x10,Regs);
  }

//.parse

void EditNumRec::SetAllowNegatives(Bool NewStat)
  {
    if (NewStat!=NegativesAllowed())
      {
        if (NewStat==On)
          {
            S+='+';
            NumType|=Bit7;
          }
        else
          {
            S.Delete(S.Length()-1);
            NumType|=(~Bit7);
          }
      }
  }

//.parse

void RootWindow::BlinkAtt(Bool State)
  {
    unsigned PortNum;
    if (FullColor())
      {
        PortNum=0x3D8;
        Registers Regs;
        Regs.AH()=0x10;
        Regs.AL()=0x03;
        Regs.BL()=State;
        CallBIOS(0x10,Regs);
      }
    else PortNum=0x3B8;
    Byte PortVal;
    PortVal=inportb(PortNum);
    int I=PortVal;  // Borland Byte math in C has always been shaky
    if (State==On) I |= Bit5;
    else I &= (255-Bit5);
    PortVal=Byte(I);
    outportb(PortNum,PortVal);
    BlinkOn=State;

  }

//.parse

VideoAtt LogicalWindow::NoBlink(VideoAtt A)
  {
    if (Root->BlinkAvail()) A&=0x7F;
    return A;
  }

//.parse

const char* TypeName(int Num)
  {
    static const char* Names[]={"Byte","Signed Byte","Word","Signed Word",
                                "Long","Signed Long","Float","Double"};
    switch(Num)
      {
        case 1:  return (Names[0]);
        case 129: return (Names[1]);
        case 2:  return (Names[2]);
        case 130: return (Names[3]);
        case 4:  return (Names[4]);
        case 132: return (Names[5]);
        case 68:
        case 196:  return (Names[6]);
        case 72:
        case 200:  return (Names[7]);
      }
    return (Names[0]);  //  to satisfy compiler
  }

//.parse

String ValidMaskTokens="!#&*+/<=>?@[]^{|}~";

Bool ValidMaskToken(char C)
  {
    Bool B=(ValidMaskTokens.Index(C)!=NotFound);
    return B;
  }

int MaskIndex(char Token)
  {
    int X;
    if (Token=='\xFF') X=19;
    else if (Token=='\0') X=0;
    else
      {
        X=ValidMaskTokens.Index(Token);
        if (X==NotFound) X=0;
        else X++;
      }
    return X;
  }

String DefaultMask(int Len)
  {
    String S('#',Len);
    return S;
  }

KeySetType Maskey[20];

KeySetType TokenKeys(char Token)
  {
    KeySetType KS=Maskey[MaskIndex(Token)];
    return KS;
  }

void SetMask(char Token, String M)
  {
    int MI=MaskIndex(Token);
    Maskey[MI].Clear();
    if (M.Length()>0)
      {
        int I;
        For(I,M.Length())
            if ( (M(I)=='.') && (I>0) && (M(I-1)!='.') && (M(I+1)!='.') )
                Maskey[MI].SetRange(M(I-1),M(I+1));
            else Maskey[MI][M(I)]=On;
      }
  }

void InitMaskey()
  {
    SetMask('\xFF'," .~");  // plum everything
    SetMask('#'," .~");      // plum everything
    SetMask('<',"a.z");      // lower case only
    SetMask('>',"A.Z");      // upper case only
    SetMask('*',"!@#$%&()-_{}`'A.Z0.9\\*:?.."); //entering file paths
    SetMask('/',"!@#$%&()-_{}`'A.Z0.9\\:..");   //file paths without wild cards
    SetMask('{'," .@[.~");   // everything but caps
    SetMask('}'," .`{.~");   // everything but lowercase
    SetMask('!',"A.Za.z");   // letters only
    SetMask('&',"0.9");      // numbers only
    SetMask('+'," 0.9");     // numbers and spaces
    SetMask('@',"A.Z0.9");
  }

class MaskInit
  {
    public: MaskInit(){InitMaskey();}
  };

MaskInit CallInitMaskey;
