#include "WWLocal.h"
#pragma hdrstop

// Copyright (c) 1992, 1993 Paul Wheaton

//.parse

void LogicalWindow::DisplayAtt(int Len,int X, int Y, VideoAtt Att)
  {
    Touch();
    if (Att==0) Att=WAtt;

    if (X==Center) X = ((Wide()-Len)/2)+1;
    else if (X==Left) X=1;
    else if (X==Right) X = Wide()-Len+1;
    else if (X==Curs) X=TextCursorPos().X();
    X+=XA()-2;

    if (Y==Curs) Y=TextCursorPos().Y();
    else if (Y==Center) Y = High()/2+1;
    else if (Y==Bottom) Y = High();
    else if (Y==Top) Y=1;
    Y+=YA()-2;

    Byte* Screen=Root->ScreenMemoryPos();
    Screen+=X*2+Y*160+1;
    while (Len)
      {
        *Screen=Byte(Att);
        Screen+=2;
        Len--;
      }
  }

//.parse

Bool LogicalWindow::YesNoBox(Bool& YN,const char* St,int X,int Y,VideoAtt Att)
  {
    Window* W;
    LogicalWindow* MenuWin;
    String S=St;
    if ((S.Length()>50)||(S.Index('|')!=NotFound))
      {
        W=MakeWinOText(*this,St,X,Y,Att,10);
        MenuWin=new LogicalWindow(*W,Center,W->High()-1,6,1);
        if (MenuWin==NULL) FatalError("YesNo1");
      }
    else
      {
        if (Att==0) Att=DialogAtt();
        W=new Window(*this,X,Y,S.Length()+9,3,Att);
        if (W==NULL) FatalError("YesNo2");
        MenuWin=new LogicalWindow(*W,S.Length()+3,2,6,1);
        if (MenuWin==NULL) FatalError("YesNo3");
        W->Display(St,2,2);
      }
    int Choice=(YN)?1:2;
    MenuWin->BarMenu(Choice,"Yes|No",1,W->Att());
    delete MenuWin;
    delete W;
    if (Choice==0) return False;
    YN=(Choice==1);
    return True;
  }

//.parse

String LogicalWindow::FileMenu(const char* FileMask, const char* Heading,
                        int X, int Y,VideoAtt Att)
  {
    String FileName;
    find_t FileRec;
    if (_dos_findfirst(FileMask,_A_NORMAL,&FileRec)==0)
      {
        String Names=FileRec.name;
        while (_dos_findnext(&FileRec)==0) Names+=String('|')+FileRec.name;
        int Sel=Menu(Names,Heading,X,Y,0,0,Att);
        if (Sel>0)
          {
            while (Sel>1)
              {
                Sel--;
                Names=Names.After(Names.Index('|'));
              }
            int X=Names.Index('|');
            if (X!=NotFound) Names=Names.Before(X);
            char buf[100];
            _fullpath(buf,FileMask,100);
            String SFN=buf;
            while(SFN(SFN.Length()-1)!='\\') SFN.Delete(SFN.Length()-1);
            FileName=SFN+Names;
          }
      }
    else Warning("Cannot find any files!");
    return FileName;
  }

//.parse

void SaveBootRec(TokenFile& F,const char* CName)
  {
    BootRec.Ver=0;
    BootRec.Dual=(VideoDevice1!=VideoDevice2);
    BootRec.DeviceNum=VideoDevice1->Type();
    BootRec.Device2Num=VideoDevice2->Type();
    if (CName) strcpy(BootRec.ClientName,CName);
    F.WritePrep(902,sizeof(BootRec));
    F.WriteThing(BootRec);
  }

//.parse

String WWFileName("WW.DAT");

void SetWWFileName(const char* NewName)
  {
    WWFileName=NewName;
  }

//.parse

RootWindow::RootWindow(const char* FileName,VideoAtt Att)
  {
    if (FileName!=NULL) WWFileName=FileName;
    if (TokenExists(WWFileName,902))
      {
        TokenFile F(WWFileName);
        long Size=F.Seek(902);
        F.Read(&BootRec,int(Min(long(sizeof(BootRec)),Size)));
        if (BootRec.Ver!=0)
          {
            puts("boot rec is not ver 0");
            exit(-1);
          }
        DefAtt=&BootRec.DAtt;
        ClientName=BootRec.ClientName;
        if (Att!=UseDefaultAtt) BootRec.DAtt.Normal=Att;
        VideoInit(BootRec.DeviceNum,BootRec.DAtt.Normal);
        if (BootRec.Dual) VideoDevice2=new RootWindow(BootRec.D2Att);
      }
    else
      {
        puts("cannot find boot info "+WWFileName);
        exit(-1);
      }
  }

#ifdef UseGraphics

  fontRec* FontAlloc(Word Token)
    {
      if (!TokenExists(WWFileName,Token)) FatalError("cannot find font");
      return FontAlloc(WWFileName,Token);
    }

#endif

//.parse

CreateBitSetClass(BitSet256,256);

class LineCharSet: public BitSet256
  {
    public:
      LineCharSet();
  };

LineCharSet::LineCharSet():BitSet256()
  {
    Ref(179)=1;
    Ref(180)=1;
    Ref(191)=1;
    Ref(192)=1;
    Ref(193)=1;
    Ref(194)=1;
    Ref(195)=1;
    Ref(196)=1;
    Ref(197)=1;
    Ref(217)=1;
    Ref(218)=1;
  }

static LineCharSet LineChars;

static void SelectCharHorz(Byte* S, Byte& C, int Len)
  {
    Bool West=LineChars(S[-2]);
    Bool East=(LineChars(S[2]))||(Len>1);
    Bool North=LineChars(S[-160]);
    Bool South=LineChars(S[160]);
    if (North)
      {
        if (South)
          {
            if (West)
              {
                if (East) C=197;
                else C=180;
              }
            else if (East) C=195;
          }
        else if (West)
          {
            if (East) C=193;
            else C=217;
          }
        else if (East) C=192;
      }
    else if (South)
      {
        if (West)
          {
            if (East) C=194;
            else C=191;
          }
        else if (East) C=218;
      }
  }

static void SelectCharVert(Byte* S, Byte& C, int Len)
  {
    Bool North=LineChars(S[-160]);
    Bool South=(LineChars(S[160]))||(Len>1);
    Bool East=LineChars(S[2]);
    Bool West=LineChars(S[-2]);
    if (East)
      {
        if (West)
          {
            if (North)
              {
                if (South) C=197;
                else C=193;
              }
            else if (South) C=194;
          }
        else if (North)
          {
            if (South) C=195;
            else C=192;
          }
        else if (South) C=218;
      }
    else if (West)
      {
        if (North)
          {
            if (South) C=180;
            else C=217;
          }
        else if (South) C=191;
      }
  }

void LogicalWindow::SmartLine(Point P1, Point P2, VideoAtt A)
  {
    Touch();
    #ifdef UseGraphics
      xxx handle colors
      P1+=Point(DeviceRectA());
      P2+=Point(DeviceRectA());
      MoveTo(P1.X(),P1.Y());
      LineTo(P2.X(),P2.Y());
    #else
      if (A==UseDefaultAtt) A=WAtt;
      Byte* S=Root->ScreenMemoryPos();
      if (P1.X()==P2.X())  // if vert line
        {
          S+=((Min(P1.Y(),P2.Y())-1)*160) + ((P1.X()-1)*2);
          int Len=Abs(P1.Y()-P2.Y())+1;
          while (Len>0)
            {
              Byte C=179;
              if (LineChars[int(*S)])  //  there is already a line char here
                SelectCharVert(S,C,Len);
              *S=C;
              S[1]=Byte(A);
              S+=160;
              Len--;
            }
        }
      else  // horz line
        {
          S+=((Min(P1.X(),P2.X())-1)*2) + ((P1.Y()-1)*160);
          int Len=Abs(P1.X()-P2.X())+1;
          while (Len>0)
            {
              Byte C=196;
              if (LineChars[int(*S)])  //  there is already a line char here
                SelectCharHorz(S,C,Len);
              *S=C;
              S[1]=Byte(A);
              S+=2;
              Len--;
            }
        }
    #endif
  }

//.parse

Point::Point()
  {
    PX=0;
    PY=0;
  }

//.parse

Point::Point(const Point &P)
  {
    PX=P.PX;
    PY=P.PY;
  }

//.parse

Point::Point(const point &P)
  {
    PX=P.X;
    PY=P.Y;
  }

//.parse

Point::Point(const Rect &R)
  {
    PX=R.X();
    PY=R.Y();
  }

//.parse

Point::Point(const rect &R)
  {
    PX=Min(R.Xmin,R.Xmax);
    PY=Min(R.Ymin,R.Ymax);
  }

//.parse

Point::Point(int X,int Y)
  {
    PX=X;
    PY=Y;
  }

//.parse

void Point::operator=(Point P)
  {
    PX=P.PX;
    PY=P.PY;
  }

//.parse

void Point::operator=(point P)
  {
    PX=P.X;
    PY=P.Y;
  }

//.parse

void Point::operator=(const Rect &R)
  {
    PX=R.X();
    PY=R.Y();
  }

//.parse

void Point::operator=(const rect &R)
  {
    PX=Min(R.Xmin,R.Xmax);
    PY=Min(R.Ymin,R.Ymax);
  }

//.parse

Point Point::operator+(Point P) const
  {
    Point NP;
    NP.PX=PX+P.PX;
    NP.PY=PY+P.PY;
    return NP;
  }

//.parse

Point Point::operator-(Point P) const
  {
    Point NP;
    NP.PX=PX-P.PX;
    NP.PY=PY-P.PY;
    return NP;
  }

//.parse

void Point::operator+=(Point P)
  {
    PX+=P.PX;
    PY+=P.PY;
  }

//.parse

void Point::operator-=(Point P)
  {
    PX-=P.PX;
    PY-=P.PY;
  }

//.parse

Point::operator point() const
  {
    point P;
    P.X=PX;
    P.Y=PY;
    return(P);
  }

//.parse

Bool Point::operator==(Point P) const
  {
    Bool B=((PX==P.PX)&&(PY==P.PY));
    return B;
  }

//.parse

Bool Point::operator!=(Point P) const
  {
    Bool B=((PX!=P.PX)||(PY!=P.PY));
    return B;
  }

//.parse

Rect::Rect()
  {
    RWide=0;
    RHigh=0;
  }

//.parse

Rect::Rect(const Rect &R)
  {
    RXY=R.RXY;
    RWide=R.RWide;
    RHigh=R.RHigh;
  }

//.parse

Rect::Rect(const rect &R)
  {
    RXY=Point(Min(R.Xmin,R.Xmax),Min(R.Ymin,R.Ymax));
    RWide=Abs(R.Xmax-R.Xmin)+1;
    RHigh=Abs(R.Ymax-R.Ymin)+1;
  }

//.parse

Rect::Rect(int X,int Y,int Wide,int High)
  {
    RXY=Point(X,Y);
    RWide=Wide;
    RHigh=High;
  }

//.parse

Rect::Rect(Point P,int Wide,int High)
  {
    RXY=P;
    RWide=Wide;
    RHigh=High;
  }

//.parse

Rect::Rect(Point P1,Point P2)
  {
    RXY=Point(Min(P1.X(),P2.X()),Min(P1.Y(),P2.Y()));
    RWide=Abs(P1.X()-P2.X())+1;
    RHigh=Abs(P1.Y()-P2.Y())+1;
  }

//.parse

Rect::Rect(const Point &P)
  {
    RXY=P;
    RWide=0;
    RHigh=0;
  }

//.parse

Rect Rect::operator+(Point P) const
  {
    Rect R=*this;
    R.RXY+=P;
    return R;
  }

//.parse

Rect Rect::operator-(Point P) const
  {
    Rect R=*this;
    R.RXY+=P;
    return R;
  }

//.parse

void Rect::Adjust(int X,int Y,int Wide,int High)
  {
    RXY+=Point(X,Y);
    RWide+=Wide;
    RHigh+=High;
  }

//.parse

void Rect::operator=(const Rect &R)
  {
    RXY=R.RXY;
    RWide=R.RWide;
    RHigh=R.RHigh;
  }

//.parse

Bool Rect::operator==(const Rect &R) const
  {
    Bool B=((RXY==R.RXY)&&(RWide==R.RWide)&&(RHigh==R.RHigh));
    return B;
  }

//.parse

void Rect::operator=(const rect &R)
  {
    RXY=Point(Min(R.Xmin,R.Xmax),Min(R.Ymin,R.Ymax));
    RWide=Abs(R.Xmax-R.Xmin)+1;
    RHigh=Abs(R.Ymax-R.Ymin)+1;
  }

//.parse

void Rect::Shrink(int L)
  {
    RXY+=Point(L,L);
    RWide-=(L*2);
    RHigh-=(L*2);
  }

//.parse

void Rect::Swell(int L)
  {
    RXY-=Point(L,L);
    RWide+=(L*2);
    RHigh+=(L*2);
  }

//.parse

Rect::operator rect() const
  {
    rect r;
    r.Xmin=XMin();
    r.Xmax=XMax();
    r.Ymin=YMin();
    r.Ymax=YMax();
    return(r);
  }

//.parse

Bool PointOnRect(Point P,Rect R)
  {
    int a,b;
    a=R.Left();
    b=R.Right();
    Bool B=InRange(P.X(),a,b);
    a=R.Top();
    b=R.Bottom();
    B= B && InRange(P.Y(),a,b);
    return B;
  }

#ifdef UseMouse

PreserveMouseHideStatusX::PreserveMouseHideStatusX(Bool OnOrOff)
  {
    int CX,CY,CB;
    QueryCursor(&CX,&CY,&OrigCursorStatus,&CB);
    int I;
    if ((OrigCursorStatus==0)&&(OnOrOff==Off)) HideCursor();
    else if ((OrigCursorStatus<0)&&(OnOrOff==On))
        for (I=OrigCursorStatus;I<0;I++) ShowCursor();
    else if ((OrigCursorStatus<-1)&&(OnOrOff==Off))
        for (I=OrigCursorStatus;I<-1;I++) ShowCursor();
  }

PreserveMouseHideStatusX::~PreserveMouseHideStatusX()
  {
    int CX,CY,CursorStatus,CB;
    QueryCursor(&CX,&CY,&CursorStatus,&CB);
    int I;
    if (CursorStatus>OrigCursorStatus)
        for (I=CursorStatus;I>OrigCursorStatus;I--) HideCursor();
    else if (CursorStatus<OrigCursorStatus)
        for (I=CursorStatus;I<OrigCursorStatus;I++) ShowCursor();
  }

fontRec* FontAlloc(File& F,Long Size)
  {
    fontRec* FontPtr = (fontRec*) new Byte[size_t(Size)];
    if (FontPtr == NULL) return NULL;
    F.Read(FontPtr,Size);
    return FontPtr;
  }

fontRec* FontAlloc(const char* FontName)
  {
    if (!FileExists(FontName)) return NULL;
    File FontFile(FontName,ReadOnly);
    Long FontLen = FontFile.Size();
    return FontAlloc(FontFile,FontLen);
  }

fontRec* FontAlloc(const char* TokenFileName, Word Token)
  {
    if (!TokenExists(TokenFileName,Token)) return NULL;
    TokenFile F(TokenFileName);
    Long Size=F.Seek(Token);
    return FontAlloc(F,Size);
  }

#endif

//.parse

static void ADisp(LogicalWindow& W,char C,int X,int Y)
  {
    if ((X==0)&&(Y==0)) W.ColorBox(2,3,1,1,VAtt(Gray,Black));
    else
      {
        char* S="x";  // makes a one char long string
        S[0]=C;
        W.Display(S,X+2,Y+3,VAtt(X,Y));
      }
  }

static void DrawVert(LogicalWindow& W,
  #ifdef UseGraphics
    Rect& R,
  #endif
    int X,Bool Clear=No)
  {
    #ifdef UseGraphics
      if (Clear) PenColor(W.Att().Background());
      else PenColor(W.Att().Foreground());
      int DX=R.X()+((X+1)*W.GridCellWide())+(W.GridCellWide()/2)-1;
      int Y1=R.Y()+1;
      int Y2=W.DeviceRectA().Top()+(W.GridCellHigh()*2)-1; // Y1+High;
      int Y4=R.Bottom()-1;
      int Y3=W.DeviceRectA().Bottom()-W.GridCellHigh()+1; // Y4-High;
      W.RootWin().DrawLine(DX,Y1,DX,Y2);
      W.RootWin().DrawLine(DX,Y3,DX,Y4);
    #else
      if (Clear)
        {
          W.Display("\0xc4",X,3);
          W.Display("\0xc4",X,W.High()+2);
        }
      else
        {
          W.Display("\0xc2",X,3);
          W.Display("\0xc1",X,W.High()+2);
        }
    #endif
  }

static void DrawHorz(LogicalWindow& W,
  #ifdef UseGraphics
    Rect& R,
  #endif
    int Y,Bool Clear=No)
  {
    #ifdef UseGraphics
      if (Clear) PenColor(W.Att().Background());
      else PenColor(W.Att().Foreground());
      int Wide=W.GridCellWide()-2;
      int DY=R.Y()+((Y+1)*W.GridCellHigh())-1;
      int X1=R.X()+1;
      int X2=X1+Wide;
      int X4=R.Right()-1;
      int X3=X4-Wide;
      W.RootWin().DrawLine(X1,DY,X2,DY);
      W.RootWin().DrawLine(X3,DY,X4,DY);
    #else
      if (Clear)
        {
          W.Display("\0xb3",0,Y);
          W.Display("\0xb3",W.Wide()+1,Y);
        }
      else
        {
          W.Display("\0xc3",0,Y);
          W.Display("\0xb4",W.Wide()+1,Y);
        }
    #endif
  }

KeyType LogicalWindow::EditAtt(VideoAtt& Att,int X, int Y,VideoAtt A)
  {
    #ifdef UseMouse
      PreserveMouseHideStatus(Off);
    #endif
    int BackColors=16;
    #ifdef UseGraphics
      Window W(*this,X,Y,18,19,A);
      Rect R=W.DeviceRectA();
      R.Adjust(0,int(1.5*GridCellHigh()),0,-2*GridCellHigh());
      Root->Draw(R);
    #else
      Att=NoBlink(Att);
      if (Root->BlinkAvail()) BackColors=8;
      Window W(*this,X,Y,18,BackColors+2,A);
      W.DrawLine(0,2,19,2);
      W.Display("\x0c3",0,2);
      W.Display("\x0b4",W.Wide()+1,2);
    #endif
    int B,F;
    For (B,BackColors)
        For(F,16) ADisp(W,'X',F,B);
    W.Display("  Sample Text!  ",Center,1,Att);
    int CurX=FColor(Att);
    int CurY=BColor(Att);
    ADisp(W,'+',CurX,CurY);
    #ifdef UseGraphics
      DrawVert(W,R,CurX);
      DrawHorz(W,R,CurY);
    #else
      DrawVert(W,CurX);
      DrawHorz(W,CurY);
    #endif
    KeyType Key=NullKey;
    VideoAtt OrigAtt=Att;
    while ((Key!=EnterKey)&&(Key!=EscKey))
      {
        Key=WaitForKeypress();
        if (OrigAtt==VAtt(CurX,CurY)) ADisp(W,'O',CurX,CurY);
        else ADisp(W,'X',CurX,CurY);
        switch(Key)
          {
            case ArrowUpKey:
                #ifdef UseGraphics
                  DrawHorz(W,R,CurY,Yes);
                #else
                  DrawHorz(W,CurY,Yes);
                #endif
                if (CurY>0) CurY--;
                else CurY=BackColors-1;
                #ifdef UseGraphics
                  DrawHorz(W,R,CurY);
                #else
                  DrawHorz(W,CurY);
                #endif
                break;
            case ArrowDownKey:
                #ifdef UseGraphics
                  DrawHorz(W,R,CurY,Yes);
                #else
                  DrawHorz(W,CurY,Yes);
                #endif
                if (CurY<BackColors-1) CurY++;
                else CurY=0;
                #ifdef UseGraphics
                  DrawHorz(W,R,CurY);
                #else
                  DrawHorz(W,CurY);
                #endif
                break;
            case ArrowRightKey:
                #ifdef UseGraphics
                  DrawVert(W,R,CurX,Yes);
                #else
                  DrawVert(W,CurX,Yes);
                #endif
                if (CurX<15) CurX++;
                else CurX=0;
                #ifdef UseGraphics
                  DrawVert(W,R,CurX);
                #else
                  DrawVert(W,CurX);
                #endif
                break;
            case ArrowLeftKey:
                #ifdef UseGraphics
                  DrawVert(W,R,CurX,Yes);
                #else
                  DrawVert(W,CurX,Yes);
                #endif
                if (CurX>0) CurX--;
                else CurX=15;
                #ifdef UseGraphics
                DrawVert(W,R,CurX);
                #else
                DrawVert(W,CurX);
                #endif
                break;
          }
        ADisp(W,'+',CurX,CurY);
        W.Display("  Sample Text!  ",Center,1,VAtt(CurX,CurY));
      }
    if (Key==EscKey) Att=OrigAtt;
    else Att=VAtt(CurX,CurY);
    return Key;
  }

