#ifndef WWMenuIncluded
#define WWMenuIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <WW.h>
#include <WWTools.h>

class WWW:public WindowRec
  {
    public:
      WWW(LogicalWindow &LW, int X, int Y, int Wide, int High,
          VideoAtt Att=UseDefaultAtt,const char* Title=NULL):
          WindowRec(LW,X,Y,Wide,High,Att,Title) {}
  };

const int UseCurItem=MaxInt;

class MenuRec
  {
      WWW* MainWindow; // s/b of Window type.  WWW* fixes Glock to MSC prob xxx
      LogicalWindow* TW; // the window for the text stuff
      VertScrollBar* VSBar;
      HorzScrollBar* HSBar;
      #ifdef UseMouse
        Rect ConfirmRect; // used for OrderedMenuRec and MultiMenuRec
      #endif
      char* ConfirmStr;  // ditto
      int CurItem;  //  the item that is currently highlighted
      char** Choices; // the list of possible selections
      void* ExtraStorage;// NULL if unused. For converting char* parm to char*[]
      int NumChoices; //  the number of strings in "Choices"
      Bool Drawn;  // has the menu been drawn for the first time yet?
      Bool DoDBase;  // is this a DBase menu?
      int ConfirmKey;
        //  the key to press to exit and keep the changes
        //  EnterKey with MenuRec, F2 with others
      BitVector OtherExitKeys;  // usually empty.  May have a key or two added
      int SplitLeft; // How much of the left side of the menu may not be scrolled left and right
      int SplitTop; // How much of the top side of the menu may not be scrolled up and down

      virtual void Disp(int ItemNum=UseCurItem, Bool Normal=Yes);
        //  accepts "Highlight" argument
      int TopChoice();
      int TopChoiceRange();
      int MaxTopChoice();
      void SetTopChoice(int TC);
      int LeftColNum();
      int MaxLeftColNum();
      void SetLeftColNum(int L);
      void DrawCurrentSelections();
      int ChoiceToElevatorPos();
      void GoUp();
      void GoDown();
      void GoLeft();
      void GoRight();
      void GoHome();
      void GoEnd();
      int JumpDistance();
      void JumpLeft();
      void JumpRight();
      void DoPageUp();
      void DoPageDown();
      #ifdef UseMouse
        void DoMouseStuff(Point& LastMousePos);
        void ProcessLeftButton(KeyType& Key, Bool& Done);
        void AdjustMousePos();
      #endif
      void AlignTextToChoice();
      virtual void Toggle(Bool& Done){Done=True;}
      KeyType Do();  // returns the exiting keypress
      void Init2(LogicalWindow &ParentWin, int Choice, char** Items,
          const char* Heading, int X, int Y, int Wide, int High,
          VideoAtt VAtt,int ConfKey,const char* ConfStr,int ExtraWidth);
      void Init(LogicalWindow &ParentWin, int Choice, char** Items,
          const char* Heading, int X, int Y, int Wide, int High,
          VideoAtt VAtt,int ConfKey,const char* ConfStr,int ExtraWidth,Bool DoDB=False);
      void Init(LogicalWindow &ParentWin, int Choice, const char* Items,
          const char* Heading, int X, int Y, int Wide, int High,
          VideoAtt VAtt,int ConfKey,const char* ConfStr,int ExtraWidth);
      MenuRec(){} // used for OrderedMenuRec and MultiMenuRec
      friend class OrderedMenuRec;
      friend class MultiMenuRec;
      friend class ColorMenuRec;
      friend class FullColorMenuRec;
      friend class PartyMenuRec;
      friend class PatternMenuRec;
      friend class DBaseMenuRec;
    public:
      MenuRec(LogicalWindow& W, char** Choices,
          const char* Heading=NULL,int Choice=1,int X=Center, int Y=Center,
          int Wide=0, int High=0, VideoAtt Att=UseDefaultAtt);
      MenuRec(LogicalWindow& W,const char* Choices,
          const char* Heading=NULL,int Choice=1,int X=Center, int Y=Center,
          int Wide=0, int High=0, VideoAtt Att=UseDefaultAtt);
      ~MenuRec(){Close();}
      void Close();
      void AddExitKey(KeyType K){OtherExitKeys[K]=On;}
      void AddExitKeys(const KeySetType& KeySet){OtherExitKeys|=KeySet;}
        // Esc is always an exit key.  Enter is an exit key for MenuRec (inherited menu objects too when appropriate)
      void Show();
      KeyType Activate();
      int CurChoice(){return CurItem+1-SplitTop;}
      void Hide(){MainWindow->Hide();}
      int X(){return MainWindow->X();}
      int Y(){return MainWindow->Y();}
        // used in case the X and Y change and you want to have your next menu appear here
      void Split(int SplitLeft,int SplitTop);
  };

typedef void (* VoidFuncMRCharPtr)(MenuRec*,char);  // internal use only
extern VoidFuncMRCharPtr DBaseMenuRecSeekFunc;      // internal use only

const extern char* DefaultConfirmStr;//="F2 - Confirm";

class OrderedMenuRec:public MenuRec
  {
      ByteVector* Order;  // the selection order
      int LastSelected;  //  0..NumChoices:  0= None selected
      int NumWidth;  // passed to "Form" for the width of the order val
      void Disp(int ItemNum=UseCurItem,Bool Normal=Yes);
      void Toggle(Bool& Done);
      void Init(LogicalWindow &ParentWin, ByteVector& Select,
          char** Choices, const char* Heading, int CurItem,
          int X, int Y, int Wide, int High, VideoAtt Att,int ConfirmKey,
          const char* ConfirmStr);
      void Init(LogicalWindow &ParentWin, ByteVector& Select,
          const char* Choices, const char* Heading, int CurItem,
          int X, int Y, int Wide, int High, VideoAtt Att,int ConfirmKey,
          const char* ConfirmStr);
    public:
      OrderedMenuRec(LogicalWindow &ParentWin, ByteVector& Select,
          char** Choices,
          const char* Heading=NULL, int CurItem=1, int X=Center, int Y=Center,
          int Wide=0, int High=0, VideoAtt Att=UseDefaultAtt,int ConfirmKey=F2Key,
          const char* ConfirmStr=DefaultConfirmStr);
      OrderedMenuRec(LogicalWindow &ParentWin, ByteVector& Select,
          const char* Choices,
          const char* Heading=NULL, int CurItem=1, int X=Center, int Y=Center,
          int Wide=0, int High=0, VideoAtt Att=UseDefaultAtt,int ConfirmKey=F2Key,
          const char* ConfirmStr=DefaultConfirmStr);
      KeyType Activate();
      void Show();
  };

class MultiMenuRec:public MenuRec
  {
      BitVector* Selection;  // the selection order
      void Disp(int ItemNum=UseCurItem,Bool Normal=Yes);
      void Toggle(Bool& Done);
    public:
      MultiMenuRec(LogicalWindow &ParentWin, BitVector& Select, char** Choices,
          const char* Heading=NULL, int CurItem=1, int X=Center, int Y=Center,
          int Wide=0, int High=0, VideoAtt Att=UseDefaultAtt,int ConfirmKey=F2Key,
          const char* ConfirmStr=DefaultConfirmStr);
      MultiMenuRec(LogicalWindow &ParentWin, BitVector& Select, const char* Choices,
          const char* Heading=NULL, int CurItem=1, int X=Center, int Y=Center,
          int Wide=0, int High=0, VideoAtt Att=UseDefaultAtt,int ConfirmKey=F2Key,
          const char* ConfirmStr=DefaultConfirmStr);
      KeyType Activate();
  };

class ColorMenuRec:public MenuRec
  {
      void Disp(int ItemNum=UseCurItem,Bool Normal=Yes);
      void Toggle(Bool& Done) {Done=True;}
    public:
      ColorMenuRec(LogicalWindow &ParentWin, int Color=White,
          const char* Heading=NULL, int X=Center, int Y=Center,
          VideoAtt Att=UseDefaultAtt);
  };

class FullColorMenuRec:public MenuRec  //  includes Black
  {
      void Disp(int ItemNum=UseCurItem,Bool Normal=Yes);
      void Toggle(Bool& Done) {Done=True;}
    public:
      FullColorMenuRec(LogicalWindow &ParentWin, int Color=White,
          const char* Heading=NULL, int X=Center, int Y=Center,
          VideoAtt Att=UseDefaultAtt);
  };

class PartyMenuRec:public MenuRec
  {
      int* A;
      void Disp(int ItemNum=UseCurItem,Bool Normal=Yes);
      void Toggle(Bool& Done) {Done=True;}
    public:
      PartyMenuRec(LogicalWindow& ParentWin,char** Choices, int* Atts,
          const char* Heading=NULL, int Choice=1,int X=Center, int Y=Center,
          int Wide=0, int High=0, VideoAtt Att=UseDefaultAtt);
      PartyMenuRec(LogicalWindow& ParentWin,const char* Choices, int* Atts,
          const char* Heading=NULL, int Choice=1,int X=Center, int Y=Center,
          int Wide=0, int High=0, VideoAtt Att=UseDefaultAtt);
  };

#ifdef UseGraphics
class PatternMenuRec:public MenuRec
  {
      ByteVector* Pats;
      void Disp(int ItemNum=UseCurItem,Bool Normal=Yes);
      void Toggle(Bool& Done) {Done=True;}
    public:
      PatternMenuRec(LogicalWindow& ParentWin,ByteVector& Patterns,
          const char* Heading=NULL, int Choice=1,int X=Center, int Y=Center,
          int Wide=0, int High=0, VideoAtt Att=UseDefaultAtt);
  };
#endif

int PartyMenu(LogicalWindow& ParentWin, int& Choice, char** MenuList,
    int Atts[],const char* Title=NULL, int X=Center, int Y=Center,
    int Wide=0,int High=0, VideoAtt Att=UseDefaultAtt);

int PartyMenu(LogicalWindow& ParentWin, int& Choice, const char* MenuList,
    int Atts[],const char* Title=NULL, int X=Center, int Y=Center,
    int Wide=0,int High=0, VideoAtt Att=UseDefaultAtt);

int PatternMenu(LogicalWindow& ParentWin, int& Choice, ByteVector& Patterns,
    const char* Title=NULL, int X=Center, int Y=Center,
    int Wide=0,int High=0, VideoAtt Att=UseDefaultAtt);

#endif
