#include "WWLocal.h"
#pragma hdrstop

// copyright (c) 1992, 1993 by Paul Wheaton

//.parse

void MenuRec::Split(int SL,int ST)
  {
    SplitLeft=SL;
    if (ST)
      {
        SplitTop=ST;
        CurItem+=ST;
        if (CurItem>=NumChoices) CurItem=NumChoices-1;
      }
  }

//.parse

int LogicalWindow::Menu(char** MenuList,const char* Title,
    int X,int Y,int Wide,int High,VideoAtt Att)
  {
    int Choice=1;
    return Menu(Choice,MenuList,Title,X,Y,Wide,High,Att);
  }

//.parse

int LogicalWindow::Menu(const char* MenuList,const char* Title,
    int X,int Y,int Wide,int High,VideoAtt Att)
  {
    int Choice=1;
    return Menu(Choice,MenuList,Title,X,Y,Wide,High,Att);
  }

//.parse

int LogicalWindow::Menu(int& Choice,const char* MenuList,const char* Title,
    int X,int Y,int Wide,int High,VideoAtt Att)
  {
    char** M=ConvertStringToArray(MenuList);
    int C=Menu(Choice,M,Title,X,Y,Wide,High,Att);
    delete M;
    return C;
  }

//.parse

void MenuRec::Init(LogicalWindow &ParentWin, int Choice,char** Items,
    const char* Heading, int X, int Y, int Wide, int High,
    VideoAtt VAtt, int ConfKey,const char* ConfStr,int ExtraWidth,Bool DoDB)
  {
    DoDBase=DoDB;
    ExtraStorage=NULL;
    Init2(ParentWin,Choice,Items,Heading,X,Y,Wide,High,VAtt,ConfKey,ConfStr,ExtraWidth);
  }

//.parse

int StringArrayLen(char** Items)
  {
    int X=0;
    if (Items==NULL) Beep();
    else if (Items[0]==NULL) Beep();
    Bool Done=False;
    while (!Done)
      {
        if (Items[X]==NULL) Done=True;
        else if (Items[X][0]=='\0') Done=True;
        else X++;
        // check both that the pointer is not null and the string is not empty
      }
    return X;
  }

//.parse

int ArrayLen(void** Items)
  {
    int X=0;
    while(Items[X]!=NULL) X++;
    return X;
  }

//.parse

void MenuRec::Init(LogicalWindow &ParentWin, int Choice,const char* Items,
    const char* Heading, int X, int Y, int Wide, int High,
    VideoAtt VAtt, int ConfKey,const char* ConfStr,int ExtraWidth)
  {
    char** M=ConvertStringToArray(Items);
    ExtraStorage=M;
    DoDBase=False;
    Init2(ParentWin,Choice,M,Heading,X,Y,Wide,High,VAtt,ConfKey,ConfStr,ExtraWidth);
  }

//.parse

int LogicalWindow::Menu(int& Choice,char** MenuList,const char* Title,
    int X,int Y,int Wide,int High,VideoAtt Att)
  {
    PreserveDevice();
    Touch();
    #ifdef UseMouse
      Mouse();
    #endif
    MenuRec M(*this,MenuList,Title,Choice,X,Y,Wide,High,Att);
    M.Show();
    KeyType Key=M.Activate();
    Choice=M.CurChoice();
    if (Key==EscKey) Choice=0;
    return Choice;
  }

//.parse

void MenuRec::Show()
  {
    PreserveDevice();
    #ifdef UseMouse
      PreserveMouseHideStatus(Off);
    #endif
    #ifdef UseGraphics
      PreservePenState();
    #endif
    MainWindow->Show();
    if (!Drawn)
      {
        Drawn=True;
        AlignTextToChoice();
        if (VSBar) VSBar->Show();
        if (HSBar) HSBar->Show();
        if (ConfirmStr!=NULL)
          {
            #ifdef UseGraphics
              LogicalWindow CWin(*MainWindow,1,MainWindow->High()-1,
                                 MainWindow->Wide(),2);
              CWin.Display(ConfirmStr,Center,Center);
              ConfirmRect=Rect(Point(CWin.DeviceRect()),
                               MainWindow->DeviceWide(),TW->GridCellHigh());
              ConfirmRect.Adjust(TW->GridCellWide()/2,TW->GridCellHigh()/2,-(TW->GridCellWide()));
              ConfirmRect.Swell(3);
              MainWindow->DrawBeveledRect(ConfirmRect,TW->Att());
            #else
              MainWindow->Display(ConfirmStr,Center,Bottom);
              int Y=MainWindow->High()-1;
              MainWindow->Display(StringOf(MainWindow->Wide(),196),1,Y);
              MainWindow->Display("\xc3",0,Y);
              MainWindow->Display("\xb4",MainWindow->Wide()+1,Y);
            #endif
            delete ConfirmStr;
            ConfirmStr=NULL;
          }
        #ifdef UseMouse
          else ConfirmRect.SetWide(0);
        #endif
      }
  }

//.parse

void MenuRec::Init2(LogicalWindow &ParentWin, int Choice,char** Items,
    const char* Heading, int X, int Y, int Wide, int High,
    VideoAtt VAtt, int ConfKey,const char* ConfStr,int ExtraWidth)
  {
    PreserveDevice();
    ParentWin.Touch();
    if (!DoDBase) NumChoices=StringArrayLen(Items);
    ConfirmKey=ConfKey;
    CurItem=Choice;
    if (CurItem>0) CurItem--;
    SplitLeft=0;
    SplitTop=0;
    Choices=&Items[0];
    // establish window heights excepting scroll bars
    int MaxMenuHigh=ParentWin.Root->High()-3;
      // lines in screen - 1 line for menu border - 2 lines for top and bot line of screen
    if ((Heading!=NULL)&&(Heading[0]=='\0')) Heading=NULL;
    if (Heading!=NULL) MaxMenuHigh-=2;
    Bool ConfirmButton=((ConfStr!=NULL)&&(ConfStr[0]!=0));
    if (ConfirmButton) MaxMenuHigh-=2;
    int TextHigh=Min(MaxMenuHigh,NumChoices);
    if ((High!=0) && (High<TextHigh)) TextHigh=High;
    else High=TextHigh;
    // establish window widths excepting scroll bars
    int ItemWidth = 0; // will be the widest menu choice
    if (DoDBase) ItemWidth=Wide;
    else
      {
        int I;
        For(I,NumChoices) ItemWidth=Max(ItemWidth,int(strlen(Choices[I])));
      }
    if (Wide==0) Wide = ItemWidth;
    if (ExtraWidth) Wide+=ExtraWidth+1;
    #ifdef UseGraphics
      int MaxMenuWide=ParentWin.Root->Wide()-1; // cols in screen -1 for win borders
    #else
      int MaxMenuWide=ParentWin.Root->Wide()-2; // cols in screen -2 for win borders
    #endif
    if (Wide>MaxMenuWide) Wide=MaxMenuWide;
    int TextWide=Wide;
    // make adjustments for vertical scroll bar
    Bool VScrolling=(NumChoices>TextHigh);
    if (VScrolling)
      {
        #ifdef UseGraphics
          Wide+=3;
        #else
          Wide+=2;
        #endif
        if (Wide>MaxMenuWide)
          {
            Wide=MaxMenuWide;
            #ifdef UseGraphics
              TextWide=Wide-3;
            #else
              TextWide=Wide-2;
            #endif
          }
      }
    // make adjustments for horizontal scroll bar
    Bool HScrolling=(ItemWidth>TextWide);
    if (HScrolling)
      {
        #ifdef UseGraphics
          High+=2;
        #else
          High+=1;
        #endif
        if (High>MaxMenuHigh)
          {
            High=MaxMenuHigh;
            #ifdef UseGraphics
              TextHigh=High-2;
            #else
              TextHigh=High-1;
            #endif
            if ((!VScrolling)&&(NumChoices>TextHigh))
              {
                VScrolling=True;
                #ifdef UseGraphics
                  Wide+=3;
                #else
                  Wide+=2;
                #endif
                if (Wide>MaxMenuWide)
                  {
                    Wide=MaxMenuWide;
                    #ifdef UseGraphics
                      TextWide=Wide-3;
                    #else
                      TextWide=Wide-2;
                    #endif
                  }
              }
          }
      }
    int TextX=1;
    if (ConfirmButton)
      {
        int CSLen=strlen(ConfStr);
        ConfirmStr=new char[CSLen+1];
        strcpy(ConfirmStr,ConfStr);
        int ButtonWide=CSLen+2;
        if (ButtonWide>Wide)
          {
            int OldWide=Wide;
            Wide=Min(ButtonWide,MaxMenuWide);
            if (ButtonWide>Wide) ConfirmStr[Wide-2]='\0';
            if (OldWide!=Wide) TextX+=((Wide-OldWide)/2);
          }
        High+=2;
      }
    else ConfirmStr=NULL;
    if (VAtt==UseDefaultAtt) VAtt=ParentWin.MenuAtt();
    MainWindow=new WWW(ParentWin,X,Y,Wide,High,VAtt,Heading);
    TW=new LogicalWindow(*MainWindow,TextX,1,TextWide,TextHigh);
    if (CurItem>=NumChoices) CurItem=NumChoices-1;
    if (HScrolling) HSBar=new HorzScrollBar(*TW,ItemWidth-TW->Wide()+1);
    else HSBar=NULL;
    if (VScrolling) VSBar=new VertScrollBar(*TW,NumChoices-TW->High()+1);
    else VSBar=NULL;
    Drawn=False;
  }

//.parse

const char* DefaultConfirmStr="F2 - Confirm";

//.parse

void MenuRec::GoUp()
  {
    if ((VSBar) && (CurItem==SplitTop)) return;
    Disp();
    if (CurItem==SplitTop) CurItem=TW->High()-1;
    else if (CurItem==TopChoice())
      {
        if (SplitTop)
          {
            LogicalWindow W(*TW,1,SplitTop+1,TW->Wide(),TW->High()-SplitTop);
            W.ScrollDown();
          }
        else TW->ScrollDown();
        CurItem--;
        SetTopChoice(TopChoice()-1);
      }
    else CurItem--;
    Disp(UseCurItem,Highlight);
  }

void MenuRec::GoDown()
  {
    if ((CurItem==NumChoices-1) && (VSBar)) return;
    Disp();
    if (CurItem==NumChoices-1) CurItem=SplitTop;
    else if (CurItem==TopChoice()-SplitTop+(TW->High())-1)
      {
        if (SplitTop)
          {
            LogicalWindow W(*TW,1,SplitTop+1,TW->Wide(),TW->High()-SplitTop);
            W.ScrollUp();
          }
        else TW->ScrollUp();
        CurItem++;
        SetTopChoice(TopChoice()+1);
      }
    else CurItem++;
    Disp(UseCurItem,Highlight);
  }

void MenuRec::DoPageUp()
  {
    if (CurItem==SplitTop) return;
    if (VSBar)
      {
        int H=(TW->High())-SplitTop; // height of movable win
        if ( TopChoice() >= H ) // jump a full windows worth
          {
            SetTopChoice(TopChoice()-H);
            CurItem-=H;
          }
        else if (TopChoice()==SplitTop) CurItem=SplitTop;
        else
          {
            CurItem-=(TopChoice()-SplitTop);
            SetTopChoice(SplitTop);
          }
        DrawCurrentSelections();
      }
    else
      {
        Disp();
        CurItem=SplitTop;
      }
    Disp(UseCurItem,Highlight);
  }

void MenuRec::DoPageDown()
  {
    if (CurItem==NumChoices-1) return;
    if (VSBar)
      {
        int H=(TW->High())-SplitTop; // height of movable win
        if ( TopChoice()+H <(TopChoiceRange()+SplitTop))
          {
            SetTopChoice(TopChoice()+H);
            CurItem+=H;
          }
        else if (TopChoice()-SplitTop==TopChoiceRange()-1) CurItem=NumChoices-1;
        else
          {
            int Offset=TopChoiceRange()+SplitTop-1-TopChoice();
            CurItem+=Offset;
            SetTopChoice(TopChoice()+Offset);
          }
        DrawCurrentSelections();
      }
    else
      {
        Disp();
        CurItem=NumChoices-1;
      }
    Disp(UseCurItem,Highlight);
  }

void MenuRec::GoHome()
  {
    if (CurItem==SplitTop) return;
    if (TopChoice()==SplitTop) Disp();
    else
      {
        SetTopChoice(SplitTop);
        DrawCurrentSelections();
      }
    CurItem=SplitTop;
    Disp(UseCurItem,Highlight);
  }

void MenuRec::GoEnd()
  {
    if (CurItem==NumChoices-1) return;
    if (TopChoice()==MaxTopChoice())
      {
        Disp();
        CurItem=NumChoices-1;
      }
    else
      {
        SetTopChoice(MaxTopChoice());
        CurItem=NumChoices-1;
        DrawCurrentSelections();
      }
    Disp(UseCurItem,Highlight);
  }

void MenuRec::GoLeft()
  {
    if (LeftColNum()==0) return;
    SetLeftColNum(LeftColNum()-1);
    DrawCurrentSelections();
    Disp(UseCurItem,Highlight);
  }

void MenuRec::GoRight()
  {
    if (LeftColNum()==MaxLeftColNum()) return;
    SetLeftColNum(LeftColNum()+1);
    DrawCurrentSelections();
    Disp(UseCurItem,Highlight);
  }

//.parse

int MenuRec::JumpDistance()
  {
    int D=int(Round(double(TW->Wide())*0.15));
    return D;
  }

//.parse

void MenuRec::JumpLeft()
  {
    if (LeftColNum()==0) return;
    int NewLeft=int(SLong(LeftColNum())-JumpDistance());
    if (NewLeft<0) NewLeft=0;
    SetLeftColNum(NewLeft);
    DrawCurrentSelections();
    Disp(UseCurItem,Highlight);
  }

//.parse

void MenuRec::JumpRight()
  {
    if (LeftColNum()==MaxLeftColNum()) return;
    int NewLeft=LeftColNum()+JumpDistance();
    if (NewLeft>MaxLeftColNum()) NewLeft=MaxLeftColNum();
    SetLeftColNum(NewLeft);
    DrawCurrentSelections();
    Disp(UseCurItem,Highlight);
  }

#ifdef UseMouse

  void MenuRec::DoMouseStuff(Point& LastMousePos)
    {
      Point MP=TW->RootWin().DeviceMousePos();
      if (MP!=LastMousePos)
        {
          if (PointOnRect(MP,TW->DeviceRectA()))
            {
              Point LMP=MP-Point(TW->DeviceRectA()); // LocalMousePos
              int Row=LMP.Y()/TW->GridCellHigh()+1;
              if (Row>SplitTop)
                {
                  int OldRow=CurItem-TopChoice()+1+SplitTop;
                  if (Row!=OldRow)
                    {
                      Disp();
                      CurItem=TopChoice()+Row-1-SplitTop;
                      Disp(UseCurItem,Highlight);
                    }
                }
            }
          LastMousePos=MP;
        }
    }

  void MenuRec::ProcessLeftButton(KeyType& Key, Bool& Done)
    {
      if (!Done)
        {
          if (PointOnRect(Key.MousePos(),TW->DeviceRectA()))
            {
              Point LMP=Key.MousePos()-Point(TW->DeviceRectA()); // LocalMousePos
              int Row=LMP.Y()/TW->GridCellHigh()+1;
              if (Row>SplitTop)
                {
                  CurItem=TopChoice()+Row-1-SplitTop;
                  Toggle(Done);
                }
            }
          else if (PointOnRect(Key.MousePos()-Point(MainWindow->DeviceRectA()),ConfirmRect))
            {
              Done=True;
              Key=ConfirmKey;
            }
          else if ((HSBar)&&(HSBar->Test(Key)))
            {
              DrawCurrentSelections();
              Disp(UseCurItem,Highlight);
            }
          else
            {
              int Offset=CurItem-TopChoice();
              if ((VSBar)&&(VSBar->Test(Key)))
                {
                  DrawCurrentSelections();
                  CurItem=TopChoice()+Offset;
                  Disp(UseCurItem,Highlight);
                }
            }
        }
    }

  void MenuRec::AdjustMousePos()
    {
      TW->SetMousePos(Point(TW->Wide(),CurItem-TopChoice()+SplitTop+1));
      //MoveCursor(TW->DeviceRectA().Right()-(TW->GridCellWide()/2),
      //           TW->DeviceYA()+((CurItem-TopChoice())*TW->GridCellHigh())+TW->GridCellHigh()/2);
    }

#endif

//.parse

void MenuRec::AlignTextToChoice()
  {
    int T=int(CurItem)-int((TW->High()-SplitTop)/2);  // T is new Top
    if (T<SplitTop) T=SplitTop;
    else if (T>MaxTopChoice()) T=MaxTopChoice();
    SetTopChoice(T);
    DrawCurrentSelections();
    Disp(UseCurItem,Highlight);
    #ifdef UseMouse
      AdjustMousePos();
    #endif
  }

#ifdef UseMouse

  void TestForExit(Bool& Done, KeyType& Key)
    {
      if (Key.BothMouseButtonsDown())
        {
          Done=True;
          WaitForMouseClear();
          Key=EscKey;
        }
    }

#endif

//.parse

VoidFuncMRCharPtr DBaseMenuRecSeekFunc;

KeyType MenuRec::Do()
  {
    #ifdef UseMouse
      AdjustMousePos();
      PreserveMouseHideStatus(On);
    #endif
    #ifdef UseGraphics
      PreservePenState();
    #endif
    #ifdef UseMouse
      Point LastMousePos=TW->DeviceMousePos();
    #endif
    Bool Done = False;
    KeyType Key;
    while(!Done)
      {
        if (KeyPressed())
          {
            #ifdef UseMouse
              HideCursor();
            #endif
            Key=GetKey();
            int K=Key;
            if (InRange(K,int(' '),int('~')))
              {
                if (DoDBase) (*DBaseMenuRecSeekFunc)(this,ToUpper(K));
                else
                  {
                    int I=(CurItem+1)%NumChoices;
                    if (I<SplitTop) I=SplitTop;
                    while ((I!=CurItem)&&((ToUpper(Choices[I][0]))!=(ToUpper(K))))
                      {
                        I=(I+1)%NumChoices;
                        if (I<SplitTop) I=SplitTop;
                      }
                    if (I!=CurItem)
                      {
                        CurItem=I;
                        AlignTextToChoice();
                      }
                  }
              }
            else if (Key==ConfirmKey) Done=True;
            else if (OtherExitKeys(Key)) Done=True;
            else switch (K)
              {
                #ifdef UseMouse
                  case LeftMouseButtonUp: ProcessLeftButton(Key,Done); break;
                #endif
                case ArrowUpKey: GoUp(); break;
                case ArrowDownKey: GoDown(); break;
                case ArrowLeftKey: GoLeft(); break;
                case ArrowRightKey: GoRight(); break;
                case CtrlArrowLeftKey: JumpLeft(); break;
                case CtrlArrowRightKey: JumpRight(); break;
                case PageUpKey: DoPageUp(); break;
                case PageDownKey: DoPageDown(); break;
                case HomeKey: GoHome(); break;
                case EndKey: GoEnd(); break;
                case EnterKey: Toggle(Done); break;
                case EscKey: Done=True; break;
                #ifdef UseMouse
                  case RightMouseButtonDown:
                  case LeftMouseButtonDown: TestForExit(Done,Key); break;
                #endif
              }
            if (Key==EscKey) Done=True;
            #ifdef UseMouse
              ShowCursor();
            #endif
          }
        #ifdef UseMouse
          else DoMouseStuff(LastMousePos);
        #endif
      }
    return Key;
  }

//.parse

KeyType MenuRec::Activate()
  {
    PreserveDevice();
    TW->Touch();
    #ifdef UseMouse
      TW->Mouse();
    #endif
    if (NumChoices==0)
      {
        TW->RootWin().DialogBox("no menu selections");
        KeyType K=EscKey;
        return K;
      }
    else
      {
        Show();
        return Do();
      }
  }

//.parse

void MultiMenuRec::Toggle(Bool& Done)
  {
    Done=Done;  // supresses warning about not using Done
    (*Selection)[CurItem]=!(Selection->At(CurItem));
    Disp(UseCurItem,Highlight);
  }

//.parse

KeyType MultiMenuRec::Activate()
  {
    PreserveDevice();
    TW->Touch();
    #ifdef UseMouse
      TW->Mouse();
    #endif
    BitVector OrigSelection=*Selection;
    KeyType Key=Do();
    Bool Peachy=Bool(Key!=EscKey);
    if (ConfirmKey==EscKey) Peachy=True;
    if (!Peachy) *Selection=OrigSelection;
    return(Key);
  }

//.parse

MultiMenuRec::MultiMenuRec(LogicalWindow &ParentWin, BitVector& Select,
    char** Items, const char* Heading, int CItem,
    int X, int Y, int Wide, int High, VideoAtt VAtt,int ConfKey,
    const char* ConfirmStr):MenuRec()
  {
    Init(ParentWin,CItem,Items,Heading,X,Y,Wide,High,VAtt,
        ConfKey,ConfirmStr,2);
    Selection=&Select;
  }

//.parse

MultiMenuRec::MultiMenuRec(LogicalWindow &ParentWin, BitVector& Select,
    const char* Items, const char* Heading, int CItem,
    int X, int Y, int Wide, int High, VideoAtt VAtt,int ConfKey,
    const char* ConfirmStr):MenuRec()
  {
    Init(ParentWin,CItem,Items,Heading,X,Y,Wide,High,VAtt,
        ConfKey,ConfirmStr,2);
    Selection=&Select;
  }

//.parse

Bool LogicalWindow::MultiMenu(BitVector& Select,const char* MenuList,const char* Title,
    int FirstChoice,int X,int Y,int Wide,int High,VideoAtt Att,
    int ConfirmKey, const char* ConfirmStr)
  {
    char** M=ConvertStringToArray(MenuList);
    Bool B=MultiMenu(Select,M,Title,FirstChoice,X,Y,Wide,High,Att,ConfirmKey,ConfirmStr);
    delete M;
    return B;
  }

//.parse

Bool LogicalWindow::MultiMenu(BitVector& Select, char** MenuList,const char* Title,
    int FirstChoice,int X,int Y,int Wide,int High,VideoAtt Att,
    int ConfirmKey, const char* ConfirmStr)
  {
    PreserveDevice();
    Touch();
    #ifdef UseMouse
      Mouse();
    #endif
    MultiMenuRec M(*this,Select,MenuList,Title,FirstChoice,X,Y,Wide,High,
            Att,ConfirmKey,ConfirmStr);
    M.Show();
    KeyType Key=M.Activate();
    return Bool(Key==ConfirmKey);
  }

//.parse

void MultiMenuRec::Disp(int ItemNum,Bool Normal)
  {
    if (ItemNum==UseCurItem) ItemNum=CurItem;
    int Y=int(ItemNum-TopChoice()+1);
    Bool Selected=Selection->At(ItemNum);
    TW->Display(LeftText(&Choices[ItemNum][LeftColNum()],TW->Wide()-2),3,Y,
                TW->NoBlink(Normal?TW->Att():ReverseAtt(TW->Att())));
    #ifdef UseGraphics
      Rect R(int(TW->GridCellWide()/4)+TW->DeviceXA()-1,
             int(Y-1)*(TW->GridCellHigh())+(TW->GridCellHigh())/5+TW->DeviceYA(),
             (TW->GridCellWide())*3/2,(TW->GridCellHigh())*3/4);
      PreservePenState();
      TW->RootWin().DrawBeveledRect(R,TW->Att(),!Selected);
      PenColor(ForeColor(TW->Att()));
      BackColor(BackColor(TW->Att()));
      if (Selected)
        {
          rect r=R;
          FillRect(&r,3);
        }
      else TW->RootWin().Fill(R);
    #else
      TW->Display((Selected?"x":"\07"),1,Y,TW->Att());
    #endif
  }

//.parse

OrderedMenuRec::OrderedMenuRec(LogicalWindow &ParentWin, ByteVector& Select,
    char** Items, const char* Heading, int CItem,
    int X, int Y, int Wide, int High, VideoAtt VAtt,int ConfKey,
    const char* ConfirmStr):MenuRec()
  {
    Init(ParentWin,Select,Items,Heading,CItem,X,Y,Wide,High,VAtt,
               ConfKey,ConfirmStr);
  }

//.parse

OrderedMenuRec::OrderedMenuRec(LogicalWindow &ParentWin, ByteVector& Select,
    const char* Items, const char* Heading, int CItem,
    int X, int Y, int Wide, int High, VideoAtt VAtt,int ConfKey,
    const char* ConfirmStr):MenuRec()
  {
    Init(ParentWin,Select,Items,Heading,CItem,X,Y,Wide,High,VAtt,
               ConfKey,ConfirmStr);
  }

//.parse

Bool LogicalWindow::OrderedMenu(ByteVector& Select,const char* MenuList,const char* Title,
    int FirstChoice,int X,int Y,int Wide,int High,VideoAtt Att,
    int ConfirmKey,const char* ConfirmStr)
  {
    char** M=ConvertStringToArray(MenuList);
    Bool B=OrderedMenu(Select,M,Title,FirstChoice,X,Y,Wide,High,Att,ConfirmKey,ConfirmStr);
    delete M;
    return B;
  }

//.parse

void OrderedMenuRec::Disp(int ItemNum,Bool Normal)
  {
    if (ItemNum==UseCurItem) ItemNum=CurItem;
    int Y=int(ItemNum-TopChoice()+1);
    VideoAtt A=TW->NoBlink(Normal?(TW->Att()):(ReverseAtt(TW->Att())));
    String S1;
    if (ItemNum>=LastSelected) S1=Spaces(NumWidth);
    else S1=Form(NumWidth,ItemNum+1);
    String S2=LeftText(&Choices[(*Order)(ItemNum)-1][LeftColNum()],TW->Wide()-NumWidth-1);
    TW->Display(S1+' '+S2,1,Y,A);
  }

//.parse

Bool LogicalWindow::OrderedMenu(ByteVector& Select, char** MenuList,const char* Title,
    int FirstChoice,int X,int Y,int Wide,int High,VideoAtt Att,
    int ConfirmKey,const char* ConfirmStr)
  {
    PreserveDevice();
    Touch();
    #ifdef UseMouse
      Mouse();
    #endif
    OrderedMenuRec M(*this,Select,MenuList,Title,FirstChoice,X,Y,Wide,High,
            Att,ConfirmKey,ConfirmStr);
    M.Show();
    return (M.Activate()==ConfirmKey);
  }

//.parse

void OrderedMenuRec::Show()
  {
    if (!Drawn)
      {
        PreserveDevice();
        TW->Touch();
        #ifdef UseMouse
          TW->Mouse();
        #endif
        ByteVector OrigOrder=*Order;
        LastSelected=int(Order->Size());
        BitVector B;
        int I;
        For(I,LastSelected) B[(*Order)(I)-1]=1;
        For(I,NumChoices)
            if (!B(I)) (*Order)+=I+1;
        MenuRec::Show();
        *Order=OrigOrder;
      }
    else MenuRec::Show();
  }

//.parse

void OrderedMenuRec::Toggle(Bool& Done)
  {
    Done=Done; // eliminates warning
    int B=(*Order)(CurItem);
    Order->Delete(CurItem);
    if (CurItem>=LastSelected)
      {
        Order->Insert(B,LastSelected);
        if ((VSBar) && (TopChoice()+1>TopChoiceRange()))
            SetTopChoice(TopChoiceRange()-1);
        LastSelected++;
      }
    else
      {
        LastSelected--;
        Order->Insert(B,LastSelected);
      }
    DrawCurrentSelections();
    Disp(UseCurItem,Highlight);
  }

//.parse

KeyType OrderedMenuRec::Activate()
  {
    PreserveDevice();
    TW->Touch();
    #ifdef UseMouse
      TW->Mouse();
    #endif
    ByteVector OrigOrder=*Order;
    LastSelected=int(Order->Size());
    BitVector B;
    int I;
    For(I,LastSelected) B[(*Order)(I)-1]=1;
    For(I,NumChoices)
        if (!B(I)) (*Order)+=I+1;
    KeyType Key=Do();
    Bool Peachy=(Key!=EscKey);
    if (ConfirmKey==EscKey) Peachy=True;
    if (Peachy) *Order=Order->Before(LastSelected);
    else *Order=OrigOrder;
    return(Key);
  }

//.parse

void OrderedMenuRec::Init(LogicalWindow &ParentWin, ByteVector& Select,
    char** Items, const char* Heading, int CItem,
    int X, int Y, int Wide, int High, VideoAtt VAtt,int ConfKey,
    const char* ConfirmStr)
  {
    int NChoices=StringArrayLen(Items);
    if (NChoices>9999) NumWidth=6; // "10,000"
    else if (NChoices>999) NumWidth=4; // "1000"
    else if (NChoices>99) NumWidth=3;
    else if (NChoices>9) NumWidth=2;
    else NumWidth=1;
    Order=&Select;
    MenuRec::Init(ParentWin,CItem,Items,Heading,X,Y,Wide,High,VAtt,
        ConfKey,ConfirmStr,NumWidth);
  }

//.parse

void OrderedMenuRec::Init(LogicalWindow &ParentWin, ByteVector& Select,
    const char* Items, const char* Heading, int CItem,
    int X, int Y, int Wide, int High, VideoAtt VAtt,int ConfKey,
    const char* ConfirmStr)
  {
    int NChoices=1;
    char* ptr=(char*)Items;
    while ((ptr=strchr(ptr,'|'))!=NULL) NChoices++;
    if (NChoices>9999) NumWidth=6; // "10,000"
    else if (NChoices>999) NumWidth=4; // "1000"
    else if (NChoices>99) NumWidth=3;
    else if (NChoices>9) NumWidth=2;
    else NumWidth=1;
    Order=&Select;
    MenuRec::Init(ParentWin,CItem,Items,Heading,X,Y,Wide,High,VAtt,
        ConfKey,ConfirmStr,NumWidth);
  }

#ifdef UseGraphics

  PatternMenuRec::PatternMenuRec(LogicalWindow &ParentWin, ByteVector& Patterns,
      const char* Heading, int Choice,int X, int Y,
      int Wide, int High, VideoAtt Att):MenuRec()
    {
      Pats=&Patterns;
      if (Wide==0) Wide=20;
      String S=StringOf(Wide,' ')+'|';
      int I;
      For(I,Pats->Size()-2) S+=" |";
      S+=' ';
      MenuRec::Init(ParentWin,Choice,ConstCharPtrType(S),Heading,X,Y,Wide,High,Att,EnterKey,NULL,0);
    }

  void PatternMenuRec::Disp(int ItemNum,Bool Normal)
    {
      if (ItemNum==UseCurItem) ItemNum=CurItem;
      VideoAtt A=TW->Att();
      if (!Normal) A=ReverseAtt(A);
      A=NoBlink(A);
      int Y=int(ItemNum-TopChoice()+1);
      TW->Display(" ",1,Y,A);
      TW->Display(" ",TW->Wide(),Y,A);
      PreservePenState();
      PenPattern((*Pats)(ItemNum));
      TW->ColorBox(2,Y,TW->Wide()-2,1,A);
    }

  int PatternMenu(LogicalWindow& ParentWin, int& Choice, ByteVector& Patterns,
      const char* Title, int X, int Y, int Wide,int High, VideoAtt Att)
    {
      PatternMenuRec M(ParentWin,Patterns,Title,Choice,X,Y,Wide,High,Att);
      M.Show();
      KeyType Key=M.Activate();
      Choice=M.CurChoice();
      if (Key==EscKey) return 0;
      else return Choice;
    }

#endif

//.parse

void ColorMenuRec::Disp(int ItemNum,Bool Normal)
  {
    if (ItemNum==UseCurItem) ItemNum=CurItem;
    VideoAtt A=ItemNum+1;
    A=TW->NoBlink(Normal?(A):(ReverseAtt(A)));
    TW->Display(LeftText(&Choices[ItemNum][LeftColNum()],TW->Wide()),1,ItemNum+1,A);
  }

//.parse

int LogicalWindow::ColorMenu(int Color,const char *Heading,
    int X, int Y,VideoAtt Att)
  {
    Root->Touch();
    ColorMenuRec M(*this,Color,Heading,X,Y,Att);
    M.Show();
    KeyType Key=M.Activate();
    if (Key==EscKey) return 0;
    else return M.CurChoice();
  }

//.parse

ColorMenuRec::ColorMenuRec(LogicalWindow &ParentWin, int Color,
    const char* Heading, int X, int Y, VideoAtt Att):MenuRec()
  {
    static char* Items="Blue|Green|Blue Green|Red|Purple|Brown|Gray|Dark Gray|"
        "Light Blue|Light Green|Light Blue Green|Light Red|Light Purple|Yellow|"
        "White";
    Init(ParentWin,Color%16,Items,Heading,X,Y,0,0,Att,EnterKey,NULL,0);
  }

//.parse

void FullColorMenuRec::Disp(int ItemNum,Bool Normal)
  {
    if (ItemNum==UseCurItem) ItemNum=CurItem;
    VideoAtt A=ItemNum+1;
    if (ItemNum==16) A=VAtt(Black,Gray);
    A=TW->NoBlink(Normal?(A):(ReverseAtt(A)));
    TW->Display(LeftText(&Choices[ItemNum][LeftColNum()],TW->Wide()),1,ItemNum+1,A);
  }

//.parse

FullColorMenuRec::FullColorMenuRec(LogicalWindow &ParentWin, int Color,
    const char* Heading, int X, int Y, VideoAtt Att):MenuRec()
  {
    static char* Items="Blue|Green|Blue Green|Red|Purple|Brown|Gray|Dark Gray|"
        "Light Blue|Light Green|Light Blue Green|Light Red|Light Purple|Yellow|"
        "White|Black";
    Init(ParentWin,Color%17,Items,Heading,X,Y,0,0,Att,EnterKey,NULL,0);
  }

//.parse

PartyMenuRec::PartyMenuRec(LogicalWindow &ParentWin, char** Choices,
    int* Atts, const char* Heading, int Choice,int X, int Y,
    int Wide, int High, VideoAtt Att):MenuRec()
  {
    A=Atts;
    MenuRec::Init(ParentWin,Choice,Choices,Heading,X,Y,Wide,High,Att,EnterKey,NULL,0);
  }

//.parse

PartyMenuRec::PartyMenuRec(LogicalWindow &ParentWin, const char* Choices,
    int* Atts, const char* Heading, int Choice,int X, int Y,
    int Wide, int High, VideoAtt Att):MenuRec()
  {
    A=Atts;
    MenuRec::Init(ParentWin,Choice,Choices,Heading,X,Y,Wide,High,Att,EnterKey,NULL,0);
  }

//.parse

int PartyMenu(LogicalWindow& ParentWin, int& Choice, const char* MenuList,
    int Atts[], const char* Title, int X, int Y,
    int Wide,int High, VideoAtt Att)
  {
    char** M=ConvertStringToArray(MenuList);
    int C=PartyMenu(ParentWin,Choice,M,Atts,Title,X,Y,Wide,High,Att);
    delete M;
    return C;
  }

//.parse

int PartyMenu(LogicalWindow& ParentWin, int& Choice, char** MenuList,
    int Atts[], const char* Title, int X, int Y,
    int Wide,int High, VideoAtt Att)
  {
    PartyMenuRec M(ParentWin,MenuList,Atts,Title,Choice,X,Y,Wide,High,Att);
    M.Show();
    KeyType Key=M.Activate();
    Choice=M.CurChoice();
    if (Key==EscKey) return 0;
    else return Choice;
  }

//.parse

void PartyMenuRec::Disp(int ItemNum,Bool Normal)
  {
    int Y;
    if (ItemNum<SplitTop) Y=ItemNum+1;
    else
      {
        if (ItemNum==UseCurItem) ItemNum=CurItem;
        Y=int(ItemNum-TopChoice()+1+SplitTop);
      }
    VideoAtt Att=A[ItemNum];
    if (!Normal) Att=ReverseAtt(Att);
    Att=TW->NoBlink(Att);
    if (SplitLeft) TW->Display(LeftText(Choices[ItemNum],SplitLeft),1,Y,Att);
    TW->Display(LeftText(&Choices[ItemNum][LeftColNum()+SplitLeft],TW->Wide()-SplitLeft),1+SplitLeft,Y,Att);
  }

//.parse

int MenuRec::LeftColNum()
  {
    if (HSBar) return HSBar->CurStep();
    return 0;
  }

//.parse

int MenuRec::TopChoiceRange()
  {
    if (VSBar) return VSBar->CurStepRange();
    return 0;
  }

//.parse

int MenuRec::MaxLeftColNum()
  {
    if (HSBar) return HSBar->CurStepRange()-1;
    return 0;
  }

//.parse

int MenuRec::TopChoice()
  {
    if (VSBar) return ((VSBar->CurStep())+SplitTop);
    return SplitTop;
  }

//.parse

void MenuRec::SetLeftColNum(int L)
  {
    if (HSBar)
        if (L<=MaxLeftColNum()) HSBar->SetStep(L);
  }

//.parse

int MenuRec::MaxTopChoice()
  {
    if (VSBar)
      {
        int MT=TopChoiceRange()+SplitTop-1;
        return MT;
      }
    else return 0;
  }

//.parse

void MenuRec::DrawCurrentSelections()
  {
    int Stop=TopChoice()+TW->High()-SplitTop;
    int I;
    if (SplitTop) For(I,SplitTop) Disp(I);
    for(I=TopChoice(); I<Stop;I++) Disp(I);
  }

//.parse

MenuRec::MenuRec(LogicalWindow &ParentWin,char** Items,const char* Heading,
    int Choice, int X, int Y, int Wide, int High, VideoAtt VAtt)
  {
    Init(ParentWin,Choice,Items,Heading,X,Y,Wide,High,VAtt,EnterKey,NULL,0);
  }

//.parse

MenuRec::MenuRec(LogicalWindow &ParentWin, const char* Items, const char* Heading,
    int Choice, int X, int Y, int Wide, int High, VideoAtt VAtt)
  {
    Init(ParentWin,Choice,Items,Heading,X,Y,Wide,High,VAtt,EnterKey,NULL,0);
  }

//.parse

void MenuRec::SetTopChoice(int TC)
  {
    if (VSBar)
      {
        if (SplitTop)
          {
            if (TC<SplitTop) TC=0;
            else TC-=SplitTop;
          }
        if (TC<TopChoiceRange()) VSBar->SetStep(TC);
      }
  }

//.parse

void MenuRec::Close()
  {
    if (TW)
      {
        delete TW;
        TW=NULL;
        delete MainWindow;
        if (ConfirmStr) delete ConfirmStr;
        if (ExtraStorage) delete ExtraStorage;
        if (VSBar) delete VSBar;
        if (HSBar) delete HSBar;
      }
  }

//.parse

void MenuRec::Disp(int ItemNum,Bool Normal)
  {
    int Y;
    if (ItemNum<SplitTop) Y=ItemNum+1;
    else
      {
        if (ItemNum==UseCurItem) ItemNum=CurItem;
        Y=ItemNum-TopChoice()+1+SplitTop;
      }
    VideoAtt A=TW->NoBlink(Normal?(TW->Att()):(ReverseAtt(TW->Att())));
    if (SplitLeft) TW->Display(LeftText(Choices[ItemNum],SplitLeft),1,Y,A);
    TW->Display(LeftText(&Choices[ItemNum][LeftColNum()+SplitLeft],TW->Wide()-SplitLeft),1+SplitLeft,Y,A);
  }

//.parse

char** ConvertStringToArray(const char* S)
  {
    // count the number of entries there will be
    int Items=1;
    const char* SPtr=&S[0];
    while ((SPtr=strchr(SPtr,'|'))!=NULL)
      {
        SPtr++;
        Items++;
      }
    // allocate space for the menu array
    Byte* Buf=new Byte[(Items+1)*sizeof(char*)+strlen(S)+1];
    if (Buf==NULL) FatalError("Cannot allocate memory for menu");
    char** A=(char**)Buf;
    char* Ptr= (char*) (&A[Items+1]);
    // convert the '|' to null terminators
    memcpy(Ptr,S,strlen(S)+1);
    A[0]=Ptr;
    Items=1;
    while ((Ptr=strchr(Ptr,'|'))!=NULL)
      {
        *(Ptr++)=0;
        A[Items++]=Ptr;
      }
    A[Items]=NULL;
    return A;
  }

