#ifndef WWLowLevIncluded
#define WWLowLevIncluded

// copyright (c) 1992, 1993 by Paul Wheaton
// 1916 Brooks #205, Missoula, MT  59801
//
//       phone:  (406)543-1928
//  CompuServe:  72707,207
//    Internet:  72707.207@CompuServe.com

#include <WMisc.h>
#include <WFile.h>

#ifdef UseGraphics

  #include <metainc.h>

#else

  typedef struct _point       /* "Point" structure type        */
     {short    X;             /* X coordinate                  */
      short    Y;             /* Y coordinate                  */
     }  point;

  typedef struct _rect       /* "Rectangle" structure type     */
     {short    Xmin;           /* minimum X                    */
      short    Ymin;           /* minimum Y                    */
      short    Xmax;           /* maximum X                    */
      short    Ymax;           /* maximum Y                    */
     }  rect;

  typedef struct _event      /* Event record structure         */
     {Byte     ASCII;          /* ASCII character code         */
      Byte     ScanCode;       /* Keyboard scan code           */
      short    State;          /* Keyboard & mouse switches    */
      short    CursorX;        /* Cursor X position            */
      short    CursorY;        /* Cursor Y position            */
      short    Time;           /* System time of event         */
      long     evntData;       /* User defined 32 bit item     */
     }  event;

#endif

class Rect;

class Point
  {
      int PX,PY;
    public:
      Point();
      Point(const Point& P);  // my kinda point
      Point(const point& P);  // meta kinda point
      Point(const Rect& R);
      Point(const rect& R);
      Point(int X,int Y);
      void operator=(Point P);
      Bool operator==(Point P) const;
      Bool operator!=(Point P) const;
      void operator=(point P);
      void operator=(const Rect& R);  // copy the X,Y out of the rectangle
      void operator=(const rect& R);
      Point operator+(Point P) const; // X=X1+X2 Y=Y1+Y2, works like imaginary numbers
      Point operator-(Point P) const;
      void operator+=(Point P);
      void operator-=(Point P);
      operator point() const;
      int X() const {return PX;}
      int Y() const {return PY;}
      void SetX(int X) {PX=X;}
      void SetY(int Y) {PY=Y;}
      void Adjust(int X,int Y=0) {PX+=X; PY+=Y;}
  };

class Rect
  {
      Point RXY;
      int RWide,RHigh;
    public:
      Rect();  //  everything set to 0
      Rect(const Rect& R); // my kinda rectangle
      Rect(const rect& R); // meta kinda rectangle
      Rect(int X,int Y,int Wide,int High);
      Rect(Point P,int Wide,int High);
      Rect(Point P1,Point P2);
      Rect(const Point& P);  //  wide and high are set to 0
      void operator=(const Rect& R);
      void operator=(const rect& R);
      void operator=(Point P) {RXY=P;}
      Bool operator==(const Rect& R) const;
      Bool operator!=(const Rect& R) {return (!(operator==(R)));}
      Rect operator+(Point P) const; // X=X1+X2 Y=Y1+Y2, works like imaginary numbers
      Rect operator-(Point P) const;
      void operator+=(Point P){RXY+=P;}
      void operator-=(Point P){RXY-=P;}
      operator rect() const;
      int X() const {return RXY.X();}
      int Y() const {return RXY.Y();}
      int  Wide()   const {return RWide;}
      int  High()   const {return RHigh;}
      int XMin()   const {return RXY.X();}
      int Left()   const {return RXY.X();}
      int YMin()   const {return RXY.Y();}
      int Top()    const {return RXY.Y();}
      int XMax()   const {return RXY.X()+RWide-1;}
      int Right()  const {return RXY.X()+RWide-1;}
      int YMax()   const {return RXY.Y()+RHigh-1;}
      int Bottom() const {return RXY.Y()+RHigh-1;}
      void SetRight(int R) {if (R>RXY.X()) RWide=R-RXY.X()+1;}
      void SetBottom(int B) {if (B>RXY.Y()) RHigh=B-RXY.Y()+1;}
      void SetX(int X) {RXY.SetX(X);}
      void SetY(int Y) {RXY.SetY(Y);}
      void SetWide(int Wide) {RWide=Wide;}
      void SetHigh(int High) {RHigh=High;}
      Point TopLeft()     const {return RXY;}
      Point TopRight()    const {Point P(XMax(),YMin()); return P;}
      Point BottomLeft()  const {Point P(XMin(),YMax()); return P;}
      Point BottomRight() const {Point P(XMax(),YMax()); return P;}
      void Adjust(int X,int Y=0,int Wide=0,int High=0);
      void Swell(int L=1);
        //  make Rect bigger by "L" layers all the way around
      void Shrink(int L=1);  // reverse of Swell
  };

#ifdef UseMouse

  class PreserveMouseHideStatusX
    {
        int OrigCursorStatus;
      public:
        PreserveMouseHideStatusX(Bool OnOrOff=On);
        ~PreserveMouseHideStatusX();
    };

  #define PreserveMouseHideStatus(OnOrOff) PreserveMouseHideStatusX PMHSVar(OnOrOff)

#else

  inline void PreserveMouseHideStatus(Bool OnOrOff=On){OnOrOff=OnOrOff;}

#endif

#ifdef UseGraphics

  class PenStatePreserver
    {
        penState OrigPenState;
      public:
        PenStatePreserver(){GetPenState(&OrigPenState);}
        ~PenStatePreserver(){SetPenState(&OrigPenState);}
    };

  #define PreservePenState() PenStatePreserver PPSVar

  extern int GrafixCard;
  extern int CommPort;

  fontRec* FontAlloc(const char* FontName);  // loads the entire file
  fontRec* FontAlloc(File& F); // for when the file is open and pointing at the font
  fontRec* FontAlloc(const char* TokenFileName, Word Token);
  fontRec* FontAlloc(Word Token); // uses the token file name
  inline fontRec* OutlineFontAlloc(){return FontAlloc(920);}

#else
  inline void PreservePenState(){}
#endif

Bool PointOnRect(Point P,Rect R);

const Black       =  0;
const Blue        =  1;
const Green       =  2;
const BlueGreen   =  3;  // some wanna say "Cyan"
const Red         =  4;
const Purple      =  5;  // some wanna say "Magenta" or "Violet"
const Brown       =  6;
const Gray        =  7;
const DkGray      =  8;
const LtBlue      =  9;
const LtGreen     = 10;
const LtBlueGreen = 11;
const LtRed       = 12;
const LtPurple    = 13;
const Yellow      = 14;
const White       = 15;

extern const char* ColorName[]; // give the array a number and get back a name

//  I have this awesome VideoAtt class - unfortunately, there are probs
//  with having class types being used as default parameters in every
//  compiler I have tried.

typedef int VideoAtt;
const UseDefaultAtt=0;

inline int VAtt(int Fore, int Back){return (Fore+Back*16);}
  // I wanted to call these ForeColor and BackColor, but there were
  // name conflicts.  Then I got to thinking that there would be name
  // conflicts with any reasonable name with some graphics library,
  // so I thought this would be a temporary measure until I can get the
  // VideoAtt class up and running.
inline int FColor(VideoAtt A){int i=(A%16); return i;}
inline int BColor(VideoAtt A){int i=((A/16)%16); return i;}

int ReverseAtt(VideoAtt A);

typedef struct _DefaultAttRec
  {
    VideoAtt Normal;
    VideoAtt Panic;
    VideoAtt Menu;
    VideoAtt Dialog;
    VideoAtt LiveEdit;
    VideoAtt DeadEdit;
    VideoAtt NeutralEdit;
    VideoAtt EditCursor;
    VideoAtt NotUsed1;
    VideoAtt NotUsed2;
    VideoAtt NotUsed3;
    VideoAtt NotUsed4;
    VideoAtt NotUsed5;
    VideoAtt NotUsed6;
    VideoAtt NotUsed7;
    VideoAtt NotUsed8;
  } DefaultAttRec;

class LogicalWindow;
class RootWindow;

#endif
